

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_AssociateTaskEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QS_AssociateTaskEntity.sp,v $ $Id: QS_AssociateTaskEntity.sp,v 1.1.2.2 2020/12/23 21:57:07 mnatarajan Exp $";
-- =========================================================
-- Author:		Sergio Bonilla
-- Create date: 06/28/2014
-- Description:	Add/Remove entity to schedule policy
-- =========================================================
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='QS_AssociateTaskEntity')
BEGIN
	print '>>> Drop Stored Procedure: QS_AssociateTaskEntity <<<'
	drop procedure QS_AssociateTaskEntity
END
IF EXISTS (select * from GxQscripts where name='QS_AssociateTaskEntity')
	delete from GxQscripts where name = 'QS_AssociateTaskEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssociateTaskEntity')
	delete from GXDBVersions where aliasname = 'QS_AssociateTaskEntity'
GO
print '... Creating Procedure: QS_AssociateTaskEntity'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure QS_AssociateTaskEntity
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
  @schedulePolicyName NVARCHAR(1024) = N'',
  @operationType NVARCHAR(1024) = N'',
  @param1 NVARCHAR(1024) = N'',
  @param2 NVARCHAR(1024) = N'',
  @param3 NVARCHAR(1024) = N'',
  @param4 NVARCHAR(1024) = N'',
  @param5 NVARCHAR(1024) = N''
AS
SET NOCOUNT ON
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
SET NOCOUNT ON
	DECLARE @now			INT = dbo.GetUnixTime(GETDATE())
	DECLARE @clientName  nvarchar(1024)
	DECLARE @dataAgentName nvarchar(1024)
	DECLARE @instanceName nvarchar(1024)
	DECLARE @bkpsetName nvarchar(1024)
	DECLARE @subclientName nvarchar(1024)
	DECLARE @cgName		   nvarchar(1024)
	DECLARE @addAssoc BIT = 0
	DECLARE @excludeAssoc BIT = 1
	DECLARE @xmlText XML
	SET @clientName = @PARAM1
	SET @dataAgentName = @PARAM2
	SET @instanceName = @PARAM3
	SET @bkpsetName = @PARAM4
	SET @subclientName = @PARAM5
	DECLARE @ClientId INT = 0
	DECLARE @AppTypeId INT = 0
	DECLARE @InstanceId INT = 0
	DECLARE @BackupsetId INT = 0
	DECLARE @subclientId INT = 0
	DECLARE @cgID		 INT = 0
	DECLARE @isTranStarted INT = 0
	DECLARE @errorCode INT = 0
	DECLARE @errorString nvarchar(1024)
	SET @errorString = ''
	DECLARE @assocType INT = 3 -- clientEntity
	BEGIN TRY
	DECLARE @userId INT = 0
	SET @userId =  ISNULL( (select userId from #tempQSUser),0)
	IF (@userId = 0)
	BEGIN
	  SET @errorCode = 1
	  SET @errorString = 'Error, no logged in user found'
	  GOTO ERROR_EXIT
	END
	DECLARE @i_taskId INT = 0
	DECLARE @i_policyType INT = -1
SELECT TOP 1 @i_taskId = taskId,@i_policyType = policyType  FROM TM_Task (READUNCOMMITTED) WHERE deleted = 0 AND taskType = 4 AND taskName = @schedulePolicyName
	IF @i_taskId=0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Schedule policy ['+ @schedulePolicyName + '] does not exist'
		GOTO ERROR_EXIT
	END
	-- check whether its data protection schedule policy policy type
	IF @i_policyType <> 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Can modify only data protection schedule policies'
		GOTO ERROR_EXIT
	END
	IF @operationType<> 'add' AND @operationType<> 'remove'
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Error. Invalid operation type ['+ @operationType + '] specified. OperationType should be add or remove.'
		GOTO ERROR_EXIT
	END
	ELSE IF @operationType = 'add'
	BEGIN
		SET @addAssoc = 1
		SET @excludeAssoc = 0
	END
	IF @clientName LIKE '%c=%'
	BEGIN
		EXECUTE @errorCode = QscriptGetAppIdsFromNames  @clientName, @dataAgentName, @instanceName, @bkpsetName, @subclientName,
		@subclientId OUTPUT, @BackupsetId OUTPUT, @InstanceId OUTPUT, @AppTypeId OUTPUT, @ClientId OUTPUT,
		@errorString OUTPUT, 1 -- Subclient and hierarchy is optional
		IF @errorCode != 0
		BEGIN
			GOTO ERROR_EXIT
		END
		IF @subclientId>0
		BEGIN
			SET @assocType = 7 -- subclient entity
		END
		ELSE IF @BackupsetId>0
		BEGIN
			SET @assocType = 6 -- backupset entity
		END
		ELSE IF @instanceId>0
		BEGIN
			SET @assocType = 5 -- Instance entity
		END
		ELSE IF @AppTypeId>0
		BEGIN
			SET @assocType = 4 -- AppType entity
		END
		ELSE
			SET @assocType = 3 -- Client entity
	END
	ELSE IF @clientName LIKE '%cg=%'
	BEGIN
		SET @cgName = SUBSTRING(@clientName, LEN('cg=')+1, LEN(@clientName) )
		SELECT @cgID = ID FROM App_CLientGroup (NOLOCK) WHERE name=@cgName
		IF @cgId = 0
        BEGIN
            SET @ErrorCode = 1
            SET @ErrorString = 'Error. Invalid clientgroup[' + @cgName + '] specified.'
            GOTO ERROR_EXIT
        END
		SET @assocType = 28 -- Client group entity
	END
	ELSE
	BEGIN
		SET @ErrorCode = 1
        SET @ErrorString = 'Error. Third input param must be client name specified as c=clientName or clientgroup name specified as cg=clientgroupName'
		GOTO ERROR_EXIT
	END
	-- check for agent filter only if present.
	IF (@ClientId>0 AND EXISTS(SELECT 1 FROM TM_AssocFilter (NOLOCK) WHERE taskID =@i_taskId ) )
	BEGIN
		DECLARE @isAssocAllowed TABLE(isAssocAllowed INT)
		INSERT INTO @isAssocAllowed
		EXEC QSDK_CanAssociateToTask @i_taskId, @ClientId, @AppTypeId
		IF NOT EXISTS(SELECT 1 FROM @isAssocAllowed WHERE isAssocAllowed>0)
		BEGIN
			SET @errorCode = 1
			IF @AppTypeId>0
			BEGIN
				SET @errorString = 'Error. Given apptype cannot be associated to the schedule policy.'
			END
			ELSE
			BEGIN
				SET @errorString = 'Error. Client does not have any agent which are allowed as part of agent filters in schedule policy.'
			END
			GOTO ERROR_EXIT
		END
	END
	DECLARE @association	XML
	DECLARE @xmlForSec		XML
	DECLARE @t_taskDetail	TABLE( oXml XML )
	SET @association = (SELECT @cgID '@clientGroupId', @clientId '@clientId', @AppTypeId '@applicationId',@InstanceId '@instanceId', @BackupsetId '@backupsetId', @subclientId '@subclientId', @assocType '@_type'
	FOR XML PATH('associations') )
--GET SCHEDULE INFO
	INSERT INTO @t_taskDetail EXECUTE TM_GetTaskDetail @i_taskId, @userId, 0
--
	--CHECK SECURITY ONLY ON ASSOCIATION BEING PASSED
	SELECT  TOP 1 @xmlForSec = oXml FROM @t_taskDetail
	-- check whether error is returned from taskDetail SP
	SELECT @errorCode = ISNULL ( ref.value('@errorCode', 'INT'),0),
		@errorString = ISNULL ( ref.value('@errorMessage', 'NVARCHAR(1024)'),'')
		FROM @xmlForSec.nodes ('//TMMsg_GenericResp') R(ref)
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	SET @xmlForSec = (SELECT  @xmlForSec.query('TMMsg_GetTaskDetailResp/*') FROM @t_taskDetail FOR XML PATH('TMMsg_ModifyTaskReq'))
	-- delete appgroups and subtasks node from xml
	SET @xmlForSec.modify('delete /TMMsg_ModifyTaskReq/taskInfo/appGroup')
	SET @xmlForSec.modify('delete /TMMsg_ModifyTaskReq/taskInfo/subTasks')
	SET @xmlForSec.modify('insert (sql:variable("@association")) into (//taskInfo)[1]')
--
	DELETE FROM @t_taskDetail
	INSERT INTO @t_taskDetail
	EXECUTE TM_SecurityCheckForTask @userId, 0, 0, @xmlForSec OUTPUT
--
	SELECT @errorCode = ISNULL ( ref.value('@errorCode', 'INT'),0),
		@errorString = ISNULL ( ref.value('@errorMessage', 'NVARCHAR(1024)'),'')
		FROM @xmlForSec.nodes ('//TMMsg_GenericResp') R(ref)
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	IF @@TRANCOUNT = 0
	BEGIN
		BEGIN TRAN
		SET @isTranStarted = 1
	END
	DECLARE @isParentIncludePresent INT = 0
	DECLARE @isParentExcludedPresent INT = 0
	DECLARE @parentCGID INT = 0
	SELECT @isParentIncludePresent = 1,@parentCGID = clientGroupId FROM TM_AssocEntity (NOLOCK)
	WHERE taskId = @i_taskId
	AND Exclude = 0
	AND @clientID > 0
	AND
	(
(assocType = 2)   --CHECK ASSOCIATION FOR ALL CLIENTS
		OR
		(
			clientId = @clientID
			AND (apptypeId = 0 OR apptypeId = @AppTypeId)
			AND (instanceId = 0 OR instanceId = @instanceId)
			AND (backupsetId = 0 OR backupsetId = @backupsetId)
			AND (subclientId = 0 OR subclientId = @subClientId)
		)
		OR
		(
			clientGroupId IN (SELECT APP_ClientGroupAssoc.clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE APP_ClientGroupAssoc.clientId = @clientID) AND clientId = 0
		)
	)
	SELECT @isParentIncludePresent = 1 FROM TM_AssocEntity (NOLOCK)
	WHERE taskId = @i_taskId
	AND Exclude = 0
AND assocType = 27
	AND @cgID > 0
	SELECT @isParentExcludedPresent = 1, @parentCGID = clientGroupId FROM TM_AssocEntity (NOLOCK)
	WHERE taskId = @i_taskId
	AND Exclude = 1
	AND @clientID > 0
	AND
	(
		(
			clientId = @clientID
			AND (apptypeId = 0 OR apptypeId = @AppTypeId)
			AND (instanceId = 0 OR instanceId = @instanceId)
			AND (backupsetId = 0 OR backupsetId = @backupsetId)
			AND (subclientId = 0 OR subclientId = @subClientId)
		)
		OR
		(
			clientGroupId IN (SELECT APP_ClientGroupAssoc.clientGroupId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE APP_ClientGroupAssoc.clientId = @clientID)  AND clientId = 0
		)
	)
	DECLARE @actualCGID INT = 0
	IF @cgID > 0
	BEGIN
		SET @actualCGID = @cgID
	END
	ELSE
	BEGIN
		SET @actualCGID = @parentCGID
	END
	--IF same entry is present or excluded as per request now then error out.
	IF EXISTS(SELECT 1 FROM TM_assocEntity (NOLOCK)
		WHERE taskId = @i_taskId AND assocType = @assocType AND @actualCGID = clientGroupId AND @clientId = clientId
		AND @appTypeId = appTypeId AND @instanceId = instanceId AND @backupsetId = backupsetId AND @subClientId = subClientId
		AND 0 = mediaAgentId AND 0 = policyId AND 0 = copyId
		AND exclude = @excludeAssoc)
	BEGIN
		SET @errorString = 'Schedule policy ['+ @schedulePolicyName + '] is '+ CASE WHEN @addAssoc = 1 THEN 'associated' ELSE 'disassociated' END +' to entity provided. So not performing operation'
		SET @errorCode = 1
		GOTO ERROR_EXIT
	END
	-- First delete from TM_assocEntity if same entity is added before and we want to remove now or it was excluded before and we want to add now.
	-- If we want to remove now excludeAssoc will be 1 and if we want to add now, excludeassoc will be 0
	-- If it was added before exclude will be 0 and if it was removed before , exclude will be 1
	DELETE FROM TM_assocEntity
	WHERE taskId = @i_taskId AND assocType = @assocType AND clientGroupId = @actualCGID AND @clientId = clientId
	AND @appTypeId = appTypeId AND @instanceId = instanceId AND @backupsetId = backupsetId AND @subClientId = subClientId
	AND 0 = mediaAgentId AND 0 = policyId AND 0 = copyId
	AND exclude != @excludeAssoc
	IF @@ROWCOUNT>0
	BEGIN
		IF (@clientId>0)
		BEGIN
			-- DELETE all children of provided entity.
			DELETE FROM TM_assocEntity
			WHERE taskId = @i_taskId AND @actualCGId = clientGroupId AND @clientId = clientId
			AND (@appTypeId = appTypeId  OR @appTypeId = 0)
			AND (@instanceId = instanceId OR @instanceId = 0)
			AND (@backupsetId = backupsetId OR @backupsetId = 0)
			AND (@subClientId = subClientId OR @subClientId = 0)
			AND 0 = mediaAgentId AND 0 = policyId AND 0 = copyId
		END
		ELSE IF (@cgID>0)
		BEGIN
			DELETE FROM TM_assocEntity
			WHERE taskId = @i_taskId AND @cgID = clientGroupId
			AND 0 = mediaAgentId AND 0 = policyId AND 0 = copyId
		END
		GOTO OP_COMPLETE
	END
	IF @addAssoc = 1 AND @isParentIncludePresent = 1
	BEGIN
		SET @errorString = 'Schedule policy ['+ @schedulePolicyName + '] is associated to parent of entity provided. So not associating again'
		SET @errorCode = 1
		GOTO ERROR_EXIT
	END
	IF @addAssoc = 0 AND @isParentExcludedPresent = 1
	BEGIN
		SET @errorString = 'Schedule policy ['+ @schedulePolicyName + '] has parent of entity excluded. So cannot exclude provided entity'
		SET @errorCode = 1
		GOTO ERROR_EXIT
	END
	IF @addAssoc = 0 AND @isParentIncludePresent = 0
	BEGIN
		SET @errorString = 'Entity or its parent is not associated to Schedule policy ['+ @schedulePolicyName + ']. So cannot be excluded'
		SET @errorCode = 1
		GOTO ERROR_EXIT
	END
--
	-- Delete all children of provided entity
	IF (@clientId>0)
	BEGIN
		-- DELETE all children of provided entity.
		DELETE FROM TM_assocEntity
		WHERE taskId = @i_taskId AND clientGroupId = @actualCGID
		AND @clientId = clientId
		AND (@appTypeId = appTypeId  OR @appTypeId = 0)
		AND (@instanceId = instanceId OR @instanceId = 0)
		AND (@backupsetId = backupsetId OR @backupsetId = 0)
		AND (@subClientId = subClientId OR @subClientId = 0)
		AND 0 = mediaAgentId AND 0 = policyId AND 0 = copyId
	END
	ELSE IF (@cgID>0)
	BEGIN
		DELETE FROM TM_assocEntity
		WHERE taskId = @i_taskId AND @cgID = clientGroupId
		AND 0 = mediaAgentId AND 0 = policyId AND 0 = copyId
	END
	INSERT INTO TM_assocEntity (assocType, taskId, flags, created, clientGroupId, clientId, apptypeId, instanceId, backupsetId, subclientId, policyId, copyId, srmReportSet, srmReportType, exclude, trackingPolicyId, MediaAgentId, agentlessPolicyId, workflowId,sidbStoreId, libraryId, logMonitoringPolicyId)
	SELECT @assocType, @i_taskId, 0, @now, @actualCGID, @clientId, @appTypeId, @instanceId, @backupsetId, @subclientId, 0, 0, 0, 0, @excludeAssoc, 0, 0 , 0, 0, 0, 0, 0
OP_COMPLETE:
	-- If there are automatic schedules send osc to client
	IF EXISTS(SELECT 1 FROM TM_SubTask S (NOLOCK)
                JOIN TM_Task T (NOLOCK) ON T.taskId = S.taskId AND T.disabled = 0 AND T.taskId = @i_taskId
                JOIN TM_PatternAssoc A (NOLOCK) ON A.subTaskId = S.subTaskId
JOIN  TM_Pattern P (NOLOCK) ON P.patternId = A.patternId AND P.freq_type = 1024
            )
    BEGIN
DECLARE @workQOutPutTbl     TABLE (errCode INT, errString NVARCHAR(2048))
        INSERT INTO @workQOutPutTbl
        EXEC AppWorkQueueSubmitRequest 4/*WORK_TOKEN_OSC,*/, 0, 0, @clientId, @cgID, ''
    END
	IF @isTranStarted = 1
	BEGIN
		COMMIT TRAN
	END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
ERROR_EXIT:
IF @errorCode != 0 AND @isTranStarted = 1
	ROLLBACK TRAN
IF @errorCode <> 0
		Raiserror(@errorString,
                15,  --Severity (> 10 to force DOS Error Code = 1)
                1    --State
    )
	ELSE
	PRINT 'Operation on schedule policy completed successfully. '
END
GO

IF EXISTS (select * from GxQscripts where name = 'QS_AssociateTaskEntity')
	delete from GxQscripts where name = 'QS_AssociateTaskEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssociateTaskEntity')
	delete from GXDBVersions where aliasname = 'QS_AssociateTaskEntity'
GO

insert into GXDBVersions values(2, 'QS_AssociateTaskEntity',  '00010001000200020000', 'QS_AssociateTaskEntity', '00010001000200020000')
GO

insert into GxQscripts values(2+8,'QS_AssociateTaskEntity',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_AssociateTaskEntity -si schedulePolicyName -si add|remove -si ''c=docserve04'' -si ''a=Q_FILESYSTEM'' -si ''i=defaultInstanceName'' -si ''b=DefaultBackupset'' -si ''s=default''
'
 + CHAR(10) + '	qoperation execscript -sn QS_AssociateTaskEntity -si schedulePolicyName -si add|remove -si ''cg=grp1'' 
'
)
GO

