

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_AssociateStoragePolicyToVTPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_AssociateStoragePolicyToVTPolicy')
BEGIN
	print '>>> Drop Stored Procedure: QS_AssociateStoragePolicyToVTPolicy <<<'
	drop procedure QS_AssociateStoragePolicyToVTPolicy
END
IF EXISTS (select * from GxQscripts where name='QS_AssociateStoragePolicyToVTPolicy')
	delete from GxQscripts where name = 'QS_AssociateStoragePolicyToVTPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssociateStoragePolicyToVTPolicy')
	delete from GXDBVersions where aliasname = 'QS_AssociateStoragePolicyToVTPolicy'
GO
print '... Creating Procedure: QS_AssociateStoragePolicyToVTPolicy'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QS_AssociateStoragePolicyToVTPolicy
-- Qscript is Enabled
-- QScript secure this script does the user validation
-- Qscript Usage. Do not use special char in HTML
  @editMode varchar(16),
  @archGroup nvarchar(144),
  @vtPolicy nvarchar(128)
AS
set nocount on
declare @errorCode int
declare @errorMessage nvarchar(max) = N''
declare @archGroupId int
declare @vtPolicyId int
declare @userId int = 0
declare @vtRule int = 0
/*
** Check user input validity
*/
if datalength(@archGroup) = 0 or datalength(@vtPolicy) = 0 or (@EditMode <> 'set' and @EditMode <> 'update')
begin
	set @errorCode = 1
	goto proc_exit
end
select @archGroupId = id from archGroup(nolock) where name = @archGroup
if @archGroupId is null
begin
	set @errorCode = 2
	goto proc_exit
end
select @vtPolicyId=PolicyId from VTPolicy(nolock) where PolicyName = @vtPolicy
if @vtPolicyId is null
begin
	set @errorCode = 3
	goto proc_exit
end
select @vtRule = RuleId
from VTPolicyToRule(nolock)
where PolicyId = @vtPolicyId
if not exists (select * from VtRuleToSchema where schemaId = 7 and ruleId = @vtRule and param <> -1)
begin
	set @errorCode = 4
	goto proc_exit
end
/*
** Check user permissions
*/
if object_id('tempdb.dbo.#tempQSUser') is null
begin
	set @errorCode = 5
	goto proc_exit
end
set @userId = isnull((select userId from #tempQSUser), 0)
if @userId = 0
begin
	set @errorCode = 6
	goto proc_exit
end
--Check user has Storage Policy permission
if object_id('tempdb.dbo.#spPolicyPermissions') is not null drop table #spPolicyPermissions
create table #spPolicyPermissions(archGroupId int)
exec sec_getNonIdaObjectsForThisUser @userId, 17, 4, '#spPolicyPermissions'
if not exists(select 1 from #spPolicyPermissions where archGroupId = @archGroupId)
begin
	set @errorCode = 7
	goto proc_exit
end
--Check user has Vault Tracker Policy permission
if object_id('tempdb.dbo.#vtPolicyPermissions') is not null drop table #vtPolicyPermissions
create table #vtPolicyPermissions(vtPolicyId int)
exec sec_getNonIdaObjectsForThisUser @userId, 21, 26, '#vtPolicyPermissions'
if not exists(select 1 from #vtPolicyPermissions where vtPolicyId = @vtPolicyId)
begin
	set @errorCode = 8
	goto proc_exit
end
if @editMode = 'update'
begin
	/*
	** Only updating if
	** 1. VT Policy is not already associated with all SPs
	** 2. SP is associated, but not all copies are associated
	*/
	if not exists(select 1 from VTPolicyToCopy(nolock)
				where PolicyId = @vtPolicyId
				and (ArchGroupId = 0 or (ArchGroupId = @archGroupId and CopyId = 0)))
	begin
		--Clean up existing associations for the SP to VT policy
		delete from VTPolicyToCopy
		where PolicyId = @vtPolicyId
		and ArchGroupId = @archGroupId
		--Add new association
		insert into VTPolicyToCopy
		values(@vtPolicyId, @archGroupId, 0)
	end
end
else --set
begin
	--Clean up all existing associations
	delete from VTPolicyToCopy
	where PolicyId = @vtPolicyId
	--Add new association
	insert into VTPolicyToCopy
	values(@vtPolicyId, @archGroupId, 0)
end
proc_exit:
	if @errorCode = 1
		set @errorMessage 	+= CHAR(10)
							+ 'Error: Invalid arguments supplied.'
							+ CHAR(10)
							+ CHAR(10)
							+ 'Usage: qoperation execscript -sn AssociateStoragePolicyToVTPolicy -si ''set|update'' -si ''Storage Policy name'' -si ''VaultTracker Policy name'''
	else if @errorCode = 2
		set @errorMessage 	+= CHAR(10)
							+ 'Error: Input Storage Policy in invalid'
	else if @errorCode = 3
		set @errorMessage 	+= CHAR(10)
							+ 'Error: Input VaultTracker Policy in invalid'
	else if @errorCode = 4
		set @errorMessage 	+= CHAR(10)
							+ 'Error: Storage Policy cannot be associated with a ''Due Back for Reuse'' VaultTracker Policy'
	else if @errorCode = 5
		set @errorMessage 	+= CHAR(10)
							+ 'Error: No logged in user found.'
	else if @errorCode = 6
		set @errorMessage 	+= CHAR(10)
							+ 'Error: Logged in user information not found.'
	else if @errorCode = 7
		set @errorMessage 	+= CHAR(10)
							+ 'Error: User does not have ''Storage Policy Management'' permissions for the Storage Policy.'
	else if @errorCode = 8
		set @errorMessage 	+= CHAR(10)
							+ 'Error: User does not have ''VaultTracker Operations'' permissions for the VaultTracker Policy.'
	if @errorCode not in (0)
        Raiserror(@errorMessage,
                    15,  --Severity (> 10 to force DOS Error Code = 1)
                    1    --State
                    )
    else
        select @errorMessage
	if (object_id('tempdb.dbo.#outputSuppressor') is not null) drop table #outputSuppressor
	if (object_id('tempdb.dbo.#nodelist') is not null) drop table #nodelist
set nocount on
GO

IF EXISTS (select * from GxQscripts where name = 'QS_AssociateStoragePolicyToVTPolicy')
	delete from GxQscripts where name = 'QS_AssociateStoragePolicyToVTPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssociateStoragePolicyToVTPolicy')
	delete from GXDBVersions where aliasname = 'QS_AssociateStoragePolicyToVTPolicy'
GO

insert into GXDBVersions values(2, 'QS_AssociateStoragePolicyToVTPolicy',  '00000000000000000000', 'QS_AssociateStoragePolicyToVTPolicy', '00000000000000000000')
GO

insert into GxQscripts values(2+8,'QS_AssociateStoragePolicyToVTPolicy',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '--       qoperation execscript -sn AssociateStoragePolicyToVTPolicy -si ''set|update'' -si ''Storage Policy name'' -si ''VaultTracker Policy name'''
 + CHAR(10) + '--       Example: qoperation execscript -sn AssociateStoragePolicyToVTPolicy -si ''set'' -si ''TestSP'' -si ''Test VTPolicy'''
 + CHAR(10) + '--       Example: qoperation execscript -sn AssociateStoragePolicyToVTPolicy -si ''update'' -si ''TestSP'' -si ''Test VTPolicy'''
)
GO

