

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_AssociateBillableEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2010  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_AssociateBillableEntity <<<'

IF EXISTS (select * from sysobjects where name='QS_AssociateBillableEntity')
	drop procedure QS_AssociateBillableEntity
IF EXISTS (select * from GxQscripts where name='QS_AssociateBillableEntity')
	delete from GxQscripts where name = 'QS_AssociateBillableEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssociateBillableEntity')
	delete from GXDBVersions where aliasname = 'QS_AssociateBillableEntity'
GO
print '... Creating Procedure: QS_AssociateBillableEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_AssociateBillableEntity
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage. Do not use special char in HTML
  @PARAM1 nvarchar(1024) = ''
AS
-------------------------------------------
-- Name:	QS_AssociateBillableEntity
-- Date:	29-March-2011
-- Description:		To set client item (client,IDA,backupset/Instance,subclient) as a billable entity
-- Argument	: Takes input as a filename of a file that contains Client-Item/BE associations.
------------------------------------------------------------------------------------------------------------------
-- ------------------------------------------ USER INPUT ---------------------------------------------
-- User input will be of the following format (set of symbols that appear between '<' and '>' is one token.
-- ('[', ']', '<' and '>' are not part of user input)
-- [<Billable Entity Name>,<Client Name>,<IDA Name>,<Instance Name>,<BackupSet Name>,<SubClient Name>\n]*
-- BE Name and Client Name are mandatory. Others are conditionally optional.
-- Optional tokens <IDA Name>,<Instance Name>,<BackupSet Name>,<SubClient Name> can be empty.
-- For <BackupSet Name> or <Instance Name> token to be non-empty <IDA Name> must also be non-empty.
-- We can have a <SubClient Name> directly under IDA.
-- NOTE:
-- Looks like DB2 IDA is currently the only IDA that seems to take all valid values for the user input template
-- <Billable Entity Name>,<Client Name>,<IDA Name>,<Instance Name>,<BackupSet Name>,<SubClient Name>.
-- For other IDAs we either have instance name missing or have backupset missing.
--	-------------------------------------	   LIMITATION    -----------------------------------------------
--	All tokens are separated with a comma. But backupsetname and subclientname can also have a comma in them.
--  Currently we do NOT expect commas to be present in any of the tokens.
--	-------------------------------------	   ASSUMPTION    -----------------------------------------------
-- We assume that the names of items of the above hierarchy (with client at its root) are unique. If not
-- so then it will result in ambiguity when we resolve backupset IDs from backupset names.
--  -----------------------------------  BE ASSOCIATION RULES ----------------------------------------------------
-- Rules:
-- #1. BE association can be made at a level if and only if ALL its parent levels have not been associated
--     with any BE.
-- #2. BE association can be made at a level even when its child levels are associated with some BE. In this case
--     this association will remove all child associations.
-- #3. BE can be modified for a level provided it satisfies the above 2 rules.
-- ---------------------------------------------------------------------------------------------------------------
	SET NOCOUNT ON
	DECLARE @filename NVARCHAR(MAX)
    DECLARE @errCode INT
    DECLARE @errString VARCHAR(512)
    DECLARE @scriptName VARCHAR(255)
    DECLARE @noParameter nvarchar(4)
    -- Drop all Temporary tables that will be used in case a stale Temporary Table is still in memory
    IF OBJECT_ID('tempdb.dbo.#tempOPErrCodes') IS NOT NULL DROP TABLE #tempOPErrCodes
    IF OBJECT_ID('tempdb.dbo.#tempOPStatus') IS NOT NULL DROP TABLE #tempOPStatus
    IF OBJECT_ID('tempdb.dbo.#tempBEMembersInput') IS NOT NULL DROP TABLE #tempBEMembersInput
    IF OBJECT_ID('tempdb.dbo.#tempBEMembersProcessed') IS NOT NULL DROP TABLE #tempBEMembersProcessed
    SET  @filename =@PARAM1
    SET @noParameter = '%'
    SET @noParameter = @noParameter + 's'
    SET @errCode = 0
    SET @scriptName = 'QS_AssociateBillableEntity'
    -- Table that holds the input values broken up into tokens.
    CREATE TABLE #tempBEMembersInput
    (
      [EntityName]		NVARCHAR(512),
      [ClientName]		NVARCHAR(512),
      [IDAName]			NVARCHAR(512),
      [InstanceName]	NVARCHAR(512),
      [BackupSetName]	NVARCHAR(512),
      [SubclientName]	NVARCHAR(512)
    )
    -- Table holds values that are to be inserted into BLEntityMembers
    CREATE TABLE #tempBEMembersProcessed
    (
      InID			INT,
      EntityID		INT,
      ClientID		INT,
      AppTypeID		INT,
      BackupSetID	INT,
      InstanceID	INT,
      AppID			INT,
      AssocLevel	INT
    )
	CREATE TABLE #tempOPErrCodes
	(
		ErrCode		INT,
		ErrString	VARCHAR(512)
	)
	CREATE TABLE #tempOPStatus
	(
       UID			INT,
       ErrCode		INT
	)
	INSERT INTO #tempOPErrCodes VALUES (0, 'No error.')
	INSERT INTO #tempOPErrCodes VALUES (1, 'Could not make a few associations since associations at higher levels were already present.')
	INSERT INTO #tempOPErrCodes VALUES (2, 'Could not make a few associtations due to invalid user input. Please verify input CSV association file.')
	IF @filename = @noParameter
    BEGIN
     	SET @errCode = 2
     	GOTO ERROR_EXIT
    END
    -- load data into temporary table
    EXECUTE('
    BULK
    INSERT  #tempBEMembersInput
    FROM    ''' + @filename + '''
    WITH    (ROWTERMINATOR=''\n'', FIELDTERMINATOR='','', KEEPNULLS)')
    ALTER TABLE #tempBEMembersInput ADD [ID] INTEGER NOT NULL IDENTITY (1,1)
    --SELECT * FROM #tempBEMembersInput
    DECLARE  @cEntityName	NVARCHAR(512)
    DECLARE  @cClientName	NVARCHAR(512)
    DECLARE  @cIDAName		NVARCHAR(512)
    DECLARE  @cBackupSetName	NVARCHAR(512)
    DECLARE  @cInstanceName	NVARCHAR(512)
    DECLARE  @cSubclientName	NVARCHAR(512)
    DECLARE  @cEntityID		INT
    DECLARE  @cClientID		INT
    DECLARE  @cAppTypeID	INT
    DECLARE  @cBackupID		INT
    DECLARE	 @cInstanceID	INT
    DECLARE  @cAppID		INT
    DECLARE  @cAssocLevel	INT
    DECLARE  @cTmpID		INT
    DECLARE  @cRCount		INT
    DECLARE @Assoc_ClientLvl		INT
    DECLARE @Assoc_IDALvl			INT
    DECLARE @Assoc_BkpSetLvl		INT
    DECLARE @Assoc_InstanceLvl		INT
    DECLARE @Assoc_SubClientLvl		INT
    DECLARE @bCanAdd				INT
    DECLARE @OPErrCode				INT
    DECLARE @retAssoc				INT
    SET @Assoc_ClientLvl	= 2
    SET @Assoc_IDALvl		= 3
    SET @Assoc_BkpSetLvl	= 5
    SET @Assoc_InstanceLvl	= 4
    SET @Assoc_SubClientLvl	= 6
    DECLARE ProcessBEUserInput_Cursor CURSOR FOR
    SELECT [ID],[EntityName],[ClientName],[IDAName],[InstanceName],[BackupSetName],[SubclientName] FROM #tempBEMembersInput
    WHERE [EntityName] IS NOT NULL AND LEN([EntityName]) > 0 AND
    [ClientName] IS NOT NULL AND LEN([ClientName]) > 0
    OPEN ProcessBEUserInput_Cursor
    FETCH NEXT FROM ProcessBEUserInput_Cursor INTO @cTmpID,@cEntityName,@cClientName,@cIDAName,@cInstanceName,@cBackupSetName,@cSubclientName
    WHILE @@FETCH_STATUS = 0
    BEGIN
		-- Get BE EntityID
		SET @cEntityID = ISNULL( (SELECT EntityID FROM BLEntity WHERE DisplayName = LTRIM(RTRIM(@cEntityName))),0)
		SET @cAssocLevel =  0
		-- Get Client ID
		IF (@cEntityID <> 0)
		BEGIN
			-- Fetch ClientId.
			SET @cClientID = ISNULL( (SELECT Id FROM App_Client WHERE  name = LTRIM(RTRIM(@cClientName))), -1)
			IF(@cClientID > 0)
				SET @cAssocLevel =  @Assoc_ClientLvl
		END
		ELSE
			SET @cClientID = 0
		-- Get IDAType
		IF (@cIDAName IS NOT NULL AND @cClientID > 0 )
		BEGIN
			SET @cAppTypeID = ISNULL( (SELECT TOP 1 type from APP_idaType WHERE type IN (
									SELECT DISTINCT appTypeId FROM APP_IDAName WHERE clientId = @cClientID)
									AND displayName = LTRIM(RTRIM(@cIDAName)) ), -1)
			IF(@cAppTypeID = -1 ) -- iDA Name was not found in SIM table. Look into app_idatype.
			BEGIN
				SET @cAppTypeID = ISNULL( (	SELECT TOP 1 type FROM APP_iDAType WHERE type IN (
											SELECT DISTINCT appTypeId FROM APP_IDAName WHERE clientId = @cClientID)
											AND name = LTRIM(RTRIM(@cIDAName)) ), -1)
			END
			IF(@cAppTypeID > 0)
			BEGIN
				SET @cAssocLevel =  @Assoc_IDALvl
			END
			ELSE
			BEGIN
				SET @cAppTypeID = 0
				SET @cAssocLevel = 0
			END
		END
		IF(@cAppTypeID > 0)
		BEGIN
			-- Get Instance ID
			IF( @cInstanceName IS NULL OR LEN(@cInstanceName) = 0)
			BEGIN
				SET @cInstanceID	=  0
			END
			ELSE
			BEGIN
				SET @cInstanceID = ISNULL( (SELECT  DISTINCT Instance FROM APP_Application WHERE clientId = @cClientID
											AND appTypeId = @cAppTypeID AND instance in
											(SELECT id FROM APP_InstanceName WHERE name = LTRIM(RTRIM(@cInstanceName)) )), -1)
				IF(@cInstanceID > 0)
				BEGIN
					SET @cAssocLevel =  @Assoc_InstanceLvl
					--print ''Set assoc level to INST''
				END
				ELSE
					SET @cAssocLevel =  0
			END
			-- Get BackupSet ID
			IF(@cBackupSetName IS NULL OR LEN(@cBackupSetName) = 0 )
			BEGIN
				SET @cBackupID = 0
			END
			ELSE
			BEGIN
				IF(@cInstanceID > 0)
				BEGIN
					SET @cBackupID = ISNULL( (SELECT  DISTINCT backupSet FROM APP_Application WHERE clientId = @cClientID
												AND appTypeId = @cAppTypeID AND instance = @cInstanceID AND backupSet in
												(SELECT id FROM APP_BackupSetName WHERE name = LTRIM(RTRIM(@cBackupSetName)) )), -1)
				END
				ELSE
				BEGIN
					SET @cRCount = ISNULL( (SELECT  COUNT( DISTINCT backupSet) FROM APP_Application WHERE clientId = @cClientID
											AND appTypeId = @cAppTypeID AND backupSet in
											(SELECT id FROM APP_BackupSetName WHERE name = LTRIM(RTRIM(@cBackupSetName)) )), 0)
					IF(@cRCount = 0 OR @cRCount > 1) -- backupSet not present or ambiguous
					BEGIN
						SET @cBackupID = -1
						SET @cAssocLevel  = 0
					END
					ELSE
					BEGIN
						SELECT  DISTINCT @cBackupID  = backupSet FROM APP_Application WHERE clientId = @cClientID
							AND appTypeId = @cAppTypeID AND backupSet in
							(SELECT id FROM APP_BackupSetName WHERE name = LTRIM(RTRIM(@cBackupSetName)) )
						SELECT  DISTINCT @cInstanceID  = instance FROM APP_Application WHERE clientId = @cClientID
							AND appTypeId = @cAppTypeID AND backupSet =  @cBackupID
					END
				END
				IF(@cBackupID > 0 AND  @cInstanceID	>  0)
					SET @cAssocLevel  = @Assoc_BkpSetLvl
				ELSE
					SET @cAssocLevel  = 0
			END
		END
		ELSE
		BEGIN
			SET @cBackupID = 0
			SET @cInstanceID	=  0
		END
		-- Get the subclient Info
		IF( @cSubclientName IS NOT NULL )
		BEGIN
			IF (@cAppTypeID = 0)
			BEGIN
				SET @cAppID = -1
				SET @cAssocLevel = 0
			END
			ELSE
			BEGIN
				IF(@cBackupID > 0 AND @cInstanceID > 0 )
				BEGIN
					-- Subclient shoule not be in de-configured or deleted state
					SET @cAppID  = ISNULL( (SELECT Id FROM APP_Application
						WHERE clientId = @cClientID AND appTypeId = @cAppTypeID
						AND backupSet = @cBackupID AND instance  = @cInstanceID
						AND (subclientStatus & 0x02) <> 0x02 AND (subclientStatus & 0x04) <> 0x04
						AND subclientName = LTRIM(RTRIM(@cSubclientName))),-1)
				END
				-- Subclient is directly under IDA.
				-- For such subclients, we generally have the same instance and backupsetid.
				ELSE IF(@cBackupID = 0 AND @cInstanceID = 0 )
				BEGIN
					SET @cRCount = ISNULL( (SELECT COUNT(*) FROM APP_Application WHERE clientId = @cClientID
						  AND appTypeId = @cAppTypeID AND (subclientStatus & 0x02) <> 0x02 AND (subclientStatus & 0x04) <> 0x04 AND subclientName = LTRIM(RTRIM(@cSubclientName)) ),0)
					IF (@cRCount = 0 OR @cRCount > 1) -- subclient is not present or ambiguous
					  SET @cAppID = -1
					ELSE
					BEGIN
					  SELECT @cAppID=Id, @cBackupID = backupSet, @cInstanceID  = instance FROM APP_Application
							WHERE clientId = @cClientID AND appTypeId = @cAppTypeID
							AND (subclientStatus & 0x02) <> 0x02 AND (subclientStatus & 0x04) <> 0x04
							AND subclientName = LTRIM(RTRIM(@cSubclientName))
					END
				END
				ELSE IF (@cInstanceID > 0 AND @cBackupID = 0 )
				BEGIN
					-- Get the backup set ID
					SET @cRCount = ISNULL((SELECT COUNT(*) FROM APP_Application WHERE clientId = @cClientID
										AND appTypeId = @cAppTypeID AND instance = @cInstanceID
										AND (subclientStatus & 0x02) <> 0x02 AND (subclientStatus & 0x04) <> 0x04
										AND subclientName = LTRIM(RTRIM(@cSubclientName)) ),0)
					IF (@cRCount = 0 OR @cRCount > 1) -- subclient is not present or ambiguous
						SET @cAppID = -1
					ELSE
					BEGIN
						SELECT @cAppID=Id, @cBackupID = backupSet  FROM APP_Application WHERE clientId = @cClientID
							AND appTypeId = @cAppTypeID AND instance = @cInstanceID
							AND (subclientStatus & 0x02) <> 0x02 AND (subclientStatus & 0x04) <> 0x04
							AND subclientName = LTRIM(RTRIM(@cSubclientName))
					END
				END
				ELSE IF (@cBackupID  > 0  AND @cInstanceID = 0 )
				BEGIN
					-- Get the instance ID
					SET @cRCount = ISNULL( (SELECT COUNT(*) FROM APP_Application WHERE clientId = @cClientID
						AND appTypeId = @cAppTypeID AND backupSet = @cBackupID
						AND (subclientStatus & 0x02) <> 0x02 AND (subclientStatus & 0x04) <> 0x04
						AND subclientName = LTRIM(RTRIM(@cSubclientName)) ),0)
					IF (@cRCount = 0 OR @cRCount > 1) -- subclient is not present or ambiguous
						SET @cAppID = -1
					ELSE
					BEGIN
						SELECT @cAppID=Id, @cInstanceID = instance  FROM APP_Application WHERE clientId = @cClientID
							AND appTypeId = @cAppTypeID AND backupSet = @cBackupID
							AND (subclientStatus & 0x02) <> 0x02 AND (subclientStatus & 0x04) <> 0x04
							AND subclientName = LTRIM(RTRIM(@cSubclientName))
					END
				END
				IF(@cAppID > 0)
					SET @cAssocLevel =  @Assoc_SubClientLvl
				ELSE
				BEGIN
					SET @cAppID = -1
					SET @cAssocLevel = 0
				END
			END
		END -- End of Get the subclient Info
		ELSE
			SET @cAppID = 0
		INSERT INTO #tempBEMembersProcessed VALUES (@cTmpID,@cEntityID,@cClientID,@cAppTypeID,@cBackupID,@cInstanceID,@cAppID,@cAssocLevel)
		FETCH NEXT FROM ProcessBEUserInput_Cursor INTO @cTmpID,@cEntityName,@cClientName,@cIDAName,@cInstanceName,@cBackupSetName,@cSubclientName
    END
    CLOSE ProcessBEUserInput_Cursor
    DEALLOCATE ProcessBEUserInput_Cursor
    -- SELECT * FROM #tempBEMembersProcessed
    DECLARE AddBEAssoc_Cursor CURSOR FOR
      SELECT  InID,EntityID,ClientID,AppTypeID,BackupSetID,InstanceID,AppID,AssocLevel FROM #tempBEMembersProcessed
       WHERE EntityID > 0 AND ClientID > 0 AND AssocLevel > 0
    OPEN AddBEAssoc_Cursor
    FETCH NEXT FROM AddBEAssoc_Cursor INTO
		@cTmpID,@cEntityID,@cClientID,@cAppTypeID,@cBackupID,@cInstanceID,@cAppID,@cAssocLevel
	WHILE @@FETCH_STATUS = 0
    BEGIN
    SET @bCanAdd  = 0
    -- Validate user input. We are doing this to mimic this scripts behavior with that of GUI.
    -- Otherwise trigger on table BLEntityMembers is capable enough to handle all cases.
    -- Validation : While associating BE at a level, verify that all the parent levels
    --                of this branch are not associated with any BE.
    SET @retAssoc = dbo.IsBEAssocPresent_QSUtilFN(@cClientID,@cAssocLevel,@cAppTypeID,@cInstanceID,@cBackupID)
    IF(@retAssoc = 0)
    BEGIN
       INSERT INTO BLEntityMembers (EntityID, AssocType, ClientID, AppTypeID, InstanceID, BackupSetID, AppID)
       VALUES (@cEntityID,@cAssocLevel,@cClientID,@cAppTypeID,@cInstanceID,@cBackupID,@cAppID)
    END
    ELSE
    BEGIN
       INSERT INTO #tempOPStatus VALUES (@cTmpID,@retAssoc)
    END
      FETCH NEXT FROM AddBEAssoc_Cursor INTO
		@cTmpID,@cEntityID,@cClientID,@cAppTypeID,@cBackupID,@cInstanceID,@cAppID,@cAssocLevel
    END
    CLOSE AddBEAssoc_Cursor
    DEALLOCATE AddBEAssoc_Cursor
    IF EXISTS (SELECT * FROM #tempOPStatus )
    BEGIN
      SELECT 'Following associations were not made since either associations are already present or there are asscociations at higher levels.'
      SELECT * FROM #tempBEMembersInput WHERE ID in (SELECT UID from #tempOPStatus)
    END
    IF EXISTS (SELECT * FROM #tempBEMembersProcessed WHERE
				EntityID <= 0 OR ClientID <= 0 OR  AppTypeID < 0 OR BackupSetID < 0 OR InstanceID < 0
				OR AppID < 0  OR AssocLevel = 0 )
	BEGIN
	  SELECT 'Could not make a few associtations due to invalid user input'
	  SELECT * FROM #tempBEMembersInput WHERE ID in (
	  SELECT InID FROM #tempBEMembersProcessed WHERE
				EntityID <= 0 OR ClientID <= 0 OR  AppTypeID < 0 OR BackupSetID < 0 OR InstanceID < 0
				OR AppID < 0  OR AssocLevel = 0 )
	  SET @errCode = 2
	END
 ERROR_EXIT:
    SELECT @errString = ErrString FROM #tempOPErrCodes WHERE ErrCode = @errCode
    IF OBJECT_ID('tempdb.dbo.#tempOPErrCodes') IS NOT NULL DROP TABLE #tempOPErrCodes
    IF OBJECT_ID('tempdb.dbo.#tempOPStatus') IS NOT NULL DROP TABLE #tempOPStatus
    IF OBJECT_ID('tempdb.dbo.#tempBEMembersInput') IS NOT NULL DROP TABLE #tempBEMembersInput
    IF OBJECT_ID('tempdb.dbo.#tempBEMembersProcessed') IS NOT NULL DROP TABLE #tempBEMembersProcessed
    Print @scriptName + ' completed at '+ Convert(varchar(60), getdate())+'. ErrorCode ('+	Convert(varchar(2),@errCode) +').'
    if @errCode <> 0
     	Raiserror(@errString,
     			    15,  --Severity (> 10 to force DOS Error Code = 1)
    				1	 --State
     				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_AssociateBillableEntity')
	delete from GxQscripts where name = 'QS_AssociateBillableEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssociateBillableEntity')
	delete from GXDBVersions where aliasname = 'QS_AssociateBillableEntity'
GO

insert into GXDBVersions values(2, 'QS_AssociateBillableEntity',  '00000000000000000000', 'QS_AssociateBillableEntity', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_AssociateBillableEntity',  0, GETDATE(), GETDATE(), '' + CHAR(10) + '	qoperation execscript -sn QS_AssociateBillableEntity.sql -si AssociationCSVFile
'
 + CHAR(10) + '-- 	script_name: QS_AssociateBillableEntity.'
 + CHAR(10) + '-- 	Associate billable entity to client or iDA or Instance or Backupset or SubClient.'
 + CHAR(10) + '-- 	Input Argument: AssociationCSVFile is file that contains CSV of billable entity and intended associations.'
 + CHAR(10) + '	Input file contains one or more lines of this format [<Billable Entity Name>,<Client Name>,<IDA Name>,<Instance Name>,<BackupSet Name>,<SubClient Name>]
'
 + CHAR(10) + '	Billable Entity Name and Client Name are mandatory. Others are conditionally optional. 
'
)
GO

