

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_AssignRoleToUserOrGroupOnPlan.sp] ---------- 

-------------------------------------------
--         Name:   QS_AssignRoleToUserOrGroupOnPlan.sql
--         Date:   25-June-2014
--       Author:   njain
--  Description:   Assign role to plan for a user/usergroup
--
--   CommcellId:   N/A (generic)
-------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QS_AssignRoleToUserOrGroupOnPlan')
BEGIN
	print '>>> Drop Stored Procedure: QS_AssignRoleToUserOrGroupOnPlan <<<'
	drop procedure QS_AssignRoleToUserOrGroupOnPlan
END
IF EXISTS (select * from GxQscripts where name='QS_AssignRoleToUserOrGroupOnPlan')
	delete from GxQscripts where name = 'QS_AssignRoleToUserOrGroupOnPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssignRoleToUserOrGroupOnPlan')
	delete from GXDBVersions where aliasname = 'QS_AssignRoleToUserOrGroupOnPlan'
GO
print '... Creating Procedure: QS_AssignRoleToUserOrGroupOnPlan'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_AssignRoleToUserOrGroupOnPlan
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
-- Qscript Usage.
  @i_operation NVARCHAR(MAX) = '',
  @i_roleName NVARCHAR(MAX) = '',
  @i_userOrGroupName NVARCHAR(MAX) = '',
  @i_planName NVARCHAR(MAX) = ''
AS
SET NOCOUNT ON
DECLARE @opType				INT = 0,
		@isUser				INT = 0,
		@roleDefintionXml	XML = NULL
DECLARE	@userGroupId		INT = 0,
		@roleId				INT = ISNULL((SELECT id FROM UmRoles WHERE name = @i_roleName), 0),--ISNULL((SELECT id FROM UmRoles WHERE name = 'CVIT - CommServe Admin_Advanced'), 0),
		@adminUserId		INT = (SELECT TOP 1 id FROM UMUsers WHERE flags & 0x040 <> 0),
		@lastError			INT = 0,
		@errorMsg			NVARCHAR(MAX)=''
-------- Local Variables    -------------
--
BEGIN TRY
	------------------------------------------------------------
	--- CHECK IF MINIMUM (& VALID!) PARAMETERS SPECIFIED	 ---
	------------------------------------------------------------
	SET @i_roleName			= ISNULL(LTRIM(RTRIM(@i_roleName)),'')
	SET @i_userOrGroupName	= ISNULL(LTRIM(RTRIM(@i_userOrGroupName)),'')
	SET @i_planName			= ISNULL(LTRIM(RTRIM(@i_planName)),'')
	IF @i_operation = '' OR @i_roleName = '' OR @i_userOrGroupName = ''
	BEGIN
		Set @lastError = 1;
		THROW 51000, N'Incorrect usage.', 1
	END
	--
	SELECT @opType = IIF(@i_operation = 'remove', 3, 2/*ADD*/)
	IF @roleId = 0
	BEGIN
		SET @lastError = 1;
		SET @errorMsg = 'The role name ''' + @i_roleName + ''' doesn''t exist.';
		THROW 51000, @errorMsg, 1
	END
	SET @userGroupId = ISNULL((SELECT id FROM UmGroups where name = @i_userOrGroupName), 0)
	IF @userGroupId = 0
	BEGIN
		-- CHECK IF IT IS COMPANY USER GROUP
		IF @userGroupId = 0
		BEGIN
			DECLARE @pos INT = CHARINDEX('\', @i_userOrGroupName), @providerId INT = -1
			DECLARE @userGroupName NVARCHAR(1024) = '', @providerName NVARCHAR(1024) = ''
			IF @pos <> 0
			BEGIN
				SET @providerName = LTRIM(RTRIM(LEFT(@i_userOrGroupName, @pos-1)))
				SET @userGroupName = RIGHT(@i_userOrGroupName, LEN(@i_userOrGroupName)-@pos)
			END
			SET @providerId = ISNULL((SELECT id FROM UMDSProviders WHERE domainName = @providerName), 0)
			IF (@providerId <> 0)
				SET @userGroupId = ISNULL((SELECT id FROM UmGroups WHERE name = @userGroupName AND umdsProviderId = @providerId), 0)
		END
		IF @userGroupId = 0
		BEGIN
			SET @userGroupId = ISNULL((SELECT id FROM UmUsers WHERE login = @i_userOrGroupName), 0)
			IF @userGroupId = 0
			BEGIN
				SET @lastError = 1;
				SET @errorMsg = 'The user or group name ''' + @i_userOrGroupName + ''' doesn''t exist.';
				THROW 51000, @errorMsg, 1
			END
			SET @isUser = 1
		END
	END
	--
	--	-------------------------------------------------------------------
	IF OBJECT_ID('tempdb.dbo.#plans') IS NOT NULL
        DROP TABLE #plans
	CREATE TABLE #plans (planId INT PRIMARY KEY)
	INSERT INTO #plans (planId)
		SELECT id
		FROM App_Plan
		WHERE flag&0x0004 <> 0x0004/*filter deleted*/ and flag&0x40000000 <>0x40000000/*Scheduled to be deleted*/
		AND (@i_planName = '' OR name = @i_planName)
	DECLARE @executionStatus  TABLE (errorCode INT, errorMsg NVARCHAR(1024))
	--  GIVE OWNERS COMPANY AND PLAN OWNER SUBSCRIPTION ROLE -----------------------------------------------------------------------------------------------
	-- -- build xml
	SET @roleDefintionXml =
		(SELECT @opType AS '@associationsOperationType', -- Operation Type REMOVE=1, ADD=2
			(SELECT
				(SELECT
					(SELECT 150 AS '@_type_',  158 AS '@entityType', P.planId AS '@entityId' FOR XML PATH('entity'), TYPE)
					FROM #plans P ORDER BY P.planId
					FOR XML PATH('entities'), TYPE),
				(SELECT
					(SELECT @roleId AS '@roleId' FOR XML PATH('role'), TYPE)
				FOR XML PATH('properties'), TYPE)
			FOR XML PATH('associations'), TYPE)--,
	--           (SELECT
	--               (SELECT
				--	(SELECT 150 AS '@_type_',  158 AS '@entityType', P.id as '@entityId' FOR XML PATH('entity'),TYPE)
				--FOR XML PATH('entities'), TYPE),
	--               (SELECT
				--	(SELECT 107 AS '@categoryId', 31 AS '@permissionId'  FOR XML PATH('permissions'), TYPE)
				--FOR XML PATH('properties'), TYPE)
	--           FOR XML PATH('associations'), TYPE)
		FOR XML PATH('App_SecurityAssociationForUserOrGroupList'),TYPE)
	-- -- make the association
	BEGIN TRAN
	IF @isUser = 0
		INSERT INTO @executionStatus
			EXEC sec_setSecurityAssociationsFromUserOrUserGroup @roleDefintionXml, @adminUserId, 0/*userId*/, @userGroupId, 0/*isCmdline*/
	ELSE
		INSERT INTO @executionStatus
			EXEC sec_setSecurityAssociationsFromUserOrUserGroup @roleDefintionXml, @adminUserId, @userGroupId, 0/*groupId*/, 0/*isCmdline*/
	-- check for errors
	SELECT @lastError = errorCode, @errorMsg = errorMsg FROM @executionStatus
	IF @lastError != 0
	BEGIN
		ROLLBACK TRAN
		IF LEN(ISNULL(@errorMsg, '')) = 0
			SET @errorMsg = 'Failed to execute the script successfully.';
		THROW 51000, @errorMsg, 1
	END
	ELSE
		COMMIT TRAN
	--SELECT @lastError as errorCode, @errorMsg as errorMessage, @roleDefintionXml
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @lastError = @@ERROR
	IF (@lastError = 1 )
    BEGIN
        SELECT usage FROM GxQscripts
        WHERE name = 'QS_AssignRoleToUserOrGroupOnPlan'
    END
	IF (XACT_STATE()) = 1 AND @lastError = 0
    BEGIN
        PRINT 'The transaction is committable.' + ' Committing transaction.'
        COMMIT TRANSACTION;
    END;
	ELSE IF (XACT_STATE()) <> 0
	BEGIN
		PRINT 'The transaction is in an uncommittable state.' + ' Rolling back transaction.'
        ROLLBACK TRANSACTION;
	END;
    THROW
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QS_AssignRoleToUserOrGroupOnPlan')
	delete from GxQscripts where name = 'QS_AssignRoleToUserOrGroupOnPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AssignRoleToUserOrGroupOnPlan')
	delete from GXDBVersions where aliasname = 'QS_AssignRoleToUserOrGroupOnPlan'
GO

insert into GXDBVersions values(2, 'QS_AssignRoleToUserOrGroupOnPlan',  '00000000000000000000', 'QS_AssignRoleToUserOrGroupOnPlan', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_AssignRoleToUserOrGroupOnPlan',  2, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn AssignRoleToUserOrGroupOnPlan -si "<add/remove>" -si "<role name>" -si "<user/usergroup name>" -si "<plan name>"'
 + CHAR(10) + '-- 		qoperation execscript -sn AssignRoleToUserOrGroupOnPlan -si "<add/remove>" -si "<role name>" -si "<user/usergroup name>"'
 + CHAR(10) + '-- 		Script to assign role to plan for a user/usergroup'
)
GO

