

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QS_AppSetOverrideSPcompression.sp] ---------- 

-------------------------------------------
--         Name:   QS_AppSetOverrideSPcompression.sql
--         Date:   16-Aug-2011
--       Author:   SKatz
--  Description:   Set/Clear the "Override SP Compression Setting" subClient  property
--					.. for the provided appId and its children
--
-- TR(original):   None
--     Customer:   The Dress Barn
--   CommcellId:   N/A (generic)
-------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QS_AppSetOverrideSPcompression <<<'

IF EXISTS (select * from sysobjects where name='QS_AppSetOverrideSPcompression')
	drop procedure QS_AppSetOverrideSPcompression
IF EXISTS (select * from GxQscripts where name='QS_AppSetOverrideSPcompression')
	delete from GxQscripts where name = 'QS_AppSetOverrideSPcompression'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AppSetOverrideSPcompression')
	delete from GXDBVersions where aliasname = 'QS_AppSetOverrideSPcompression'
GO
print '... Creating Procedure: QS_AppSetOverrideSPcompression'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QS_AppSetOverrideSPcompression
-- Qscript is Enabled
-- Set Audit Level: NO_AUDIT_TRAIL, AUDIT_TRAIL_LEVEL_LOW, _MEDIUM, _HIGH, _CRITICAL
--  3 Corresponds to "medium", same as same functionality in GUI.  Macro doesn't expand right for some reason
-- Qscript Usage.
  @NewState Varchar(256),			-- Must always have this parameter
  @ClientParam varchar(1030),			-- Must always specifiy Client or ClientGroup 
  @AppTypeParam varchar(100)  = '',		-- AppType (or empty)
  @ParamOption1 varchar(256)  = '',		-- Could be Instance or BackupSet (or empty)
  @ParamOption2 varchar(1030) = '',		-- Counld be BackupSet or SubClient (or empty)
  @ParamOption3 varchar(1030) = ''		-- Could be SubClient or (empty)
AS
Set NOCOUNT ON
---- Convenience Definitions    -----------
DECLARE @scriptName				varchar(32)
SET		@scriptName				= 'QS_AppSetOverrideSPcompression'
DECLARE @created				AS integer		= 0
DECLARE @nowTime				AS integer		= dbo.GetUnixTime (GetUTCdate())
DECLARE @0x0080	AS integer		= 	128  		--Subclient Policy backupset
DECLARE @OVERRIDE_COMPR_PROP	AS nvarchar(256)= N'Override SP Compression Setting'
--
--
-------- Local Variables    -------------
--
DECLARE @userId					AS	integer = 1			-- Until there is a way to fetch from Qcommand!
DECLARE	@newStateVal			AS	nvarchar(64) = N'0'
DECLARE @currentVal				nvarchar(256)
DECLARE @isIgnoreJobsRunning	AS 	integer = 0
--
--
DECLARE @localErrorMsg			AS	VARCHAR(512)	='Error Encountered when running script.'
DECLARE @lastError				AS	integer = 0							-- Be optimistic
--
DECLARE @clientOption			AS VARCHAR(10) ='c='
DECLARE @clientGroupOption		AS VARCHAR(10) ='cg='
DECLARE @apptypeOption			AS VARCHAR(32) ='a='
DECLARE @instanceOption			AS VARCHAR(32) ='i='
DECLARE @backupsetOption		AS VARCHAR(32) ='b='
DECLARE @subclientOption		AS VARCHAR(32) ='s='
Declare @clientId				AS INTEGER	= 0
DECLARE	@clientGroupId			AS INTEGER	= 0
DECLARE	@appTypeId				AS INTEGER	= 0
DECLARE	@instanceId				AS INTEGER	= 0
DECLARE	@backupsetId			AS INTEGER	= 0
DECLARE	@subclientId			AS INTEGER	= 0
DECLARE @clientName				AS VARCHAR(256) = ''
DECLARE @clientGroupName		AS VARCHAR(256) = ''
DECLARE @appTypeName			AS VARCHAR(256) = ''
DECLARE @instanceName			AS VARCHAR(256) = ''
DECLARE @backupsetName			AS VARCHAR(256) = ''
DECLARE @subclientName			AS VARCHAR(256) = ''
--
--
---------------------------------------------------
--- FOR GUI AUDIT TRAIL						-------
---------------------------------------------------
	DECLARE @opMsgId INTEGER
--
	DECLARE @opEvMsgId			INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId			INTEGER
	DECLARE @paramData 			NVARCHAR(MAX)
	DECLARE @dataIsEvent		INTEGER
---------------------------------------------------
DECLARE @INSERT_PROP_RESULTS table (			-- THIS TABLE WILL BE USED TO CAPTURE THE RESULT SETS FROM
	errorCode 			integer,				-- APPINSERTSUBCLIENTPROP
	hasChanged			integer,
	propId				integer,
	errorString			varchar(1024)
)
--
CREATE TABLE #subClientList						-- THIS WILL BE POPULATED WITH ALL THE SUBCLIENTS THAT NEED TO BE ADDRESSED
(
  clientId		integer,
  appTypeId		integer,
  InstanceId	integer,
  BackupsetId	integer,
  subClientId  	integer,
  subClientName	varchar(256),
  currentVal	nvarchar(256)
)
--DECLARE @jobIdTbl table( jobId integer );
------------------------------------------------------------
--- CHECK IF MINIMUM (& VALID!) PARAMETERS SPECIFIED	 ---
------------------------------------------------------------
	IF @NewState = 'enable'
		SET @newStateVal = N'1'
	ELSE if @newState = 'disable'
		SET @newStateVal = N'0'
	ELSE
		BEGIN
			SET @localErrorMsg	='Error. New state must be enable or disable'
			SET @lastError = 1
			GOTO   ARGS_ERROR
		END
----------------------------------------------
--	PROCESS CLIENTNAME OR CLIENT GROUP NAME --
----------------------------------------------
	IF SUBSTRING(@ClientParam, 1, 2) = @clientOption
	BEGIN
		SET @clientName  = (SELECT SUBSTRING(@ClientParam, 3, LEN(@ClientParam)-2))
		SET @clientId = ISNULL((Select id from APP_Client where name = @clientName), 0)
		IF @clientId = 0
		BEGIN
			SET @localErrorMsg = 'Error. No client with the name [' + @clientName + '] exists on this Commcell.'
			SET @lastError = 1
			GOTO ARGS_ERROR
		END
	END
	ELSE IF SUBSTRING(@ClientParam, 1, 3) = @clientGroupOption
	BEGIN
		SET @clientGroupName  = (SELECT SUBSTRING(@ClientParam, 4, LEN(@ClientParam)-3))
		SET @clientgroupId = ISNULL((Select id from APP_ClientGroup where name = @clientGroupName), 0)
		IF @clientgroupId = 0
		BEGIN
			SET @localErrorMsg = 'Error. No client group with the name [' + @clientGroupName + '] exists on this Commcell.'
			SET @lastError = 1
			GOTO ARGS_ERROR
		END
	END
  	ELSE
	BEGIN
		SET @lastError = 1
		SET @localErrorMsg = 'Parameter2 must be a Client or client group name beginning with c=  or cg=. But it was ['+@clientOption+'].'
		GOTO ARGS_ERROR
	END
--
--
--	AFTER NEWSTATE, AND CLIENT OR CLIENTGROUP PARAMETERS, ALL THE REMAINING PARAMETERS ARE "OPTIONS" (i.e. wildcarded)
----------------------------------------------
--	PROCESS APPTYPE 						--
----------------------------------------------
	IF @appTypeParam <> ''
	BEGIN
		IF SUBSTRING(@AppTypeParam, 1, 2) <> @apptypeOption
		BEGIN
			SET @lastError = 1
			SET @localErrorMsg = 'Parameter3 must be iDA name beginning with a= . But it was ['+@AppTypeParam+'].'
			GOTO ARGS_ERROR
		END
		SET @appTypeName  = (SELECT SUBSTRING(@AppTypeParam, 3, LEN(@AppTypeParam)-2))
		IF @clientId <> 0
		BEGIN
			SET @appTypeId = ISNULL((Select distinct type from APP_IDAType where displayName = @appTypeName AND type in
								(Select distinct appTypeId from app_application where clientId = @clientId)), 0)
			IF @appTypeId = 0
			BEGIN
				SET @lastError = 1
				SET @localErrorMsg = 'Error. No application of type ['+@appTypeName + '] could be found on client ['+ @clientName + '].'
				GOTO ARGS_ERROR
			END
		END
	END
--
--
----------------------------------------------
--	PROCESS Instance or backupset			--
----------------------------------------------
	IF @ParamOption1 <> ''
	BEGIN
		IF SUBSTRING(@ParamOption1, 1, 2) <> @instanceOption AND SUBSTRING(@ParamOption1, 1, 2) <> @backupsetOption
		BEGIN
			SET @lastError = 1
			SET @localErrorMsg = 'Parameter4 must be Instance name beginning with i=  or backupsetName beginning with b= . But it was ['+@ParamOption1+'].'
			GOTO ARGS_ERROR
		END
--
		IF SUBSTRING(@ParamOption1, 1, 2) = @instanceOption
		BEGIN
			SET @instanceName  = (SELECT SUBSTRING(@ParamOption1, 3, LEN(@ParamOption1)-2))
		END
		IF SUBSTRING(@ParamOption1, 1, 2) = @backupsetOption
		BEGIN
			SET @backupsetName  = (SELECT SUBSTRING(@ParamOption1, 3, LEN(@ParamOption1)-2))
		END
	END
--
--
----------------------------------------------
--	PROCESS Backupset or subClient			--
----------------------------------------------
	IF @ParamOption2 <> ''
	BEGIN
		IF SUBSTRING(@ParamOption2, 1, 2) <> @subClientOption AND SUBSTRING(@ParamOption2, 1, 2) <> @backupsetOption
		BEGIN
			SET @lastError = 1
			SET @localErrorMsg = 'Parameter5 must be Instance name beginning with i=  or backupsetName beginning with b= . But it was ['+@ParamOption2+'].'
			GOTO ARGS_ERROR
		END
--
		IF SUBSTRING(@ParamOption2, 1, 2) = @backupsetOption
		BEGIN
			SET @backupsetName  = (SELECT SUBSTRING(@ParamOption2, 3, LEN(@ParamOption2)-2))
		END
		IF SUBSTRING(@ParamOption2, 1, 2) = @subClientOption
		BEGIN
			SET @subclientName  = (SELECT SUBSTRING(@ParamOption2, 3, LEN(@ParamOption2)-2))
		END
	END
--
--
----------------------------------------------
--	PROCESS  subClient(or nothing)			--
----------------------------------------------
	IF @ParamOption3 <> ''
	BEGIN
		IF SUBSTRING(@ParamOption3, 1, 2) <> @subClientOption
		BEGIN
			SET @lastError = 1
			SET @localErrorMsg = 'Parameter6 must be subClientName beginning with s= . But it was ['+@ParamOption3 +'].'
			GOTO ARGS_ERROR
		END
--
		IF SUBSTRING(@ParamOption3, 1, 2) = @subClientOption
		BEGIN
			SET @subclientName  = (SELECT SUBSTRING(@ParamOption3, 3, LEN(@ParamOption3)-2))
		END
	END
--	-------------------------------------------------------------------
BEGIN TRY
	BEGIN TRAN
--	DETERMINE WHICH SUBCLIENTS "MAY" NEED UPDATING.  SLIGHLY DIFFERENT FOR CLIENT vs. CLIENTGROUP SEARCHES
	IF @clientGroupId <> 0
		INSERT #subClientList
			SELECT clientId, appTypeId, instance, backupset, id, subClientName, N'0'
				FROM App_Application
					WHERE clientId in (Select clientId from APP_ClientGroupAssoc where clientGroupId = @clientGroupId)
					  AND ((appTypeId in (Select distinct type from APP_IDAType where displayName = @appTypeName)) or @appTypeName = '')
					  AND appTypeId <> 1000 -- DR subclient
	ELSE
		INSERT #subClientList
			SELECT clientId, appTypeId, instance, backupset, id, subClientName, N'0'
			  FROM APP_Application
				WHERE clientId = @clientId
				  AND (@appTypeId = 0		OR appTypeId 		= @appTypeId)
				  AND (@instanceName = ''	OR instance  		in (Select id from app_instanceNAme where name = @instanceName))
				  AND (@backupsetName = ''	OR backupset 		in (Select id from app_backupsetName where name = @backupsetName))
				  AND (@subClientName = ''	OR subClientName	= @subClientName)
--
	UPDATE #subClientList
		SET currentVal = ISNULL((Select attrVal from app_subclientProp where componentNameId = subclientId AND attrName = @OVERRIDE_COMPR_PROP and CHECKSUM(@OVERRIDE_COMPR_PROP)= cs_attrName AND modified=0), N'0')
--	select * from  #subClientList   DEBUGGING ONLY!
--	------------------------------
--	  CHECK FOR RUNNING JOBS:	--
--	------------------------------
-- 8/15/2011  - Per Anand V., No running jobs check should be done.  The code below is commented out is actually "borrowed" from another SP and was
--				.. not "ported" as of when the decision to not do the check was made.  Left here in case that decision is ever changed :). --- StuK
/*
	if @isIgnoreJobsRunning = 0
	BEGIN
		INSERT INTO @jobIdTbl
			SELECT jobId FROM JMRstJobInfo
				WHERE bkpSetID IN (Select componentNAmeId from APP_backupsetProp where attrName = N'Associated subclient Policy' and attrVal = @subClientPolicyId AND modified = 0)
		  UNION
			SELECT jobId FROM JMBkpJobInfo
				WHERE applicationId IN (Select componentNAmeId from APP_subClientProp where attrName = N'Associated subclient Policy'and attrVal = @subClientPolicyId  and modified = 0)
		IF EXISTS( SELECT jobId FROM @jobIdTbl)
			BEGIN						-- SINCE NO GUI AUDIT TRAIL OCCURS WHEN THIS HAPPENS THROGH JAVA GUI
				SET @lastError= -2		-- .. WE ARE NOT OBLIGED TO AUDIT IT THRU THIS QSCRIPT EITHER
				SET @localErrorMsg = N'Unable to modify content. Jobs are still in progress.'
				GOTO PROCESS_ERROR
			END
	END
*/
--
--
--	----------------------------------------------------------------------------------------------
--	ITERATE THROUGH ALL THE SUBCLIENTS NOW, UPDATNG THE PROPERTIES IF NEEDED AS WELL AS DO THE	--
--	GUI AUDIT TRAIL STUFF																		--
--	----------------------------------------------------------------------------------------------
	IF ( CURSOR_STATUS('global', 'subClientCursor') >= 0   OR CURSOR_STATUS('local', 'subClientCursor') >= 0 )
		CLOSE subClientCursor
	IF ( CURSOR_STATUS('global','subClientCursor') = -1     OR CURSOR_STATUS('local','subClientCursor') = -1 )
		DEALLOCATE subClientCursor
--
	DECLARE subClientCursor CURSOR STATIC FOR
			SELECT clientId,  appTypeId, InstanceId,  BackupsetId,  subClientId, subClientName,  currentVal
			FROM #subClientList
				ORDER BY clientId, appTypeId, InstanceId, backupsetId, subClientName
--
	OPEN subClientCursor
	FETCH NEXT FROM subClientCursor INTO @clientId, @appTypeId, @instanceId, @backupsetId, @subClientId, @subClientName, @currentVal
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @currentVal <> @newStateVal					-- Don't waste time processing if newstate = oldstate or by writing default value ('0')
		BEGIN											-- .. to the DB (if prop not currently "set")
			DELETE @INSERT_PROP_RESULTS
			INSERT @INSERT_PROP_RESULTS
				EXEC APPInsertSubClientProp @subClientId, 1, @nowTime, @OVERRIDE_COMPR_PROP, 2, @newStateVal      -- PIT=1, attrType = 2 (Bool)
				SET @lastError		= ISNULL((Select top 1 errorCode from @INSERT_PROP_RESULTS), 0)
				SET @localErrorMsg	= ISNULL((Select top 1 errorString from @INSERT_PROP_RESULTS), 0)
				IF @lastError <> 0
					BREAK
--
		--	DO GUI AUDIT TRAIL --
SET @opMsgId = (277 | (CAST(POWER(2, 24) AS BIGINT) * 84))
			EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
			SET @dataIsEvent = 0
		--
SET @paramMsgId  = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = ISNULL((Select name from app_client where id = @clientId), 'No Client Name')  --- FOR SCP, use client == commcell
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		--
SET @paramMsgId  = (206 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = ISNULL((Select name from app_idaType where type = @appTypeId), 'No Ida Name')
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		--
SET @paramMsgId  = (208 | (CAST(POWER(2, 24) AS BIGINT) * 85))		--'GUIAUDIT_PARAMS_BACKUP_SET'
					SET @paramData   = ISNULL((Select name from app_backupsetName where id = @backupSetId), 'No Backupset Name')
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		--
SET @paramMsgId  = (211 | (CAST(POWER(2, 24) AS BIGINT) * 85))			--'GUIAUDIT_PARAMS_SUBCLIENT_NAME'
					SET @paramData   = @subClientName
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		--
SET @paramMsgId  = (232 | (CAST(POWER(2, 24) AS BIGINT) * 85))		-- 'GUIAUDIT_PARAMS_SUBCLIENT_PROPERTY_CHANGE'
					SET @paramData   = 'Run from QCommand.'
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
					--
					IF	@isIgnoreJobsRunning <> 0
					BEGIN
						SET @paramData   = 'Running jobs check skipped by user request.'
						EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
						EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
					END
					IF @newStateVal = N'1'
						SET @paramData = 'Override Storage Policy Compression Setting is now enabled.'
					ELSE
						SET @paramData = 'Override Storage Policy Compression Setting is now disabled.'
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
		END
--
		FETCH NEXT FROM subClientCursor INTO @clientId, @appTypeId, @instanceId, @backupsetId, @subClientId, @subClientName, @currentVal
	END
--
	CLOSE subClientCursor
	DEALLOCATE subClientCursor
	IF @lastError <> 0
		GOTO PROCESS_ERROR
END TRY
--
--
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    Set @lastError      = ERROR_NUMBER()
    SET @localErrorMsg  = ERROR_MESSAGE()
END   CATCH
PROCESS_ERROR:
IF @lastError  = 0
	COMMIT TRAN
ELSE
	ROLLBACK TRAN
ARGS_ERROR:
DECLARE @msgString varchar(2048)
SET @msgString = @scriptName + ' completed at '
         + Convert(varchar(60), getdate())
		 + ' with Parameters: newState = ['
         + @NewState
         + '], '
         + @ClientParam
IF @appTypeParam <> ''
	SET @msgString = @msgString+ ', '  +@AppTypeParam
IF @ParamOption1 <> ''
	SET @msgString = @msgString + ', ' +@ParamOption1
IF @ParamOption2 <> ''
	SET @msgString = @msgString + ', ' +@ParamOption2
IF @ParamOption3 <> ''
	SET @msgString = @msgString + ', ' +@ParamOption3
SET @msgString =  @msgString   + '. Exit Code(' +convert(varchar(2), @lastError) + ').'
PRINT @msgString
if @lastError <> 0
	Raiserror(@localErrorMsg,
			    15,  --Severity (> 10 to force DOS Error Code = 1)
				1	 --State
				)
set nocount off
GO

IF EXISTS (select * from GxQscripts where name = 'QS_AppSetOverrideSPcompression')
	delete from GxQscripts where name = 'QS_AppSetOverrideSPcompression'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QS_AppSetOverrideSPcompression')
	delete from GXDBVersions where aliasname = 'QS_AppSetOverrideSPcompression'
GO

insert into GXDBVersions values(2, 'QS_AppSetOverrideSPcompression',  '00000000000000000000', 'QS_AppSetOverrideSPcompression', '00000000000000000000')
GO

insert into GxQscripts values(2,'QS_AppSetOverrideSPcompression',  3, GETDATE(), GETDATE(), '' + CHAR(10) + '-- 		qoperation execscript -sn QS_AppSetOverrideSPcompression -si ''enable|disable'' -si ''c=clientName|cg=clientGroupName''  [-si ''a=appType''] [-si ''i=instanceName''] [-si ''b=backupsetName'']  [-si s=subClientName]'
 + CHAR(10) + '--       .. Enable or disable Storage Policy Compression Override setting for selected subClient(s).'
)
GO

