

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QSDK_GetSessionInfo.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QSDK_GetSessionInfo')
BEGIN
	print '>>> Drop Stored Procedure: QSDK_GetSessionInfo <<<'
	drop procedure QSDK_GetSessionInfo
END
IF EXISTS (select * from GxQscripts where name='QSDK_GetSessionInfo')
	delete from GxQscripts where name = 'QSDK_GetSessionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_GetSessionInfo')
	delete from GXDBVersions where aliasname = 'QSDK_GetSessionInfo'
GO
print '... Creating Procedure: QSDK_GetSessionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QSDK_GetSessionInfo
  @guid varchar(255),    
  @updateLastAccessedTime int,
  @location nvarchar(2048) = ''
AS
  DECLARE @errorCode int
  DECLARE @userId int
  DECLARE @userName NVARCHAR(255)
  DECLARE @userGuid VARCHAR(255)
  DECLARE @clientHostName VARCHAR(255)
  DECLARE @lastAccessTime int
  DECLARE @timeout int
  DECLARE @lastLocation nvarchar(2048)
    SET NOCOUNT ON
	SET @errorCode = 0
	SET @userId = 0
	SET @userName = ''
	SET @clientHostName = ''
	SET @lastAccessTime = 0
	SET @timeout = 0
	DECLARE @sessionGUID UNIQUEIDENTIFIER
	IF @guid IS NOT NULL AND LEN(@guid) > 0
		BEGIN TRY
			SET @sessionGUID = CONVERT(UNIQUEIDENTIFIER,@guid)
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = CONVERT(INT,0x5)
			--EXECUTE usp_GetErrorInfo;
			GOTO CX_EXIT
		END CATCH
	ELSE
	BEGIN
SET @errorCode = CONVERT(INT,0x5)
		GOTO CX_EXIT
	END
	DECLARE @curTime int = 0
	SET @curTime  = (SELECT [CommServ].[dbo].[GetUnixTime](GETUTCDATE()))
	DECLARE @QSDKTimeOutText NVARCHAR(MAX)
	DECLARE @globalTimeOut INT = -1
	SET @QSDKTimeOutText = (SELECT TOP 1 value FROM GXGlobalParam WHERE  modified = 0 AND name = 'QSDKSessionTimeOut')
	IF @QSDKTimeOutText IS NOT NULL
		SET @globalTimeOut = CONVERT(INT, @QSDKTimeOutText)
	DELETE UMQSDKSessions WHERE GUID = @sessionGUID AND ((timeout = 0  AND @globalTimeOut > 0 AND lastAccessedTime + @globalTimeOut <= @curTime) OR (timeout > 0 AND lastAccessedTime + timeout*60 <= @curTime))
	IF NOT EXISTS(SELECT * FROM UMQSDKSessions WHERE GUID = @sessionGUID)
	BEGIN
set @errorCode = CONVERT(int,0x103)
		GOTO CX_EXIT
	END
	IF @updateLastAccessedTime IS NOT NULL AND @updateLastAccessedTime <> 0
		UPDATE UMQSDKSessions SET lastAccessedTime = @curTime WHERE GUID = @sessionGUID
	MERGE UMQSDKSessions as target
		USING (SELECT @location as location, @sessionGuid as session) as Source
		ON (target.GUID = source.session)
		WHEN MATCHED AND (source.Location is not null AND source.location != '' AND target.location != source.location)
		THEN
			UPDATE SET target.location = source.location;
	SELECT
		@userId = userId,
		@userName = userName,
		@clientHostName = hostName,
		@lastAccessTime = lastAccessedTime ,
		@timeout = timeout,
		@lastLocation = location
	FROM UMQSDKSessions WHERE GUID = @sessionGUID
	SELECT @userName = login, @userGuid = userGuid FROM UMUsers WITH (NOLOCK) WHERE id = @userId
CX_EXIT:
	SELECT
		@errorCode AS errorCode,
		@userId AS userId,
		@userName AS userName,
		@userGuid AS userGuid,
		@clientHostName AS clientHostName,
		@lastAccessTime as lastAccessTime,
		@timeout as Timeout,
		@lastLocation as location
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QSDK_GetSessionInfo')
	delete from GxQscripts where name = 'QSDK_GetSessionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_GetSessionInfo')
	delete from GXDBVersions where aliasname = 'QSDK_GetSessionInfo'
GO

insert into GXDBVersions values(2, 'QSDK_GetSessionInfo',  '00000000000000000000', 'QSDK_GetSessionInfo', '00000000000000000000')
GO

