

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QSDK_CreateSessionXML.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QSDK_CreateSessionXML <<<'

IF EXISTS (select * from sysobjects where name='QSDK_CreateSessionXML')
	drop procedure QSDK_CreateSessionXML
IF EXISTS (select * from GxQscripts where name='QSDK_CreateSessionXML')
	delete from GxQscripts where name = 'QSDK_CreateSessionXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_CreateSessionXML')
	delete from GXDBVersions where aliasname = 'QSDK_CreateSessionXML'
GO
print '... Creating Procedure: QSDK_CreateSessionXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QSDK_CreateSessionXML
  @i_xml XML
AS
  DECLARE @o_xml XML
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET NOCOUNT ON
    DECLARE @guid           VARCHAR(64)    = NULL
    DECLARE @userId         INT            = NULL
    DECLARE @clientHostName VARCHAR(MAX)   = NULL
    DECLARE @consoleType    INT            = NULL
    DECLARE @timeout        INT            = NULL
    DECLARE @location       NVARCHAR(2048) = NULL
    DECLARE @deviceId       NVARCHAR(128)  = NULL
    SELECT  @guid           = ref.value('@guid',           'VARCHAR(64)'),
            @userId         = ref.value('@userId',         'INT'),
            @clientHostName = ref.value('@clientHostName', 'VARCHAR(MAX)'),
            @consoleType    = ref.value('@consoleType',    'INT'),
            @timeout        = ref.value('@timeout',        'INT'),
            @location       = ref.value('@location',       'NVARCHAR(2048)'),
            @deviceId       = ref.value('@deviceId',       'NVARCHAR(128)')
    FROM    @i_xml.nodes ('Api_QSDKCreateSessionReq') R(ref)
    DECLARE @errorCode      INT = 0
    DECLARE @currentTime    INT = (SELECT dbo.GetUnixTime(GETUTCDATE()))
-- -- SP BODY BEGIN : QSDK_CreateSession.spb ---------------------------------------------------------------------------------------------------------------------------------------
	DECLARE @sessionGUID    UNIQUEIDENTIFIER
    DECLARE @userName       NVARCHAR(MAX)
    DECLARE @qsdkSessionId  INT
	IF @guid IS NOT NULL AND LEN(@guid) > 0
		BEGIN TRY
			SET @sessionGUID = CONVERT(UNIQUEIDENTIFIER,@guid)
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = CONVERT(INT,0x5)
			GOTO CX_EXIT
		END CATCH
	ELSE
	BEGIN
		SET @sessionGUID = NEWID()
		SET @guid = CONVERT(VARCHAR(255), @sessionGUID)
	END
    IF(@deviceId IS NULL OR @deviceId = '')
	BEGIN
		SET @deviceId = @clientHostName
	END
	SET @errorCode = 0
	SET @userName = ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @userId AND enabled = 1 ),'')
	IF LEN(@userName) = 0
	BEGIN
SET @errorCode = CONVERT(INT, 0x508)
		GOTO CX_EXIT
	END
	INSERT INTO UMQSDKSessions (userId, evmgrsSessionId, GUID, userName, password, created, lastAccessedTime, referenceCount, encryptedToken, sessionFileLocation, hostName, consoleType, timeout, location)
	    SELECT @userId, 0, @sessionGUID, @userName,'2AZdUUxUUyUUz', @currentTime, @currentTime, 1, '', '', @clientHostName, @consoleType, @timeout, @location
	INSERT INTO UMSessionAudit(userId, sessionId, createdTime, logoutTime, consoleType, host, remark, browserSessionId, location, flag, DeviceId, LinkSessionId, timeout)
	    SELECT @userId, @sessionGUID, @currentTime, 0, @consoleType, @clientHostName, '', 0, @location,0, @deviceId, NULL, @timeout
	SET @qsdkSessionId = SCOPE_IDENTITY()
CX_EXIT:
-- -- SP BODY END : QSDK_CreateSession.spb -----------------------------------------------------------------------------------------------------------------------------------------
    SET @o_xml =
		    (
                SELECT  @errorCode      AS '@errorCode',
                        id              AS '@userId',
                        [login]         AS '@userName',
                        userGuid        AS '@userGuid',
                        @clientHostName AS '@clientHostName',
                        @currentTime    AS '@lastAccessTime',
                        @timeout        AS '@timeout',
                        @location       AS '@lastLocation',
                        @guid           AS '@guid'
                FROM    UMUsers
                WHERE   id = @userId
                FOR XML PATH('Api_QSDKGetSessionInfoResp'), TYPE
             )
    SELECT @o_xml AS [o_xml]
GO

IF EXISTS (select * from GxQscripts where name = 'QSDK_CreateSessionXML')
	delete from GxQscripts where name = 'QSDK_CreateSessionXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_CreateSessionXML')
	delete from GXDBVersions where aliasname = 'QSDK_CreateSessionXML'
GO

insert into GXDBVersions values(2, 'QSDK_CreateSessionXML',  '00000000000000000000', 'QSDK_CreateSessionXML', '00000000000000000000')
GO

