

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QSDK_CreateSession.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QSDK_CreateSession')
BEGIN
	print '>>> Drop Stored Procedure: QSDK_CreateSession <<<'
	drop procedure QSDK_CreateSession
END
IF EXISTS (select * from GxQscripts where name='QSDK_CreateSession')
	delete from GxQscripts where name = 'QSDK_CreateSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_CreateSession')
	delete from GXDBVersions where aliasname = 'QSDK_CreateSession'
GO
print '... Creating Procedure: QSDK_CreateSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QSDK_CreateSession
  @guid varchar(255),    
  @userId int,    
  @clientHostName varchar(MAX),    
  @consoleType int,    
  @timeout int,
  @location nvarchar(2048) = '' ,   
  @deviceId nvarchar(128) = '',
  @loginType int = 0
AS
  DECLARE @errorCode int
  DECLARE @guidOut VARCHAR(255)
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    SET NOCOUNT ON
    DECLARE @currentTime    INT = (SELECT [dbo].[GetUnixTime](GETUTCDATE()))
    DECLARE @sessionGUID    UNIQUEIDENTIFIER
    DECLARE @userName       NVARCHAR(MAX)
    DECLARE @qsdkSessionId  INT
	IF @guid IS NOT NULL AND LEN(@guid) > 0
		BEGIN TRY
			SET @sessionGUID = CONVERT(UNIQUEIDENTIFIER,@guid)
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @errorCode = CONVERT(INT,0x5)
			GOTO CX_EXIT
		END CATCH
	ELSE
	BEGIN
		SET @sessionGUID = NEWID()
		SET @guid = CONVERT(VARCHAR(255), @sessionGUID)
	END
    IF(@deviceId IS NULL OR @deviceId = '')
	BEGIN
		SET @deviceId = @clientHostName
	END
	SET @errorCode = 0
	SET @userName = ISNULL((SELECT login FROM UMUsers WITH(NOLOCK) WHERE id = @userId AND enabled = 1 ),'')
	IF LEN(@userName) = 0
	BEGIN
SET @errorCode = CONVERT(INT, 0x508)
		GOTO CX_EXIT
	END
	--In case of Service Commcell timeout due to inactivity, the same session Id that had expired can be reused from the Router commcell.Deleting the existing entry so that the below insert
	--statements don't throw exception.Deleting instead of preventing a reinsert because this operation should be treated as a new login into commcell.
	DELETE FROM UMQSDKSessions WHERE GUID = @sessionGUID and userId = @userId
	DELETE FROM UMSessionAudit WHERE sessionId = @guid and userId = @userId
	INSERT INTO UMQSDKSessions (userId, evmgrsSessionId, GUID, userName, password, created, lastAccessedTime, referenceCount, encryptedToken, sessionFileLocation, hostName, consoleType, timeout, location, loginType)
	    SELECT @userId, 0, @sessionGUID, @userName,'2AZdUUxUUyUUz', @currentTime, @currentTime, 1, '', '', @clientHostName, @consoleType, @timeout, @location, @loginType
	INSERT INTO UMSessionAudit(userId, sessionId, createdTime, logoutTime, consoleType, host, remark, browserSessionId, location, flag, DeviceId, LinkSessionId, timeout)
	    SELECT @userId, @sessionGUID, @currentTime, 0, @consoleType, @clientHostName, '', 0, @location,0, @deviceId, NULL, @timeout
	SET @qsdkSessionId = SCOPE_IDENTITY()
CX_EXIT:
	SET @guidOut = @guid
	SELECT @errorCode as errorCode ,@guidOut as guidOut
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'QSDK_CreateSession')
	delete from GxQscripts where name = 'QSDK_CreateSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_CreateSession')
	delete from GXDBVersions where aliasname = 'QSDK_CreateSession'
GO

insert into GXDBVersions values(2, 'QSDK_CreateSession',  '00000000000000000000', 'QSDK_CreateSession', '00000000000000000000')
GO

