

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QSDK_CalculateSearchRestoreOrder.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2006  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QSDK_CalculateSearchRestoreOrder.sp,v $ $Id: QSDK_CalculateSearchRestoreOrder.sp,v 1.10.210.9 2019/08/01 13:31:11 sgolla Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QSDK_CalculateSearchRestoreOrder')
BEGIN
	print '>>> Drop Stored Procedure: QSDK_CalculateSearchRestoreOrder <<<'
	drop procedure QSDK_CalculateSearchRestoreOrder
END
IF EXISTS (select * from GxQscripts where name='QSDK_CalculateSearchRestoreOrder')
	delete from GxQscripts where name = 'QSDK_CalculateSearchRestoreOrder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_CalculateSearchRestoreOrder')
	delete from GXDBVersions where aliasname = 'QSDK_CalculateSearchRestoreOrder'
GO
print '... Creating Procedure: QSDK_CalculateSearchRestoreOrder'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QSDK_CalculateSearchRestoreOrder
  @l_SearchId integer,
  @l_copyPrec integer = 0
AS
  DECLARE @r_searchRestoreId integer
  DECLARE @r_NumFilesNotFound integer
  DECLARE @r_ErrorCode integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
-- local variables
SET @r_ErrorCode = 0
IF (@l_SearchId  is null)
BEGIN
	SET @r_ErrorCode = 1
	SET @l_SearchId = -1
	SET @r_NumFilesNotFound = -1
	GOTO FINISH
END
	if object_id('tempdb.dbo.#SearchRestoreArchChunks') is not null
	drop table #SearchRestoreArchChunks
	create table #SearchRestoreArchChunks
	(	AppType Integer,
		SearchFileId Integer,
		commcellId	Integer,
		archCopyId Integer,
		archChunkId bigint,
		MediaId		Integer,
		MediaGroupId Integer,
		MediaPoints bigInt )
	if object_id('tempdb.dbo.#SchedRestoreSearchFilesNotFound') is not null
	drop table #SchedRestoreSearchFilesNotFound
	create table #SchedRestoreSearchFilesNotFound
	(	id	Integer,
		appId Integer,
		IsCloudLaptopClient INTEGER
		primary key (id)
	)
-- update commcellIds if necessary
	UPDATE schedrestoresearchfiles
	SET CommcellId = CC.id
	FROM schedrestoresearchfiles SRF INNER JOIN App_Commcell CC ON CC.Number = SRF.CommcellNumber OR (SRF.CommcellNumber = -1 AND CC.id = 2)
	WHERE SRF.CommcellId is null
-- remove duplicate entries in a search, keep the first one. WebGUI does this automatically, Java UI does not. This causes excessive restores.
-- Duplicates are entries with the same (CCID, AFId, Offset) tuples.
	DECLARE @lt_Dups TABLE (minId Integer, CommcellId Integer, ArchiveFileId Integer, ArchiveFileOffset bigInt)
	insert into @lt_Dups
	select min(id), commcellId, ArchiveFileId, ArchiveFileOffset
	from schedrestoresearchfiles
	where SearchId = @l_SearchId
	group by commcellId, ArchiveFileId, ArchiveFileOffset
	having count(*) > 1
	delete schedrestoresearchfiles
	from @lt_Dups tt
		INNER JOIN schedrestoresearchfiles SRF ON
			SRF.commcellId = tt.commcellId AND
			SRF.ArchiveFileId = tt.ArchiveFileId AND
			SRF.ArchiveFileOffset = tt.ArchiveFileOffset
	WHERE SRF.id <> tt.minId AND SRF.SearchId = @l_SearchId
	--if show and restore aged data option enabled in commcell control panel, then we let aged items also to be restored
	--if option not enabled, we will check if ArchChunkMapping Or ArchFileCopy flags to see if it is marked as aged
	--
    DECLARE @includeAgedData int = 0
    SELECT @includeAgedData = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'ShowAgedDataForBrowseAndRecovery' AND modified = 0
	--
	-- Given an archivefileId and an offset, the following returns all the archchunks containing
	-- that offset in the archive file
	-- Chunks are needed to get the media.
	/*For NAS use logical size*/
    insert into #SearchRestoreArchChunks
	select RF.appType, RF.id, ACM.CommcellId, ACM.archCopyId, ACM.archChunkId, 0, 0,0
	from schedrestoresearchfiles RF WITH(READUNCOMMITTED)
	INNER JOIN
		ArchChunkMapping ACM WITH(READUNCOMMITTED)
		 ON ACM.CommcellId = RF.CommcellID AND ACM.ArchFileId = RF.archiveFileId AND RF.ArchiveFileOffset >= ACM.PhysicalOffset AND RF.ArchiveFileOffset < (ACM.PhysicalOffset + ACM.PhysicalSize )
AND (@includeAgedData > 0 OR ACM.flags & 256 = 0)
where RF.SearchId = @l_SearchId and RF.Status = 0 and RF.appType <> 13
    insert into #SearchRestoreArchChunks
	select RF.appType, RF.id, ACM.CommcellId, ACM.archCopyId, ACM.archChunkId, 0, 0,0
	from schedrestoresearchfiles RF WITH(READUNCOMMITTED)
	INNER JOIN
		ArchChunkMapping ACM WITH(READUNCOMMITTED)
		 ON ACM.CommcellId = RF.CommcellID AND ACM.ArchFileId = RF.archiveFileId AND RF.ArchiveFileOffset >= ACM.LogicalOffset AND RF.ArchiveFileOffset < (ACM.LogicalOffset + ACM.LogicalSize )
AND (@includeAgedData > 0 OR ACM.flags & 256 = 0)
where RF.SearchId = @l_SearchId and RF.Status = 0 and RF.appType = 13
	INSERT INTO #SchedRestoreSearchFilesNotFound
	SELECT	RF.id, RF.AppId, 0
	FROM	schedrestoresearchfiles RF WITH(READUNCOMMITTED)
			LEFT OUTER JOIN #SearchRestoreArchChunks RC WITH(READUNCOMMITTED) ON RF.id = RC.SearchFileId
	WHERE	 RF.SearchId = @l_SearchId and RF.Status = 0
			AND RC.SearchFileId IS NULL
	IF EXISTS (SELECT 1 FROM #SchedRestoreSearchFilesNotFound)
	BEGIN
		UPDATE	R
		SET		IsCloudLaptopClient = 1
		FROM	#SchedRestoreSearchFilesNotFound R, APP_Application A WITH (READUNCOMMITTED), CommCellCloudLaptopClients C WITH (READUNCOMMITTED)
			WHERE	R.AppId = A.id
					AND A.clientId = C.ClientId
		DELETE	#SchedRestoreSearchFilesNotFound
		WHERE	IsCloudLaptopClient = 0
		IF EXISTS (SELECT 1 FROM #SchedRestoreSearchFilesNotFound)
		BEGIN
			INSERT INTO #SearchRestoreArchChunks
			SELECT	RF.appType, RF.id, ACM.CommcellId, ACM.archCopyId, ACM.archChunkId, 0, 0,0
			FROM	#SchedRestoreSearchFilesNotFound N
					INNER JOIN schedrestoresearchfiles RF WITH(READUNCOMMITTED) ON N.id = RF.id
					INNER JOIN ArchChunkMapping ACM WITH(READUNCOMMITTED) ON ACM.CommcellId = RF.CommcellID
																			AND ACM.ArchFileId = RF.archiveFileId
																			AND ACM.physicalOffSet <= RF.ArchiveFileOffset
					INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON ACM.archFileID = AFC.archFileId
																			AND ACM.commCellId = AFC.commCellId
																			AND ACM.archCopyId = AFC.archCopyId
																			AND ACM.chunkNumber = AFC.lastChunkNumber
WHERE	 RF.SearchId = @l_SearchId AND RF.Status = 0 AND RF.appType <> 13
					AND ACM.physicalSize = 0
					AND ACM.chunkNumber >= 1
					AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
			INSERT INTO #SearchRestoreArchChunks
			SELECT	RF.appType, RF.id, ACM.CommcellId, ACM.archCopyId, ACM.archChunkId, 0, 0,0
			FROM	#SchedRestoreSearchFilesNotFound N
					INNER JOIN schedrestoresearchfiles RF WITH(READUNCOMMITTED) ON N.id = RF.id
					INNER JOIN ArchChunkMapping ACM WITH(READUNCOMMITTED) ON ACM.CommcellId = RF.CommcellID
																			AND ACM.ArchFileId = RF.archiveFileId
																			AND ACM.LogicalOffset <= RF.ArchiveFileOffset
					INNER JOIN archFileCopy AFC WITH (READUNCOMMITTED) ON ACM.archFileID = AFC.archFileId
																			AND ACM.commCellId = AFC.commCellId
																			AND ACM.archCopyId = AFC.archCopyId
																			AND ACM.chunkNumber = AFC.lastChunkNumber
WHERE	 RF.SearchId = @l_SearchId AND RF.Status = 0 AND RF.appType = 13
					AND ACM.physicalSize = 0
					AND ACM.chunkNumber >= 1
					AND AFC.isValid = 1
AND (@includeAgedData > 0 OR AFC.flags & 256 = 0)
		END
	END
	-- Future - copy precedence selection to go up in there to only look at specific
	-- copies
	-- This table could get large, index it.
	create index #SearchRestoreArchChunks_CCId_ChunkId ON #SearchRestoreArchChunks (CommcellId, archChunkId)
	if object_id('tempdb.dbo.#SearchRestoreChunkPoints') is not null
	drop table #SearchRestoreChunkPoints
	CREATE TABLE #SearchRestoreChunkPoints  ( CommcellId Integer, archChunkId bigint, MediaId Integer, MediaGroupId Integer, points bigInt, isMag Integer)
	-- Give points to the media containing the data.
	-- AF1, Offset 2 could exist on 2 copies, and so in 2 chunks and on different media.
	-- Give top preference to magnetic. Also, give 100x the preference to media in the library than exported media.
	INSERT INTO #SearchRestoreChunkPoints
	SELECT C.CommcellId,
		   C.Id,
		   M.MediaId,
		   V.MediaGroupId,
	-- 9223372036854775807 is maximum bigint value
		   CASE WHEN V.RecordingFormatId = 10001 THEN 9223372036854775807
	            WHEN M.MediaLocation IN (1,2) THEN 100
				ELSE 1
		   END,
		   CASE WHEN V.RecordingFormatId = 10001 THEN 1 ELSE 0 END
	FROM
		( SELECT DISTINCT CommcellId, archChunkId FROM #SearchRestoreArchChunks ) A
		INNER JOIN ArchChunk C ON C.id = A.archChunkId AND C.commcellId = A.CommcellId
		INNER JOIN MMVolume V ON V.VolumeId = C.VolumeId
		INNER JOIN MMMedia M ON M.MediaId = V.MediaId
	-- for tape media, multiply the score with the number of times the files appear on a media
	DECLARE @lt_MediaUsageCounts TABLE (MediaId INTEGER, MediaUsageCount INTEGER)
	INSERT INTO @lt_MediaUsageCounts
	SELECT CP.MediaId, count (SAC.SearchFileId)
	FROM #SearchRestoreChunkPoints CP INNER JOIN #SearchRestoreArchChunks SAC
		ON SAC.commcellId = CP.CommcellId AND SAC.archCHunkId = CP.ArchChunkId AND CP.isMag = 0
	GROUP BY CP.MediaId
	UPDATE #SearchRestoreChunkPoints
	SET points = points * MUC.MediaUsageCount
	FROM @lt_MediaUsageCounts MUC
	WHERE #SearchRestoreChunkPoints.MediaId = MUC.MediaId
	-- Store the points in the original table
	UPDATE #SearchRestoreArchChunks
	SET mediaPoints = CP.Points, MediaId = CP.MediaId, MediaGroupId = CP.MediaGroupId
	FROM #SearchRestoreChunkPoints CP
	WHERE #SearchRestoreArchChunks.archChunkId = CP.ArchChunkId AND  #SearchRestoreArchChunks.commcellId = CP.CommcellId
	if object_id('tempdb.dbo.#SearchRestoreFileOrder') is not null
	drop table #SearchRestoreFileOrder
	-- Now work out the order to restore in - basically for each file we
	-- want to restore, we want to get the top 1 entry in the rank list.
	CREATE TABLE #SearchRestoreFileOrder (OrderId INTEGER Identity(1,1), AppType Integer, MediaId Integer, CopyId Integer, SearchFileId Integer)
	INSERT INTO #SearchRestoreFileOrder (AppType, MediaId, CopyId,SearchFileId)
	SELECT SAC.AppType, SAC.MediaId, SAC.archCopyId, SAC.SearchFileId
	FROM #SearchRestoreArchChunks SAC INNER JOIN schedrestoresearchfiles(NOLOCK) RF ON RF.id = SAC.SearchFileId
	INNER JOIN archGroupCopy(NOLOCK) AGC ON AGC.id = SAC.archCopyId
	WHERE (@l_copyPrec = 0 OR (@l_copyPrec <> 0 AND AGC.copy = @l_copyPrec))
	ORDER BY AppType, MediaPoints DESC, AGC.copy, MediaId, ArchiveFileId, ArchiveFileOffset
	CREATE INDEX #SearchRestoreFileOrder_SearchFileId ON #SearchRestoreFileOrder (SearchFileId, OrderId)
	-- now store result - remove existing
	DELETE FROM SchedRestoreSearchFilesOrder
	WHERE searchId = @l_SearchId
	-- insert rows
	-- (below statement may need to be broken up to first insert into a temp table)
	INSERT INTO SchedRestoreSearchFilesOrder (searchFileId, searchId, orderId, appType,  MediaGroupId, mediaId)
	SELECT IDs.Id, @l_SearchId, Order1.OrderId, Order1.AppType, SAC.MediaGroupId, SAC.MediaId
	FROM
		schedrestoresearchfiles IDs
		INNER JOIN #SearchRestoreFileOrder Order1 ON Order1.SearchFileId = IDS.Id
		LEFT OUTER JOIN #SearchRestoreFileOrder Order2 ON Order2.SearchFileId = Order1.SearchFileId AND Order2.OrderId < Order1.OrderId
		INNER JOIN #SearchRestoreArchChunks SAC ON SAC.SearchFileId = Order1.SearchFileId AND SAC.archCopyId = Order1.copyid
	WHERE IDs.SearchId = @l_SearchId  AND Order2.OrderId is null
	ORDER BY Order1.OrderId
FINISH:
if object_id('tempdb.dbo.#SearchRestoreArchChunks') is not null
	drop table #SearchRestoreArchChunks
if object_id('tempdb.dbo.#SchedRestoreSearchFilesNotFound') is not null
	drop table #SchedRestoreSearchFilesNotFound
if object_id('tempdb.dbo.#SearchRestoreChunkPoints') is not null
	drop table #SearchRestoreChunkPoints
if object_id('tempdb.dbo.#SearchRestoreFileOrder') is not null
	drop table #SearchRestoreFileOrder
-- for now, do not calculate files with missing archfiles
SELECT @l_SearchId, 0, @r_ErrorCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QSDK_CalculateSearchRestoreOrder')
	delete from GxQscripts where name = 'QSDK_CalculateSearchRestoreOrder'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDK_CalculateSearchRestoreOrder')
	delete from GXDBVersions where aliasname = 'QSDK_CalculateSearchRestoreOrder'
GO

insert into GXDBVersions values(2, 'QSDK_CalculateSearchRestoreOrder',  '00010010021000090000', 'QSDK_CalculateSearchRestoreOrder', '00010010021000090000')
GO

