

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QSDKGenerateSessionGUIDForUser.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:      Madhusudhanan Natarajan
-- Create date: 01/31/2012
-- Description: Inserts a row into UMQSDKSessions for an user. And returns a GUID. Mainly for providing a token. This is mainly for -- Workflow environment where an user is already logged in and we dont need to do qlogin when he tries to run workflow jobs (For domain users and sso user, we need creds again)
-- Parameters :
--              @userId :  User id for which session is to be inserted
-- Returns    : 2 columns
--		errorCode in case of any error (else 0) and GUID in case of successful insertion
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QSDKGenerateSessionGUIDForUser')
BEGIN
	print '>>> Drop Stored Procedure: QSDKGenerateSessionGUIDForUser <<<'
	drop procedure QSDKGenerateSessionGUIDForUser
END
IF EXISTS (select * from GxQscripts where name='QSDKGenerateSessionGUIDForUser')
	delete from GxQscripts where name = 'QSDKGenerateSessionGUIDForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDKGenerateSessionGUIDForUser')
	delete from GXDBVersions where aliasname = 'QSDKGenerateSessionGUIDForUser'
GO
print '... Creating Procedure: QSDKGenerateSessionGUIDForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QSDKGenerateSessionGUIDForUser
  @userId int,
  @timeout int = 0
AS
  DECLARE @errorCode INTEGER ;
  DECLARE @guid varchar(255) ;
    SET NOCOUNT ON
	declare @userName nvarchar(max)
	declare @qsdkSessionId int
	set @guid =''
	set @errorCode = 0
	set @userName = IsNull((select login from UMUsers (NOLOCK) where id = @userId and enabled = 1 ),'')
	if (len(@userName)=0)
	begin
set @errorCode = CONVERT(int,0x508)
		GOTO CX_EXIT
	end
	DECLARE @curTime int
	SET @curTime  =  [dbo].[GetUnixTime](GETUTCDATE())
	Insert into UMQSDKSessions
	( userId,evmgrsSessionId,userName,password,created,lastAccessedTime,referenceCount,encryptedToken,sessionFileLocation,hostName,consoleType,timeout)
select @userId,0,@userName,'2AZdUUxUUyUUz',@curTime,@curTime,1,'','','', 18, @timeout
--18=EC_EMweb_console check evstatic.h
	set @qsdkSessionId = @@IDENTITY
	set @guid = ( select convert(varchar(255),UMQSDKSessions.GUId) from UMQSDKSessions
						where UMQSDKSessions.id = @qsdkSessionId
					)
CX_EXIT:
	select @errorCode,@guid
	return
GO

IF EXISTS (select * from GxQscripts where name = 'QSDKGenerateSessionGUIDForUser')
	delete from GxQscripts where name = 'QSDKGenerateSessionGUIDForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDKGenerateSessionGUIDForUser')
	delete from GXDBVersions where aliasname = 'QSDKGenerateSessionGUIDForUser'
GO

insert into GXDBVersions values(2, 'QSDKGenerateSessionGUIDForUser',  '00000000000000000000', 'QSDKGenerateSessionGUIDForUser', '00000000000000000000')
GO

