

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QSDKCreateTrustedSession.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QSDKCreateTrustedSession.sp,v $ $Id: QSDKCreateTrustedSession.sp,v 1.1.2.1 2019/05/01 13:31:57 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:      evolohov
-- Create date: 04/24/2019
-- Description:
-- Returns    : 0 when UMQSDKSessions table already had trusted connection record and 1 if new record was inserted
--			  : 2 columns -trusted user id  and session guid.
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QSDKCreateTrustedSession')
BEGIN
	print '>>> Drop Stored Procedure: QSDKCreateTrustedSession <<<'
	drop procedure QSDKCreateTrustedSession
END
IF EXISTS (select * from GxQscripts where name='QSDKCreateTrustedSession')
	delete from GxQscripts where name = 'QSDKCreateTrustedSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDKCreateTrustedSession')
	delete from GXDBVersions where aliasname = 'QSDKCreateTrustedSession'
GO
print '... Creating Procedure: QSDKCreateTrustedSession'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QSDKCreateTrustedSession
AS
  DECLARE @userId INT = NULL
  DECLARE @guid VARCHAR(64) = NULL
  DECLARE @timeout INT = NULL
DECLARE  @rv	  INT  = 0 -- return value will be updated to 1 if new record is inserted
SET NOCOUNT ON
DECLARE @uuid UNIQUEIDENTIFIER = NULL
DECLARE @curTime INT = [dbo].[GetUnixTime](GETUTCDATE())
-- try to retrieve existing session
SELECT TOP 1 @userId = userId, @uuid = [GUID], @timeout = [timeout] FROM UMQSDKSessions S WITH(NOLOCK) INNER JOIN UMUsers U WITH(NOLOCK) ON U.id = S.userId
WHERE S.consoleType = 22 AND U.[enabled] = 1
IF @userId IS NULL
BEGIN
	SET @rv = 1
	SET @timeout = 43200 -- 60 * 24 * 30
	DECLARE @userName NVARCHAR(510) = NULL
	-- get valid admin user id
	SELECT TOP 1 @userId = id, @userName = [name] FROM UMUsers WHERE (flags & 64) != 0 AND [enabled] = 1
	-- insert entry for the admin user with EC_EMWEB_TRUSTED flag
	INSERT INTO UMQSDKSessions
	( userId, evmgrsSessionId, userName, password, created, lastAccessedTime, referenceCount, encryptedToken, sessionFileLocation, hostName, consoleType, [timeout])
	VALUES
( @userId, 0, @userName, '2AZdUUxUUyUUz', @curTime, @curTime, 1, '', '', '', 22, @timeout )
	-- read out generated GUID
	DECLARE @trustedSessionId INT = SCOPE_IDENTITY()
	SELECT @uuid = [GUID] FROM UMQSDKSessions WITH(NOLOCK) WHERE id = @trustedSessionId
END ELSE
BEGIN
	-- update existing record
	UPDATE UMQSDKSessions SET lastAccessedTime = @curTime WHERE [GUID] = @uuid
END
SET @guid = IIF(@uuid IS NULL, '', CAST(@uuid AS VARCHAR(64)))
-- select/return
SELECT ISNULL(@userId, 0), @guid, @timeout
RETURN @rv
GO

IF EXISTS (select * from GxQscripts where name = 'QSDKCreateTrustedSession')
	delete from GxQscripts where name = 'QSDKCreateTrustedSession'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDKCreateTrustedSession')
	delete from GXDBVersions where aliasname = 'QSDKCreateTrustedSession'
GO

insert into GXDBVersions values(2, 'QSDKCreateTrustedSession',  '00010001000200010000', 'QSDKCreateTrustedSession', '00010001000200010000')
GO

