

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QSDKCreateSessionForGUIUser.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
-- Author:      Rohit Iyer
-- Create date: 01/31/2012
-- Description: Inserts a row into UMQSDKSessions for an user. And returns a GUID. Mainly for providing a token. This is mainly for -- Java GUI based webconsole login where we need to create a DUMMY row for a webconsole login.
-- Parameters :
--              @userId :  User id for which session is to be inserted
-- Returns    : 2 columns
--		errorCode in case of any error (else 0) and GUID in case of successful insertion
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QSDKCreateSessionForGUIUser')
BEGIN
	print '>>> Drop Stored Procedure: QSDKCreateSessionForGUIUser <<<'
	drop procedure QSDKCreateSessionForGUIUser
END
IF EXISTS (select * from GxQscripts where name='QSDKCreateSessionForGUIUser')
	delete from GxQscripts where name = 'QSDKCreateSessionForGUIUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDKCreateSessionForGUIUser')
	delete from GXDBVersions where aliasname = 'QSDKCreateSessionForGUIUser'
GO
print '... Creating Procedure: QSDKCreateSessionForGUIUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QSDKCreateSessionForGUIUser
  @userId int,
  @hostName nvarchar(max),
  @evmgrsSessionId int = 0 
AS
  DECLARE @errorCode INTEGER ;
  DECLARE @guid varchar(255) ;
    SET NOCOUNT ON
declare @userName 		nvarchar(max)
declare @qsdkSessionId 	int
declare @i_hostName     nvarchar(max)
declare @nowTime		int
DECLARE @consoleType INT = 19
DECLARE @timeout int = 30
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
begin try
	set @guid =''
	set @errorCode = 0
	set @i_hostName = isnull(@hostName,'')
	--check for hostname validity
	if(@i_hostName = '')
	begin
		set @errorCode = 'Empty HostName'
		goto CX_EXIT
	end
	set @userName = IsNull((select login from UMUsers (NOLOCK) where id = @userId and enabled = 1 ),'')
	--Check for username
	if (@userName = '')
	begin
set @errorCode = CONVERT(int,0x508)
		goto CX_EXIT
	end
	set @nowTime  = [dbo].[GetUnixTime](GETUTCDATE())
if (@evmgrsSessionId=0 OR not exists(select 1 from dbo.UMQSDKSessions where userId = @userId and hostName = @i_hostName and  consoleType = 19 and evmgrsSessionId=@evmgrsSessionId and ( @nowTime -lastAccessedTime< timeout*60 )) )
  begin
		Insert into UMQSDKSessions
				(
				userId,
				evmgrsSessionId,
				userName,
				password,
				created,
				lastAccessedTime,
				referenceCount,
				encryptedToken,
				sessionFileLocation,
				hostName,
				consoleType,
				timeout
				)
		select 	@userId,
				@evmgrsSessionId,
				@userName,
				'2AZdUUxUUyUUz',
				@nowTime,
				@nowTime,
				1,
				'',
				'',
				@i_hostName,
				@consoleType,
				@timeout
		--since id, guid in table UMQSDKSessions is a generated value, we compare the new ID from table to retrieve the new GUID
		set @qsdkSessionId = @@IDENTITY
		set @guid = ( 	select convert(varchar(255),UMQSDKSessions.GUID)
						from UMQSDKSessions
						where UMQSDKSessions.id = @qsdkSessionId
					)
		INSERT INTO UMSessionAudit(userId, sessionId, createdTime, logoutTime, consoleType, host, remark, browserSessionId, location, flag, DeviceId, LinkSessionId, timeout)
		VALUES(@userId, @guid, @nowTime, 0, @consoleType, @i_hostName, '', 0, @i_hostName,0, @i_hostName, NULL, @timeout)
   end
   else
   begin
select @guid = GUID from dbo.UMQSDKSessions where userId = @userId and hostName = @i_hostName and  consoleType = 19 and evmgrsSessionId=@evmgrsSessionId and ( @nowTime -lastAccessedTime< timeout*60 )
   end
end try
begin catch
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	set @errorCode     = ERROR_NUMBER()
	set @guid = ''
end catch
CX_EXIT:
	select @errorCode,@guid
GO

IF EXISTS (select * from GxQscripts where name = 'QSDKCreateSessionForGUIUser')
	delete from GxQscripts where name = 'QSDKCreateSessionForGUIUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QSDKCreateSessionForGUIUser')
	delete from GXDBVersions where aliasname = 'QSDKCreateSessionForGUIUser'
GO

insert into GXDBVersions values(2, 'QSDKCreateSessionForGUIUser',  '00000000000000000000', 'QSDKCreateSessionForGUIUser', '00000000000000000000')
GO

