

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QR_GetJobDetailsForQRSAPOracle.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2007  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sergio Bonilla
--	Date:   07/20/2007
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QR_GetJobDetailsForQRSAPOracle.sp,v $ $Id: QR_GetJobDetailsForQRSAPOracle.sp,v 1.3.294.2 2018/03/27 09:07:28 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QR_GetJobDetailsForQRSAPOracle <<<'

IF EXISTS (select * from sysobjects where name='QR_GetJobDetailsForQRSAPOracle')
	drop procedure QR_GetJobDetailsForQRSAPOracle
IF EXISTS (select * from GxQscripts where name='QR_GetJobDetailsForQRSAPOracle')
	delete from GxQscripts where name = 'QR_GetJobDetailsForQRSAPOracle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QR_GetJobDetailsForQRSAPOracle')
	delete from GXDBVersions where aliasname = 'QR_GetJobDetailsForQRSAPOracle'
GO
print '... Creating Procedure: QR_GetJobDetailsForQRSAPOracle'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure QR_GetJobDetailsForQRSAPOracle
  @i_clientId integer,
  @i_pathType integer,
  @i_instanceName varchar(255),
  @i_jobId bigint
AS
  DECLARE @o_jobId bigint
  DECLARE @o_srcVolId integer
  DECLARE @o_destVolId integer
  DECLARE @o_srcMountPath varchar(255)
  DECLARE @o_destMountPath varchar(255)
	DECLARE @sObjName VARCHAR(1024)
	SET @sObjName = @i_instanceName + ':%'
	IF object_id('tempdb.dbo.#tmpVolumeIdTbl') is not null
					DROP TABLE #tmpVolumeIdTbl
	CREATE TABLE #tmpVolumeIdTbl (srcVolumeId INT, destVolumeId INT, jobId INT)
	IF object_id('tempdb.dbo.#tmpOutputTbl') is not null
					DROP TABLE #tmpOutputTbl
	CREATE TABLE #tmpOutputTbl (srcVolumeId INT, srcPath NVARCHAR(MAX), destVolumeId INT, destPath NVARCHAR(MAX), jobId INT)
	INSERT INTO #tmpVolumeIdTbl
	SELECT PrimaryVolumeId, PhysicalVolumeId, JobId FROM QRVolume WHERE id IN (
	SELECT ReplicationVolumeId FROM QRApplicationDirs WHERE [clientId] = @i_clientId AND [pathType] = @i_pathType AND [objName] LIKE @sObjName)
	DECLARE @srcId INT
	DECLARE @srcPath NVARCHAR(MAX)
	DECLARE	@destPath NVARCHAR(MAX)
	DECLARE @destId INT
	DECLARE @jobId INT
	DECLARE GetVolumeId CURSOR FOR
	SELECT srcVolumeId, destVolumeId, jobId FROM #tmpVolumeIdTbl
	OPEN GetVolumeId
	FETCH FROM GetVolumeId INTO @srcId, @destId, @jobId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @physId INT
		SET @physId = (SELECT id FROM QRPhysicalDevice WHERE [ClientId] = @i_clientId AND SNRVolumeId = @srcId)
		SET @srcPath = ISNULL((SELECT Path FROM QRMountPoint WHERE [DeviceNameId] = @physId), '')
		SET @physId = (SELECT id FROM QRPhysicalDevice WHERE [ClientId] = @i_clientId AND SNRVolumeId = @destId)
		SET @destPath = ISNULL((SELECT Path FROM QRMountPoint WHERE [DeviceNameId] = @physId), '')
		INSERT INTO #tmpOutputTbl VALUES(@srcId, @srcPath, @destId, @destPath, @jobId)
		FETCH FROM GetVolumeId INTO @srcId, @destId, @jobId
	END
	CLOSE GetVolumeId
	DEALLOCATE GetVolumeId
	IF @i_jobId = 0
		SELECT jobId, srcVolumeId, srcPath, destVolumeId, destPath FROM #tmpOutputTbl ORDER BY jobId
	ELSE
		SELECT jobId, srcVolumeId, srcPath, destVolumeId, destPath FROM #tmpOutputTbl WHERE jobId = @i_jobId
	DROP TABLE #tmpVolumeIdTbl
	DROP TABLE #tmpOutputTbl
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'QR_GetJobDetailsForQRSAPOracle')
	delete from GxQscripts where name = 'QR_GetJobDetailsForQRSAPOracle'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QR_GetJobDetailsForQRSAPOracle')
	delete from GXDBVersions where aliasname = 'QR_GetJobDetailsForQRSAPOracle'
GO

insert into GXDBVersions values(2, 'QR_GetJobDetailsForQRSAPOracle',  '00010003029400020000', 'QR_GetJobDetailsForQRSAPOracle', '00010003029400020000')
GO

