

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QRPruneJobHistory.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/QRPruneJobHistory.sp,v $ $Id: QRPruneJobHistory.sp,v 1.3.302.2 2018/03/27 09:16:15 jiechen Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			SP : "QRPruneJobHistory"									|
--	|																		|
--	| DEMONSTRATES PASSING INTEGERS AND STRINGS INTO A CURSOR FUNCTION		|
--	| AND RETURNING RESULTS													|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: QRPruneJobHistory <<<'

IF EXISTS (select * from sysobjects where name='QRPruneJobHistory')
	drop procedure QRPruneJobHistory
IF EXISTS (select * from GxQscripts where name='QRPruneJobHistory')
	delete from GxQscripts where name = 'QRPruneJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QRPruneJobHistory')
	delete from GXDBVersions where aliasname = 'QRPruneJobHistory'
GO
print '... Creating Procedure: QRPruneJobHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QRPruneJobHistory
AS
  DECLARE @retVal integer;
--
-- DECLARE	@VolumeID Integer
-- SET		@VolumeID = 0
DECLARE	@CurrentTime Integer
SET		@CurrentTime = dbo.GetUnixTime(GetUTCDate())
DECLARE	@QNetPruneTime Integer
SET		@QNetPruneTime = dbo.GetQNetPruneTime()
BEGIN TRANSACTION TRANSACTION1
--UPDATE	QRJobVolumeHistory
--SET		PruneTime = @CurrentTime
--WHERE	DstVolId = @VolumeId
SELECT	CommCellID, JobID, COUNT(*) AS PrunTimeNULLCount
INTO #PrunTimeNULL
FROM	QRJobVolumeHistory
WHERE	PruneTime  != 0
GROUP BY JobID, CommCellId
SELECT	CommCellID, JobID, COUNT(*) AS PrunTimeAllCount
INTO #PrunTimeALL
FROM	QRJobVolumeHistory
GROUP BY JobID, CommCellId
UPDATE	JMBkpStats
SET	datastatus = 2, mediadeletedTime = @CurrentTime , agedtime = @CurrentTime, modifiedTime = @CurrentTime
FROM	JMBkpStats J, (SELECT A.CommCellId, A.JobID FROM #PrunTimeNULL N, #PrunTimeALL A
								WHERE N.JobID = A.JobID
									  AND N.CommCellID = A.CommCellID
									  AND N.PrunTimeNULLCount = A.PrunTimeAllCount) T
WHERE	J.JobID = T.JobID
		AND J.CommCellID = T.CommCellID
-- Removing rows
DELETE	JMJobStats
FROM	JMJobStats J, (SELECT CommCellID, JobId
					 FROM JMBkpStats
					 WHERE	AppType in (47, 51) and datastatus = 2
							AND modifiedTime > @QNetPruneTime) T
WHERE	J.CommCellID = T.CommCellID
		AND J.JobID = T.JobID
SET NOCOUNT OFF
SET @retVal = @@ERROR
IF @retVal = 0
   COMMIT   TRANSACTION TRANSACTION1
ELSE
   ROLLBACK TRANSACTION TRANSACTION1
DROP TABLE #PrunTimeNULL
DROP TABLE #PrunTimeALL
SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'QRPruneJobHistory')
	delete from GxQscripts where name = 'QRPruneJobHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QRPruneJobHistory')
	delete from GXDBVersions where aliasname = 'QRPruneJobHistory'
GO

insert into GXDBVersions values(2, 'QRPruneJobHistory',  '00010003030200020000', 'QRPruneJobHistory', '00010003030200020000')
GO

