

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/QListBackupset.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- ----------------------------------------------------------------------
--
--			SP Name: QListBackupsets
--			Description: SP that gets all backupset related details
--						 for qlist backupset.
--          Inputs:	userId, clientId, appTypeId, instanceId
--          Output: GalaxyUtilies_QGetBackupSetsRespMsg
--			Author: jswaminathan
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='QListBackupset')
BEGIN
	print '>>> Drop Stored Procedure: QListBackupset <<<'
	drop procedure QListBackupset
END
IF EXISTS (select * from GxQscripts where name='QListBackupset')
	delete from GxQscripts where name = 'QListBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QListBackupset')
	delete from GXDBVersions where aliasname = 'QListBackupset'
GO
print '... Creating Procedure: QListBackupset'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure QListBackupset
  @i_userId INT,
  @i_clientId INT,
  @i_appTypeId INT,
  @i_instanceId INT
AS
  DECLARE @o_XML XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#QSDKBackupsets') IS NOT NULL
	DROP TABLE #QSDKBackupsets
CREATE TABLE #QSDKBackupsets
(
	backupsetId INT PRIMARY KEY,
	backupsetName NVARCHAR(MAX),
	lastAccessTime INT,
	isDefault INT,
	isOnDemand INT,
	description NVARCHAR(MAX)
);;
-- We do not have a security SP that filters out backupsets of only one client. So call the other one that get all
-- backupsets. This one is also considerably faster.
IF OBJECT_ID('tempdb.dbo.#getIdaObjects_OutputTbl') IS NOT NULL
	DROP TABLE #getIdaObjects_OutputTbl
CREATE TABLE #getIdaObjects_OutputTbl
(
	clientId INT,
	appTypeId INT,
	instanceId INT,
	backupsetId INT,
	subclientId INT
)
CREATE CLUSTERED INDEX getIdaObjects_Idx1 ON #getIdaObjects_OutputTbl(clientId, appTypeId, instanceId, backupsetId, subclientId);;
EXEC sec_getIdaObjectsForUser @i_userId,
6,
							  0,
							  1,
							  '#getIdaObjects_OutputTbl'
INSERT INTO #QSDKBackupsets (backupsetId, backupsetName, lastAccessTime, isDefault, isOnDemand, description)
	SELECT DISTINCT
		   B.id,
		   B.name,
		   B.modified,
CASE WHEN B.status & 0x00008 <> 0 THEN 1 ELSE 0 END,
		   CASE WHEN (BP2.attrVal IS NOT NULL AND BP2.attrVal = '1') THEN 1 ELSE 0 END,
		   CASE WHEN BP1.attrVal IS NOT NULL THEN BP1.attrVal ELSE '' END
	FROM APP_Application A
		INNER JOIN APP_BackupSetName B
			ON A.backupset = B.id
		INNER JOIN #getIdaObjects_OutputTbl Sec
			ON B.id = Sec.backupsetId
		LEFT OUTER JOIN APP_BackupsetProp BP1
			ON B.id = BP1.componentNameId
			AND BP1.attrName = 'User Description'
			AND BP1.modified = 0
		LEFT OUTER JOIN APP_BackupsetProp BP2
			ON B.id = BP2.componentNameId
			AND BP2.attrName = 'OnDemand Backupset'
			AND BP2.modified = 0
	WHERE
		A.clientId = @i_clientId
		AND A.appTypeId = @i_appTypeId
		AND A.instance = @i_instanceId
AND B.status & 0x00010 = 0			-- ignore dummy backupsets.
SET @o_XML =
				(
					SELECT
					(
						SELECT backupsetid AS '@backupSetId',
							   backupsetName AS '@backupSetName',
							   lastAccessTime AS '@lastAccessTime',
							   isDefault AS '@isDefault',
							   description AS '@description',
							   isOnDemand AS '@isOnDemand'
						FROM #QSDKBackupsets
						FOR XML PATH ('backupSets'), TYPE
					)
					FOR XML PATH('GalaxyUtilies_QGetBackupSetsRespMsg')
				)
IF @o_XML IS NULL
	SET @o_XML = '<GalaxyUtilies_QGetBackupSetsRespMsg/>'
SELECT @o_XML
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'QListBackupset')
	delete from GxQscripts where name = 'QListBackupset'
GO

IF EXISTS (select * from GXDBVersions where aliasname='QListBackupset')
	delete from GXDBVersions where aliasname = 'QListBackupset'
GO

insert into GXDBVersions values(2, 'QListBackupset',  '00000000000000000000', 'QListBackupset', '00000000000000000000')
GO

