

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PublicFoldersUpdateEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PublicFoldersUpdateEntries.sp,v $ $Id: PublicFoldersUpdateEntries.sp,v 1.2.60.2 2018/03/27 08:18:13 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PublicFoldersUpdateEntries <<<'

IF EXISTS (select * from sysobjects where name='PublicFoldersUpdateEntries')
	drop procedure PublicFoldersUpdateEntries
IF EXISTS (select * from GxQscripts where name='PublicFoldersUpdateEntries')
	delete from GxQscripts where name = 'PublicFoldersUpdateEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PublicFoldersUpdateEntries')
	delete from GXDBVersions where aliasname = 'PublicFoldersUpdateEntries'
GO
print '... Creating Procedure: PublicFoldersUpdateEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PublicFoldersUpdateEntries
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
  DECLARE @o_ErrorCode integer = 0
  DECLARE @o_ErrorString NVARCHAR(MAX) = N'Success'
BEGIN TRY
DECLARE @folderId	INT
SET @folderId = ISNULL((SELECT ref.value('@folderId', 'INT')
	FROM @i_xmlText.nodes('EVGui_SetPublicFolderReq/folder/folder') R ( ref ) ), 0)
IF (@folderId = 0)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'invalid folder'
	GOTO FINISH
END
DECLARE @folderContents TABLE (
	[EntityId] [int] NOT NULL,
	[EntityXml] [nvarchar](max) NOT NULL
)
INSERT INTO @folderContents(EntityId,EntityXml)
SELECT	ref.value('@entityId', 'INT'),
		ref.value('@entityXml','nvarchar(MAX)')
FROM @i_xmlText.nodes('EVGui_SetPublicFolderReq/folder/entries') R(ref)
DELETE FROM APP_FolderEntities
WHERE FolderId = @folderId
AND FolderEntityId NOT IN (SELECT EntityId FROM @folderContents)
UPDATE APP_FolderEntities
SET APP_FolderEntities.Entity = f.EntityXml
FROM APP_FolderEntities
INNER JOIN @folderContents f ON APP_FolderEntities.FolderEntityId = f.EntityId
INSERT INTO APP_FolderEntities(FolderId, Entity, Created)
SELECT @folderId, EntityXml, GETUTCDATE()
FROM @folderContents
WHERE EntityId = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = ERROR_MESSAGE()
END CATCH
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText as o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'PublicFoldersUpdateEntries')
	delete from GxQscripts where name = 'PublicFoldersUpdateEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PublicFoldersUpdateEntries')
	delete from GXDBVersions where aliasname = 'PublicFoldersUpdateEntries'
GO

insert into GXDBVersions values(2, 'PublicFoldersUpdateEntries',  '00010002006000020000', 'PublicFoldersUpdateEntries', '00010002006000020000')
GO

