

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PublicFoldersGet.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PublicFoldersGet.sp,v $ $Id: PublicFoldersGet.sp,v 1.2.60.2 2018/03/27 08:12:49 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PublicFoldersGet <<<'

IF EXISTS (select * from sysobjects where name='PublicFoldersGet')
	drop procedure PublicFoldersGet
IF EXISTS (select * from GxQscripts where name='PublicFoldersGet')
	delete from GxQscripts where name = 'PublicFoldersGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PublicFoldersGet')
	delete from GXDBVersions where aliasname = 'PublicFoldersGet'
GO
print '... Creating Procedure: PublicFoldersGet'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PublicFoldersGet
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
  DECLARE @o_ErrorCode integer = 0
  DECLARE @o_ErrorString NVARCHAR(MAX) = N'Success'
BEGIN TRY
SET @o_xmlText = (
	SELECT  FolderId 'folder/@folderId',
			Name 'folder/@folderName',
			(SELECT FolderEntityId '@entityId',
					Entity '@entityXml'
			 FROM APP_FolderEntities e
			 WHERE f.FolderId = e.FolderId
			 FOR XML PATH('entries'), TYPE)
	FROM APP_Folders f
	FOR XML PATH('folders'), ROOT('EVGui_GetPublicFolderResp'))
IF (@o_xmlText IS NULL)
BEGIN
	SET @o_xmlText = '<EVGui_GetPublicFolderResp />'
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = ERROR_MESSAGE()
END CATCH
FINISH:
IF (@o_ErrorCode > 0)
BEGIN
	SET @o_xmlText = (
		SELECT	1				as TAG,
				0				as Parent,
				@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
				@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT)
END
SELECT @o_xmlText as o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'PublicFoldersGet')
	delete from GxQscripts where name = 'PublicFoldersGet'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PublicFoldersGet')
	delete from GXDBVersions where aliasname = 'PublicFoldersGet'
GO

insert into GXDBVersions values(2, 'PublicFoldersGet',  '00010002006000020000', 'PublicFoldersGet', '00010002006000020000')
GO

