

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PublicFoldersCreate.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PublicFoldersCreate.sp,v $ $Id: PublicFoldersCreate.sp,v 1.2.60.2 2018/03/27 07:59:06 jiechen Exp $";
-- =============================================
-- Author:		Chris Sunderland
-- Create date: 09/21/2010
-- Description:	gets a workflow
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PublicFoldersCreate <<<'

IF EXISTS (select * from sysobjects where name='PublicFoldersCreate')
	drop procedure PublicFoldersCreate
IF EXISTS (select * from GxQscripts where name='PublicFoldersCreate')
	delete from GxQscripts where name = 'PublicFoldersCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PublicFoldersCreate')
	delete from GXDBVersions where aliasname = 'PublicFoldersCreate'
GO
print '... Creating Procedure: PublicFoldersCreate'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PublicFoldersCreate
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_xmlText XML
AS
SET NOCOUNT ON
BEGIN
  DECLARE @o_xmlText XML
  DECLARE @o_ErrorCode integer = 0
  DECLARE @o_ErrorString NVARCHAR(MAX) = N'Success'
BEGIN TRY
DECLARE @name nvarchar(255)
SELECT	@name = ref.value('@folderName','nvarchar(255)')
FROM @i_xmlText.nodes('EVGui_CreatePublicFolderReq/folder') R(ref)
IF (@name IS NULL)
BEGIN
	SET @o_ErrorCode = 1
	SET @o_ErrorString = 'folder name not specified'
	GOTO FINISH
END
ELSE
BEGIN
	INSERT INTO APP_Folders(Name)
	VALUES (@name)
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
SET @o_ErrorCode = ERROR_NUMBER()
SET @o_ErrorString = ERROR_MESSAGE()
END CATCH
FINISH:
SET @o_xmlText = (
	SELECT	1				as TAG,
			0				as Parent,
			@o_ErrorCode	as [EVGui_GenericResp!1!errorCode],
			@o_ErrorString	as [EVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT)
SELECT @o_xmlText as o_xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'PublicFoldersCreate')
	delete from GxQscripts where name = 'PublicFoldersCreate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PublicFoldersCreate')
	delete from GXDBVersions where aliasname = 'PublicFoldersCreate'
GO

insert into GXDBVersions values(2, 'PublicFoldersCreate',  '00010002006000020000', 'PublicFoldersCreate', '00010002006000020000')
GO

