

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PruneIndexServerStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PruneIndexServerStats')
BEGIN
	print '>>> Drop Stored Procedure: PruneIndexServerStats <<<'
	drop procedure PruneIndexServerStats
END
IF EXISTS (select * from GxQscripts where name='PruneIndexServerStats')
	delete from GxQscripts where name = 'PruneIndexServerStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneIndexServerStats')
	delete from GXDBVersions where aliasname = 'PruneIndexServerStats'
GO
print '... Creating Procedure: PruneIndexServerStats'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PruneIndexServerStats
  @i_webserverClientId INT = 0,
  @i_pruneThresholdDays INT = 7
AS
BEGIN
    SET NOCOUNT ON
    DECLARE @curTime                    DATETIME
    DECLARE @curUnixTime                BIGINT
    DECLARE @pruningThreshold           INT
    DECLARE @o_webServiceURL            NVARCHAR(1024) = N''
DECLARE @clientId 			INT = 0
DECLARE @webserverName   	NVARCHAR(max) = ''
DECLARE @includeAlias 		TINYINT = 0
DECLARE @includeEndPoint 	TINYINT = 0
    --
    -- Fetch default webserver details.
    --
--Default webserver can be specified in control panel=>browse/search/recovery=>default web server for search
IF ISNULL(@clientId, 0) = 0
BEGIN
		SET @clientId = ISNULL((SELECT TOP 1 value FROM GXGlobalParam (NOLOCK) WHERE name = 'Web Search Server for Super Search'),0)
END
--if specified client does not have webserver package installed, pick CS webserver first otherwise any other webserver
IF @clientId =0 OR NOT EXISTS (SELECT 1 FROM simInstalledPackages (NOLOCK) WHERE simPackageID IN (803, 852) AND clientId = @clientId)
SET @clientId = ISNULL((SELECT TOP 1 ClientId FROM simInstalledPackages (NOLOCK) WHERE simPackageID IN (803, 852)),0)
--webservice url
IF @clientId > 0
BEGIN
	SELECT @o_webServiceURL = dbo.AppFetchWebServiceURL(@clientId, @includeAlias, @includeEndPoint)
	SELECT @webserverName = dbo.GetClientMangledHostName(@clientId,NULL)
END
    --
    -- If webserverClientId is provided, validate if it is the defaultWebserver, only then execute pruning.
    --
    IF ((@i_webserverClientId = 0) OR (@i_webserverClientId = @clientId))
    BEGIN
        --
        -- Init current datetime value and pruning threshold(Default is 604800 seconds i.e 1 week)
        --
        SET @curTime = getutcdate()
        SET @curUnixTime = dbo.getUnixTime(@curTime)
        SET @pruningThreshold = (@i_pruneThresholdDays * 24 * 60 * 60)
        --
        -- Update the rows with Attribute value 4 from SEIndexServerNodeStatsProp where LastUpdateTime >= 5 days
        --
        UPDATE SEIndexServerNodeStatsProp
        SET Attribute = Attribute | 4 WHERE ((@curUnixTime - LastUpdateTime) >= 5 * 24 * 60 * 60)
        --
        -- Delete the rows from SEIndexServerNodeStatsProp where Attribute is set to 4 and LastUpdateTime >= 1 week
        --
        DELETE FROM SEIndexServerNodeStatsProp
        WHERE (Attribute & 4 <> 0) AND ((@curUnixTime - LastUpdateTime) >= @pruningThreshold)
    END
    SELECT @@ROWCOUNT AS DeletedRows
END
GO

IF EXISTS (select * from GxQscripts where name = 'PruneIndexServerStats')
	delete from GxQscripts where name = 'PruneIndexServerStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneIndexServerStats')
	delete from GXDBVersions where aliasname = 'PruneIndexServerStats'
GO

insert into GXDBVersions values(2, 'PruneIndexServerStats',  '00000000000000000000', 'PruneIndexServerStats', '00000000000000000000')
GO

