

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PruneFsNodeActivity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--  Copyright (c) CommVault Systems
--  All Rights Reserved
--
--  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems
--  The copyright notice above does not evidence any
--  actual or intended publication of such source code.
--
--  File name   : PruneFsNodeActivity.sp
--	Author		: Logesh G
--
--  Description : This SP is to prune clients file & folder anomaly activity
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PruneFsNodeActivity.sp,v $ $Id: PruneFsNodeActivity.sp,v 1.1.2.2 2020/09/28 21:33:17 pgadhave Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PruneFsNodeActivity')
BEGIN
	print '>>> Drop Stored Procedure: PruneFsNodeActivity <<<'
	drop procedure PruneFsNodeActivity
END
IF EXISTS (select * from GxQscripts where name='PruneFsNodeActivity')
	delete from GxQscripts where name = 'PruneFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneFsNodeActivity')
	delete from GXDBVersions where aliasname = 'PruneFsNodeActivity'
GO
print '... Creating Procedure: PruneFsNodeActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PruneFsNodeActivity
  @userId INTEGER,
  @inputXml XML,
  @outputXml XML OUTPUT
AS
BEGIN TRY
BEGIN TRAN FS_NODE_ACTIVITY_PRUNE
	DECLARE @errorCode INT = 0
	DECLARE @errorMsg NVARCHAR(MAX) = ''
	DECLARE @currentTime INT = dbo.getunixtime(getutcdate())
	--User security check
	DECLARE @isUserAdmin INT = 0
	EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
	IF @isUserAdmin = 0
	BEGIN
		SET @errorCode  = 1
		SET @errorMsg = 'User does not have required capability to prune data'
		GOTO ERROR_EXIT
	END
	--Process request:
	DECLARE @clientTbl TABLE(clientId INT)
	INSERT INTO @clientTbl(clientId)
    SELECT ISNULL(ClientTbl.id.value('@clientId','INT'),0)
    FROM @inputXml.nodes('Api_PruneAnomalyRecordsReq/clients') AS ClientTbl(id)
	 -- delete invalid clients from input request
    DELETE clientTbl
    FROM @clientTbl clientTbl
    LEFT JOIN APP_Client appClient
    ON appClient.id = clientTbl.clientId
    WHERE appClient.id IS NULL
    --Request processing done
	DELETE historyTbl
	FROM HistoryDB.dbo.FsNodeActivityData historyTbl
	INNER JOIN @clientTbl clientTbl
	ON historyTbl.clientId = clientTbl.clientId
	UPDATE APP_ClientProp SET modified = @currentTime
    FROM (SELECT clientId as Id
    FROM  @clientTbl) as clientTbl
    WHERE componentNameId = clientTbl.Id
    AND attrName In (N'Anomaly Flag', N'Anomaly created Files', N'Anomaly renamed Files', N'Anomaly modified Files', N'Anomaly deleted Files')
    AND modified = 0
ERROR_EXIT:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = ERROR_NUMBER()
	SET @errorMsg = ERROR_MESSAGE()
END CATCH
IF @errorCode = 0
    COMMIT TRAN FS_NODE_ACTIVITY_PRUNE
ELSE
BEGIN
    ROLLBACK TRAN FS_NODE_ACTIVITY_PRUNE
END
SET @outputXml = (SELECT @errorCode AS '@errorCode',
						 @errorMsg AS '@errorMessage'
					FOR XML PATH('error'),ROOT('Api_PruneAnomalyRecordsResp'))
SELECT @outputXml
GO

IF EXISTS (select * from GxQscripts where name = 'PruneFsNodeActivity')
	delete from GxQscripts where name = 'PruneFsNodeActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PruneFsNodeActivity')
	delete from GXDBVersions where aliasname = 'PruneFsNodeActivity'
GO

insert into GXDBVersions values(2, 'PruneFsNodeActivity',  '00010001000200020000', 'PruneFsNodeActivity', '00010001000200020000')
GO

