

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/ProcessJobSummaryResponseXml.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/ProcessJobSummaryResponseXml.sp,v $ $Id: ProcessJobSummaryResponseXml.sp,v 1.1.2.1 2018/12/19 23:53:08 riyer Exp $"
--
--  +========================================================================+
--  | Stored Precedure: ProcessJobSummaryResponseXml()
--  |
--  |   Revisions  Author     Description
--  |   ---------  -------    ---------------------------------------------
--  |   1.0        Rohit		Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='ProcessJobSummaryResponseXml')
BEGIN
	print '>>> Drop Stored Procedure: ProcessJobSummaryResponseXml <<<'
	drop procedure ProcessJobSummaryResponseXml
END
IF EXISTS (select * from GxQscripts where name='ProcessJobSummaryResponseXml')
	delete from GxQscripts where name = 'ProcessJobSummaryResponseXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessJobSummaryResponseXml')
	delete from GXDBVersions where aliasname = 'ProcessJobSummaryResponseXml'
GO
print '... Creating Procedure: ProcessJobSummaryResponseXml'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure ProcessJobSummaryResponseXml
  @localeId int,
  @var XML 		OUTPUT
AS
  DECLARE @output XML
-----------------------------------------------
-- Declare variables
DECLARE @ErrorMessage		NVARCHAR(4000)
DECLARE @ErrorSeverity		INT
DECLARE @ErrorState			INT
DECLARE @jobIdVal            int
DECLARE @iCount				int
DECLARE @temp               XML
declare @pendingReasonVal	nvarchar(256)
declare @pendingIds			nvarchar(256)
declare @failureVal			nvarchar(256)
BEGIN TRY
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--For English locale, we do not require modification of localized strings.
if(@localeId <> 0)
BEGIN
	IF object_id('tempdb.dbo.#ProcessJobSummaryResponseXml_tempTbl') is not null
		DROP TABLE #ProcessJobSummaryResponseXml_tempTbl
	create table #ProcessJobSummaryResponseXml_tempTbl
	(
		  tempVal xml,
		  val int identity(1,1) primary key
	)
	insert into #ProcessJobSummaryResponseXml_tempTbl
	select T.N.query('.')
	from @var.nodes('//jobSummary') as T(N)
	SELECT @iCount = count(1) from #ProcessJobSummaryResponseXml_tempTbl
	IF @iCount IS NULL
		SET @iCount = 0
	DECLARE @i int
	SET @i = 1
	-- Loop through all entities
	WHILE (@i <= @iCount)
	BEGIN
		select @temp = tempVal from #ProcessJobSummaryResponseXml_tempTbl
				where val=@i
		set @pendingReasonVal = @temp.value('(//./@pendingReasonErrorCode)[1]','nvarchar(256)')
		IF(@pendingReasonVal IS NOT NULL)  AND (@pendingReasonVal <> '')
		BEGIN
			--set @jobIdVal = @temp.value('(//./@jobId)[1]','int')
			set @pendingIds = Replace(@pendingReasonVal, ':', '.');
			set @pendingReasonVal = (select Message from EvLocaleMsgs where MessageNum = cast(ParseName(@pendingIds, 1) as int) and SubsystemID = cast(ParseName(@pendingIds, 2) as int) and LocaleID = @localeId)
			SET @var.modify('replace value of ((//./jobSummary)[sql:variable("@i")]/@pendingReason)[1] with sql:variable("@pendingReasonVal")')
		END
		SET @i = @i+ 1
	END
END
--Time to call EntityIdToNameConverter
--EXEC EntityIdToNameConverter @var OUT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	 SELECT
        @ErrorMessage = @ErrorMessage + ERROR_MESSAGE(),
        @ErrorSeverity = ERROR_SEVERITY(),
        @ErrorState = ERROR_STATE();
END CATCH
IF @ErrorSeverity <> 0 OR @ErrorState <> 0
	RAISERROR(@ErrorMessage,@ErrorSeverity,@ErrorState)
	SELECT @var
-------------------------------------------------------------------------------------------------------
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'ProcessJobSummaryResponseXml')
	delete from GxQscripts where name = 'ProcessJobSummaryResponseXml'
GO

IF EXISTS (select * from GXDBVersions where aliasname='ProcessJobSummaryResponseXml')
	delete from GXDBVersions where aliasname = 'ProcessJobSummaryResponseXml'
GO

insert into GXDBVersions values(2, 'ProcessJobSummaryResponseXml',  '00010001000200010000', 'ProcessJobSummaryResponseXml', '00010001000200010000')
GO

