

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PopulateTopology.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author:
--	Date:
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PopulateTopology.sp,v $ $Id: PopulateTopology.sp,v 1.1.2.22.16.1 2021/01/15 23:39:07 ybaheti Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='populateTopology')
BEGIN
	print '>>> Drop Stored Procedure: populateTopology <<<'
	drop procedure populateTopology
END
IF EXISTS (select * from GxQscripts where name='populateTopology')
	delete from GxQscripts where name = 'populateTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='populateTopology')
	delete from GXDBVersions where aliasname = 'populateTopology'
GO
print '... Creating Procedure: populateTopology'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure populateTopology
  @topologyId int,
  @topologies NWTopoGroupInfoTableType READONLY,
  @topologyType int, 
  @useWildCardProxy int,
  @extendedOptions XML
AS
DECLARE @external	int = 0
DECLARE @internal	int = 0
DECLARE	@proxied	int = 0
DECLARE @perimeterProxy int = 0
DECLARE @clientGroupId INT = 0
DECLARE @fwGroupType INT = 0
DECLARE @fwOutGoingRouteOptions xml
DECLARE @topoFirewall TABLE
(
	clientGroupId INT,
	forClientGroupId INT,
	restrictionType INT
)
DECLARE @topoOutGoingRoutes TABLE
(
	clientGroupId INT,
	forClientGroupId INT,
	proxyClientGroupId INT,
	routeOptions XML
)
DECLARE @forceAllBackupRestoreDataTraffic INT = 1
DECLARE @forceThroughTunnel INT = 0
DECLARE @gatewayHostname varchar(256) = ''
DECLARE @routeType INT = 2
DECLARE @clientGroupName varchar(256) = ''
DECLARE @clientName varchar(256) = ''
DECLARE @clientId INT = 0
DECLARE @defaultOutgoingProtocol INT = 2
DECLARE @isTopoSmart INT = 0
DECLARE @directRouteDefaultOptions XML
DECLARE @flagIndicatingConfigLevel INT = 0
DECLARE @flagIndicatingConfigLevelForOptions INT = 0
DECLARE @encryptTraffic INT = ISNULL(@extendedOptions.value('/App_TopologyExtendedProperties[1]/@encryptTraffic', 'int'), 0)
DECLARE @numberOfStreams INT = ISNULL(@extendedOptions.value('/App_TopologyExtendedProperties[1]/@numberOfStreams', 'int'), 1)
DECLARE @connectionProtocol INT = ISNULL(@extendedOptions.value('/App_TopologyExtendedProperties[1]/@connectionProtocol', 'int'), 2)
DECLARE @configureAutomaticallyDefault INT = 1
DECLARE @configureAutomatically INT = @configureAutomaticallyDefault
DECLARE @defaultTunnelConnectionPort INT = 8403
DECLARE @defaultKeepAliveSeconds INT = 180
DECLARE @tunnelConnectionPort INT = @defaultTunnelConnectionPort
DECLARE @keepAliveSeconds INT = @defaultKeepAliveSeconds
DECLARE @firewallExtendedProperties xml = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	-- Consolidate all client group options
	-- Note : Topology can be created from multiple end points : Commcell console, Command center, qsdk.
	-- All properties might not be set from all ends. So when a topology has to be updated, if the given xml does not contain required options, use the existing DB values
	DECLARE @fwGroupOptions TABLE (clientGroupId INTEGER, configureAutomatically INTEGER, tunnelconnectionPort INTEGER, keepAliveSeconds INTEGER, useWildcardProxy INTEGER)
	INSERT INTO @fwGroupOptions (clientGroupId
				, configureAutomatically
				, tunnelconnectionPort
				, keepAliveSeconds
				, useWildcardProxy)
	SELECT FO.clientGroupId
			, ISNULL(ExProps.col.value('@configureAutomatically', 'INTEGER'), 1)
			, FO.tunnelconnectionPort
			, FO.keepAliveSeconds
			, ISNULL(ExProps.col.value('@useWildCardProxy', 'INTEGER'), 0)
	FROM APP_FirewallTopologyAssoc FTA WITH(NOLOCK)
	INNER JOIN App_FirewallOptions FO
	ON FTA.groupId=FO.clientGroupId
	CROSS APPLY FO.extendedProperties.nodes('App_FirewallExtendedProperties') ExProps(col)
	WHERE FTA.topologyId = @topologyId
	DECLARE @fwGroupOptionsInputXML TABLE (clientGroupId INTEGER, configureAutomatically INTEGER, tunnelconnectionPort INTEGER, keepAliveSeconds INTEGER, useWildcardProxy INTEGER)
	INSERT INTO @fwGroupOptionsInputXML (clientGroupId
				, configureAutomatically
				, tunnelconnectionPort
				, keepAliveSeconds
				, useWildcardProxy)
	SELECT FG.clientGroupId
			, ISNULL(FO.col.value('@configureAutomatically', 'INTEGER'), 1)
			, ISNULL(FO.col.value('@tunnelConnectionPort', 'INTEGER'), @defaultTunnelConnectionPort)
			, ISNULL(FO.col.value('@keepAliveSeconds', 'INTEGER'), @defaultKeepAliveSeconds)
			, ISNULL(FO.col.value('@useWildcardProxy', 'INTEGER'), 0)
	FROM @topologies FG
	CROSS APPLY FG.fwConfig.nodes('options') FO(col)
	-- Update existing options to new ones
	UPDATE FO
	SET   FO.configureAutomatically = IX.configureAutomatically
		, FO.tunnelconnectionPort = IX.tunnelconnectionPort
		, FO.keepAliveSeconds = IX.keepAliveSeconds
		, FO.useWildcardProxy = IX.useWildcardProxy
	FROM @fwGroupOptions FO
	INNER JOIN @fwGroupOptionsInputXML IX
	ON FO.clientGroupId=IX.clientGroupId
	-- Consider new groups added
	INSERT INTO @fwGroupOptions (clientGroupId, configureAutomatically, tunnelconnectionPort, keepAliveSeconds, useWildcardProxy)
	SELECT IX.clientGroupId, IX.configureAutomatically, IX.tunnelconnectionPort, IX.keepAliveSeconds, IX.useWildcardProxy
	FROM @fwGroupOptionsInputXML IX
	LEFT OUTER JOIN @fwGroupOptions FO
	ON IX.clientGroupId = FO.clientGroupId
	WHERE FO.clientGroupId IS NULL
	IF @encryptTraffic = 1
		BEGIN
SET @connectionProtocol = 1
			SET @forceThroughTunnel = 1
			SET @defaultOutgoingProtocol = 1
		END
	SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol' ,@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
	SET @directRouteDefaultOptions = (SELECT @connectionProtocol AS '@connectionProtocol',@forceThroughTunnel AS '@forceAllBackupRestoreDataTraffic','' AS '@gatewayHostname',0 /* DIRECT */ AS '@routeType', @numberOfStreams AS '@numberOfStreams' FOR XML PATH('App_FireWallOutGoingRouteOptions'))
	SELECT
       @internal = CASE t.fwGroupType
WHEN 1 THEN t.clientGroupId
                                  ELSE @internal
                           END,
       @external = CASE t.fwGroupType
WHEN 2 THEN t.clientGroupId
                                  ELSE @external
                           END,
       @proxied = CASE t.fwGroupType
WHEN 3 THEN t.clientGroupId
                                  ELSE @proxied
                           END,
	   @perimeterProxy = CASE t.fwGroupType
WHEN 4 THEN t.clientGroupId
								  ELSE @perimeterProxy
						   END
	FROM @topologies t
	SELECT @isTopoSmart = 1 FROM @topologies FwGroups WHERE FWGroups.clientGroupId < 0
SET @flagIndicatingConfigLevel = CASE WHEN @isTopoSmart = 1 THEN 4 ELSE 2 END
	/*
		Flags : 0 => Client/Group level, CONFIGURED_AT_TOPOLOGY => Configured via non-smart topology, CONFIGURED_AT_SMART_TOPOLOGY => Configured via smart topology
		Behavior till now (SP23 mid) : A client group with explicit network configuration is not allowed be part of a topology, and doesn't show up in the dropdown
		while creating a topology. Also, firewall options of groups belonging to only smart topologies are not considered.
		Consider a scenario where a client group with no explicit configuration, is part of only a smart topology.
		Now configure some firewall options such as tunnel port for this group.
		Go back to the previous smart topology, and make some update, and let it still be "smart".
		Now we lose the options set on the group. This is because the "flag" column of the App_firewallOptions is updated to indicate "Smart" and these options are ignored.
		To resolve this, start considering options specified on client groups belonging to smart topologies as well.
However, as "0" indicates group level options and 0 | 4 will still be 4, we are choosing to set the flag as 6 which is 4 | 2
		ToDo : Go ahead and fix all codebase to either use flag=1 for group level options or always consider smart topo options.
	*/
SET @flagIndicatingConfigLevelForOptions = CASE WHEN @isTopoSmart = 1 THEN (4 | 2) ELSE 2 END
	IF @external > 0 AND @isTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @external)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @external, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @external and isTrivialConfig <> 2
	END
	IF @internal > 0 AND @isTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @internal)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @internal, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @internal and isTrivialConfig <> 2
	END
	IF @proxied > 0 AND @isTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @proxied)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @proxied, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @proxied and isTrivialConfig <> 2
	END
	IF @perimeterProxy > 0 AND @isTopoSmart = 0
	BEGIN
		IF NOT EXISTS (SELECT 1 FROM App_FWTrivialConfig WHERE clientGroupId = @perimeterProxy)
			INSERT INTO [dbo].[App_FWTrivialConfig] ([clientId],[clientGroupId],[isTrivialConfig],[networkWithCS],[connectionWithCS],[proxyClientIdCS],[networkWithMA],[connectionWithMA],[proxyClientIdMA])
			VALUES
(0, @perimeterProxy, 2, 0,0,0,0,0,0)
		ELSE
UPDATE App_FWTrivialConfig SET isTrivialConfig = 2
WHERE clientGroupId = @perimeterProxy and isTrivialConfig <> 2
	END
	IF @external > 0
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@external
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		UPDATE [dbo].[App_FirewallOptions]
		SET flag = flag | @flagIndicatingConfigLevelForOptions
			, tunnelconnectionPort = @tunnelConnectionPort
			, keepAliveSeconds = @keepAliveSeconds
			, extendedProperties = @firewallExtendedProperties
		WHERE clientGroupId = @external
		IF @@ROWCOUNT=0
			INSERT INTO [dbo].[App_FirewallOptions]
			([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
SELECT 0, @external, 0, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties,@flagIndicatingConfigLevelForOptions
	END
IF @external > 0 AND @topologyType = 1
		EXEC AppSetProxyWildCardOption @external, @useWildCardProxy
	IF @internal > 0
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@internal
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		UPDATE [dbo].[App_FirewallOptions]
		SET flag = flag | @flagIndicatingConfigLevelForOptions
			, tunnelconnectionPort = @tunnelConnectionPort
			, keepAliveSeconds = @keepAliveSeconds
			, extendedProperties = @firewallExtendedProperties
		WHERE clientGroupId = @internal
		IF @@ROWCOUNT=0
			INSERT INTO [dbo].[App_FirewallOptions]
			([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
SELECT 0, @internal, 0, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties,@flagIndicatingConfigLevelForOptions
	END
IF @proxied > 0 AND  (@topologyType = 1 OR @topologyType = 4)
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@proxied
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		IF NOT EXISTS(SELECT 1 FROM App_FirewallOptions WHERE clientGroupId = @proxied)
			INSERT INTO [dbo].[App_FirewallOptions]
			([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
SELECT 0, @proxied, 1, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties,@flagIndicatingConfigLevelForOptions
		ELSE
			UPDATE App_FirewallOptions
			SET isDMZ = 1, flag = flag | @flagIndicatingConfigLevelForOptions
				, tunnelconnectionPort = @tunnelConnectionPort
				, keepAliveSeconds = @keepAliveSeconds
				, extendedProperties = @firewallExtendedProperties
			WHERE clientGroupId = @proxied
	END
IF @perimeterProxy > 0 AND @topologyType = 4
	BEGIN
		-- Reset to defaults
		SET @configureAutomatically = @configureAutomaticallyDefault
		SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @keepAliveSeconds = @defaultKeepAliveSeconds
		-- Update as per user configuration
		SELECT @configureAutomatically = configureAutomatically, @tunnelConnectionPort = tunnelconnectionPort, @keepAliveSeconds = keepAliveSeconds
		FROM @fwGroupOptions
		WHERE clientGroupId=@perimeterProxy
		-- Sanity checks and further initialization
		IF @configureAutomatically = 1 OR @tunnelConnectionPort = 0 OR @tunnelConnectionPort IS NULL
			SET @tunnelConnectionPort = @defaultTunnelConnectionPort
		SET @firewallExtendedProperties = (SELECT @defaultOutgoingProtocol as '@defaultOutgoingProtocol',@configureAutomatically as '@configureAutomatically' FOR XML PATH('App_FirewallExtendedProperties'))
		IF NOT EXISTS(SELECT 1 FROM App_FirewallOptions WHERE clientGroupId = @perimeterProxy)
			INSERT INTO [dbo].[App_FirewallOptions]
			([clientId],[clientGroupId],[isDMZ],[tunnelconnectionPort],[keepAliveSeconds],[tunnelInitSeconds],[foreceSSL],[lockDown],[bindOpenPortsOnly],[isRoamingClient],[extendedProperties],[flag])
SELECT 0, @perimeterProxy, 1, @tunnelConnectionPort, @keepAliveSeconds,30,0,0,0,0,@firewallExtendedProperties,@flagIndicatingConfigLevelForOptions
		ELSE
			UPDATE App_FirewallOptions
			SET isDMZ = 1, flag = flag | @flagIndicatingConfigLevelForOptions
				, tunnelconnectionPort = @tunnelConnectionPort
				, keepAliveSeconds = @keepAliveSeconds
				, extendedProperties = @firewallExtendedProperties
			WHERE clientGroupId = @perimeterProxy
	END
	-- Populate APP_Firewall and APP_FWOutgoingRoutes
IF @topologyType = 1
	BEGIN
		--proxied
		INSERT INTO @topoFirewall
SELECT @external, @proxied, 1
		UNION ALL
SELECT @internal, @proxied, 1
		UNION ALL
SELECT @proxied, @external, 0
		UNION ALL
SELECT @proxied, @internal, 0
		UNION ALL
SELECT @external, @internal, 1 WHERE @useWildCardProxy > 0
		SELECT @clientGroupName = name
		FROM APP_ClientGroup
		WHERE id = @proxied
		SET @fwOutGoingRouteOptions =(SELECT @connectionProtocol AS '@connectionProtocol',
				@forceAllBackupRestoreDataTraffic AS '@forceAllBackupRestoreDataTraffic',
				@gatewayHostname AS '@gatewayHostname',
				@routeType AS '@routeType',
				(SELECT @clientGroupName AS '@clientGroupName',
						@proxied AS '@clientGroupId',
						@clientName AS '@clientName',
						@clientId AS '@clientId'
						FOR XML PATH('remoteProxy'), TYPE)
					FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@external, @internal, @proxied, @fwOutGoingRouteOptions),
		(@internal, @external, @proxied, @fwOutGoingRouteOptions),
		(@internal, @proxied, 0, @directRouteDefaultOptions),
		(@external, @proxied, 0, @directRouteDefaultOptions)
	END
ELSE IF @topologyType = 2
	BEGIN
		--oneway
		INSERT INTO @topoFirewall
		VALUES
(@external, @internal, 1),
(@internal, @external, 0)
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@external, @internal, 0, @directRouteDefaultOptions)
	END
ELSE IF @topologyType = 3
	BEGIN
		--twoway
		INSERT INTO @topoFirewall
		VALUES
(@external, @internal, 0),
(@internal, @external, 0)
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@external, @internal, 0, @directRouteDefaultOptions),
		(@internal, @external, 0, @directRouteDefaultOptions)
	END
ELSE IF @topologyType = 4
	BEGIN
		-- Cascading Proxies
		INSERT INTO @topoFirewall
		VALUES
(@external, @proxied, 1),
(@perimeterProxy, @proxied, 0),
(@proxied, @external, 0),
(@proxied, @perimeterProxy, 1),
(@internal, @perimeterProxy, 1),
(@perimeterProxy, @internal, 0),
(@proxied, @internal, 1),
(@internal, @proxied, 1),
(@external, @internal, 1),
(@internal, @external, 1)
		SELECT @clientGroupName = name
		FROM APP_ClientGroup
		WHERE id = @proxied
		SET @fwOutGoingRouteOptions =(SELECT @connectionProtocol AS '@connectionProtocol',
				@forceAllBackupRestoreDataTraffic AS '@forceAllBackupRestoreDataTraffic',
				@gatewayHostname AS '@gatewayHostname',
				@routeType AS '@routeType',
				(SELECT @clientGroupName AS '@clientGroupName',
						@proxied AS '@clientGroupId',
						@clientName AS '@clientName',
						@clientId AS '@clientId'
						FOR XML PATH('remoteProxy'), TYPE)
					FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@perimeterProxy, @external, @proxied, @fwOutGoingRouteOptions),
		(@external, @perimeterProxy, @proxied, @fwOutGoingRouteOptions),
		(@external, @proxied, 0, @directRouteDefaultOptions),
		(@proxied, @perimeterProxy, 0, @directRouteDefaultOptions),
		(@external, @internal, @proxied, @fwOutGoingRouteOptions)
		SELECT @clientGroupName = name
		FROM APP_ClientGroup
		WHERE id = @perimeterProxy
		SET @fwOutGoingRouteOptions =(SELECT @connectionProtocol AS '@connectionProtocol',
				@forceAllBackupRestoreDataTraffic AS '@forceAllBackupRestoreDataTraffic',
				@gatewayHostname AS '@gatewayHostname',
				@routeType AS '@routeType',
				(SELECT @clientGroupName AS '@clientGroupName',
						@perimeterProxy AS '@clientGroupId',
						@clientName AS '@clientName',
						@clientId AS '@clientId'
						FOR XML PATH('remoteProxy'), TYPE)
					FOR XML PATH('App_FireWallOutGoingRouteOptions'))
		INSERT INTO @topoOutGoingRoutes
		VALUES
		(@internal, @external, @perimeterProxy, @fwOutGoingRouteOptions),
		(@internal, @proxied, @perimeterProxy, @fwOutGoingRouteOptions),
		(@proxied, @internal, @perimeterProxy, @fwOutGoingRouteOptions),
		(@internal, @perimeterProxy, 0, @directRouteDefaultOptions)
	END
	-- Update flag column of App_Firewall to indicate the route is part of smart vs non-smart topology
	UPDATE AF
	SET AF.flag = (AF.flag | @flagIndicatingConfigLevel)
	FROM APP_Firewall AF
	INNER JOIN @topoFirewall TF
	ON AF.clientGroupId = TF.clientGroupId AND AF.forClientGroupId = TF.forClientGroupId AND AF.restrictionType = TF.restrictionType
	INSERT INTO APP_Firewall
	SELECT 0, TF.clientGroupId, 0, TF.forClientGroupId, TF.restrictionType, @flagIndicatingConfigLevel
	FROM @topoFirewall TF
	LEFT JOIN APP_Firewall AF
	ON AF.clientGroupId = TF.clientGroupId AND AF.forClientGroupId = TF.forClientGroupId AND AF.restrictionType = TF.restrictionType
	WHERE AF.id IS NULL
	-- Update flag column of App_FWOutGoingRoutes to indicate the route is part of smart vs non-smart topology
	UPDATE FWOR
	SET FWOR.flag = ( FWOR.flag | @flagIndicatingConfigLevel)
	FROM App_FWOutGoingRoutes FWOR
	CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
	INNER JOIN @topoOutGoingRoutes TFO
	ON FWOR.clientGroupId=TFO.clientGroupId AND FWOR.forClientGroupId=TFO.forClientGroupId AND
	CASE WHEN OutRoute.routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(OutRoute.routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END = TFO.proxyClientGroupId
	-- Update "connectionProtocol" based on "@encryptTraffic" from App_FirewallTopology.extendedOptions
	IF @encryptTraffic = 1
	BEGIN
		UPDATE FO
		SET fwOutGoingRouteOptions.modify('
			replace value of (/App_FireWallOutGoingRouteOptions/@connectionProtocol)[1]
with "1"
		')
		FROM App_FWOutGoingRoutes FO
		CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
		INNER JOIN @topoOutGoingRoutes TFO
		ON FO.clientGroupId=TFO.clientGroupId AND FO.forClientGroupId=TFO.forClientGroupId AND
		CASE WHEN OutRoute.routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(OutRoute.routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END = TFO.proxyClientGroupId
	END
	INSERT INTO APP_FWOutGoingRoutes
	SELECT 0, TFO.clientGroupId, 0, TFO.forClientGroupId, TFO.routeOptions, @flagIndicatingConfigLevel
	FROM @topoOutGoingRoutes TFO
	LEFT JOIN
	(
		SELECT id, clientGroupId, forClientGroupId, CASE WHEN routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END proxyClientGroupId FROM APP_FWOutGoingRoutes
		CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
	) AFO
	ON AFO.clientGroupId = TFO.clientGroupId AND AFO.forClientGroupId = TFO.forClientGroupId AND AFO.proxyClientGroupId = TFO.proxyClientGroupId
	WHERE AFO.id IS NULL
	INSERT INTO App_FirewallRoutesTopoAssoc
	SELECT AF.id, @topologyId
	FROM @topoFirewall TF
	INNER JOIN APP_Firewall AF
	ON AF.clientGroupId = TF.clientGroupId AND AF.forClientGroupId = TF.forClientGroupId AND AF.restrictionType = TF.restrictionType
	INSERT INTO App_FWOutGoingRoutesTopoAssoc
	SELECT AFO.id, @topologyId
	FROM @topoOutGoingRoutes TFO
	INNER JOIN
	(
		SELECT id, clientGroupId, forClientGroupId, CASE WHEN routeOptions.exist('./remoteProxy[1]/@clientGroupId') = 1 THEN ISNULL(routeOptions.value('./remoteProxy[1]/@clientGroupId','int'),0) ELSE 0 END proxyClientGroupId FROM APP_FWOutGoingRoutes
		CROSS APPLY fwOutGoingRouteOptions.nodes('/App_FireWallOutGoingRouteOptions') OutRoute(routeOptions)
	) AFO
	ON AFO.clientGroupId = TFO.clientGroupId AND AFO.forClientGroupId = TFO.forClientGroupId AND AFO.proxyClientGroupId = TFO.proxyClientGroupId
	-- We need to update route specific properties (set at the topology level) if the route is part of multiple topologies
	-- Find out if the route is part of multiple topologies
	DECLARE @RoutePartOfMultipleTopologies TABLE (routeId INTEGER, topologyId INTEGER, connectionProtocol INTEGER, numberOfStreams INTEGER, connectionProtocolRank INTEGER)
	-- Old topologies created before SP21 or via commcell console do not have the connectionProtocol set. They only have encryptTraffic attribute.
	INSERT INTO @RoutePartOfMultipleTopologies (routeId, topologyId, connectionProtocol, numberOfStreams)
	SELECT FWORA2.routeId, FWORA2.topologyId, CASE ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@encryptTraffic', 'INTEGER'), 0)
WHEN 1 THEN 1
ELSE ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@connectionProtocol', 'INTEGER'), 2) END, ISNULL(Props.col.value('/App_TopologyExtendedProperties[1]/@numberOfStreams', 'INTEGER'), 1)
	FROM App_FWOutGoingRoutesTopoAssoc FWORA1
	INNER JOIN App_FWOutGoingRoutesTopoAssoc FWORA2
	ON FWORA1.routeId=FWORA2.routeId
	INNER JOIN APP_FirewallTopology FT
	ON FWORA2.topologyId=FT.topologyId
	CROSS APPLY FT.extendedProperties.nodes('/App_TopologyExtendedProperties') Props(col)
	WHERE FWORA1.topologyId = @topologyId
-- Start of UpdateTopologySpecificOptions
	-- Now update Topology specific options
	-- We need to consider MAX of numberOfStreams
	DECLARE @RouteStreams TABLE(routeId INTEGER, numberOfStreams INTEGER)
	INSERT INTO @RouteStreams
	SELECT routeId, MAX(numberOfStreams)
	FROM @RoutePartOfMultipleTopologies
	GROUP BY routeId
	-- Update App_FWOutGoingRoutes accordingly
	UPDATE FWOR
	SET fwOutGoingRouteOptions.modify(' replace value of (/App_FireWallOutGoingRouteOptions/@numberOfStreams)[1]
            with sql:column("RS.numberOfStreams")')
	FROM App_FWOutGoingRoutes FWOR
	INNER JOIN @RouteStreams RS
	ON FWOR.id=RS.routeId
	-- For connectionProtocol, we have the following priority order : https (1) > httpsa (2) > http (0) > raw  (3)
	-- For ease of enforcing this priority, let us map connection protocols to the following ranks
	-- Rank 1 => HTTPS	(enum value 1)
	-- Rank 2 => HTTPSA (enum value 2)
	-- Rank 3 => HTTP	(enum value 0)
	-- Rank 4 => RAW	(enum value 3)
	UPDATE @RoutePartOfMultipleTopologies
SET connectionProtocolRank = CASE connectionProtocol WHEN 1 THEN 1
WHEN 2	THEN 2
WHEN 0 THEN 3
WHEN 3 THEN 4
														 END
	DECLARE @RouteProtocol TABLE(routeId INTEGER, connectionProtocolRank INTEGER, connectionProtocol INTEGER)
	INSERT INTO @RouteProtocol (routeId, connectionProtocolRank)
	SELECT routeId, MIN(connectionProtocolRank)
	FROM @RoutePartOfMultipleTopologies
	GROUP BY routeId
	-- Reverse mapping rank to protocol (as we cannot use rank directly in xml.modify(replace value of) with a case statement)
	UPDATE @RouteProtocol
SET connectionProtocol = CASE connectionProtocolRank WHEN 1 THEN 1
WHEN 2	THEN 2
WHEN 3 THEN 0
WHEN 4 THEN 3
														 END
	-- Update App_FWOutGoingRoutes accordingly
	UPDATE FWOR
	SET fwOutGoingRouteOptions.modify(' replace value of (/App_FireWallOutGoingRouteOptions/@connectionProtocol)[1]
            with sql:column("RP.connectionProtocol")')
	FROM App_FWOutGoingRoutes FWOR
	INNER JOIN @RouteProtocol RP
	ON FWOR.id=RP.routeId
-- End of UpdateTopologySpecificOptions
END
GO

IF EXISTS (select * from GxQscripts where name = 'PopulateTopology')
	delete from GxQscripts where name = 'PopulateTopology'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PopulateTopology')
	delete from GXDBVersions where aliasname = 'PopulateTopology'
GO

insert into GXDBVersions values(2, 'PopulateTopology',  'v1.1.2.22.16.1', 'PopulateTopology', 'v1.1.2.22.16.1')
GO

