

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PopulateEntityNamesForAppId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PopulateEntityNamesForAppId.sp,v $ $Id: PopulateEntityNamesForAppId.sp,v 1.3.72.1 2018/03/27 09:00:42 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PopulateEntityNamesForAppId <<<'

IF EXISTS (select * from sysobjects where name='PopulateEntityNamesForAppId')
	drop procedure PopulateEntityNamesForAppId
IF EXISTS (select * from GxQscripts where name='PopulateEntityNamesForAppId')
	delete from GxQscripts where name = 'PopulateEntityNamesForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PopulateEntityNamesForAppId')
	delete from GXDBVersions where aliasname = 'PopulateEntityNamesForAppId'
GO
print '... Creating Procedure: PopulateEntityNamesForAppId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PopulateEntityNamesForAppId
  @i_input XML
AS
  DECLARE @o_outputXML XML;
BEGIN
SET NOCOUNT ON
	DECLARE @idoc           int
	EXEC sp_xml_preparedocument @idoc OUTPUT, @i_input
	if object_id('tempdb.dbo.#tempArchivedPSTs') is not null DROP TABLE #tempArchivedPSTs
	CREATE TABLE #tempArchivedPSTs (
		PSTName NVARCHAR(1024),
		PSTPath	NVARCHAR(2048),
		PSTOwner	NVARCHAR(2048),
		OwnerType	INT,
		Status		INT,
		PSTReason	NVARCHAR(2048),
		PSTSize		BIGINT,
		NumOfMsgs	BIGINT,
		NumOfSuccessMsgs	BIGINT,
		NumOfFailedMsgs		BIGINT,
		subclientId INT,
		subClientName NVARCHAR(1024),
		backupSetNaame NVARCHAR(1024),
		clientName	  NVARCHAR(1024)
	)
	INSERT INTO #tempArchivedPSTs (PSTName, PSTPath, PSTOwner, OwnerType, Status, PSTReason, PSTSize, NumOfMsgs, NumOfSuccessMsgs, NumOfFailedMsgs, subclientId, subClientName, backupSetNaame, clientName)
	SELECT *
	FROM OPENXML(@idoc, '//JobManager_PSTArch_Reports/PSTFileInfo', 0)
	WITH(
		PSTName NVARCHAR(1024) '@PSTName',
		PSTPath	NVARCHAR(2048) '@PSTPath',
		PSTOwner	NVARCHAR(2048) '@PSTOwner',
		OwnerType	INT '@OwnerType',
		Status		INT '@Status',
		PSTReason	NVARCHAR(2048) '@PSTReason',
		PSTSize		BIGINT '@PSTSize',
		NumOfMsgs	BIGINT '@NumOfMsgs',
		NumOfSuccessMsgs	BIGINT '@NumOfSuccessMsgs',
		NumOfFailedMsgs		BIGINT '@NumOfFailedMsgs',
		subclientId INT '@subclientId',
		subClientName NVARCHAR(1024) '@subClientName',
		backupSetNaame NVARCHAR(1024) '@backupSetNaame',
		clientName	  NVARCHAR(1024) '@clientName'
	)
	UPDATE	#tempArchivedPSTs SET SubClientName = A.subclientName, backupSetNaame = B.name, ClientName = C.name
	FROM	#tempArchivedPSTs T, APP_Application A, APP_Client C, APP_BackupSetName B
	WHERE	T.SubclientId = A.id AND A.clientId = C.id AND A.backupSet = B.id
	SELECT	PSTName AS '@PSTName',
			PSTPath AS '@PSTPath',
			PSTOwner AS '@PSTOwner',
			OwnerType AS '@OwnerType',
			Status AS '@Status',
			PSTReason AS '@PSTReason',
			PSTSize AS '@PSTSize',
			NumOfMsgs AS '@NumOfMsgs',
			NumOfSuccessMsgs AS '@NumOfSuccessMsgs',
			NumOfFailedMsgs AS '@NumOfFailedMsgs',
			subclientId AS '@subclientId',
			subClientName AS '@subClientName',
			backupSetNaame AS '@backupSetNaame',
			clientName AS '@clientName'
	FROM	#tempArchivedPSTs
	FOR	XML PATH ('PSTFileInfo'), ROOT('JobManager_PSTArch_Reports')
	if object_id('tempdb.dbo.#tempArchivedPSTs') is not null DROP TABLE #tempArchivedPSTs
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'PopulateEntityNamesForAppId')
	delete from GxQscripts where name = 'PopulateEntityNamesForAppId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PopulateEntityNamesForAppId')
	delete from GXDBVersions where aliasname = 'PopulateEntityNamesForAppId'
GO

insert into GXDBVersions values(2, 'PopulateEntityNamesForAppId',  '00010003007200010000', 'PopulateEntityNamesForAppId', '00010003007200010000')
GO

