

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PopulateCaseManagerDiscovery.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PopulateCaseManagerDiscovery.sp,v $ $Id: PopulateCaseManagerDiscovery.sp,v 1.5.60.2 2018/03/22 01:48:15 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: To populate CaseManager Client source associations.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PopulateCaseManagerDiscovery <<<'

IF EXISTS (select * from sysobjects where name='PopulateCaseManagerDiscovery')
	drop procedure PopulateCaseManagerDiscovery
IF EXISTS (select * from GxQscripts where name='PopulateCaseManagerDiscovery')
	delete from GxQscripts where name = 'PopulateCaseManagerDiscovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PopulateCaseManagerDiscovery')
	delete from GXDBVersions where aliasname = 'PopulateCaseManagerDiscovery'
GO
print '... Creating Procedure: PopulateCaseManagerDiscovery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PopulateCaseManagerDiscovery
AS
	SET NOCOUNT ON
	DECLARE @refClientId integer
	DECLARE @caseInfo XML
	DECLARE @auditCMClients TABLE
	(
		subclientEntity	nvarchar(max),
		oldXml			nvarchar(max),
		newXml			nvarchar(max)
	)
	Declare caseCur CURSOR FOR
	select RefCopyClientId, caseXml from DM2CaseInfo where ISNull(RefCopyClientId, 0) > 0
	And status = 1/*OPEN*/
	Open caseCur;
	Fetch Next From caseCur Into @refClientId, @caseInfo
	While @@FETCH_STATUS = 0
	BEGIN
		BEGIN TRY
			BEGIN TRAN
			Insert Into @auditCMClients
			Exec PopulateCaseManagerAssociations @refClientId, @caseInfo
			COMMIT TRAN
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			ROLLBACK TRAN
		END CATCH
		Fetch Next From caseCur Into @refClientId, @caseInfo
	END
	CLOSE caseCur
	DEALLOCATE caseCur
	SELECT * FROM @auditCMClients
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PopulateCaseManagerDiscovery')
	delete from GxQscripts where name = 'PopulateCaseManagerDiscovery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PopulateCaseManagerDiscovery')
	delete from GXDBVersions where aliasname = 'PopulateCaseManagerDiscovery'
GO

insert into GXDBVersions values(2, 'PopulateCaseManagerDiscovery',  '00010005006000020000', 'PopulateCaseManagerDiscovery', '00010005006000020000')
GO

