

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PopulateCaseManagerAssociations.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PopulateCaseManagerAssociations.sp,v $ $Id: PopulateCaseManagerAssociations.sp,v 1.8.2.4 2018/03/22 01:33:39 jiechen Exp $";
--  +========================================================================+
--  | Stored Precedure: To populate CaseManager Client source associations.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PopulateCaseManagerAssociations <<<'

IF EXISTS (select * from sysobjects where name='PopulateCaseManagerAssociations')
	drop procedure PopulateCaseManagerAssociations
IF EXISTS (select * from GxQscripts where name='PopulateCaseManagerAssociations')
	delete from GxQscripts where name = 'PopulateCaseManagerAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PopulateCaseManagerAssociations')
	delete from GXDBVersions where aliasname = 'PopulateCaseManagerAssociations'
GO
print '... Creating Procedure: PopulateCaseManagerAssociations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PopulateCaseManagerAssociations
  @inClientId INT,
  @inputxml XML,
  @fromDiscovery INT = 1
AS
BEGIN
  DECLARE @outSubclientEntity XML
  DECLARE @oldAssocXml XML
  DECLARE @newAssocXml XML
SET NOCOUNT ON
	DECLARE @allAssociations	INT
	DECLARE @capability			INT
	DECLARE @caseManagerId		INT = 0
	DECLARE @retainUntil		INT = -1
	DECLARE @CaseId				INT = 0
	DECLARE @LocalUserClientIdTbl INT = 0
	DECLARE @isActual			INT = 0
	--DECLARE @fromDiscovery		INT = 0
	DECLARE @auditCMClients TABLE
	(
		subclientEntity	nvarchar(max),
		oldXml			nvarchar(max),
		newXml			nvarchar(max)
	)
	DECLARE @refCopyContent TABLE
	(
		holdType		integer,
		content			xml
	)
	-- Populate the supported holdTypes
	DECLARE @appTypeHoldType TABLE
	(
		appType			integer,
		holdType		integer
	)
	Insert Into @appTypeHoldType values(33/*File System*/, 4)
	Insert Into @appTypeHoldType values(29/*File System*/, 4)
	Insert Into @appTypeHoldType values(54/*Mail Box*/, 5)
	Insert Into @appTypeHoldType values(67/*Journal*/, 6)
	-- Populate the supported AppTypes
	DECLARE @supportedRefAppTypes TABLE
	(
		refAppType			integer,
		appType				integer
	)
	Insert Into @supportedRefAppTypes values(33, 11)
	Insert Into @supportedRefAppTypes values(33, 34)
	Insert Into @supportedRefAppTypes values(33, 42)
	Insert Into @supportedRefAppTypes values(33, 43)
	Insert Into @supportedRefAppTypes values(33, 1)
	Insert Into @supportedRefAppTypes values(29, 17)
	Insert Into @supportedRefAppTypes values(29, 18)
	Insert Into @supportedRefAppTypes values(29, 19)
	Insert Into @supportedRefAppTypes values(29, 20)
	Insert Into @supportedRefAppTypes values(29, 21)
	Insert Into @supportedRefAppTypes values(29, 29)
	Insert Into @supportedRefAppTypes values(29, 36)
	Insert Into @supportedRefAppTypes values(29, 38)
	Insert Into @supportedRefAppTypes values(29, 63)
	Insert Into @supportedRefAppTypes values(29, 64)
	Insert Into @supportedRefAppTypes values(29, 74)
	Insert Into @supportedRefAppTypes
	select T.ref.value('@applicationId','int'), T.ref.value('@applicationId','int') from @inputxml.nodes('/DM2ContentIndexing_CaseInfo/supportedAgents') T(ref)
/*
	-- Populate reviewType appType
	DECLARE @reviewTypeHoldType TABLE
	(
		reviewType		integer,
		appType			integer
	)
	Insert Into @reviewTypeHoldType values(1/*Files*/, 33)
	Insert Into @reviewTypeHoldType values(1/*Files*/, 29)
	Insert Into @reviewTypeHoldType values(2/*Emails*/, 54)
	Insert Into @reviewTypeHoldType values(3/*Journal*/, 67)
*/
	IF object_id('tempdb.dbo.#userClientIdTbl') IS NULL
	BEGIN
		CREATE TABLE #userClientIdTbl ( id integer, appId integer, holdType integer)
		SET @LocalUserClientIdTbl = 1
	END
	--
	-- DM2GetCMRefCopyAssociations stored procedure does the job of populating this table with selected client groups
	-- by reading data from case XML that are applicable to be protected by case selectively.
	IF object_id('tempdb.dbo.#userClientGroupsTbl') IS NOT NULL
	BEGIN
		DROP TABLE #userClientGroupsTbl
	END
	CREATE TABLE #userClientGroupsTbl ( entityId INT)
	--
	-- capture parameters from case XML
	SELECT @CaseId = (CASE WHEN @inputxml IS NULL THEN CaseId ELSE 0 END),
	@retainUntil = ISNULL(dbo.GetUnixTime(RetentionDateTime), -1)
	FROM DM2CaseInfo(NoLock)
	WHERE RefCopyClientId = @inClientId
	Select @isActual = ISNULL(i.Col.value('@enableDataCopy', 'int'),0) From  @inputxml.nodes('/DM2ContentIndexing_CaseInfo') as i(col)
	IF @isActual = 0 -- Inline ReferenceCopy
		exec DM2GetAllCaseClients @GetUserClientRelationPerCase = 0, @CaseId = @CaseId, @i_xmlText = @inputxml, @debug = 0
	ELSE
	BEGIN
		exec DM2GetCMRefCopyAssociations @inputxml, @CaseId
		Insert into @refCopyContent
		SELECT
				ISNULL(col.value('@holdType', 'int'), 0) as holdType,
				col.query('filters/refCopyCriteria') as Filters
		FROM
				@inputxml.nodes('/DM2ContentIndexing_CaseInfo/caseCriteria') AS i(Col)
		Update T
		Set content = (
						Select
						ISNULL(content.value('(refCopyCriteria/@fromTime)[1]', 'int'), 0) as '@fromTime',
						ISNULL(content.value('(refCopyCriteria/@toTime)[1]', 'int'), 0) as '@toTime',
						ISNULL(content.value('(refCopyCriteria/@useLatestCycle)[1]', 'int'), 0) as '@useLatestCycle',
						content.query('refCopyCriteria/*')
						For XML PATH('databrowse_ReferenceCopyContents')
						)
		From @refCopyContent T
	END
	-- If the Case passes the retentionTime then reset all the associations.
	IF @retainUntil > 0 AND @retainUntil > dbo.GetUnixTime(GETUTCDATE())
	BEGIN
		Delete From #userClientIdTbl
		--PRINT 'Retention Date Time Passed. All client deleted'
	END
	DECLARE @holdClients TABLE
	(
		id int
	)
	Insert Into @holdClients
	Select distinct id from #userClientIdTbl
	-- Update CaseManager Hold client property to be used for CaseManager smart group.
	Merge APP_ClientProp cProp
	Using @holdClients cHold
	On (cHold.id = cProp.componentNameId AND cProp.attrName = N'CaseManager Hold' and cast(cProp.attrVal as int) = @inClientId and cProp.modified = 0)
	WHEN NOT MATCHED THEN
		INSERT VALUES(cHold.id, N'CaseManager Hold', 7, @inClientId, dbo.GetUnixTime(GETDATE()), 0, 0);
	-- Ideally this should be added in the above merge statement. But it is throwing error.
	DELETE FROM App_ClientProp
	WHERE attrName = N'CaseManager Hold' AND modified = 0 AND attrVal = @inClientId AND componentNameId not in(select id from @holdClients)
	--Make sure below line is commented before check-in.
	--select * from #userClientIdTbl
	IF object_id('tempdb.dbo.#refCopyAppId') IS NOT NULL
	   DROP TABLE #refCopyAppId
	create table #refCopyAppId(client integer, appTypeId integer, subclientId integer)
	Insert into #refCopyAppId
	select clientId, appTypeId, id
	From APP_Application
Where clientId = @inClientId And subclientStatus & 0x10000 = 0x10000
	-- Write loop to fetch list of appIds and then to populate to all the subclients.
	Declare @inSubClient integer
	Declare @inAppTypeId integer
	DECLARE @oldXml nvarchar(max)
	DECLARE @newXml nvarchar(max)
	DECLARE @subclientEntity xml
	DECLARE @reviewSetAssoc xml
	DECLARE @clientGroupsAssocXML xml
	DECLARE @tempXml xml
	IF @LocalUserClientIdTbl = 1
	BEGIN
		Declare appCur CURSOR FOR
		Select appTypeId, subClientId from #refCopyAppId
		Open appCur;
		Fetch Next From appCur Into @inAppTypeId, @inSubClient
		While @@FETCH_STATUS = 0
		BEGIN
			set @oldXml = ISNULL((Select attrVal From App_SubclientProp Where componentNameId = @inSubClient and attrName = 'Reference Copy Association' and modified = 0), '')
			IF @inAppTypeId = 54
			BEGIN
				set @newXml = (
				select
7 as '@_type_',
					C.id as '@clientId',
					C.name as '@clientName',
					Ida.type as '@applicationId',
					Ida.name as '@appName',
					Inst.id as '@instanceId',
					dbo.EncodeInvalidXMLChar(Inst.name) as '@instanceName',
					BK.id as '@backupsetId',
					BK.name as '@backupsetName',
					SC.id as '@subclientId',
					SC.subclientName as '@subclientName'
				FROM #userClientIdTbl A, APP_Client(NOLOCK) C,
					APP_iDAType(NOLOCK) Ida,
					APP_InstanceName(NOLOCK) Inst,
					APP_BackupSetName(NOLOCK) BK,
					APP_Application(NOLOCK) SC
				Where
					A.holdType In (select holdType From @appTypeHoldType Where appType = @inAppTypeId) And
					A.appId = SC.id and
					C.id = SC.clientId and
					Ida.type = SC.appTypeId and
					Inst.id = SC.instance and
					BK.id = SC.backupSet
					For XML PATH('associations'), root('databrowse_ReferenceCopyAssociations'))
			END
			ELSE
			BEGIN
				set @newXml = (
				select
3	as '@_type_',
				B.id as '@clientId',
				B.name as '@clientName'
				from #userClientIdTbl A, APP_Client B, App_IdaName C
				Where
				A.holdType In (select holdType From @appTypeHoldType Where appType = @inAppTypeId) And
				A.id = B.id And B.id = C.clientId
				And C.appTypeId In(Select appType From @supportedRefAppTypes Where refAppType = @inAppTypeId)
				For XML PATH('associations'), root('databrowse_ReferenceCopyAssociations'))
			END
			IF(@newXml IS NULL)
				SET @newXml = '<databrowse_ReferenceCopyAssociations/>'
			SET @reviewSetAssoc =
			(
				SELECT
					9501 as '@_type_',
					containerId as '@reviewSetId',
					containerName as '@reviewSetName'
				FROM DM2Container where containerGuid in
				(
					SELECT  i.col.value('@containerGuid','varchar(256)')
					FROM @inputXml.nodes('DM2ContentIndexing_CaseInfo/caseCriteria/filters/reviewSetHoldDetail/reviewSetCriteria') as i(col)
					--outer apply i.col.nodes('../dataTypes') as o(col)
					--WHERE i.col.value('../../../@holdType', 'int') = 7/*Hold by ReviewSet*/ And o.col.value('@val','int') in(select reviewType From @reviewTypeHoldType where appType = @inAppTypeId)
					WHERE i.col.value('../../../@holdType', 'int') = 7/*Hold by ReviewSet*/
				)
				For Xml Path('associations')
			)
			IF (@reviewSetAssoc IS NOT NULL)
			BEGIN
				SET @tempXml = @newXml
				set @tempXml.modify('insert
										(sql:variable("@reviewSetAssoc"))
										as last into
										(/databrowse_ReferenceCopyAssociations[1])
									')
				SET @newXml = CONVERT(nvarchar(max), @tempXml)
			END
			if exists (select top 1 entityid from #userClientGroupsTbl)
			BEGIN
				SET @clientGroupsAssocXML =
					(
SELECT 28 as '@_type_',
						entityId as '@clientGroupId',
						name as '@clientGroupName'
						from #userClientGroupsTbl a, APP_ClientGroup b WITH(NOLOCK)
						where a.entityId = b.id
						For Xml Path('associations')
					)
				--got client groups association xml, now we have to insert that into main xml
				IF @clientGroupsAssocXML IS NOT NULL
				BEGIN
					SET @tempXml = @newXml
					SET @tempXml.modify('insert
										(sql:variable("@clientGroupsAssocXML"))
										as last into
										(/databrowse_ReferenceCopyAssociations[1])
									')
					SET @newXml = CONVERT(nvarchar(max), @tempXml)
				END
			END
			if( @oldXml != @newXml)
			begin
				-- Add code to do audit trail
				Update App_SubclientProp
				set modified = dbo.getunixtime(getutcdate())
				where attrName = 'Reference Copy Association'
				And componentNameId = @inSubclient
				insert into App_SubclientProp
				values (@inSubClient, 'Reference Copy Association', 1, @newXml, dbo.getunixtime(getutcdate()), 0, 0)
				SET @subclientEntity = (SELECT
7 as '@_type_',
										C.id as '@clientId',
										C.name as '@clientName',
										Ida.type as '@applicationId',
										Ida.name as '@appName',
										Inst.id as '@instanceId',
										dbo.EncodeInvalidXMLChar(Inst.name) as '@instanceName',
										BK.id as '@backupsetId',
										BK.name as '@backupsetName',
										SC.id as '@subclientId',
										SC.subclientName as '@subclientName'
										FROM
										APP_Client(NOLOCK) C,
										APP_iDAType(NOLOCK) Ida,
										APP_InstanceName(NOLOCK) Inst,
										APP_BackupSetName(NOLOCK) BK,
										APP_Application(NOLOCK) SC
										where
										SC.id = @inSubClient and
										C.id = SC.clientId and
										Ida.type = SC.appTypeId and
										Inst.id = SC.instance and
										BK.id = SC.backupSet
										FOR XML PATH('SubClientEntity'), TYPE)
				Insert Into @auditCMClients
				values( cast(@subclientEntity as nvarchar(max)), @oldXml, @newXml)
			end
			IF @fromDiscovery = 0 AND @isActual = 1
			BEGIN
				SET @oldXml = ISNULL((Select attrVal From App_SubclientProp Where componentNameId = @inSubClient and attrName = 'Reference Copy Content' and modified = 0), '')
				SET @newXml = (select cast(content as nvarchar(max)) From @refCopyContent Where holdType = (select holdType From @appTypeHoldType where appType = @inAppTypeId))
				IF(@newXml is null)
					set @newXml = '<databrowse_ReferenceCopyContents/>'
				IF( @oldXml != @newXml)
				BEGIN
					Update App_SubclientProp
					set modified = dbo.getunixtime(getutcdate())
					where attrName = 'Reference Copy Content'
					And componentNameId = @inSubclient
					insert into App_SubclientProp
					values (@inSubClient, 'Reference Copy Content', 1, @newXml, dbo.getunixtime(getutcdate()), 0, 0)
				END
			END
			Fetch Next From appCur Into @inAppTypeId, @inSubClient
		END
		-- select '<DM2ContentIndexing::CaseManagerClientResp/>'
		Select * From @auditCMClients
		DROP TABLE #userClientIdTbl
	END
	--
	-- drop and cleanup locally created temp tables
	--
	DROP TABLE #userClientGroupsTbl
	DROP TABLE #refCopyAppId
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'PopulateCaseManagerAssociations')
	delete from GxQscripts where name = 'PopulateCaseManagerAssociations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PopulateCaseManagerAssociations')
	delete from GXDBVersions where aliasname = 'PopulateCaseManagerAssociations'
GO

insert into GXDBVersions values(2, 'PopulateCaseManagerAssociations',  '00010008000200040000', 'PopulateCaseManagerAssociations', '00010008000200040000')
GO

