

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PlanRulesGetV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PlanRulesGetV2.sp,v $ $Id: PlanRulesGetV2.sp,v 1.1.2.8 2019/12/27 13:38:01 mdilshad Exp $";
--	+===================================================================================+
--	|  								PlanRulesGetV2										|
--	|																					|
--  |  PARAMETERS																		|
--  |    i_UserId     = id of the caller												|
--  |    i_LocaleId   = Locale id														|
--  |    i_entityId   = id of plan/planrule												|
--  |    i_entityType = Plan_Entity -> 158, Plan_Rule_Entity -> 159						|
--  |  OUTPUTS																			|
--  |	 x_XmlData	  = Api::PlanRulesInfoResp message									|
--	+===================================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PlanRulesGetV2')
BEGIN
	print '>>> Drop Stored Procedure: PlanRulesGetV2 <<<'
	drop procedure PlanRulesGetV2
END
IF EXISTS (select * from GxQscripts where name='PlanRulesGetV2')
	delete from GxQscripts where name = 'PlanRulesGetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRulesGetV2')
	delete from GXDBVersions where aliasname = 'PlanRulesGetV2'
GO
print '... Creating Procedure: PlanRulesGetV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PlanRulesGetV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_UserId INT,
  @i_LocaleId INT,
  @i_entityType INT,
  @i_entityId INT,
  @x_XmlData XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode				INT = 0,
			@errorString			NVARCHAR(MAX) = ''
	DECLARE @propertyLevel INT = 0
	BEGIN TRY
		IF @x_XmlData IS NOT NULL
		BEGIN
				SET @propertyLevel = @x_XmlData.value('.', 'INT')
				SET @x_XmlData = NULL
		END
		-- DECLARING TABLE VARIABLE INSTEAD OF TEMP TABLE AS EXPECTING # OF ROWS < 100
		DECLARE @ruleList TABLE (ruleId INT PRIMARY KEY, rank INT)
IF @i_entityType = 159 /*PLAN_RULE_ENTITY*/
		BEGIN
			-- VALIDATE IF RULEID IS VALID
			IF NOT EXISTS (SELECT 1 FROM App_PlanRule WHERE ruleId = @i_entityId)
			BEGIN
SET @errorCode = (3773 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_PLANRULE_NOT_FOUND*/
				SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @i_LocaleId)
				;THROW @errorCode, @errorString, 1
			END
			INSERT INTO @ruleList (ruleId) VALUES(@i_entityId)
		END
ELSE IF @i_entityType = 158 /*PLAN_ENTITY*/
		BEGIN
			-- VALIDATE IF PLAN IS VALID
			IF NOT EXISTS (SELECT 1 FROM App_Plan WHERE id = @i_entityId)
			BEGIN
SET @errorCode = (3442 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_PLAN_NOT_FOUND*/
				SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @i_LocaleId)
				;THROW @errorCode, @errorString, 1
			END
			-- GET THE RULEIDs FROM App_PlanProp TABLE
DECLARE @ruleXml XML = dbo.AppPlanGetEntityValueV2(@i_entityId, 'Storage Rules', default)
			INSERT INTO @ruleList (ruleId, rank)
			SELECT
				ISNULL(( ref.value('(rule/@ruleId)[1]', 'INT')), 0),
				ISNULL(( ref.value('@rank', 'INT')), 0)
				FROM @ruleXml.nodes ('Api_PlanRuleMaps/rules') R(ref)
		END
		-- POPULATE THE OUTPUT XML WITH THE RESPONSE
		SET @x_xmlData = (SELECT
							(SELECT
								--(SELECT Data from dbo.SplitString(R.RetentionPeriod, ',') WHERE id = 1) as '@retentionDays',
								AG.retentionDays as '@retentionDays',
								RL.rank as '@rank',
								R.summary as '@summary',
								(SELECT R.ruleId as '@ruleId', R.ruleName as '@ruleName' FOR XML PATH('rule'), TYPE),
								(SELECT R.regionIds as 'regions'),
								/*Commenting out ClientGroups/Agents for now. Needs to be enabled if required in future.
								(SELECT ISNULL(R.clientGroupId, 0) as '@clientGroupId', ISNULL(CG.name, 'Any') as '@clientGroupName'
									FOR XML PATH('clientGroup'), TYPE),
								(SELECT R.agentTypeIds as 'agents'),*/
								(SELECT
									(SELECT R.storagePolicyId AS '@storagePolicyId' FOR XML PATH('storagePolicy'), TYPE),
									DBO.GetStoragePolicyCopyDetails(R.storagePolicyId, @propertyLevel)
								 FOR XML PATH('storage'), TYPE),
								(SELECT A.id AS '@storagePoolId', A.name AS '@storagePoolName'
									FOR XML PATH('storagePool'), TYPE)
							FOR XML PATH('rules'), TYPE),
							(SELECT @errorCode as '@erroCode', @errorString as '@errorMessage' WHERE @errorCode <> 0
							 FOR XML PATH('error'), TYPE)
						FROM @ruleList RL
						JOIN App_PlanRule R ON R.ruleId = RL.ruleId
						LEFT OUTER JOIN archGroup A WITH(NOLOCK) ON A.id = R.storagePoolId
						LEFT OUTER JOIN archAgingRule AG WITH(NOLOCK) ON AG.copyId = R.storagePolicyId
						--LEFT OUTER JOIN APP_ClientGroup CG WITH(NOLOCK) ON R.clientGroupId = CG.id
						FOR XML PATH(''), ROOT('PlanRulesInfoResp')
						)
	END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @errorCode = 0
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
	SET @x_XmlData = (SELECT @errorCode as '@erroCode', @errorString as '@errorMessage'
						FOR XML PATH('error'), ROOT('PlanRulesInfoResp')
					 )
END CATCH
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PlanRulesGetV2')
	delete from GxQscripts where name = 'PlanRulesGetV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRulesGetV2')
	delete from GXDBVersions where aliasname = 'PlanRulesGetV2'
GO

insert into GXDBVersions values(2, 'PlanRulesGetV2',  '00010001000200080000', 'PlanRulesGetV2', '00010001000200080000')
GO

