

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PlanRuleGetFieldsValuesForEntityV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PlanRuleGetFieldsValuesForEntityV2.sp,v $ $Id: PlanRuleGetFieldsValuesForEntityV2.sp,v 1.1.2.15.4.3 2021/05/10 18:43:06 njain Exp $";
--	+===============================================================================+
--	|  					PlanRuleGetFieldsValuesForEntityV2							|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_entityId	  = id of client/subclient/backupset/instance					|
--  |    i_entityType = Client -> 3, subclient -> 7, backupset -> 6, instance -> 5	|
--  |    i_userId	  = id of the requestor					|
--  |  OUTPUTS																		|
--  |	 o_xml		  =	appTypeId, comma separated clientGroupIds and regionId		|
--	+===============================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='PlanRuleGetFieldsValuesForEntityV2')
BEGIN
	print '>>> Drop Stored Procedure: PlanRuleGetFieldsValuesForEntityV2 <<<'
	drop procedure PlanRuleGetFieldsValuesForEntityV2
END
IF EXISTS (select * from GxQscripts where name='PlanRuleGetFieldsValuesForEntityV2')
	delete from GxQscripts where name = 'PlanRuleGetFieldsValuesForEntityV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRuleGetFieldsValuesForEntityV2')
	delete from GXDBVersions where aliasname = 'PlanRuleGetFieldsValuesForEntityV2'
GO
print '... Creating Procedure: PlanRuleGetFieldsValuesForEntityV2'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure PlanRuleGetFieldsValuesForEntityV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_entityId INT,
  @i_entityType INT,
  @i_userId INT = 0,
  @i_localeId INT = 0,
  @o_xml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
  DECLARE @errorCode INT = 0
  DECLARE @errorMsg NVARCHAR(MAX) = ''
IF (@i_entityId > 0)
BEGIN TRY
 	DECLARE	@clientId				INT = @i_entityId,
 			@appTypeId				INT,
 			@regionId				INT,
 			@clientGroupId			VARCHAR(1024),
			@companyId				INT,
			@reCalculate    		INT  = 1
DECLARE @clientZones			TABLE(zoneId INT PRIMARY KEY, lat float, long float, distance float default 0, country nvarchar(127), state nvarchar(127))
 	DECLARE @clientGroups			TABLE(clientGroupId INT PRIMARY KEY)
	IF OBJECT_ID('tempdb.dbo.#regionInfo') IS NOT NULL
		DROP TABLE #regionInfo
	CREATE TABLE #regionInfo(regionId	INT)
--
	----- PseudoCient to client mapping BEGIN -------------------------------------------------------------------------------------------
IF @i_entityType = 3 /*CLIENT_ENTITY*/
		AND EXISTS (SELECT 1 FROM APP_ClientProp WITH(READUNCOMMITTED)
					WHERE componentNameId = @i_entityId AND modified = 0
AND attrName = 'User Centric Client' AND ISNUMERIC(attrVal) = 1)
	BEGIN
		SELECT
 			@clientId = attrVal
		FROM APP_ClientProp WITH(READUNCOMMITTED)
WHERE componentNameId = @i_entityId AND modified = 0 AND attrName = 'Physical Client Id' AND ISNUMERIC(attrVal) = 1
	END
	----- PseudoCient to client mapping END ---------------------------------------------------------------------------------------------
--
--
 	----- AgentType BEGIN ---------------------------------------------------------------------------------------------------------------
IF @i_entityType = 3 /*CLIENT_ENTITY*/
 		SELECT
 			@appTypeId = appTypeId
 		FROM APP_Application a WITH(READUNCOMMITTED)
JOIN APP_BackupSetName b WITH(READUNCOMMITTED) ON a.backupset = b.id AND (b.status & 0x00008) <> 0
WHERE clientId = @i_entityId AND (subclientStatus & 0x00008) <> 0
 	ELSE
 	BEGIN
 		SELECT
 			@clientId = c.id, @appTypeId = a.appTypeId
 		FROM APP_Application a WITH(READUNCOMMITTED)
 			JOIN APP_Client c WITH(READUNCOMMITTED) ON a.clientId = c.id AND a.id = @i_entityId
 	END
 	----- AgentType END -----------------------------------------------------------------------------------------------------------------
--
--
	----- Get user id BEGIN -------------------------------------------------------------------------------------------------------------
	IF @i_userId = 0
	BEGIN
SET @companyId = ISNULL((SELECT attrVal FROM APP_ClientProp WITH(READUNCOMMITTED) WHERE componentNameId = @clientId AND attrName = 'Installation Company ID' AND modified = 0),0)
		IF @companyId = 0
SET @i_userId = (SELECT TOP 1 id FROM UmUsers WITH(READUNCOMMITTED) WHERE (flags & 0x040) = 0x040)
		ELSE
		BEGIN
			SELECT TOP 1 @i_userId = uu.id
				FROM UMUsers uu WITH(READUNCOMMITTED)
			JOIN UMUserGroup uug WITH(READUNCOMMITTED) ON uug.userId=uu.id
JOIN UMGroups ug WITH(READUNCOMMITTED) ON ug.id=uug.groupId AND (ug.groupFlags & 0x10000) <> 0
			WHERE uu.umDSproviderId = @companyId
		END
	END
	----- Get user id END ---------------------------------------------------------------------------------------------------------------
--
--
 	----- ClientGroup BEGIN -------------------------------------------------------------------------------------------------------------
	INSERT INTO @clientGroups
 			SELECT
 				g.clientGroupId
 			FROM APP_ClientGroupAssoc g WITH(READUNCOMMITTED)
 			WHERE g.clientId = @clientId
 	SET @clientGroupId = NULL
 	SELECT @clientGroupId = COALESCE(@clientGroupId + ',', '') + CAST(clientGroupId AS VARCHAR(1024)) FROM @clientGroups
 	SET @clientGroupId = ISNULL(@clientGroupId, '')
 	----- ClientGroup END ---------------------------------------------------------------------------------------------------------------
--
--
 	----- Region BEGIN ------------------------------------------------------------------------------------------------------------------
	-- get region tagged to the entity or at client level
	SELECT
 		@regionId = IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
 	FROM APP_AdvanceSettings -- No dirty reads
 	WHERE entityId = @i_entityId and entityType = @i_entityType
AND sourceId = 0 /*set on entity directly*/ AND keyName = 'Region Id' AND enabled = 1 AND deleted = 0
--
	IF @regionId = 0 OR @regionId IS NULL
 		SELECT
 			@regionId = IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
 		FROM APP_AdvanceSettings -- No dirty reads
WHERE entityId = @clientId and entityType = 3/*CLIENT_ENTITY*/
AND sourceId = 0 /*set on client directly*/ AND keyName = 'Region Id' AND enabled = 1 AND deleted = 0
--
 	-- IF NOT FOUND THEN GET REGIONS INHERITED FROM CLIENT GROUPS
 	IF @regionId = 0 OR @regionId IS NULL
 	BEGIN
		-- 1. GET FROM GROUPS CURRENTLY ASSOCIATED TO
 		INSERT INTO #regionInfo
 			SELECT
 				r.id
 			FROM APP_AdvanceSettings s -- No dirty reads
 				JOIN @clientGroups g
ON s.entityId = @clientId AND s.entityType = 3 AND s.sourceId = g.clientGroupId AND s.sourceEntityType = 28/*CLIENT_GROUP_ENTITY*/ AND keyName = 'Region Id'
 				JOIN App_Region r WITH(READUNCOMMITTED)
 					ON CAST(value AS NVARCHAR(MAX)) = CAST(r.id AS NVARCHAR(MAX))
 			WHERE s.enabled = 1 AND s.deleted = 0
		-- 2. IF NOT FOUND THEN GET FROM GROUPS PREVIOUSLY PART OF. AMDOCS TR# 210304-201
		IF NOT EXISTS (SELECT 1 FROM #regionInfo)
		BEGIN
			SELECT
 				TOP 1 @regionId = IIF(ISNUMERIC(CONVERT(NVARCHAR(MAX), value)) = 1, CONVERT(INT, CONVERT(NVARCHAR(MAX), value)), 0)
 			FROM APP_AdvanceSettings -- No dirty reads
WHERE entityId = @clientId and entityType = 3/*CLIENT_ENTITY*/ AND keyName = 'Region Id' AND enabled = 1 AND deleted = 0
		END
--
	END
	BEGIN
		-- FILTER ONLY IF PLAN IS NOT CONFIGURED WITH ANY REGIONS
		DECLARE @isPlanRegionConfigured INT = 0
		IF OBJECT_ID('tempdb.dbo.#planRegions') IS NOT NULL
		BEGIN
			IF EXISTS (SELECT 1 FROM #planRegions)
				SET @isPlanRegionConfigured = 1
		END
		-- IF NOT FOUND THEN CALCULATE CLOSEST ONE USING GEO LOCATION
		IF EXISTS (SELECT 1 FROM #regionInfo)
		BEGIN
			SELECT @regionId = regionId FROM #regionInfo
			-- If client region doesn't match with any of the plan region, then ideally,
			--	--	we should recalculate client region with one of the matching plan region (using closet geolocationmatching)
			--	-- else code will not return any storage policy
			IF @isPlanRegionConfigured = 1 AND EXISTS (SELECT 1 FROM #planRegions WHERE regionId = @regionId)
			BEGIN
				SET @reCalculate = 0
			END
			ELSE
			BEGIN
				-- no need to set @reCalculate as it is already 1 in default value
				SET @regionId = 0 /*Just to be safe set it as zero as it will get recalculated later.*/
			END
		END
		IF (@reCalculate=1) AND EXISTS (SELECT 1 FROM APP_ClientProp WITH(READUNCOMMITTED) WHERE attrName = 'Client Geo Location' AND componentNameId = @clientId AND modified = 0)
		BEGIN
			-- GET CLIENT'S GEO LOCATION
 			DECLARE	@cLat		float,
					@cLong		float,
					@cLocation	XML,
					@cCountry	NVARCHAR(255),
					@cState		NVARCHAR(255)
 			SELECT
 				@cLocation = attrVal
 			FROM APP_ClientProp WITH(READUNCOMMITTED)
 			WHERE attrName = 'Client Geo Location' AND componentNameId = @clientId AND modified = 0
 				AND modified = 0
 			SET @cLat =		@cLocation.value('(.//@latitude)[1]', 'float')
 			SET @cLong =	@cLocation.value('(.//@longitude)[1]', 'float')
			SET @cCountry =	@cLocation.value('(.//@country)[1]', 'NVARCHAR(255)')
			SET @cState =	@cLocation.value('(/App_GeoLocation/detailedlocationInfo/state/@name)[1]', 'NVARCHAR(255)')
--
			IF @isPlanRegionConfigured = 0
			BEGIN
 				-- FILTER BY COUTRY AND CONTINENT
				INSERT INTO @clientZones (zoneId, lat, long, country, state)
				SELECT id, latitude, longitude, country, state
					FROM App_Zone WITH(READUNCOMMITTED) WHERE country = @cCountry
--
				IF NOT EXISTS (SELECT 1 FROM @clientZones)
					GOTO PROC_END
--
				-- FILTER BY STATE
				IF EXISTS (SELECT 1 FROM App_Zone WITH(READUNCOMMITTED) WHERE state = @cState AND country = @cCountry)
					DELETE cz
					FROM @clientZones cz
						JOIN App_Zone z ON z.id = cz.zoneId
						WHERE z.state <> @cState
			END
			ELSE
			BEGIN
				-- GET THE ZONES FROM PLAN's REGIONS. NO FILTERING BY COUNTRY OR STATE i.e., CLIENT WILL BE SET TO A CLOSEST REGION BASED ON PLAN STORAGE RULES
				INSERT INTO @clientZones (zoneId, lat, long, country, state)
				SELECT z.id, z.latitude, z.longitude, z.country, z.state
					FROM App_RegionZoneAssoc rz WITH(READUNCOMMITTED)
					JOIN App_Zone z WITH(READUNCOMMITTED) ON z.id = rz.zoneRegionId AND rz.isRegion = 0
					JOIN #planRegions r ON r.regionId = rz.regionId
			END
			-- REMOVE ZONES WHICH ARE NOT PART OF ANY REGION
			DELETE
			FROM @clientZones
				WHERE zoneId NOT IN (SELECT zoneRegionId FROM App_RegionZoneAssoc WITH(READUNCOMMITTED) WHERE isRegion = 0)
			IF NOT EXISTS (SELECT 1 FROM @clientZones)
				GOTO PROC_END
--
			-- CALCULATE CLOSEST REGION BASED ON GEO LOCATION
			UPDATE @clientZones
				SET distance = dbo.APPComputeGeoDistance(@cLat, @cLong, lat, long, default)
--
			-- GET ALL THE REGIONS ON WHICH USER HAS EV_VISIBILITY CAPABILITY
			/* Based on discussion with Bhavyan at present we do not have/need security for Region entity,
				We will add it back when required.
			TRUNCATE TABLE #regionInfo
EXEC sec_getNonIdaObjectsForThisUser @i_UserId, 102, 31, '#regionInfo'
			*/
--
			-- GET THE ID OF THE CLOSEST REGION
				-- FIRST CHECK IF ENTITY'S LOCATION MATCHED WITH PLAN'S DEFINED REGION
				-- #planRegions is created and filled by PlanRuleEvaluateStoragePolicyForEntityV2.sp which contains regionIds associated with the plan.
			IF OBJECT_ID('tempdb.dbo.#planRegions') IS NOT NULL
			BEGIN
				SET @regionId = (SELECT TOP 1 rz.regionId
									FROM APP_RegionZoneAssoc rz WITH(READUNCOMMITTED)
										JOIN @clientZones z ON z.zoneId = rz.zoneRegionId AND rz.isRegion = 0
										JOIN #planRegions r WITH(READUNCOMMITTED) ON r.regionId = rz.regionId
									ORDER BY z.distance ASC
								)
				IF @regionId IS NOT NULL
				BEGIN
					IF EXISTS(select 1 FROM @clientZones where country = @cCountry)
						DELETE cz
						FROM @clientZones cz
							JOIN App_Zone z ON z.id = cz.zoneId
							WHERE z.country <> @cCountry
						SET @regionId		= ISNULL((SELECT TOP 1 rz.regionId
													FROM APP_RegionZoneAssoc rz WITH(READUNCOMMITTED)
													JOIN @clientZones z ON z.zoneId = rz.zoneRegionId AND rz.isRegion = 0
													JOIN #planRegions r WITH(READUNCOMMITTED) ON r.regionId = rz.regionId
													ORDER BY z.distance ASC
													),@regionId)
					IF EXISTS(select 1 FROM @clientZones where state = @cState)
						DELETE cz
						FROM @clientZones cz
							JOIN App_Zone z ON z.id = cz.zoneId
							WHERE z.state <> @cState
						SET @regionId		= ISNULL((SELECT TOP 1 rz.regionId
													FROM APP_RegionZoneAssoc rz WITH(READUNCOMMITTED)
													JOIN @clientZones z ON z.zoneId = rz.zoneRegionId AND rz.isRegion = 0
													JOIN #planRegions r WITH(READUNCOMMITTED) ON r.regionId = rz.regionId
													ORDER BY z.distance ASC
													),@regionId)
				END
			END
				-- IF NOT MATCHED WITH PLAN'S THEN FIND THE CLOSEST MATCHING REGION.
			IF @regionId IS NULL OR @regionId = 0
			BEGIN
 				SET @regionId = (SELECT TOP 1 rz.regionId
									FROM APP_RegionZoneAssoc rz WITH(READUNCOMMITTED)
										--JOIN #regionInfo r ON r.regionId = rz.regionId
										JOIN App_Region r WITH(READUNCOMMITTED) ON r.id = rz.regionId
										JOIN @clientZones z ON z.zoneId = rz.zoneRegionId AND rz.isRegion = 0
									WHERE z.distance = (SELECT MIN(distance) FROM @clientZones)
								)
			END
			-- TAG THE REGION TO THE CLIENT
			-- TODO: Cannot use AppSetAdditionalSettingsForEntity as it returns resultset. Need to create a wrapper SP with a common sp body.
			IF @regionId > 0
			BEGIN
--EXEC AppSetAdditionalSettingsForEntity @clientId, 3, 'Region Id', 'CommServDB.Client', 'INTEGER', @regionId, default, 'Configured by rule evaluator.'
				DECLARE @outTable TABLE (keyId INT, mergeAction NVARCHAR(200))
				INSERT INTO @outTable
					SELECT T.id, T.MergeAction
					FROM
					(
						MERGE APP_AdvanceSettings as addSet
USING (SELECT @clientId as entityID , 3 as entityType ,'Region Id' as keyName,'INTEGER' as type,'CommServDB.Client' as relativePath) S
							ON addSet.entityId = S.entityID AND addSet.entityType = S.entityType AND addSet.KeyName = S.keyName AND addSet.type = S.type AND addSet.relativePath = S.relativePath
							WHEN MATCHED THEN UPDATE SET addSet.value = CAST(@regionId AS NVARCHAR(16))
							WHEN NOT MATCHED THEN
INSERT VALUES(@clientId,'Region Id','INTEGER','CommServDB.Client',CAST(@regionId AS NVARCHAR(16)),1,0,3,0,0)
							OUTPUT $action, inserted.id
					) AS T (mergeAction,id)
				--
				IF EXISTS (SELECT TOP 1 1 FROM @outTable WHERE mergeAction='INSERT')
				BEGIN
					MERGE APP_AdvanceSettingsEx addSetEx
					USING (SELECT keyId FROM @outTable WHERE mergeAction='INSERT') AS temp
					ON temp.keyId = addSetEx.keyId
					WHEN NOT MATCHED THEN INSERT VALUES(temp.keyId,'<App_AdvanceSettingProps comment="Added as part of plan rule evaluation"/>', 1/*hidden*/);
				END
			END
		END
	END
 	----- Region END --------------------------------------------------------------------------------------------------------------------
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode = @@error
	SET @errorMsg = (SELECT ERROR_MESSAGE())
END CATCH
--
--
PROC_END:
SET @regionId = ISNULL(@regionId, 0)
IF @regionId = 0 AND @errorCode = 0
BEGIN
	-- Sad:( REACHING HERE MEANS CLIENT IS NOT TAGGED TO REGION.
SET @errorCode = (3877 | (CAST(POWER(2, 24) AS BIGINT) * 35))/*GUIMSG_CLIENT_REGION_NOT_TAGGED*/
	SET @errorMsg = (SELECT message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = @errorCode AND [localeId] = @i_localeId)
END
----- CREATE RESULT -----------------------------------------------------------------------------------------------------------------
SET @o_xml =
	(Select
 			ISNULL(@appTypeId, 0)		AS '@agentTypeId',
 			ISNULL(@clientGroupId, '')	AS '@groupIds',
 			@regionId					AS '@regionId',
			@errorCode					AS '@errorCode',
			@errorMsg					AS '@errorMessage'
		FOR XML PATH('Values'), TYPE)
----- CREATE RESULT -----------------------------------------------------------------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#regionInfo') IS NOT NULL
	DROP TABLE #regionInfo
GO

IF EXISTS (select * from GxQscripts where name = 'PlanRuleGetFieldsValuesForEntityV2')
	delete from GxQscripts where name = 'PlanRuleGetFieldsValuesForEntityV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRuleGetFieldsValuesForEntityV2')
	delete from GXDBVersions where aliasname = 'PlanRuleGetFieldsValuesForEntityV2'
GO

insert into GXDBVersions values(2, 'PlanRuleGetFieldsValuesForEntityV2',  'v1.1.2.15.4.3', 'PlanRuleGetFieldsValuesForEntityV2', 'v1.1.2.15.4.3')
GO

