

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PlanRuleEvaluateStoragePolicyForEntityV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PlanRuleEvaluateStoragePolicyForEntityV2.sp,v $ $Id: PlanRuleEvaluateStoragePolicyForEntityV2.sp,v 1.1.2.7 2019/05/02 10:16:13 njain Exp $";
--	+===============================================================================+
--	|  			  PlanRuleEvaluateStoragePolicyForEntityV2							|
--	|																				|
--  |  PARAMETERS			  														|
--  |    i_planId	  = id of plan													|
--  |    i_entityId	  = id of client/subclient/backupset/instance					|
--  |    i_entityType = Client -> 3, subclient -> 7, backupset -> 6, instance -> 5	|
--  |    i_userId	  = id of the requestor											|
--  |    i_localeId	  = locale Id													|
--  |    i_retResultSet	  = 1 to return result set. Used to call from Cpp layer		|
--  |  OUTPUTS																		|
--  |	 o_storagePolicyId	  = storage policy Id									|
--	+===============================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PlanRuleEvaluateStoragePolicyForEntityV2')
BEGIN
	print '>>> Drop Stored Procedure: PlanRuleEvaluateStoragePolicyForEntityV2 <<<'
	drop procedure PlanRuleEvaluateStoragePolicyForEntityV2
END
IF EXISTS (select * from GxQscripts where name='PlanRuleEvaluateStoragePolicyForEntityV2')
	delete from GxQscripts where name = 'PlanRuleEvaluateStoragePolicyForEntityV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRuleEvaluateStoragePolicyForEntityV2')
	delete from GXDBVersions where aliasname = 'PlanRuleEvaluateStoragePolicyForEntityV2'
GO
print '... Creating Procedure: PlanRuleEvaluateStoragePolicyForEntityV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PlanRuleEvaluateStoragePolicyForEntityV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_planId INT,
  @i_entityId INT,
  @i_entityType INT,
  @i_userId INT = 0,
  @i_localeId INT = 0,
  @i_retResultSet INT = 0,
  @o_storagePolicyId INT				OUTPUT,
  @o_errorCode INT				OUTPUT,
  @o_errorMsg NVARCHAR(1024)	OUTPUT
-----------------------------------------------------------
AS
-- Variable to return in select statement. This is required as the proc gets called from CPP and SQL layer both.
	--CPP code doesn't understand the OUTPUT variable
  DECLARE @storagePolicyId INT
  DECLARE @errorCode INT = 0
  DECLARE @errorMsg NVARCHAR(MAX) = ''
SET NOCOUNT ON
DECLARE @storageRules	XML
DECLARE @clientId		INT = @i_entityId,
		@isElasticPlan	INT = 0,
		@matchingRuleId	INT = 0
BEGIN TRY
	-- get storage rules for the plan (if exist)
SET @storageRules = dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage Rules', default)
	IF @storageRules.exist('//rules/rule') = 1
		SET @isElasticPlan = 1
	IF @isElasticPlan = 1
	BEGIN
		-- Evaluation will to be done on following rule fields and if all matches the the rule is considered to be a match.
		-- rank property of the rule will be used for tie breaker.
			-- regionIds
			-- agentTypeIds
			-- clientGroupId
--
		-- GET STORAGE RULE DETAILS ---------------------------------------------------------------------------------------------------------------------------------
		DECLARE @ruleIds	TABLE(id INT PRIMARY KEY, rank INT)
		INSERT INTO @ruleIds (id, [rank])
			SELECT
				ref.value('(rule/@ruleId)[1]', 'INT'),
				ISNULL((ref.value('@rank', 'INT')), 0)
			FROM @storageRules.nodes ('Api_PlanRuleMaps/rules') R(ref)
		--
		-- GET REGION IDs FOR THE RULES --------------------------------------------------------------------------------------------------------------------------------
			-- THIS TABLE IS USED BY PlanRuleGetFieldsValuesForEntityV2.sp
		IF OBJECT_ID('tempdb.dbo.#planRegions') IS NOT NULL
			DROP TABLE #planRegions
		CREATE TABLE #planRegions(regionId	INT)
		INSERT INTO #planRegions
			SELECT
				regionIds.value('(/regions/region/@regionId)[1]', 'INT')
			FROM App_PlanRule PR WITH(NOLOCK)
			JOIN @ruleIds R ON R.id = PR.ruleId
--
		-- Get client details --------------------------------------------------------------------------------------------------------------------------------------
		DECLARE @clientRuleValues XML
		EXEC PlanRuleGetFieldsValuesForEntityV2 @i_entityId,  @i_entityType, @i_userId, @i_localeId, @clientRuleValues OUTPUT
		SET @o_errorCode = ISNULL(@clientRuleValues.value('(.//@errorCode)[1]', 'INT'), 0)
		SET @o_errorMsg = ISNULL(@clientRuleValues.value('(.//@errorMessage)[1]', 'NVARCHAR(MAX)'), '')
		IF @o_errorCode <> 0
		BEGIN
IF @o_errorCode = (3877 | (CAST(POWER(2, 24) AS BIGINT) * 35))
				SET @o_errorMsg = REPLACE(@o_errorMsg, '^1%s', ISNULL((SELECT name FROM App_Plan WITH(NOLOCK) WHERE id = @i_planId), ''))
			GOTO PROC_END
		END
--
		-- EVALUATE RULES AND GET THE TOP MATCHING RULE BASED ON RANK -----------------------------------------------------------------------------------------------
		SELECT
			TOP 1 @matchingRuleId = id
		FROM @ruleIds
		WHERE dbo.PlanRuleEvaluateV2(id, @clientRuleValues) = 1 AND [rank] > 0
		ORDER BY [rank] ASC
		-- GET STORAGEPOLICYID FOR THE MATCHING RULE ----------------------------------------------------------------------------------------------------------------
		IF @matchingRuleId > 0
			SET @o_storagePolicyId = ISNULL((SELECT storagePolicyId FROM App_PlanRule WITH(NOLOCK) WHERE ruleId = @matchingRuleId), 0)
		IF @o_storagePolicyId = 0 OR @o_storagePolicyId IS NULL
		BEGIN
SET @o_errorCode = (3878 | (CAST(POWER(2, 24) AS BIGINT) * 35))/*GUIMSG_CLIENT_REGION_STORGERULE_NOT_DEFINED_IN_PLAN*/
			SET @o_errorMsg = (SELECT message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = @o_errorCode AND [localeId] = @i_localeId)
		END
	END
	END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = @@error
	SET @o_errorMsg = (SELECT ERROR_MESSAGE())
END CATCH
--
PROC_END:
-- get plan's default storage policyId ------------------------------------------------------------------------------------------------------------------------------
IF @isElasticPlan = 0
SET @o_storagePolicyId = dbo.AppPlanGetEntityValueV2(@i_planId, 'Storage policy', default)
--
IF (@o_storagePolicyId = 0 OR @o_storagePolicyId IS NULL) AND @o_errorCode = 0
BEGIN
SET @o_errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35))/*GUIMSG_GENERIC_FAILURE*/
	SET @o_errorMsg = (SELECT message FROM EvLocaleMsgs WITH(NOLOCK) WHERE messageId = @o_errorCode AND [localeId] = @i_localeId)
END
--
IF @i_retResultSet = 1
	BEGIN
		SET @storagePolicyId = @o_storagePolicyId
		SET @errorCode = @o_errorCode
		SET @errorMsg = @o_errorMsg
		SELECT @storagePolicyId AS storagePolicyId, @errorCode AS errorCode, @errorMsg AS errorMsg
	END
IF OBJECT_ID('tempdb.dbo.#planRegions') IS NOT NULL
		DROP TABLE #planRegions
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PlanRuleEvaluateStoragePolicyForEntityV2')
	delete from GxQscripts where name = 'PlanRuleEvaluateStoragePolicyForEntityV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRuleEvaluateStoragePolicyForEntityV2')
	delete from GXDBVersions where aliasname = 'PlanRuleEvaluateStoragePolicyForEntityV2'
GO

insert into GXDBVersions values(2, 'PlanRuleEvaluateStoragePolicyForEntityV2',  '00010001000200070000', 'PlanRuleEvaluateStoragePolicyForEntityV2', '00010001000200070000')
GO

