

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PlanRuleCreateUpdateV2.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PlanRuleCreateUpdateV2.sp,v $ $Id: PlanRuleCreateUpdateV2.sp,v 1.1.2.10 2020/10/09 16:23:05 rengu Exp $";
--	+===================================================================+
--	|  					  PlanRuleCreateUpdateV2						|
--	|																	|
--  |  PARAMETERS                                                       |
--  |    inUserId     = id of the creator                               |
--  |    inLocaleId   = Locale id					                    |
--  |    inXml		  = Api_CreateUpdatePlanRuleReq object xml		    |
--  |  OUTPUTS                                                          |
--  |       returns planRuleId and App_GenericResp in input				|
--	|				param for errors (if any)							|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PlanRuleCreateUpdateV2')
BEGIN
	print '>>> Drop Stored Procedure: PlanRuleCreateUpdateV2 <<<'
	drop procedure PlanRuleCreateUpdateV2
END
IF EXISTS (select * from GxQscripts where name='PlanRuleCreateUpdateV2')
	delete from GxQscripts where name = 'PlanRuleCreateUpdateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRuleCreateUpdateV2')
	delete from GXDBVersions where aliasname = 'PlanRuleCreateUpdateV2'
GO
print '... Creating Procedure: PlanRuleCreateUpdateV2'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PlanRuleCreateUpdateV2
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inUserId INT,
  @inLocaleId INT,
  @inXml XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode			INT = 0,
			@errorString		NVARCHAR(MAX) = 'Rule creation successful.',
			@inPlanId			INT,
			@nowTime			INT = dbo.GetUnixTime (GetUTCdate()),
			@ruleName			nvarchar(255),
			@summary			nvarchar(2048),
			@regionIds			xml,
			@agentTypeIds		xml,
			@clientGroupId		integer,
			@planIdList			xml,
			@storagePolicyId	integer,
			@storagePoolId		integer,
			@retentionPeriod	varchar(128),
			@flag				integer,
			@rank				integer,
			@extendedRule		xml,
			@isFound			INT = 0,
			@backupCopyTaskId	INT = 0
	DECLARE @cRegionTbl			TABLE (regionId INT, regionName NVARCHAR(255), displayName NVARCHAR(255))
	DECLARE @cAgentTbl			TABLE (applicationid INT, name NVARCHAR(1024), isGroup INT)
	-- return value
	DECLARE @rv_planRuleId		INT = 0
--
	BEGIN TRY
		-- QUERY PLAN RULE DEFINTION VALUES -- ------------------------------------------------------------------------------------------------------
		SELECT
			@ruleName =			ISNULL((ref.value('(rule/@ruleName)[1]', 'nvarchar(255)')), ''),
			@rv_planRuleId =	ISNULL((ref.value('(rule/@ruleId)[1]', 'int')), 0),
			@regionIds =		(ref.query('regions')),
			@agentTypeIds =		'<agents applicationId="0" appName="ANY" />',--(ref.query('agents')),--ISNULL(ref.value('(agentType/@applicationId)[1]', 'int'), 0 /*DEFAULT ALL*/),
			@clientGroupId =	0, --ISNULL(ref.value('(clientGroup/@clientGroupId)[1]', 'int'), 0 /*DEFAULT ANY*/),
			@storagePolicyId =	ISNULL(ref.value('(storage/storagePolicy/@storagePolicyId)[1]', 'int'), 0),
			@storagePoolId =	ISNULL(ref.value('(storage/copy/useGlobalPolicy/@storagePolicyId)[1]', 'int'), 0),
			@retentionPeriod =	ISNULL(ref.value('@retentionDays', 'varchar(128)'), '90'),
			@flag =				0 /*flag*/,
			@extendedRule =		ISNULL((ref.query('extendedRules')), ''),
			@rank =				ISNULL(ref.value('@rank', 'int'), 0)
		FROM
		@inXml.nodes('/Api_CreateUpdatePlanRuleReq/ruleInfo') doc(ref)
		-- get planId
		SELECT @inPlanId = ISNULL(ref.value('@planId', 'int'), @inPlanId)
		FROM
		@inXml.nodes('/Api_CreateUpdatePlanRuleReq/plan') doc(ref)
--
		-- get retention
	    SELECT
	        @retentionPeriod = ar.retentionDays
	    FROM archgroup ag WITH(NOLOCK)
	        JOIN archAgingRule ar WITH(NOLOCK) ON ar.copyId = ag.defaultCopy
	    WHERE ag.id = @storagePolicyId
		-- insert regions and agents in temp table variable
		INSERT INTO @cRegionTbl
			SELECT
				ISNULL(rg.id, 0), ISNULL(rg.name, 'ANY'), ISNULL(rg.displayName, 'ANY')
			FROM @regionIds.nodes('//region') R(ref)
				LEFT OUTER JOIN App_Region rg WITH(READUNCOMMITTED) ON rg.id = ref.value('@regionId', 'INT')
--
		INSERT INTO @cAgentTbl
			SELECT
				a.type, a.name, 0 /*isGroup*/
			FROM @agentTypeIds.nodes('//agent') R(ref)
				JOIN APP_iDAType a WITH(READUNCOMMITTED) ON a.type = ref.value('@applicationId', 'INT')
			UNION
			SELECT
				g.appTypeGroupId, g.groupName, 1 /*isGroup*/
			FROM @agentTypeIds.nodes('//agentGroup') R(ref)
				JOIN APP_AppTypeGroupAssoc ag WITH(READUNCOMMITTED) ON ag.appGroupId = ref.value('@appGroupId', 'INT')
				JOIN APP_AppTypeGroup g WITH(READUNCOMMITTED) ON g.appTypeGroupId = ag.appGroupId
		-- -- ---------------------------------------------------------------------------------------------------------------------------------------
--
--
		-- VALIDATION -- ----------------------------------------------------------------------------------------------------------------------------
		IF @regionIds.exist('regions') = 0
			SET @regionIds = '<regions regionId="0" regionName="ANY" displayName="ANY"/>'
		IF @agentTypeIds.exist('agents') = 0
			SET @agentTypeIds = '<agents applicationId="0" appName="ANY" />'
--
		-- VALIDATION FOR STORAGE POLICY
		IF (@storagePolicyId = 0)
		BEGIN
SET @errorCode = (1987 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_INCORRECT_STORAGE_POLICY*/
			SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @inLocaleId)
			;THROW @errorCode, @errorString, 1
		END
		-- -- ---------------------------------------------------------------------------------------------------------------------------------------
--
--
		-- FORMULATE FIELD VALUES -- ----------------------------------------------------------------------------------------------------------------
		-- Create planIds xml
		SET @planIdList = '<Api_planList><plan planId="' + CAST(@inPlanId as varchar(10)) + '"/></Api_planList>'
--
		-- SET GENERIC NAME AS SUMMARY FOR THE RULE
		IF @ruleName = ''
			SET @ruleName = 'Plan:' + (SELECT ISNULL(name, '') FROM App_Plan WITH(NOLOCK) WHERE id = @inPlanId) + '_Retention:' +
				CAST(@retentionPeriod AS varchar(6)) + '_SP:' + CAST(@storagePolicyId AS varchar(6))
--
		-- Re-Create regionIds and agentTypeIds xml from the table variables
			-- This will make sure that the xml being saved in the DB has correct data. User can send duplicate/invalid items.
		IF EXISTS (SELECT 1 FROM @cRegionTbl)
			SET @regionIds = (SELECT
								regionId AS '@regionId',
								regionName AS '@regionName',
								displayName AS '@displayName'
							 FROM @cRegionTbl
							 FOR XML PATH('region'), ROOT('regions'))
		IF EXISTS (SELECT 1 FROM @cAgentTbl)
			SET @agentTypeIds = (SELECT
									(CASE WHEN isGroup = 0 THEN
										(select applicationid AS '@applicationid',
												name AS '@appName'
										 FOR XML PATH('agent'), TYPE)
									ELSE
										(select applicationid AS '@appGroupId',
												name AS '@appGroupName'
										 FOR XML PATH('agentGroup'), TYPE)
									END)
								FROM @cAgentTbl
								FOR XML PATH(''), ROOT('agents'))
--
		-- CREATE SUMMARY
		DECLARE @regionStr	NVARCHAR(MAX) = NULL,
				@agentStr	NVARCHAR(MAX) = NULL,
				@agentGrpStr NVARCHAR(MAX) = NULL,
				@msgId		INT = 0
SET @msgId = (3798 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		SET @summary = ISNULL((select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = @msgId AND [localeId] = @inLocaleId),
			'Clients matching Region [^1%s], AgentType [^2%s] and ClientGroups [^3%s] will be backed up on storage pool [^4%s] for [^5%s] days')
--
		SELECT
			@regionStr = COALESCE(@regionStr + ',', '') + regionName
		FROM @cRegionTbl
--
		SELECT
			@agentStr = COALESCE(@agentStr + ',', '') + name
		FROM @cAgentTbl
--
		SET @summary = REPLACE(REPLACE(REPLACE(@summary, '^1%s', ISNULL(@regionStr, 'Any')), '^2%s', ISNULL(@agentStr, 'Any')), '^3%s',
			(ISNULL((SELECT name FROM APP_ClientGroup WITH(NOLOCK) WHERE id = @clientGroupId), 'Any')))
		SET @summary = REPLACE(@summary, '^4%s', ISNULL((SELECT name FROM archgroup WITH(NOLOCK) WHERE id = @storagePoolId), ''))
		SET @summary = REPLACE(@summary, '^5%s', @retentionPeriod)
		-- -- ---------------------------------------------------------------------------------------------------------------------------------------
--
		IF @rv_planRuleId = 0 /*New rule*/
		BEGIN
			-- check for duplicate rule. rule is considered dupe if all of the below fields are same
			-- storagePoolId, agentTypeIds, clientGroupId, regionIds
			IF (EXISTS (SELECT 1 FROM App_PlanRule WITH(NOLOCK))) /*check only if rules already present*/
				AND EXISTS
				(
					SELECT
						ER.regionId, EA.agentTypeId, EAG.agentGroupId
					FROM App_PlanRule as PR
						OUTER APPLY (
										SELECT N.region.value('@regionId', 'int') as regionId
											FROM @regionIds.nodes('//region') N(region)
										EXCEPT
										SELECT E.region.value('@regionId', 'int') as regionId
											FROM PR.regionIds.nodes('//region') as E(region)
									) as ER
						OUTER APPLY (
										SELECT N.agent.value('@applicationId', 'int') as agentTypeId
											FROM @agentTypeIds.nodes('//agent') N(agent)
										EXCEPT
										SELECT E.agent.value('@applicationId', 'int') as agentTypeId
											FROM PR.agentTypeIds.nodes('//agent') as E(agent)
						) as EA
						OUTER APPLY (
										SELECT N.agent.value('@appGroupId', 'int') as agentGroupId
											FROM @agentTypeIds.nodes('//agentGroup') N(agent)
										EXCEPT
										SELECT E.agent.value('@appGroupId', 'int') as agentGroupId
											FROM PR.agentTypeIds.nodes('//agentGroup') as E(agent)
						) as EAG
					WHERE PR.storagePoolId = @storagePoolId AND PR.clientGroupId = @clientGroupId AND ER.regionId IS NULL
					AND EA.agentTypeId IS NULL AND EAG.agentGroupId IS NULL AND planIds.exist('//./plan[@planId=sql:variable("@inPlanId")]') = 1
				) /*means existing rule found*/
				SET @isFound = 1
--
			IF (EXISTS (SELECT 1 FROM App_PlanRule WITH(NOLOCK) WHERE storagePolicyId = @storagePolicyId)) OR @isFound = 1
			BEGIN
SET @errorCode = (3772 | (CAST(POWER(2, 24) AS BIGINT) * 35)) /*GUIMSG_PLANRULE_DUPLICATE_FOUND*/
				SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @inLocaleId)
				SET @errorString = REPLACE(@errorString, '^1%s', @storagePolicyId)
				;THROW @errorCode, @errorString, 1
			END
--
			-- INSERT PLANRULE
			BEGIN TRAN
			INSERT INTO App_PlanRule (ruleName, summary, regionIds, agentTypeIds, clientGroupId, planIds, storagePolicyId, storagePoolId, RetentionPeriod, flag, created, modified, extendedRule)
			VALUES					 (@ruleName, @summary, @regionIds, @agentTypeIds, @clientGroupId, @planIdList, @storagePolicyId, @storagePoolId, @retentionPeriod, @flag, @nowTime, 0, @extendedRule)
			SET @rv_planRuleId = SCOPE_IDENTITY()
--
			-- INSERT Association to backup copy schedule.
SET @backupCopyTaskId = ISNULL(dbo.AppPlanGetEntityValueV2(@inPlanId, 'Backup copy schedule policy', 2),0)
IF NOT EXISTS(SELECT 1 FROM TM_AssocEntity WITH(NOLOCK) WHERE taskId = @backupCopyTaskId AND policyId = @storagePolicyId AND assocType=17)
			AND @backupCopyTaskId > 0
				EXEC TM_AddEntityToTask 0, 0, 0, 0, 0, 0, @storagePolicyId, 0, @backupCopyTaskId, 0
			IF @rv_planRuleId = 0
			BEGIN
				SET @errorCode = 1
				SET @errorString = 'Insert to App_PlanRule table failed.'
				;THROW @errorCode, @errorString, 1
			END
		END
		ELSE
		BEGIN
			-- CHECK IF ANY CHANGES ARE PRESENT IN THE REGIONS OR AGENTS
			IF EXISTS (
					SELECT
						ER.regionId, EA.agentTypeId, EAG.agentGroupId
					FROM App_PlanRule as PR
						OUTER APPLY (
										SELECT N.region.value('@regionId', 'int') as regionId
											FROM @regionIds.nodes('//region') N(region)
										EXCEPT
										SELECT E.region.value('@regionId', 'int') as regionId
											FROM PR.regionIds.nodes('//region') as E(region)
									) as ER
						OUTER APPLY (
										SELECT N.agent.value('@applicationId', 'int') as agentTypeId
											FROM @agentTypeIds.nodes('//agent') N(agent)
										EXCEPT
										SELECT E.agent.value('@applicationId', 'int') as agentTypeId
											FROM PR.agentTypeIds.nodes('//agent') as E(agent)
									) as EA
						OUTER APPLY (
										SELECT N.agent.value('@appGroupId', 'int') as agentGroupId
											FROM @agentTypeIds.nodes('//agentGroup') N(agent)
										EXCEPT
										SELECT E.agent.value('@appGroupId', 'int') as agentGroupId
											FROM PR.agentTypeIds.nodes('//agentGroup') as E(agent)
						) as EAG
					WHERE ruleId = @rv_planRuleId AND ER.regionId IS NULL AND EA.agentTypeId IS NULL AND EAG.agentGroupId IS NULL
				) /*Means no changes*/
				SET @isFound = 1
--
			-- ADD planId IN THE LIST IF NOT PRESENT
			SELECT @planIdList = ISNULL(planIds, @planIdList) FROM App_PlanRule WHERE ruleId = @rv_planRuleId
--
			DECLARE @xPath varchar(100) = '//./plan[@planId=' + CAST(@inPlanId as varchar(10)) + ']'
			IF @planIdList.exist('sql:variable("@xPath")') <> 1
			BEGIN
				SET @planIdList.modify('insert <plan planId=""/> as first into (/Api_planList)[1]')
				SET @planIdList.modify('replace value of (/Api_planList/plan/@planId)[1] with sql:variable("@inPlanId")')
			END
--
			-- UPDATE THE PlanRule IN App_PlanRule table.
			UPDATE App_PlanRule
			SET agentTypeIds = @agentTypeIds, clientGroupId = @clientGroupId, planIds = @planIdList, modified = @nowTime, flag = @flag, extendedRule = @extendedRule,
			regionIds = ISNULL(@regionIds, regionIds), RetentionPeriod = @retentionPeriod, ruleName = ISNULL(@ruleName, ruleName), summary = @summary
			WHERE ruleId = @rv_planRuleId
			AND (
					(ruleName <> @ruleName AND @ruleName <> '')
				 OR	(clientGroupId <> @clientGroupId)
				 OR (planIds.exist('sql:variable("@xPath")') = 0)
				 OR (flag <> @flag)
				 OR (RetentionPeriod <> @retentionPeriod)
				 OR (@isFound = 0 /*change in field value, so need to update*/)
				)
--
			IF @@ERROR <> 0
			BEGIN
				SET @errorCode = @@ERROR
				SET @errorString = 'Update to App_PlanRule table failed.'
				;THROW @errorCode, @errorString, 1
			END
		END
--
	END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	IF @errorCode = 0
		SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
		SET @rv_planRuleId = 0
END CATCH
--
IF @errorCode <> 0
BEGIN
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRAN
	END
	IF @errorString = ''
	BEGIN
		SET @errorCode = (1287 | (CAST(POWER(2, 24) AS BIGINT) * 35)) --TODO
		SET @errorString = dbo.fn_EvFormatEventMsgText(0, @inLocaleId, @errorCode, 0, 2)
	END
END
ELSE IF XACT_STATE() = 1
	COMMIT TRAN
SET @inXml = (SELECT
				@errorCode AS '@errorCode',
				@errorString AS '@errorMessage'
			FOR XML PATH('App_GenericResp'), TYPE)
--
SELECT @inXml AS inXml
RETURN @rv_planRuleId;
END
--
SET NOCOUNT OFF
--
GO

IF EXISTS (select * from GxQscripts where name = 'PlanRuleCreateUpdateV2')
	delete from GxQscripts where name = 'PlanRuleCreateUpdateV2'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PlanRuleCreateUpdateV2')
	delete from GXDBVersions where aliasname = 'PlanRuleCreateUpdateV2'
GO

insert into GXDBVersions values(2, 'PlanRuleCreateUpdateV2',  '00010001000200100000', 'PlanRuleCreateUpdateV2', '00010001000200100000')
GO

