

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PerformanceModeMA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PerformanceModeMA.sp,v $ $Id: PerformanceModeMA.sp,v 1.1.2.6 2018/06/29 02:55:21 vdevassy Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PerformanceModeMA <<<'

IF EXISTS (select * from sysobjects where name='PerformanceModeMA')
	drop procedure PerformanceModeMA
IF EXISTS (select * from GxQscripts where name='PerformanceModeMA')
	delete from GxQscripts where name = 'PerformanceModeMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PerformanceModeMA')
	delete from GXDBVersions where aliasname = 'PerformanceModeMA'
GO
print '... Creating Procedure: PerformanceModeMA'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure PerformanceModeMA
-- Network CRC (0/1)
-- Media CRC (0/1)
  @i_copyId integer,
  @i_clientId integer,
  @i_CRCOverNetworkEnable integer,			
  @i_CRCOverMediaEnable integer,
  @i_pipelineBufferSize int,		
  @i_numPipeline integer,
  @i_lookAheadReaderSlots integer	
AS
  DECLARE @o_errorMsg NVARCHAR(MAX) = ''
  DECLARE @o_errorCode INT = 0
--Old values
  DECLARE @o_CRCOverNetworkEnable INT = -1
  DECLARE @o_CRCOverMediaEnable INT = -1
  DECLARE @o_clientName NVARCHAR(MAX)
  DECLARE @o_pipelineBufferSize int = -1
  DECLARE @o_numPipeline INT = -1
  DECLARE @o_lookAheadReaderSlots INT = -1
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION;
-- local variables
DECLARE @l_attribute		INT = 0
BEGIN TRY
	SELECT	@o_clientName = A.name
	FROM	APP_Client A WITH(READUNCOMMITTED)
	JOIN	MMDataPath M WITH(READUNCOMMITTED) ON M.CopyId = @i_copyId AND A.id = M.HostClientId AND A.id = @i_clientId
	IF @o_clientName IS NOT NULL
	BEGIN
		SELECT @l_attribute = Attribute FROM MMHost WITH(READUNCOMMITTED) WHERE	ClientId =	@i_clientId
SET @o_CRCOverNetworkEnable = CASE WHEN (@l_attribute & 256 = 256) THEN 1 ELSE 0 END
SET @o_CRCOverMediaEnable = CASE WHEN (@l_attribute & 512 = 512) THEN 1 ELSE 0 END
		--Network CRC
		IF(@o_CRCOverNetworkEnable <> @i_CRCOverNetworkEnable AND @i_CRCOverNetworkEnable IN (0,1))
		BEGIN
			UPDATE	MMHost
SET		Attribute = CASE @i_CRCOverNetworkEnable WHEN 0 THEN (Attribute&~(Attribute & 256))
ELSE (Attribute | 256) END
			WHERE	ClientId =	@i_clientId
		END
		--Media CRC
		IF(@o_CRCOverMediaEnable <> @i_CRCOverMediaEnable AND @i_CRCOverMediaEnable IN (0,1))
		BEGIN
			UPDATE	MMHost
SET		Attribute = CASE @i_CRCOverMediaEnable WHEN 0 THEN (Attribute&~(Attribute & 512))
ELSE (Attribute | 512) END
					WHERE	ClientId =	@i_clientId
		END
		--Number of Pipeline Buffers
IF(@i_numPipeline >= 30 AND @i_numPipeline <= 1024)
		BEGIN
SELECT 	@o_numPipeline = (CASE ISNULL(enabled,0) WHEN 0 THEN 90 ELSE CONVERT(int, CONVERT(VARCHAR(5), ISNULL(value,'0'))) END) FROM APP_AdvanceSettings WITH(READUNCOMMITTED)
WHERE 	keyname = 'nNumPipelineBuffers'
			AND 	entityId = @i_clientId
AND 	entityType = 3
AND 	relativePath = 'Cvd'
			AND		deleted = 0
			IF @@ROWCOUNT = 0
			BEGIN
				--Only add if non default value
SET @o_numPipeline = 90
				IF @i_numPipeline <> @o_numPipeline
					INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@i_clientId, 'nNumPipelineBuffers', N'INTEGER', 'Cvd', CONVERT(varchar(10), @i_numPipeline), 1, 0, 3, 0, 0)
			END
			ELSE
			IF @o_numPipeline <> @i_numPipeline
			BEGIN
UPDATE APP_AdvanceSettings SET value = CONVERT(varchar(10), @i_numPipeline), enabled = (CASE @i_numPipeline WHEN 90 THEN 0 ELSE 1 END)
WHERE keyname = 'nNumPipelineBuffers' AND entityId = @i_clientId AND entityType = 3 AND relativePath = 'Cvd'
			END
		END
		--Pipeline Buffer Size
IF(@i_pipelineBufferSize >= ((64*1024)/1024) AND @i_pipelineBufferSize <= ((256*1024)/1024))
		BEGIN
SELECT 	@o_pipelineBufferSize = (CASE ISNULL(enabled,0) WHEN 0 THEN ((64*1024)/1024) ELSE CONVERT(int, CONVERT(VARCHAR(5), ISNULL(value,'0'))) END) FROM APP_AdvanceSettings WITH(READUNCOMMITTED)
WHERE 	keyname = 'nPipelineBufferSize'
			AND 	entityId = @i_clientId
AND 	entityType = 3
AND 	relativePath = 'Cvd'
			AND		deleted = 0
			IF @@ROWCOUNT = 0
			BEGIN
				--Only add if non default value
SET @o_pipelineBufferSize = ((64*1024)/1024)
				IF @i_pipelineBufferSize <> @o_pipelineBufferSize
					INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@i_clientId, 'nPipelineBufferSize', N'INTEGER', 'Cvd', CONVERT(varchar(10), @i_pipelineBufferSize*1024), 1, 0, 3, 0, 0)
			END
			ELSE
			IF @o_pipelineBufferSize <> @i_pipelineBufferSize
			BEGIN
UPDATE APP_AdvanceSettings SET value = CONVERT(varchar(10), @i_pipelineBufferSize*1024), enabled = (CASE @i_pipelineBufferSize WHEN ((64*1024)/1024) THEN 0 ELSE 1 END)
WHERE keyname = 'nPipelineBufferSize' AND entityId = @i_clientId AND entityType = 3 AND relativePath = 'Cvd'
			END
		END
		--DatamoverLookaheadreaderslots
IF(@i_lookAheadReaderSlots >= 1 AND @i_lookAheadReaderSlots <= 256)
		BEGIN
SELECT 	@o_lookAheadReaderSlots = (CASE ISNULL(enabled,0) WHEN 0 THEN 4 ELSE CONVERT(int, CONVERT(VARCHAR(5), ISNULL(value,'0'))) END) FROM APP_AdvanceSettings WITH(READUNCOMMITTED)
WHERE 	keyname = 'DataMoverLookAheadLinkReaderSlots'
			AND 	entityId = @i_clientId
AND 	entityType = 3
AND 	relativePath = 'MediaAgent'
			AND		deleted = 0
			IF @@ROWCOUNT = 0
			BEGIN
SET @o_lookAheadReaderSlots = 4
				IF @i_lookAheadReaderSlots <> @o_lookAheadReaderSlots
				INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@i_clientId, 'DataMoverLookAheadLinkReaderSlots', N'INTEGER', 'MediaAgent', CONVERT(varchar(10), @i_lookAheadReaderSlots), 1, 0, 3, 0, 0)
			END
			ELSE
			IF @o_lookAheadReaderSlots <> @i_lookAheadReaderSlots
			BEGIN
UPDATE APP_AdvanceSettings SET value = CONVERT(varchar(10), @i_lookAheadReaderSlots), enabled = (CASE @i_lookAheadReaderSlots WHEN 4 THEN 0 ELSE 1 END)
WHERE keyname = 'DataMoverLookAheadLinkReaderSlots' AND entityId = @i_clientId AND entityType = 3 AND relativePath = 'MediaAgent'
			END
		END
	END
	ELSE
		SET @o_clientName = ''
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode=ERROR_NUMBER()
	SET @o_errorMsg=ERROR_MESSAGE()
END CATCH
PERF_EXIT:
IF @o_errorCode <> 0
BEGIN
	ROLLBACK TRANSACTION
END
ELSE
BEGIN
	COMMIT TRANSACTION
END
	SELECT 	@o_errorMsg AS errorMsg,
			@o_errorCode AS errorCode,
			@o_CRCOverNetworkEnable AS CRCOverNetworkEnable,
			@o_CRCOverMediaEnable AS CRCOverMediaEnable,
			@o_clientName AS clientName,
			@o_pipelineBufferSize AS pipelineBufferSize,
			@o_numPipeline as numPipeline,
			@o_lookAheadReaderSlots AS lookAheadReaderSlots;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'PerformanceModeMA')
	delete from GxQscripts where name = 'PerformanceModeMA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PerformanceModeMA')
	delete from GXDBVersions where aliasname = 'PerformanceModeMA'
GO

insert into GXDBVersions values(2, 'PerformanceModeMA',  '00010001000200060000', 'PerformanceModeMA', '00010001000200060000')
GO

