

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PerformanceMode.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PerformanceMode.sp,v $ $Id: PerformanceMode.sp,v 1.1.2.7 2018/06/29 02:55:06 vdevassy Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PerformanceMode <<<'

IF EXISTS (select * from sysobjects where name='PerformanceMode')
	drop procedure PerformanceMode
IF EXISTS (select * from GxQscripts where name='PerformanceMode')
	delete from GxQscripts where name = 'PerformanceMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PerformanceMode')
	delete from GXDBVersions where aliasname = 'PerformanceMode'
GO
print '... Creating Procedure: PerformanceMode'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure PerformanceMode
-- Note: -1 on fields used to ignore value
-- MT Scan Threads (0/100)
-- Number of Pipeline buffers (30-1024)
-- Data Mover Use Look Ahead Link Reader (0/1)
  @i_subClientId integer,
  @i_maxMultiplex integer,			
  @i_useDeviceStreams integer,			
  @i_numPipeline integer,
  @i_pipelineBufferSize int
AS
  DECLARE @o_errorMsg NVARCHAR(MAX) = ''
  DECLARE @o_errorCode INT = 0
--old values
  DECLARE @o_maxMultiplex INT = -1
  DECLARE @o_useDeviceStreams INT = -1
  DECLARE @o_spName NVARCHAR(MAX) = ''
  DECLARE @o_copyName NVARCHAR(MAX) = ''
  DECLARE @o_copyId INT = -1
  DECLARE @o_clientId INT = -1
  DECLARE @o_numPipeline INT = -1
  DECLARE @o_pipelineBufferSize int = -1
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
BEGIN TRANSACTION;
-- local variables
DECLARE @l_copyFlag		INT = 0
BEGIN TRY
	SELECT 	@o_clientId = ISNULL(APP.clientId,-1), @o_copyId = ISNULL(AG.defaultCopy,''), @o_spName = ISNULL(AG.name,''), @o_copyName = AGC.name, @o_maxMultiplex = AGC.maxMultiplex,
@o_useDeviceStreams = (CASE WHEN (AGC.flags & 268435456 = 268435456) THEN 1 ELSE 0 END)
	FROM	APP_Application APP WITH(READUNCOMMITTED) JOIN 	archGroup AG WITH(READUNCOMMITTED) ON AG.id = APP.dataArchGrpId JOIN archGroupCopy AGC WITH(READUNCOMMITTED) ON AGC.id = AG.defaultCopy
	WHERE 	APP.id = @i_subClientId
	IF @o_copyId > 0
	BEGIN
		SELECT @l_copyFlag = flags FROM archGroupCopy WITH(READUNCOMMITTED) WHERE id = @o_copyId AND dedupeFlags = 0
		--Multiplexing Factor on nonDedup Copies (0 = disabled / 1 = enabled)
		IF @i_maxMultiplex >= 0 AND @i_maxMultiplex <> @o_maxMultiplex
		BEGIN
			UPDATE	archGroupCopy
			SET		maxMultiplex = @i_maxMultiplex
			WHERE	id = @o_copyId AND dedupeFlags = 0
		END
		--Use Device Streams Checkbox can be (0 = false / 1 = true)
		IF @i_useDeviceStreams >= 0 AND @l_copyFlag > 0 AND @i_useDeviceStreams <> @o_useDeviceStreams
		BEGIN
			UPDATE archGroupCopy
			SET flags =	 (CASE WHEN @i_useDeviceStreams = 0
THEN ((@l_copyFlag&~(@l_copyFlag & 268435456)))
ELSE (@l_copyFlag | 268435456) END)
			WHERE	id = @o_copyId AND dedupeFlags = 0
		END
	END
	IF @o_clientId > 0
	BEGIN
IF(@i_numPipeline >= 30 AND @i_numPipeline <= 1024)
		BEGIN
SELECT 	@o_numPipeline = (CASE ISNULL(enabled,0) WHEN 0 THEN 90 ELSE CONVERT(int, CONVERT(VARCHAR(5), ISNULL(value,'0'))) END) FROM APP_AdvanceSettings WITH(READUNCOMMITTED)
WHERE 	keyname = 'nNumPipelineBuffers'
			AND 	entityId = @o_clientId
AND 	entityType = 3
AND 	relativePath = 'Cvd'
			AND		deleted = 0
			IF @@ROWCOUNT = 0
			BEGIN
				--Only add if non default value
SET @o_numPipeline = 90
				IF @i_numPipeline <> @o_numPipeline
					INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@o_clientId, 'nNumPipelineBuffers', N'INTEGER', 'Cvd', CONVERT(varchar(10), @i_numPipeline), 1, 0, 3, 0, 0)
			END
			ELSE
			IF @o_numPipeline <> @i_numPipeline
			BEGIN
UPDATE APP_AdvanceSettings SET value = CONVERT(varchar(10), @i_numPipeline), enabled = (CASE @i_numPipeline WHEN 90 THEN 0 ELSE 1 END)
WHERE keyname = 'nNumPipelineBuffers' AND entityId = @o_clientId AND entityType = 3 AND relativePath = 'Cvd'
			END
		END
IF(@i_pipelineBufferSize >= ((64*1024)/1024) AND @i_pipelineBufferSize <= ((256*1024)/1024))
		BEGIN
SELECT 	@o_pipelineBufferSize = (CASE ISNULL(enabled,0) WHEN 0 THEN ((64*1024)/1024) ELSE CONVERT(int, CONVERT(VARCHAR(5), ISNULL(value,'0'))) END) FROM APP_AdvanceSettings WITH(READUNCOMMITTED)
WHERE 	keyname = 'nPipelineBufferSize'
			AND 	entityId = @o_clientId
AND 	entityType = 3
AND 	relativePath = 'Cvd'
			AND		deleted = 0
			IF @@ROWCOUNT = 0
			BEGIN
				--Only add if non default value
SET @o_pipelineBufferSize = ((64*1024)/1024)
				IF @i_pipelineBufferSize <> @o_pipelineBufferSize
					INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
VALUES(@o_clientId, 'nPipelineBufferSize', N'INTEGER', 'Cvd', CONVERT(varchar(10), @i_pipelineBufferSize*1024), 1, 0, 3, 0, 0)
			END
			ELSE
			IF @o_pipelineBufferSize <> @i_pipelineBufferSize
			BEGIN
UPDATE APP_AdvanceSettings SET value = CONVERT(varchar(10), @i_pipelineBufferSize*1024), enabled = (CASE @i_pipelineBufferSize WHEN ((64*1024)/1024) THEN 0 ELSE 1 END)
WHERE keyname = 'nPipelineBufferSize' AND entityId = @o_clientId AND entityType = 3 AND relativePath = 'Cvd'
			END
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode=ERROR_NUMBER()
	SET @o_errorMsg=ERROR_MESSAGE()
END CATCH
PERF_EXIT:
IF @o_errorCode <> 0
BEGIN
	ROLLBACK TRANSACTION
END
ELSE
BEGIN
	COMMIT TRANSACTION
END
	SELECT 	@o_errorMsg AS errorMsg,
			@o_errorCode AS errorCode,
			@o_maxMultiplex AS maxMultiplex,
			@o_useDeviceStreams AS useDeviceStreams,
			@o_spName AS spName,
			@o_copyName	AS copyName,
			@o_copyId AS copyId,
			@o_clientId AS clientId,
			@o_numPipeline AS numPipeline,
			@o_pipelineBufferSize AS pipelineBufferSize;
SET NOCOUNT OFF;
GO

IF EXISTS (select * from GxQscripts where name = 'PerformanceMode')
	delete from GxQscripts where name = 'PerformanceMode'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PerformanceMode')
	delete from GXDBVersions where aliasname = 'PerformanceMode'
GO

insert into GXDBVersions values(2, 'PerformanceMode',  '00010001000200070000', 'PerformanceMode', '00010001000200070000')
GO

