

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchVerifySource.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchVerifySource.sp,v $ $Id: PatchVerifySource.sp,v 1.1.4.3 2020/04/08 17:41:13 rpolimera Exp $";
--  +========================================================================+
--  | Stored Proc: PatchVerifySource()
--  |
--  | Description: Given source client name and destination client name.
--	|			   Return if the source client is a Remote Cache and installation
--	|			   directory of destination client.
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PatchVerifySource')
BEGIN
	print '>>> Drop Stored Procedure: PatchVerifySource <<<'
	drop procedure PatchVerifySource
END
IF EXISTS (select * from GxQscripts where name='PatchVerifySource')
	delete from GxQscripts where name = 'PatchVerifySource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchVerifySource')
	delete from GXDBVersions where aliasname = 'PatchVerifySource'
GO
print '... Creating Procedure: PatchVerifySource'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchVerifySource
  @sourceClientName VARCHAR(1024),
  @destinationClientName VARCHAR(1024)
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @oIsSourceClientRC INT
  DECLARE @oDestinationInstallDir VARCHAR(4096)
  DECLARE @oIsVSAProxy INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @srcClientId INT = 0
DECLARE @dstClientId INT = 0
SET @oIsSourceClientRC = 0
SET @oDestinationInstallDir = ''
SET @oIsVSAProxy  =0
SELECT @srcClientId = id FROM APP_Client WITH(NOLOCK) WHERE name = @sourceClientName
SELECT @dstClientId = id FROM APP_Client WITH(NOLOCK) WHERE name = @destinationClientName
IF @srcClientId <> 0 AND EXISTS (SELECT 1 FROM PatchUpdateAgentInfo WITH(NOLOCK) WHERE clientId = @srcClientId AND isDeleted = 0 AND isEnabled = 1)
	SET @oIsSourceClientRC = 1
ELSE
	SET @oIsSourceClientRC = 0
IF @dstClientId <> 0
	SELECT @oDestinationInstallDir = attrVal FROM App_ClientProp WITH(NOLOCK) WHERE componentNameId = @dstClientId AND attrName = 'Patch Local Location'
ELSE
	SET @oDestinationInstallDir = ''
if exists ( select top 1 id from simInstalledPackages where clientid = @srcClientId  and simPackageID in ( 713, 1136) )
	SET @oIsVSAProxy = 1
SELECT @oIsSourceClientRC, @oDestinationInstallDir, @oIsVSAProxy
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchVerifySource')
	delete from GxQscripts where name = 'PatchVerifySource'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchVerifySource')
	delete from GXDBVersions where aliasname = 'PatchVerifySource'
GO

insert into GXDBVersions values(2, 'PatchVerifySource',  '00010001000400030000', 'PatchVerifySource', '00010001000400030000')
GO

