

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchSetUpdateAgentCacheDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  | Stored Proc: PatchSetUpdateAgentCacheDetails()
--  |
--  | Description: Processes input from XML patchInformation message
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PatchSetUpdateAgentCacheDetails')
BEGIN
	print '>>> Drop Stored Procedure: PatchSetUpdateAgentCacheDetails <<<'
	drop procedure PatchSetUpdateAgentCacheDetails
END
IF EXISTS (select * from GxQscripts where name='PatchSetUpdateAgentCacheDetails')
	delete from GxQscripts where name = 'PatchSetUpdateAgentCacheDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchSetUpdateAgentCacheDetails')
	delete from GXDBVersions where aliasname = 'PatchSetUpdateAgentCacheDetails'
GO
print '... Creating Procedure: PatchSetUpdateAgentCacheDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchSetUpdateAgentCacheDetails
  @inputXML xml,
  @inClientId int
AS
  DECLARE @oErrorCode int
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
SET @oErrorCode = 0
DECLARE @inRelease      INT
DECLARE @inOSType       INT
DECLARE @inHighestSP  VARCHAR(max)
DECLARE @inAddUpdates NVARCHAR(max)
DECLARE @inClearExisting integer = 2
DECLARE @inTransactionId INT
DECLARE @inRevisionId INT
DECLARE @inFriendlySPName varchar(256)
DECLARE @UpdatePackNumber INT
DECLARE @UpdatePackFriendlyName VARCHAR(64)
DECLARE @CSCacheID INT
IF object_id('tempdb.dbo.#tempRelIDOSIDMapTable') IS NOT null  DROP TABLE #tempRelIDOSIDMapTable
       create table #tempRelIDOSIDMapTable (RelId INT, OSId INT, HighestSP INT, TransactionId INT, RevisionID INT)
IF object_id('tempdb.dbo.#tempPMCDetailsTable') IS NOT null  DROP TABLE #tempPMCDetailsTable
       create table #tempPMCDetailsTable (ReleaseID INT, OSId INT, HighestSP VARCHAR(20), addUpdates NVARCHAR(max), TransactionId INT, UpdatePackNumber INT, UpdatePackFriednlyName VARCHAR(20), RevisionID INT, CSCacheID INT)
INSERT INTO #tempRelIDOSIDMapTable
SELECT P.RelList.value('./@RelId[1]', 'INT') as RelID, Q.RelFileList.value('./@OSId', 'INT') OSId,
	P.RelList.value('./SPInfo[1]/@Major[1]', 'INT') as HighestSP, P.RelList.value('./SPInfo[1]/@TransactionId[1]', 'INT') as TransactionId,
	P.RelList.value('./SPInfo[1]/@RevisionID[1]', 'INT') as RevisionID
from @inputXML.nodes('//UpdatePatches_CacheOpReq/RelList') as P(RelList)
CROSS APPLY P.RelList.nodes('./RelFileList') as Q(RelFileList)
INSERT INTO #tempPMCDetailsTable
SELECT pmc.Release, pmc.OSType, pmc.HighestSP, pmc.AddUpdates, pmc.TransactionId, pmc.UpdatePackNumber, pmc.UpdatePackFriendlyName, pmc.RevisionId, pmc.CacheID
FROM #tempRelIDOSIDMapTable relIDOSMap join PatchSPVersion psp
ON relIDOSMap.RelId = psp.Release AND relIDOSMap.HighestSP = psp.SPMajor AND relIDOSMap.TransactionId = psp.TransactionID AND relIDOSMap.RevisionID = psp.RevisionID
CROSS APPLY (SELECT TOP 1 * from dbo.patchGetCacheInfoByLevel(2, relIDOSMap.RelId, psp.id, relIDOSMap.OSId, 0))  AS pmc
DECLARE pmcDetailsTableCursor CURSOR FOR SELECT * from #tempPMCDetailsTable
OPEN pmcDetailsTableCursor
FETCH NEXT FROM  pmcDetailsTableCursor INTO @inRelease, @inOSType, @inHighestSP, @inAddUpdates, @inTransactionId, @UpdatePackNumber, @UpdatePackFriendlyName, @inRevisionId, @CSCacheID
WHILE @@FETCH_STATUS = 0
BEGIN
--
	DECLARE @IsSPValid INTEGER
	set @IsSPValid=1
	DECLARE @patchSPVersionId   INTEGER = 0
	DECLARE @majorVersion INTEGER = 0
	DECLARE @minorVersion INTEGER = 0
	SELECT @majorVersion = major, @minorVersion = minor FROM dbo.GetServicePackNumbers(@inHighestSP)
	DECLARE @spVersionInfo 		TABLE (id INTEGER)
	DECLARE @buildNum 			INTEGER = dbo.GetBuildNum(@inRelease)
	IF @inClearExisting<=1
	BEGIN
		DECLARE @cacheIdList VARCHAR(MAX) = ''
		DECLARE @isListBased INTEGER = 0
		IF(@majorVersion != 0 AND @inTransactionId! = 0 AND @inRevisionId != 0 AND @buildNum != 0 )
		BEGIN
			SET @patchSPVersionId = -1
			SELECT @patchSPVersionId = id
			FROM PatchSPVersion WITH(NOLOCK)
			WHERE Release = @inRelease AND
				Build = @buildNum AND
				SPMajor = @majorVersion AND
				SPMinor = @minorVersion AND
				TransactionID = @inTransactionId AND
				RevisionID = @inRevisionId
		END
		ELSE IF(@buildNum != 0 AND @inTransactionId = 0 AND @inRevisionId = 0)
		BEGIN
			SET @isListBased = 1
			SELECT @cacheIdList = COALESCE(@cacheIdList + ',' ,'') + CAST(id AS VARCHAR(255))
			FROM PatchMultiCache PMC
			WHERE PMC.ClientId = @inClientId AND PMC.ReleaseId = @inRelease
			    AND((@majorVersion = 0)
				OR (@majorVersion > 0 AND PMC.HighestSP = @majorVersion))
		END
		EXEC patchCleanCacheEntries @isListBased, @inClientId , @cacheIdList, @inOSType, @patchSPVersionId
	END
	IF @inClearExisting>=1
	BEGIN
		-- Check PatchSPVersion table for entry
		INSERT @spVersionInfo EXEC simGetSPVersionId @inRelease, @buildNum, @majorVersion, @minorVersion, @inTransactionId, @inRevisionId, @inFriendlySPName, 0, 0
		SELECT @patchSPVersionId = id FROM @spVersionInfo
		IF NOT EXISTS (SELECT 1 FROM PatchMultiCache
					   WHERE ReleaseId=@inRelease
					   AND OSId=@inOSType
					   AND ClientId=@inClientId
					   AND SPVersionID=@patchSPVersionId)
		BEGIN
			INSERT INTO PatchMultiCache
			VALUES (@inClientId,
					@inRelease,
					@inOSType,
					@inHighestSP,
					@inAddUpdates,
					@IsSPValid,
					@patchSPVersionId)
		END
		ELSE IF @inClearExisting > 2
		BEGIN
			UPDATE PatchMultiCache
			SET addUpdates 	= 	@inAddUpdates	,
				isSPValid	=	@IsSPValid		,
				SPVersionID	=	@patchSPVersionID
			WHERE ReleaseId	=	@inRelease 	AND
				  OSId		=	@inOSType 	AND
				  ClientId	=	@inClientId
		END
	END
--
	IF @UpdatePackNumber > 0
	BEGIN
		DECLARE @currentCacheID INT = 0
		DECLARE @currentUpdatePackID INT = 0
		IF @patchSPVersionId > 0
		BEGIN
			SET @currentCacheID = (SELECT id from PatchMultiCache where ReleaseId = @inRelease and OSId = @inOSType and ClientId = @inClientId and SPVersionID=@patchSPVersionId)
		END
		ELSE
		BEGIN
			SET @currentCacheID = (SELECT id from PatchMultiCache where ReleaseId = @inRelease and OSId = @inOSType and ClientId = @inClientId)
		END
		SET @currentUpdatePackID = (SELECT TOP 1 UpdatePackID from PatchCacheUpdatePackMap pcupm INNER JOIN PatchUPVersion pupv WITH(NOLOCK) on (pcupm.CacheID = @CSCacheID and pcupm.UpdatePackID = pupv.UPVersionID ) where pupv.UPNumber = @UpdatePackNumber)
		IF NOT EXISTS (SELECT 1 FROM PatchCacheUpdatePackMap WHERE CacheID=@currentCacheID and UpdatePackID=@currentUpdatePackID)
		BEGIN
			INSERT INTO PatchCacheUpdatePackMap values(@currentCacheID, @currentUpdatePackID)
		END
	END
	FETCH NEXT FROM  pmcDetailsTableCursor INTO @inRelease, @inOSType, @inHighestSP, @inAddUpdates, @inTransactionId, @UpdatePackNumber, @UpdatePackFriendlyName, @inRevisionId, @CSCacheID
END
CLOSE pmcDetailsTableCursor
DEALLOCATE pmcDetailsTableCursor
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @oErrorCode = ERROR_NUMBER()
END CATCH
CLEAN_EXIT:
	IF object_id('tempdb.dbo.#tempRelIDOSIDMapTable') IS NOT null DROP TABLE #tempRelIDOSIDMapTable
	IF object_id('tempdb.dbo.#tempPMCDetailsTable') IS NOT null DROP TABLE #tempPMCDetailsTable
	IF object_id('tempdb.dbo.pmcDetailsTableCursor') IS NOT null DEALLOCATE pmcDetailsTableCursor
SELECT @oErrorCode
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchSetUpdateAgentCacheDetails')
	delete from GxQscripts where name = 'PatchSetUpdateAgentCacheDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchSetUpdateAgentCacheDetails')
	delete from GXDBVersions where aliasname = 'PatchSetUpdateAgentCacheDetails'
GO

insert into GXDBVersions values(2, 'PatchSetUpdateAgentCacheDetails',  '00000000000000000000', 'PatchSetUpdateAgentCacheDetails', '00000000000000000000')
GO

