

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchIsThirdPartyPatchRequired.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchIsThirdPartyPatchRequired.sp,v $ $Id: PatchIsThirdPartyPatchRequired.sp,v 1.1.2.9 2020/05/01 18:11:08 kgao Exp $";
--
--  +========================================================================+
--  | Stored Proc:  PatchIsThirdPartyPatchRequired
--  |
--  | Description: Check whether third party patch is required
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PatchIsThirdPartyPatchRequired')
BEGIN
	print '>>> Drop Stored Procedure: PatchIsThirdPartyPatchRequired <<<'
	drop procedure PatchIsThirdPartyPatchRequired
END
IF EXISTS (select * from GxQscripts where name='PatchIsThirdPartyPatchRequired')
	delete from GxQscripts where name = 'PatchIsThirdPartyPatchRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchIsThirdPartyPatchRequired')
	delete from GXDBVersions where aliasname = 'PatchIsThirdPartyPatchRequired'
GO
print '... Creating Procedure: PatchIsThirdPartyPatchRequired'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure PatchIsThirdPartyPatchRequired
  @i_clientId INT,
  @i_installOptions BIGINT
AS
--	The next lines are the columns, in order, that will be in the result set for this cursor.
--  EXTREME CAUTION must be exercised to ensure that these match up with the result set
--  in terms of type, size and order!
  DECLARE @o_SQLUpdate integer
  DECLARE @o_WinOSUpdate integer
  DECLARE @o_SQLUpdateInCache integer
  DECLARE @o_WinOSUpdateInCache integer
SET NOCOUNT ON
DECLARE @sqlType INT = 1
DECLARE @winOSType INT = 2
SET @o_WinOSUpdate = 0
SET @o_SQLUpdate = 0
SET @o_WinOSUpdateInCache = 0
SET @o_SQLUpdateInCache = 0
IF EXISTS (SELECT 1 FROM GxGlobalParam WHERE name='Patch Enable SW Appliance Update' and value='1')
BEGIN
	DECLARE @relID	INT = 0
	DECLARE @spID	INT = 0
	DECLARE @TranID	INT = 0
	SELECT TOP 1 @relID = release, @spID = SPMajor, @TranID = TransactionID
	FROM PatchSPVersion NOLOCK WHERE id IN (select SPversionID from simInstalledPackages NOLOCK where clientID = @i_clientId)
	ORDER BY release DESC, SPMajor DESC, TransactionID DESC
	IF @relID > 16 OR @relID >= 16 AND @spID > 16 -- only supported for clients with v11 sp17
	BEGIN
		DECLARE @winOSVer VARCHAR(128) = ISNULL((	SELECT version FROM simInstalledThirdpartyCU NOLOCK
WHERE (@i_installOptions & 0x4) > 0 and clientID = @i_clientId and type = @winOSType and enabled = 1 and eligible = 1), '')
		DECLARE @sqlVer VARCHAR(128) = ISNULL((		SELECT version FROM simInstalledThirdpartyCU NOLOCK
WHERE (@i_installOptions & 0x2) > 0 and clientID = @i_clientId and type = @sqlType and enabled = 1 and eligible = 1), '')
		DECLARE @osID INT = 3 -- winx64
		DECLARE @uaID INT = 0
		DECLARE @uaClientID INT = 2
		SELECT  @uaID = CAST(ISNULL([UPDATE CACHE AGENT ID], '0') AS INT), @osID = CAST(ISNULL([Binary Set ID], '3') AS INT)
			FROM (select attrName, attrVal from APP_clientProp NOLOCK where componentNameID = @i_clientId and attrName IN ('UPDATE CACHE AGENT ID', 'Binary Set ID') AND modified = 0) T
				PIVOT (MAX(attrVal) FOR attrName IN ([UPDATE CACHE AGENT ID], [Binary Set ID])) AS P
		SELECT @uaClientID = clientID FROM PatchUpdateAgentInfo NOLOCK WHERE @uaID > 0 AND id = @uaID
		IF EXISTS (	SELECT 1 FROM PatchSPVersion NOLOCK
				WHERE	id IN (select SPversionID from patchMulticache NOLOCK WHERE clientID = @uaClientID and ReleaseID = @relID and OSID = @osID) AND
					release>@relID OR release=@relID and SPMajor>@spID OR release=@relID and SPMajor=@spID and TransactionID>@TranID)
		BEGIN
			IF @winOSVer <> ''
			BEGIN
				SET @o_WinOSUpdate = 1
				SELECT @o_WinOSUpdateInCache = bExistInCache FROM patchApplianceOS NOLOCK WHERE type = @winOSType and name = @winOSVer AND clientId = @uaClientID
			END
			IF @sqlVer <> ''
			BEGIN
				SET @o_SQLUpdate = 1
				SELECT @o_SQLUpdateInCache = bExistInCache FROM patchApplianceOS NOLOCK WHERE type = @sqlType  and name = @sqlVer AND clientId = @uaClientID
			END
		END
	END
END
SELECT @o_SQLUpdate, @o_WinOSUpdate, @o_SQLUpdateInCache, @o_WinOSUpdateInCache
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchIsThirdPartyPatchRequired')
	delete from GxQscripts where name = 'PatchIsThirdPartyPatchRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchIsThirdPartyPatchRequired')
	delete from GXDBVersions where aliasname = 'PatchIsThirdPartyPatchRequired'
GO

insert into GXDBVersions values(2, 'PatchIsThirdPartyPatchRequired',  '00010001000200090000', 'PatchIsThirdPartyPatchRequired', '00010001000200090000')
GO

