

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchInputXmlConfigIni.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchInputXmlConfigIni.sp,v $ $Id: PatchInputXmlConfigIni.sp,v 1.1.4.21 2020/07/10 22:28:43 kgao Exp $";
--  +========================================================================+
--  | Stored Proc: patchInputXmlConfigIni()
--  |
--  | Description: Processes input from XML patchInformation message
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='patchInputXmlConfigIni')
BEGIN
	print '>>> Drop Stored Procedure: patchInputXmlConfigIni <<<'
	drop procedure patchInputXmlConfigIni
END
IF EXISTS (select * from GxQscripts where name='patchInputXmlConfigIni')
	delete from GxQscripts where name = 'patchInputXmlConfigIni'
GO

IF EXISTS (select * from GXDBVersions where aliasname='patchInputXmlConfigIni')
	delete from GXDBVersions where aliasname = 'patchInputXmlConfigIni'
GO
print '... Creating Procedure: patchInputXmlConfigIni'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure patchInputXmlConfigIni
  @inputXml xml
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
-- Client ID will be assumed to be CS unless the XML is modified to pass client name / client ID from a remote cache
DECLARE @clientID INT = 2
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- keep this table for processing this sproc
DECLARE @UpdateInfoTable TABLE (operationType int, cacheID int, spVersionID int, osID int, releaseId int, Patches xml, Packages xml, upVersionID int, upBundledUpdates xml, upAdditionalUpdates xml)
--------- Create SPVersions for the missing entries --------------------------------
; WITH SPVersions(ReleaseId, BuildNum, MajorVersion, MinorVersion, TransactionId, RevisionId)
AS
(
	SELECT DISTINCT Req.CacheSetup.value('(./SPVersion/@ReleaseId)[1]', 'int') as releaseId,
		   Req.CacheSetup.value('(./SPVersion/@Build)[1]', 'int') as buildNum,
		   Req.CacheSetup.value('(./SPVersion/@Major)[1]', 'int') as majorVersion,
		   Req.CacheSetup.value('(./SPVersion/@Minor)[1]', 'int') as minorVersion,
		   Req.CacheSetup.value('(./SPVersion/@TransactionId)[1]', 'int') as transactionID,
		   COALESCE(Req.CacheSetup.value('(./SPVersion/@RevisionID)[1]', 'int'), 0) as revisionID
	FROM @inputXML.nodes('/UpdatePatches_CacheUpdateRequest/CacheUpdateInfo/CacheSetup') as Req(CacheSetup)
)
INSERT INTO PatchSPVersion(ReleaseStr, BuildIdString, DVDName, Release, Build, SPMajor, SPMinor, TransactionID, RevisionID, SPName, FriendlyName, Timestamp, bIsDVDPresent,bShowInGUI, nCacheFlags, nLTSFlag, nBootstrapperDelayDays, nGUIDownloadDelayDays)
SELECT '', '', '', ReleaseId, BuildNum, MajorVersion, MinorVersion, TransactionId, RevisionId, '', '', 0, 0, 0, 0, 0, 0, 0
FROM SPVersions
WHERE NOT EXISTS
(
	SELECT 1
	FROM PatchSPVersion pspv
	WHERE pspv.Release = SPVersions.ReleaseId AND
		  pspv.Build = SPVersions.BuildNum AND
		  pspv.SPMajor = SPVersions.MajorVersion AND
		  pspv.SPMinor = SPVersions.MinorVersion AND
		  pspv.TransactionID = SPVersions.TransactionId AND
		  pspv.RevisionID = SPVersions.RevisionId
)
--------- Create UPVersions for the missing entries --------------------------------
; WITH UPVersions(Number, TransactionID, SPVersionId, FriendlyName) AS
(
	SELECT DISTINCT Req.CacheSetup.value('(./UpdatePack/@Number)[1]', 'int') as Number,
		   Req.CacheSetup.value('(./UpdatePack/@TransactionId)[1]', 'int') as TransactionID,
		   spver.id as SPVersionId,
		   ISNULL(Req.CacheSetup.value('(./UpdatePack/@FriendlyName)[1]', 'varchar(256)'), '') as FriendlyName
	FROM @inputXML.nodes('/UpdatePatches_CacheUpdateRequest/CacheUpdateInfo/CacheSetup') as Req(CacheSetup)
	JOIN PatchSPVersion spver ON spver.release = Req.CacheSetup.value('(./SPVersion/@ReleaseId)[1]', 'int')
	WHERE Req.CacheSetup.exist('(./UpdatePack)') = 1  AND
		  spver.Build = Req.CacheSetup.value('(./SPVersion/@Build)[1]', 'int') AND
		  spver.SPMajor = Req.CacheSetup.value('(./SPVersion/@Major)[1]', 'int') AND
		  spver.SPMinor = Req.CacheSetup.value('(./SPVersion/@Minor)[1]', 'int') AND
		  spver.TransactionID =  Req.CacheSetup.value('(./SPVersion/@TransactionId)[1]', 'int') AND
		  spver.RevisionID = Req.CacheSetup.value('(./SPVersion/@RevisionID)[1]', 'int')
)
INSERT INTO PatchUPVersion(SPVersionID, UPNumber, MaxTransactionID, bIsAvailableForDownload, bShowInGUI, FriendlyName, Timestamp, nBootstrapperDelayDays, nGUIDownloadDelayDays)
SELECT SPVersionId, Number, TransactionId, 0, 0, FriendlyName, 0, 0, 0
FROM UPVersions
WHERE NOT EXISTS
(
	SELECT 1
	FROM PatchUPVersion pup
	JOIN PatchSPVersion pspv WITH(NOLOCK) ON pup.SPVersionId = pspv.id
	WHERE pup.UPNumber = UPVersions.Number AND
		  pup.SPVersionId = UPVersions.SPVersionId
)
AND UPVersions.Number > 0
--------- Shred XML --------------------------------
INSERT INTO @UpdateInfoTable
SELECT Req.CacheSetup.value('../@operationType', 'int') as operationType,
	   COALESCE(pmc.id, 0) as cacheId,
	   spver.id as spVersionID,
	   Req.CacheSetup.value('(./OSInfo/@updateOSId)[1]', 'int') as osId,
	   Req.CacheSetup.value('(./SPVersion/@ReleaseId)[1]', 'int')  as releaseId,
	   Req.CacheSetup.query('./Patches/patchInformation') as Patches,
	   Req.CacheSetup.query('./Packages/Package') as Packages,
	   upver.UPVersionID as UPVersionID,
	   Req.CacheSetup.query('./UpdatePack/BundledUpdates/patchInformation') as upBundledUpdates,
	   Req.CacheSetup.query('./UpdatePack/AdditionalUpdates/patchInformation') as upAdditionalUpdates
FROM @inputXML.nodes('/UpdatePatches_CacheUpdateRequest/CacheUpdateInfo/CacheSetup') as Req(CacheSetup)
JOIN PatchSPVersion spver WITH(NOLOCK) ON spver.release = Req.CacheSetup.value('(./SPVersion/@ReleaseId)[1]', 'int')
						AND spver.Build = Req.CacheSetup.value('(./SPVersion/@Build)[1]', 'int')
						AND spver.SPMajor = Req.CacheSetup.value('(./SPVersion/@Major)[1]', 'int')
						AND spver.SPMinor = Req.CacheSetup.value('(./SPVersion/@Minor)[1]', 'int')
						AND spver.TransactionID =  Req.CacheSetup.value('(./SPVersion/@TransactionId)[1]', 'int')
						AND spver.RevisionID =  Req.CacheSetup.value('(./SPVersion/@RevisionID)[1]', 'int')
LEFT JOIN PatchUPVersion upver WITH(NOLOCK) ON upver.SPVersionId = spver.id
						AND upver.UPNumber = Req.CacheSetup.value('(./UpdatePack/@Number)[1]', 'int') -- only use UPNumber and ignore the UP transactionID here
LEFT JOIN PatchMultiCache pmc WITH(NOLOCK) ON spver.id = pmc.SPVersionID
										AND pmc.ClientID = @clientID
										AND pmc.OSId = Req.CacheSetup.value('(./OSInfo/@updateOSId)[1]', 'int')
										AND pmc.ReleaseId = Req.CacheSetup.value('(./SPVersion/@ReleaseId)[1]', 'int')
--------- Populate PatchMultiCache entries --------------------------------
INSERT INTO PatchMultiCache
SELECT @clientId, psp.Release, uit.OSId, psp.SPMajor, '', 0, psp.id
FROM @UpdateInfoTable uit
JOIN PatchSPVersion psp WITH (NOLOCK) ON uit.spVersionID = psp.id
WHERE uit.operationType = 1 AND uit.cacheId = 0
EXCEPT SELECT ClientId, ReleaseId, OSId, HighestSP, '', 0, SPVersionID FROM PatchMultiCache
UPDATE @UpdateInfoTable
SET cacheId = pmc.id
FROM PatchMultiCache pmc WITH (NOLOCK)
JOIN @UpdateInfoTable uit ON pmc.spVersionID = uit.spVersionID
WHERE uit.cacheId = 0
AND uit.operationType = 1
AND uit.osID = pmc.osid
AND pmc.ReleaseId = uit.ReleaseID
AND clientId = @clientID
--------- Write Additional Updates to Cache -----------------------
; WITH PatchInformation (cacheId, PatchId)
AS(
       SELECT DISTINCT
       cacheId,
	   STUFF((SELECT DISTINCT ',' + RIGHT(p.value('(./@patchName)[1]', 'varchar(256)'),  CHARINDEX('_', REVERSE(p.value('(./@patchName)[1]', 'varchar(256)'))) - 1)
        FROM @UpdateInfoTable uit1
              CROSS APPLY Patches.nodes('./patchInformation') AS T(p)
              WHERE uit1.operationType = 1  and uit1.cacheid = uit2.cacheid
        FOR XML PATH ('')), 1, 1, '') AS PatchId
       FROM @UpdateInfoTable uit2
       WHERE uit2.operationType = 1
)
UPDATE PatchMultiCache
SET AddUpdates = pi.patchId
FROM PatchInformation pi
JOIN PatchMultiCache pmc on pi.cacheid = pmc.id
--------- Invalidate Cache entries --------------------------------
-- this is no longer needed since isSPValid column is obsolted
--UPDATE PatchMultiCache
--SET IsSPValid = 0
--FROM @UpdateInfoTable uit
--JOIN PatchMultiCache pmc ON uit.cacheId = pmc.id
--------- Delete mapping entries --------------------------------
DELETE PatchCachePackageMap
FROM @UpdateInfoTable uit
JOIN PatchCachePackageMap pcp on pcp.cacheId = uit.cacheID
WHERE uit.operationType = 0
; WITH PatchInformation (patchName)
AS(
    SELECT DISTINCT p.value('(./@patchName)[1]', 'varchar(256)') as patchName
    FROM @UpdateInfoTable uit
    CROSS APPLY Patches.nodes('./patchInformation') AS T(p)
    WHERE uit.operationType = 1
)
DELETE PatchUpdatePackageMap
FROM PatchInformation pi
JOIN PatchINI pini WITH(NOLOCK) ON pi.patchName = pini.patchName
JOIN PatchUpdatePackageMap map ON pini.id = map.UpdateID
-- just delete all root level updates here
DELETE PatchCacheUpdateMap
FROM @UpdateInfoTable uit
JOIN PatchCacheUpdateMap pcu on pcu.cacheId = uit.cacheID
DELETE PatchUpdatePackPatchesMap
FROM @UpdateInfoTable uit
JOIN PatchCacheUpdatePackMap pcup WITH(NOLOCK) ON uit.cacheId = pcup.cacheId
JOIN PatchUpdatePackPatchesMap pup ON pcup.updatePackID = pup.updatePackID
WHERE uit.operationType = 0
DELETE PatchCacheUpdatePackMap
FROM @UpdateInfoTable uit
JOIN PatchCacheUpdatePackMap map ON uit.cacheID = map.CacheID
WHERE uit.upVersionID IS NOT NULL AND uit.operationType = 0 AND UpdatePackID = uit.upVersionID
-- We cannot simply delete the records here, or CUs belongs to same SP won't be able to find an entry in PMC table
--DELETE PatchMultiCache
--FROM @UpdateInfoTable uit
--JOIN PatchMultiCache pmc ON uit.cacheID = pmc.id
--WHERE uit.operationType = 0
--------- Create Patch records --------------------------------------------
; WITH PatchInformation (ReleaseId, OSId, PatchName, PatchId, AliasName, Servicepacks, AppTypeList, RebootPkgList, Obsoletes, Requires, SpaceRequired, HasJar, Flags)
AS(
	SELECT
		   spver.Release as ReleaseId,
		   uit.osID as OSId,
		   p.value('(./@patchName)[1]', 'varchar(256)') as PatchName,
		   p.value('(./@patchId)[1]', 'varchar(256)') as PatchId,
		   p.value('(./@aliasName)[1]', 'varchar(256)') as AliasName,
		   COALESCE(p.value('(./@spName)[1]', 'varchar(256)'), '0') as Servicepacks,
		   COALESCE(p.value('(./@appTypeList)[1]', 'varchar(max)'), '') as AppTypeList,
		   COALESCE(p.value('(./@rebootPkgList)[1]', 'varchar(max)'), '') as RebootPkgList,
		   COALESCE(p.value('(./@obsoletes)[1]', 'varchar(max)'), '') as Obsoletes,
		   COALESCE(p.value('(./@requires)[1]', 'varchar(max)'), '') as Requires,
		   COALESCE(p.value('(./@spaceReq)[1]', 'int'), 0) as SpaceRequired,
		   COALESCE(p.value('(./@hasJar)[1]', 'int'), 0) as HasJar,
		   COALESCE(p.value('(./@flags)[1]', 'int'), 0) as Flags
	FROM @UpdateInfoTable uit
	JOIN PatchSPVersion spver WITH(NOLOCK) ON uit.spVersionID = spver.id
	CROSS APPLY Patches.nodes('./patchInformation') AS T(p)
	WHERE uit.operationType = 1
	UNION
	SELECT
		   spver.Release as ReleaseId,
		   uit.osID as OSId,
		   b.value('(./@patchName)[1]', 'varchar(256)') as PatchName,
		   b.value('(./@patchId)[1]', 'varchar(256)') as PatchId,
		   b.value('(./@aliasName)[1]', 'varchar(256)') as AliasName,
		   COALESCE(b.value('(./@spName)[1]', 'varchar(256)'), '0') as Servicepacks,
		   COALESCE(b.value('(./@appTypeList)[1]', 'varchar(max)'), '') as AppTypeList,
		   COALESCE(b.value('(./@rebootPkgList)[1]', 'varchar(max)'), '') as RebootPkgList,
		   COALESCE(b.value('(./@obsoletes)[1]', 'varchar(max)'), '') as Obsoletes,
		   COALESCE(b.value('(./@requires)[1]', 'varchar(max)'), '') as Requires,
		   COALESCE(b.value('(./@spaceReq)[1]', 'int'), 0) as SpaceRequired,
		   COALESCE(b.value('(./@hasJar)[1]', 'int'), 0) as HasJar,
		   COALESCE(b.value('(./@flags)[1]', 'int'), 0) as Flags
	FROM @UpdateInfoTable uit
	JOIN PatchSPVersion spver WITH(NOLOCK) ON uit.spVersionID = spver.id
	CROSS APPLY upBundledUpdates.nodes('./patchInformation') AS T(b)
	WHERE uit.operationType = 1
	UNION
	SELECT
		   spver.Release as ReleaseId,
		   uit.osID as OSId,
		   b.value('(./@patchName)[1]', 'varchar(256)') as PatchName,
		   b.value('(./@patchId)[1]', 'varchar(256)') as PatchId,
		   b.value('(./@aliasName)[1]', 'varchar(256)') as AliasName,
		   COALESCE(b.value('(./@spName)[1]', 'varchar(256)'), '0') as Servicepacks,
		   COALESCE(b.value('(./@appTypeList)[1]', 'varchar(max)'), '') as AppTypeList,
		   COALESCE(b.value('(./@rebootPkgList)[1]', 'varchar(max)'), '') as RebootPkgList,
		   COALESCE(b.value('(./@obsoletes)[1]', 'varchar(max)'), '') as Obsoletes,
		   COALESCE(b.value('(./@requires)[1]', 'varchar(max)'), '') as Requires,
		   COALESCE(b.value('(./@spaceReq)[1]', 'int'), 0) as SpaceRequired,
		   COALESCE(b.value('(./@hasJar)[1]', 'int'), 0) as HasJar,
		   COALESCE(b.value('(./@flags)[1]', 'int'), 0) as Flags
	FROM @UpdateInfoTable uit
	JOIN PatchSPVersion spver WITH(NOLOCK) ON uit.spVersionID = spver.id
	CROSS APPLY upAdditionalUpdates.nodes('./patchInformation') AS T(b)
	WHERE uit.operationType = 1
)
INSERT INTO PatchINI(ReleaseId, OSId, PatchName, PatchId, AliasName, Servicepacks, AppTypeList, RebootPkgList, Obsoletes, Requires, SpaceRequired, HasJar, Flags)
SELECT ReleaseId, OSId, PatchName, PatchId, AliasName, Servicepacks, AppTypeList, RebootPkgList, Obsoletes, Requires, SpaceRequired, HasJar, Flags
FROM PatchInformation pi
WHERE NOT EXISTS (SELECT 1 FROM PatchINI pini WHERE pi.patchName = pini.patchName)
--------- Create Mapping records --------------------------------------------
; WITH PatchInformation (patchName, aliasName, appTypeList)
AS(
	SELECT DISTINCT	p.value('(./@patchName)[1]', 'varchar(256)') as patchName,
					p.value('(./@aliasName)[1]', 'varchar(256)') as aliasName,
					p.value('(./@appTypeList)[1]', 'varchar(max)') as appTypeList
	FROM @UpdateInfoTable uit
	CROSS APPLY Patches.nodes('./patchInformation') AS T(p)
	WHERE uit.operationType = 1
)
INSERT INTO PatchUpdatePackageMap
SELECT pini.ID, split._ID
FROM PatchInformation pi
JOIN PatchINI pini WITH (NOLOCK) ON pi.patchName = pini.patchName
CROSS APPLY dbo.SplitStringByDelimiter(pi.appTypeList, ',') split
WHERE split._ID IS NOT NULL AND split._ID <> ''
EXCEPT SELECT UpdateID, PackageID FROM PatchUpdatePackageMap
; WITH PatchInformation (cacheId, patchName)
AS(
	SELECT uit.cacheID,
		   p.value('(./@patchName)[1]', 'varchar(256)') as patchName
	FROM @UpdateInfoTable uit
	CROSS APPLY Patches.nodes('./patchInformation') AS T(p)
	WHERE uit.operationType = 1
)
INSERT INTO PatchCacheUpdateMap
SELECT cacheID, pini.ID, 0
FROM PatchInformation pi
JOIN PatchINI pini WITH (NOLOCK) ON pi.patchName = pini.patchName
EXCEPT SELECT CacheID, UpdateID, UPNumber FROM PatchCacheUpdateMap
INSERT INTO PatchCachePackageMap
SELECT uit.cacheID,
	   p.value('(./@pkgID)[1]', 'varchar(256)') as packageId
FROM @UpdateInfoTable uit
CROSS APPLY Packages.nodes('./Package') AS T(p)
WHERE uit.operationType = 1
EXCEPT SELECT CacheID, PackageID FROM PatchCachePackageMap
INSERT INTO PatchCacheUpdatePackMap
SELECT uit.cacheId, uit.upVersionID
FROM @UpdateInfoTable uit
JOIN PatchUPVersion upver WITH(NOLOCK) on uit.upVersionID = upver.UPVersionID
JOIN PatchMultiCache pmc WITH(NOLOCK) ON uit.cacheId = pmc.id
WHERE uit.operationType = 1
EXCEPT SELECT CacheID, UpdatePackID FROM PatchCacheUpdatePackMap
INSERT INTO PatchUpdatePackPatchesMap
SELECT uit.upVersionID, pini.id, 0
FROM @UpdateInfoTable uit
CROSS APPLY upBundledUpdates.nodes('./patchInformation') AS T(p)
JOIN PatchINI pini WITH (NOLOCK) ON pini.patchName = p.value('(./@patchName)[1]', 'varchar(256)')
WHERE uit.operationType = 1
EXCEPT SELECT UpdatePackID, UpdateID, bIsAdditionalUpdate FROM PatchUpdatePackPatchesMap
INSERT INTO PatchUpdatePackPatchesMap
SELECT uit.upVersionID, pini.id, 1
FROM @UpdateInfoTable uit
CROSS APPLY upAdditionalUpdates.nodes('./patchInformation') AS T(p)
JOIN PatchINI pini WITH (NOLOCK) ON pini.patchName = p.value('(./@patchName)[1]', 'varchar(256)')
WHERE uit.operationType = 1
EXCEPT SELECT UpdatePackID, UpdateID, bIsAdditionalUpdate FROM PatchUpdatePackPatchesMap
------------- Set cache as valid ---------------------------------
-- This is not required but we still keep it to avoid regression
UPDATE PatchMultiCache
SET IsSPValid = 1
FROM @UpdateInfoTable uit
JOIN PatchMultiCache pmc ON uit.cacheID = pmc.id
WHERE uit.operationType = 1
-- delete unused PMC entries
DELETE PatchMultiCache
FROM @UpdateInfoTable uit
JOIN PatchMultiCache pmc ON uit.cacheID = pmc.id
WHERE uit.operationType = 0
	AND COALESCE(uit.upVersionID, 0) = 0
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchInputXmlConfigIni')
	delete from GxQscripts where name = 'PatchInputXmlConfigIni'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchInputXmlConfigIni')
	delete from GXDBVersions where aliasname = 'PatchInputXmlConfigIni'
GO

insert into GXDBVersions values(2, 'PatchInputXmlConfigIni',  '00010001000400210000', 'PatchInputXmlConfigIni', '00010001000400210000')
GO

