

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetUpdatesDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetUpdatesDetails.sp,v $ $Id: PatchGetUpdatesDetails.sp,v 1.1.4.4 2018/03/27 09:15:32 jiechen Exp $";
--
--  +========================================================================+
--  |   Cursor:  PatchGetUpdatesDetails
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Get the updates details
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PatchGetUpdatesDetails <<<'

IF EXISTS (select * from sysobjects where name='PatchGetUpdatesDetails')
	drop procedure PatchGetUpdatesDetails
IF EXISTS (select * from GxQscripts where name='PatchGetUpdatesDetails')
	delete from GxQscripts where name = 'PatchGetUpdatesDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetUpdatesDetails')
	delete from GXDBVersions where aliasname = 'PatchGetUpdatesDetails'
GO
print '... Creating Procedure: PatchGetUpdatesDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchGetUpdatesDetails
  @inSPVersionId INTEGER,
  @inOSId INTEGER
AS
  DECLARE @oUpdatesName VARCHAR(512)
  DECLARE @oUpdatesNum VARCHAR(256)
  DECLARE @oBinarySetId INTEGER
  DECLARE @oPkgList VARCHAR(2048)
  DECLARE @oChecksum BIGINT
  DECLARE @oSizeInBytes BIGINT
  DECLARE @oReserved INTEGER
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
SELECT UpdatesName,
	UpdatesNumber,
	S.BinarySetId,
	PkgList,
	Checksum,
	SizeInBytes,
	Reserved
FROM PatchUpdatesInfo S JOIN PatchUpdateOS P WITH(NOLOCK) ON P.NewUpdateOSID = @inOSId
WHERE S.SPVersionId = @inSPVersionId AND S.BinarySetId = P.BinarySetId
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetUpdatesDetails')
	delete from GxQscripts where name = 'PatchGetUpdatesDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetUpdatesDetails')
	delete from GXDBVersions where aliasname = 'PatchGetUpdatesDetails'
GO

insert into GXDBVersions values(2, 'PatchGetUpdatesDetails',  '00010001000400040000', 'PatchGetUpdatesDetails', '00010001000400040000')
GO

