

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetUpdateStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetUpdateStatus.sp,v $ $Id: PatchGetUpdateStatus.sp,v 1.1.2.3 2018/09/02 03:16:20 rnethi Exp $";
--
--  +========================================================================+
--  |   Cursor:  PatchGetUpdateStatus
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Get the updates status
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PatchGetUpdateStatus <<<'

IF EXISTS (select * from sysobjects where name='PatchGetUpdateStatus')
	drop procedure PatchGetUpdateStatus
IF EXISTS (select * from GxQscripts where name='PatchGetUpdateStatus')
	delete from GxQscripts where name = 'PatchGetUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetUpdateStatus')
	delete from GXDBVersions where aliasname = 'PatchGetUpdateStatus'
GO
print '... Creating Procedure: PatchGetUpdateStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchGetUpdateStatus
  @inReleaseId INTEGER,
  @inBuild INTEGER,
  @inSPMajor INTEGER,
  @inSPMinor INTEGER,
  @inMediaTransId INTEGER,
  @inUpdatesName VARCHAR(512),
  @inCUNumber INTEGER
AS
  DECLARE @oIsUpdateExist INTEGER
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
DECLARE @UpdateExisted INTEGER = 0
DECLARE @DVDIDs TABLE (id INT)
-- There could be multiple DVDs with same transaction Id but different Revision Id
INSERT INTO @DVDIDs
SELECT id FROM PatchSPVersion P WHERE P.Release = @inReleaseId AND P.Build = @inBuild AND P.SPMajor = @inSPMajor AND P.SPMinor = @inSPMinor AND P.TransactionID = @inMediaTransId
IF (@inCUNumber = 0)
	BEGIN
		SET @UpdateExisted = (SELECT CASE WHEN EXISTS
			(SELECT 1 FROM PatchINI I WITH(NOLOCK)
			JOIN PatchCacheUpdateMap U WITH(NOLOCK) on I.id = U.UpdateID
			JOIN PatchMultiCache M WITH(NOLOCK) on U.CacheID = M.id
			JOIN @DVDIDs D on M.SPVersionID = D.id
		WHERE I.PatchName = @inUpdatesName)
		THEN 1 ELSE 0
		END)
	END
ELSE
	BEGIN
		SET @UpdateExisted = (SELECT CASE WHEN EXISTS
			(SELECT 1 FROM PatchINI I WITH(NOLOCK)
			JOIN PatchUpdatePackPatchesMap UPPM WITH(NOLOCK) on I.id = UPPM.UpdateID
			JOIN PatchCacheUpdatePackMap UPM WITH(NOLOCK) on UPPM.UpdatePackID = UPM.UpdatePackID
			JOIN PatchUPVersion UV WITH(NOLOCK) on UPM.UpdatePackID = UV.UPVersionID AND UV.UPNumber = @inCUNumber
			JOIN @DVDIDs D on UV.SPVersionID = D.id
			WHERE I.PatchName = @inUpdatesName)
		THEN 1 ELSE 0
		END)
	END
SELECT @UpdateExisted
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetUpdateStatus')
	delete from GxQscripts where name = 'PatchGetUpdateStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetUpdateStatus')
	delete from GXDBVersions where aliasname = 'PatchGetUpdateStatus'
GO

insert into GXDBVersions values(2, 'PatchGetUpdateStatus',  '00010001000200030000', 'PatchGetUpdateStatus', '00010001000200030000')
GO

