

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetOSes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetOSes.sp,v $ $Id: PatchGetOSes.sp,v 1.1.2.3 2018/08/08 15:48:15 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  PatchGetOSes
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Gets list of OSes already in PatchMultiCache table
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PatchGetOSes <<<'

IF EXISTS (select * from sysobjects where name='PatchGetOSes')
	drop procedure PatchGetOSes
IF EXISTS (select * from GxQscripts where name='PatchGetOSes')
	delete from GxQscripts where name = 'PatchGetOSes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetOSes')
	delete from GXDBVersions where aliasname = 'PatchGetOSes'
GO
print '... Creating Procedure: PatchGetOSes'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure PatchGetOSes
  @inClientId INTEGER
AS
  DECLARE @oRelease INTEGER
  DECLARE @oBuild INTEGER
  DECLARE @oSPMajor INTEGER
  DECLARE @oSPMinor INTEGER
  DECLARE @oTransactionId INTEGER
  DECLARE @oRevisionId INTEGER
  DECLARE @oOSId INTEGER
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT DISTINCT P.Release, P.Build, P.SPMajor, P.SPMinor, P.TransactionId, P.RevisionId, M.osId
FROM PatchMultiCache M WITH(NOLOCK) JOIN PatchSPVersion P WITH(NOLOCK) ON M.SPVersionId = P.Id
WHERE M.ClientId = @inClientId
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetOSes')
	delete from GxQscripts where name = 'PatchGetOSes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetOSes')
	delete from GXDBVersions where aliasname = 'PatchGetOSes'
GO

insert into GXDBVersions values(2, 'PatchGetOSes',  '00010001000200030000', 'PatchGetOSes', '00010001000200030000')
GO

