

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetOSIdForClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetOSIdForClient.sp,v $ $Id: PatchGetOSIdForClient.sp,v 1.1.2.1 2019/11/22 16:53:24 kvankadaru Exp $";
--
--  +========================================================================+
--  |   Cursor:  PatchGetOSIdForClient
--  |
--  |   Revisions Author        Description
--  |   --------- -------       ---------------------------------------------
--  |   1.0       kvankadaru    Get installed OS id for the given client Id
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PatchGetOSIdForClient')
BEGIN
	print '>>> Drop Stored Procedure: PatchGetOSIdForClient <<<'
	drop procedure PatchGetOSIdForClient
END
IF EXISTS (select * from GxQscripts where name='PatchGetOSIdForClient')
	delete from GxQscripts where name = 'PatchGetOSIdForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetOSIdForClient')
	delete from GXDBVersions where aliasname = 'PatchGetOSIdForClient'
GO
print '... Creating Procedure: PatchGetOSIdForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchGetOSIdForClient
  @inClientId INTEGER
AS
  DECLARE @nOsId INTEGER
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
DECLARE @BinarySetId			INTEGER = 0
IF (@inClientId = 2)
BEGIN
	IF EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @inClientId AND attrName = 'Virtual Client' and attrVal = 1)
	BEGIN
		SELECT @inClientId = acp.attrVal
		FROM APP_ClientProp acp WITH(NOLOCK)
		WHERE acp.componentNameId = 2 AND acp.attrName = 'CS Active Physical Node'
	END
END
SELECT @BinarySetId = attrVal FROM  App_ClientProp WITH(NOLOCK) WHERE attrName = 'Binary Set Id' AND componentNameId = @inClientId
SELECT NewUpdateOSID FROM PatchUpdateOS WITH(NOLOCK) WHERE BinarySetID = @BinarySetId
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetOSIdForClient')
	delete from GxQscripts where name = 'PatchGetOSIdForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetOSIdForClient')
	delete from GXDBVersions where aliasname = 'PatchGetOSIdForClient'
GO

insert into GXDBVersions values(2, 'PatchGetOSIdForClient',  '00010001000200010000', 'PatchGetOSIdForClient', '00010001000200010000')
GO

