

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetMultiCacheValidityForSide.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetMultiCacheValidityForSide.sp,v $ $Id: PatchGetMultiCacheValidityForSide.sp,v 1.1.4.2 2020/05/01 18:11:08 kgao Exp $";
--
--  +========================================================================+
--  |   Cursor:  PatchGetOSIdForClient
--  |
--  |   Revisions Author        Description
--  |   --------- -------       ---------------------------------------------
--  |   1.0       kvankadaru    Get PatchMultiCache Validity flag for the given input side
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PatchGetMultiCacheValidityForSide')
BEGIN
	print '>>> Drop Stored Procedure: PatchGetMultiCacheValidityForSide <<<'
	drop procedure PatchGetMultiCacheValidityForSide
END
IF EXISTS (select * from GxQscripts where name='PatchGetMultiCacheValidityForSide')
	delete from GxQscripts where name = 'PatchGetMultiCacheValidityForSide'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetMultiCacheValidityForSide')
	delete from GXDBVersions where aliasname = 'PatchGetMultiCacheValidityForSide'
GO
print '... Creating Procedure: PatchGetMultiCacheValidityForSide'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchGetMultiCacheValidityForSide
  @inClientId INTEGER	,
  @inRelease INTEGER	,
  @inOSType INTEGER	,
  @inMajorSP INTEGER	,
  @inMinorSP INTEGER ,
  @inTransactionId INTEGER ,
  @inRevisionId INTEGER
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @isSPValid INTEGER
SET NOCOUNT ON
DECLARE @spValid			INTEGER = 0
DECLARE @spVersionId		INTEGER = 0
DECLARE @spVersionInfo      TABLE (id INTEGER)
DECLARE @buildNum           INTEGER = dbo.GetBuildNum(@inRelease)
INSERT @spVersionInfo EXEC simGetSPVersionId @inRelease, @buildNum, @inMajorSP, @inMinorSP, @inTransactionId, @inRevisionId, '', 0, 0
SELECT @spVersionId = id FROM @spVersionInfo
SELECT TOP 1 @spValid = IsSPValid FROM PatchMultiCache WITH(NOLOCK)
WHERE SPVersionID = @spVersionId AND
	ReleaseId = @inRelease AND
	OSId = @inOSType AND
	ClientId  = @inClientId
SELECT @spValid
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetMultiCacheValidityForSide')
	delete from GxQscripts where name = 'PatchGetMultiCacheValidityForSide'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetMultiCacheValidityForSide')
	delete from GXDBVersions where aliasname = 'PatchGetMultiCacheValidityForSide'
GO

insert into GXDBVersions values(2, 'PatchGetMultiCacheValidityForSide',  '00010001000400020000', 'PatchGetMultiCacheValidityForSide', '00010001000400020000')
GO

