

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetLatestDVDForSP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetLatestDVDForSP.sp,v $ $Id: PatchGetLatestDVDForSP.sp,v 1.1.2.2 2020/12/04 01:54:49 kgao Exp $";
--  +========================================================================+
--  | Stored Proc: PatchGetLatestDVDForSP()
--  |
--  | Description: Gets the highest revisionId and TransactionId for the
--	|			   input SP
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='PatchGetLatestDVDForSP')
BEGIN
	print '>>> Drop Stored Procedure: PatchGetLatestDVDForSP <<<'
	drop procedure PatchGetLatestDVDForSP
END
IF EXISTS (select * from GxQscripts where name='PatchGetLatestDVDForSP')
	delete from GxQscripts where name = 'PatchGetLatestDVDForSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetLatestDVDForSP')
	delete from GXDBVersions where aliasname = 'PatchGetLatestDVDForSP'
GO
print '... Creating Procedure: PatchGetLatestDVDForSP'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure PatchGetLatestDVDForSP
  @inCandidateSPXML XML
AS
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
  DECLARE @oUpdatedSPXML XML 
SET NOCOUNT ON
DECLARE @tmpCandSPInfoTbl TABLE(ReleaseId INT, Version INT, Build INT, Major INT, Minor INT, TransactionId INT, Timestamp INT, RevisionId INT)
INSERT INTO @tmpCandSPInfoTbl
SELECT TOP 1 x.ref.value('(@ReleaseId)[1]', 'INT'),
		x.ref.value('(@Version)[1]', 'INT'),
		x.ref.value('(@Build)[1]', 'INT'),
		x.ref.value('(@Major)[1]', 'INT'),
		x.ref.value('(@Minor)[1]', 'INT'),
		x.ref.value('(@TransactionId)[1]', 'INT'),
		x.ref.value('(@Timestamp)[1]', 'INT'),
		x.ref.value('(@RevisionId)[1]', 'INT')
	FROM @inCandidateSPXML.nodes('/UpdatePatches_FullVersion/spVersion') AS x(ref)
-- Update to the recut with highest transactionId and revisionId which exists in DVDInfo
DECLARE @maxTransId INT =
	(SELECT MAX(S.TransactionId)
		FROM PatchSPVersion S WITH(NOLOCK) JOIN @tmpCandSPInfoTbl T
			ON T.ReleaseId = S.Release AND T.Build = S.Build AND T.Major = S.SPMajor AND T.Minor = S.SPMinor
AND S.nCacheFlags = 0x1)
DECLARE @maxRevId INT =
	(SELECT MAX(S.RevisionId)
		FROM PatchSPVersion S WITH(NOLOCK) JOIN @tmpCandSPInfoTbl T ON
			T.ReleaseId = S.Release AND T.Build = S.Build AND T.Major = S.SPMajor AND T.Minor = S.SPMinor
AND S.transactionId = @maxTransId AND S.nCacheFlags = 0x1)
UPDATE @tmpCandSPInfoTbl
SET TransactionId = @maxTransId,  RevisionId = @maxRevId
WHERE @maxTransId > 0 AND @maxRevId > 0
DECLARE @oSPXML XML = (SELECT TOP 1 ReleaseId AS ReleaseId,
		Version AS Version,
		Build AS Build,
		Major AS Major,
		Minor AS Minor,
		TransactionId AS TransactionId,
		RevisionId AS RevisionID
		FROM @tmpCandSPInfoTbl
		FOR XML RAW('spVersion')
		)
SELECT @oSPXML FOR XML RAW('UpdatePatches_FullVersion')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetLatestDVDForSP')
	delete from GxQscripts where name = 'PatchGetLatestDVDForSP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetLatestDVDForSP')
	delete from GXDBVersions where aliasname = 'PatchGetLatestDVDForSP'
GO

insert into GXDBVersions values(2, 'PatchGetLatestDVDForSP',  '00010001000200020000', 'PatchGetLatestDVDForSP', '00010001000200020000')
GO

