

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetDVDStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetDVDStatus.sp,v $ $Id: PatchGetDVDStatus.sp,v 1.1.2.2 2018/03/27 09:01:40 jiechen Exp $";
--
--  +========================================================================+
--  |   Cursor:  PatchGetDVDStatus
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Get DVD version based on OS and MaxMediaTransactionId
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PatchGetDVDStatus <<<'

IF EXISTS (select * from sysobjects where name='PatchGetDVDStatus')
	drop procedure PatchGetDVDStatus
IF EXISTS (select * from GxQscripts where name='PatchGetDVDStatus')
	delete from GxQscripts where name = 'PatchGetDVDStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetDVDStatus')
	delete from GXDBVersions where aliasname = 'PatchGetDVDStatus'
GO
print '... Creating Procedure: PatchGetDVDStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchGetDVDStatus
  @inReleaseId INTEGER,
  @inBuildId INTEGER,
  @inOSId INTEGER,
  @inMaxMediaTransId INTEGER
AS
  DECLARE @oIsDVDInExist INTEGER
  DECLARE @oSPMajor INTEGER
  DECLARE @oSPMinor INTEGER
  DECLARE @oRevisionId INTEGER
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
DECLARE @IsDVDThere INTEGER = 0
DECLARE @SPMajor INTEGER = -1
DECLARE @SPMinor INTEGER = 0
DECLARE @RevID	 INTEGER = 0
-- Multple entry may exist for same transId by different RevisionId
DECLARE @DVDIDs TABLE (id INT, SPMajor INT, SPMinor INT, RevId INT)
INSERT INTO @DVDIDs
SELECT P.id, P.SPMajor, P.SPMinor, P.RevisionId FROM PatchSPVersion P WHERE P.Release = @inReleaseId AND P.Build = @inBuildId AND P.TransactionId = @inMaxMediaTransId
SELECT @IsDVDThere = 1, @SPMajor = D.SPMajor, @SPMinor = D.SPMinor, @RevID = MAX(D.RevId)
	FROM PatchMultiCache M JOIN @DVDIDs D ON D.id = M.SPVersionId
	WHERE M.OSId = @inOSId
	GROUP BY D.SPMajor, D.SPMinor, D.RevId
SELECT @IsDVDThere, @SPMajor, @SPMinor, @RevID
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetDVDStatus')
	delete from GxQscripts where name = 'PatchGetDVDStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetDVDStatus')
	delete from GXDBVersions where aliasname = 'PatchGetDVDStatus'
GO

insert into GXDBVersions values(2, 'PatchGetDVDStatus',  '00010001000200020000', 'PatchGetDVDStatus', '00010001000200020000')
GO

