

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetClientsWithVersionInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetClientsWithVersionInfo.sp,v $ $Id: PatchGetClientsWithVersionInfo.sp,v 1.1.2.3 2020/05/06 16:15:41 xsui Exp $";
--  +========================================================================+
--  | Stored Proc:  PatchGetClientsWithVersionInfo
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PatchGetClientsWithVersionInfo')
BEGIN
	print '>>> Drop Stored Procedure: PatchGetClientsWithVersionInfo <<<'
	drop procedure PatchGetClientsWithVersionInfo
END
IF EXISTS (select * from GxQscripts where name='PatchGetClientsWithVersionInfo')
	delete from GxQscripts where name = 'PatchGetClientsWithVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetClientsWithVersionInfo')
	delete from GXDBVersions where aliasname = 'PatchGetClientsWithVersionInfo'
GO
print '... Creating Procedure: PatchGetClientsWithVersionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PatchGetClientsWithVersionInfo
AS
  DECLARE @ClientId INT
  DECLARE @HighestSP INT
  DECLARE @MissingPatches VARCHAR(2048)
  DECLARE @baseline INT
  DECLARE @ReleaseId INT
  DECLARE @build VARCHAR(2048)
  DECLARE @v11InstallTime INT
  DECLARE @osType INT
  DECLARE @platType INT
  DECLARE @linkedFailoverClient INT
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @failoverClients TABLE (t_csClient VARCHAR(32), t_sqlClient INT)
INSERT INTO @failoverClients SELECT attrval, componentNameID FROM APP_ClientProp NOLOCK WHERE attrname = 'Linked CS Client'
CREATE TABLE #tempClients (t_clientId INT, t_HighestSP INT, t_MissingPatches varchar(1024), t_baseline INT, t_bUnknownBaseline INT, t_relId INT, t_build VARCHAR(128), t_v11InstallTime INT, t_osType INT, t_plattype INT)
INSERT INTO #tempClients
SELECT clientId, MIN(HighestSP), MAX(CAST(MissingPatches AS char(2048))), dbo.simGetBaseline(SUM(DISTINCT baseline)), SUM(CASE WHEN (baseline & 0) > 0 THEN 1 ELSE 0 END), 0, '', 0, 0, platType = SUM(ISNULL(t_appType, 0))
FROM	simInstalledPackages NOLOCK LEFT JOIN
(	select DISTINCT t_packageID=simPackageID, t_appType=(case appType when 1000 then 1 when 1002 then 2 else 0 end)
from simPackageMap NOLOCK where appType IN (1000, 1002)) T ON t_packageID=simPackageID
GROUP BY clientId
UPDATE #tempClients
SET	t_relId = releaseID, t_baseline = (CASE	WHEN (t_baseline & 8) > 0	THEN 8
WHEN (t_baseline & 16) > 0	THEN 16
WHEN (t_baseline & 2) > 0		THEN 2
WHEN t_bUnknownBaseline > 0				THEN 0
WHEN (t_baseline & 4) > 0		THEN 4
WHEN (t_baseline & 1) > 0		THEN 1
ELSE 0 END)
FROM APP_Client NOLOCK
WHERE id = t_clientId
UPDATE #tempClients
SET	t_build = UPPER(ISNULL([Galaxy Build], '')), t_v11InstallTime = CAST(ISNULL([Release 11], '0') AS INT),
	t_osType = CASE WHEN [Binary Set ID] IS NOT NULL THEN (select UpdateOSID from PatchUpdateOS NOLOCK where BinarySetId = CAST([Binary Set ID] AS INT)) ELSE 0 END
FROM	(select componentNameID, attrName, attrVal from APP_clientProp NOLOCK where componentNameID IN (select t_clientId from #tempClients) and attrName IN ('Galaxy Build', 'Release 11', 'Binary Set ID') AND modified = 0) T
	 PIVOT (MAX(attrVal) FOR attrName IN ([Galaxy Build], [Release 11], [Binary Set ID])) AS P
WHERE	t_clientId = componentNameID
SELECT	t_clientId, t_HighestSP, t_MissingPatches, t_baseline, t_relId, t_build, t_v11InstallTime, t_osType, t_plattype,
	ISNULL((select t_sqlClient from @failoverClients where t_csClient = t_clientId and LEN(t_sqlClient) > 0), 0)
FROM	#tempClients
DROP TABLE #tempClients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetClientsWithVersionInfo')
	delete from GxQscripts where name = 'PatchGetClientsWithVersionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetClientsWithVersionInfo')
	delete from GXDBVersions where aliasname = 'PatchGetClientsWithVersionInfo'
GO

insert into GXDBVersions values(2, 'PatchGetClientsWithVersionInfo',  '00010001000200030000', 'PatchGetClientsWithVersionInfo', '00010001000200030000')
GO

