

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchGetBaseline.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2016  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchGetBaseline.sp,v $ $Id: PatchGetBaseline.sp,v 1.1.2.9 2020/05/06 16:15:35 xsui Exp $";
--
--  +========================================================================+
--  |   Cursor:  PatchGetBaseline
--  |
--  |   Revisions Author  Description
--  |   --------- ------- ---------------------------------------------
--  |   1.0       Kim    Gets baseline information on givin client
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='PatchGetBaseline')
BEGIN
	print '>>> Drop Stored Procedure: PatchGetBaseline <<<'
	drop procedure PatchGetBaseline
END
IF EXISTS (select * from GxQscripts where name='PatchGetBaseline')
	delete from GxQscripts where name = 'PatchGetBaseline'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetBaseline')
	delete from GXDBVersions where aliasname = 'PatchGetBaseline'
GO
print '... Creating Procedure: PatchGetBaseline'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure PatchGetBaseline
  @inClientId INTEGER
AS
  DECLARE @oDataXML XML
--  The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
-- These lines represent the actual SQL code that will get executed.
-- :PARAM input lines
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @clientSPMajor INT = 0
DECLARE @clientSPMinor INT = 0
DECLARE @clientSPTransId INT = 0
-- variables passed to SPBody
DECLARE @inUAID			INTEGER = 2
DECLARE @inAppTypeID		INTEGER = 0
-- Get SP number for this client
SELECT @clientSPMajor = PSP.SPMajor, @clientSPMinor = PSP.SPMinor, @clientSPTransId = PSP.TransactionID
FROM PatchSPVersion PSP
OUTER APPLY
(
	SELECT TOP 1 SPVersionId FROM simInstalledPackages SIM WHERE SIM.SPVersionID = PSP.id AND SIM.ClientId = @inClientID ORDER BY SIM.id DESC
) SIM WHERE SIM.SPVersionID IS NOT NULL
IF object_id('tempdb.dbo.#AU_ClientsUpdateInfo') IS NOT null DROP TABLE #AU_ClientsUpdateInfo
-- HOLDS THE UPDATE INFO & BASELINE OF CLIENTS
CREATE	TABLE #AU_ClientsUpdateInfo
(
	CID		INTEGER NOT null,
	ReleaseID		INTEGER NOT null,
	AppTypeID		INTEGER NOT null, -- This is same as simPackageID
	InstSPMajor		INTEGER,
	InstSPMinor		INTEGER,
	InstSPTranId	INTEGER,
	InstUpdatePackNumber	INTEGER,
	InstAddUpdates	VARCHAR(MAX),
	MissingUpdates	VARCHAR(MAX),
	Baseline		INTEGER,
	BaselineSP		VARCHAR(255),
	BaselineUpdates	VARCHAR(MAX),
	cacheSPMajor	INTEGER,
	cacheSPMinor	INTEGER,
	cacheSPTranId	INTEGER,
	cacheUpdatePackNumber	INTEGER,
	bAddUpdatesCached	INT,
	UAMultiCacheId		INT
)
CREATE CLUSTERED INDEX AU_ClientsUpdate_Idx ON #AU_ClientsUpdateInfo(CID,AppTypeID)
INSERT INTO #AU_ClientsUpdateInfo
SELECT	clientID, (SELECT releaseID FROM APP_Client C WITH (NOLOCK) WHERE C.id = ClientID), simPackageID, highestSP, spMinorVersion, (SELECT TransactionID FROM PatchSPVersion P WITH (NOLOCK) WHERE P.id = SPVersionID),
	UPNumber, additionalPatches, missingPatches, baseline, baselineDeltaSP, baselineDeltaUpdate, 0, 0, 0, 0, 0, 0
FROM	SimInstalledPackages NOLOCK
WHERE	clientID = @inClientID
IF EXISTS (select 1 from #AU_ClientsUpdateInfo where baseline < 0)
	DELETE #AU_ClientsUpdateInfo
ELSE
	GOTO BUILD_XML
-- Need to show extra Updates when clients are below SP
DECLARE @showExtraUpdates INT = 1
/*
Caller will create temp table #AU_ClientsUpdateInfo to hold the result
(
	CID		INTEGER NOT null,
	ReleaseID		INTEGER NOT null,
	AppTypeID		INTEGER NOT null, -- This is same as simPackageID
	InstSPMajor		INTEGER,
	InstSPMinor		INTEGER,
	InstSPTranId	INTEGER,
	InstUpdatePackNumber	INTEGER,
	InstAddUpdates	VARCHAR(MAX),
	MissingUpdates	VARCHAR(MAX),
	Baseline		INTEGER,
	BaselineSP		VARCHAR(255),
	BaselineUpdates	VARCHAR(MAX),
	cacheSPMajor	INTEGER,
	cacheSPMinor	INTEGER,
	cacheSPTranId	INTEGER,
	cacheUpdatePackNumber	INTEGER,
	bAddUpdatesCached	INT,
	UAMultiCacheId		INT
)
Caller will also set @showExtraUpdates flag to indicate if extra BaselineDeltaUpdate will be added for low SP clients
*/
DECLARE @bDebug INT=0
IF @bDebug > 0
BEGIN
	DECLARE @tracking TABLE (t_name varchar(1024), t_time DateTime)
	INSERT INTO @tracking VALUES ('START', getdate())
END
IF object_id('tempdb.dbo.#AU_ClientsUpdateInfo') IS null
GOTO END_HERE
IF object_id('tempdb.dbo.#AU_ClientsInfo') IS NOT null DROP TABLE #AU_ClientsInfo
IF object_id('tempdb.dbo.#AU_UAMultiCache') IS NOT null DROP TABLE #AU_UAMultiCache
IF object_id('tempdb.dbo.#AU_MCAddUpdates') IS NOT null DROP TABLE #AU_MCAddUpdates
IF object_id('tempdb.dbo.#AU_PatchList') IS NOT null DROP TABLE #AU_PatchList
IF object_id('tempdb.dbo.#AU_listIDStrings') IS NOT null DROP TABLE #AU_listIDStrings
IF object_id('tempdb.dbo.#AU_spList') IS NOT null DROP TABLE #AU_spList
IF object_id('tempdb.dbo.#AU_aboveBaselineClients') IS NOT null DROP TABLE #AU_aboveBaselineClients
IF object_id('tempdb.dbo.#tempServicePackStrings') IS NOT null DROP TABLE #tempServicePackStrings
IF object_id('tempdb.dbo.#tempCacheLevelComparison') IS NOT null DROP TABLE #tempCacheLevelComparison
IF object_id('tempdb.dbo.#tempAddUpdateTbl') IS NOT null DROP TABLE #tempAddUpdateTbl
IF object_id('tempdb.dbo.#tempCachedAddUpdateInfo') IS NOT null DROP TABLE #tempCachedAddUpdateInfo
-- HOLDS THE LIST OF CLIENTS WHOSE UPDATE BASELINE IS TO BE COMPUTED
CREATE	TABLE #AU_ClientsInfo
(
	ClientID	INTEGER NOT null,
	ReleaseID	INTEGER NOT null,
	SPVersionID	INTEGER NOT null,
	UpdateOSID	INTEGER NOT null,
	UAClientID	INTEGER NOT null,
	ClientFlags	INTEGER NOT null,
	SkipFlag	TINYINT	NOT null  -- 1 means base line does not apply to this client.
)
CREATE CLUSTERED INDEX AU_Clients_Idx ON #AU_ClientsInfo(ClientID)
-- HOLDS VALID DISTINCT UACLIID,RELID,OSID
CREATE TABLE #AU_UAMultiCache
(
    ID			INTEGER NOT null IDENTITY (1,1),
    UAClientID	INTEGER NOT null,
    ReleaseID	INTEGER NOT null,
    UpdateOSID	INTEGER NOT null,
    IsValid		INTEGER,
    SP			VARCHAR(255),
    AdditionalUpdates	VARCHAR(MAX),
    SPMajor		INTEGER,
    SPMinor		INTEGER,
	SPTranId	INTEGER,
	UpdatePackNumber	INTEGER,
	UpdatePackFriendlyName VARCHAR(64),
	SPVersionID	INTEGER,
	cacheID	INTEGER,
	isCSSide	INTEGER
 )
-- HOLDS EXPANDED LIST ADDITIONAL UPDATES APPLICABLE TO APPTYPE INFO FOR GIVEN REC OF #AU_UAMultiCache
CREATE TABLE #AU_MCAddUpdates
(
    ID				INTEGER,
    PatchID			INTEGER,
    AppTypeID			INTEGER,
    PatchIDStr			VARCHAR(255),
	HasRebootPkg		INTEGER
)
CREATE CLUSTERED INDEX AU_MCAddUpdates_IDx ON #AU_MCAddUpdates(ID,AppTypeID)
-- USED TO HOLD SPLIT RESULTS FROM ADDNL UPDATES & APPTYPES
CREATE TABLE #AU_PatchList
(
   t_UAID		INTEGER,
   t_RelID		INTEGER,
   t_OSID		INTEGER,
   t_patchID		INTEGER,
   t_patchName		VARCHAR(255),
   t_appTypeList	VARCHAR(4096),
   t_hasRebootPkg	INTEGER
 )
CREATE TABLE #AU_listIDStrings(t_list varchar(MAX), t_id INT, t_string VARCHAR(MAX))
CREATE TABLE #AU_spList(t_SPs VARCHAR(MAX), t_name VARCHAR(64), t_spMajor INT, t_spMinor INT)
CREATE TABLE #AU_aboveBaselineClients(t_cid INT, t_appTypeID INT, t_instSPMaj INT, t_instSPMin INT, t_BaselineUpdates varchar(MAX), t_OSId INT, t_relID INT)
CREATE TABLE #tempServicePackStrings (major INT, minor INT, spString VARCHAR(32))
CREATE TABLE #tempCacheLevelComparison (clientID INT, spCompareVal INT, upCompareVal INT)
CREATE TABLE #tempCachedAddUpdateInfo (	t_clientId INT, t_appTypeId INT, t_relId INT, t_OSId INT, t_patchID INT, t_patchIDString VARCHAR(64), t_SPInCache VARCHAR(64),
										t_instSPMajor INT, t_instSPMinor INT, t_instSPTranId INT, t_cacheSPMajor INT, t_cacheSPMinor INT, t_cacheSPTranId INT, t_hasRebootPkg INT)
CREATE TABLE #tempAddUpdateTbl (t_clientId INT, t_appTypeId INT, t_baseline INT, t_patch VARCHAR(64), t_hasRebootPkg INT)
-- TODO: Talk to Geeta about how to avoid creating these temp tables to get UpdateOSID.
-- Answer: We cannot seem to avoid SIMODIS map. We will continue to have them hard-coded.
--		   Existing Biary SetIDs we will hard-code. Any new OS additions will be done on simBinarySet table.
--		   We will find if there are any new OS versions here and add them up to our temp table.
-- TODO  : Cluster CS node updation:
-- Answer: Not required. We no longer update the node name since we now have different unique clientIDs for
-- all CS nodes.
-- DONE : Set baseline as up-to-date for third party packages.
-- INPUT VALUES INTERPRETATION  ----
-- X --> DONT CARE
--  ----------------------------------------------------------------------------------------------------------
-- inClientID = 0 ,inUAID = 0, inAppTypeID = X --> compute baseline of ALL Clients
-- inClientID = N ,inUAID = X, inAppTypeID = 0 --> compute baseline of inClientID
-- inClientID = N ,inUAID = X, inAppTypeID = P --> compute baseline of inClientID for SIMPKGID = P
-- inClientID = 0 ,inUAID = N, inAppTypeID = X --> compute baseline of ALL clients whose cache source is UA = N
--  ----------------------------------------------------------------------------------------------------------
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Get Clients', getdate())
DECLARE @BASELINE_NOT_SET		INT = -1
DECLARE @BASELINE_UNKNOWN		INT = 0 --    0
DECLARE @BASELINE_MATCH			INT = 1 --    	1
DECLARE @BASELINE_BELOW			INT = 2 --    	2
DECLARE @BASELINE_ABOVE			INT = 4 --    	4
DECLARE @BASELINE_NOT_APLICABLE	INT = 8 --   8
DECLARE @BASELINE_HAS_DIAG		INT = 16 --    	16
DECLARE @BASELINE_OTHER			INT = 32 --    		32
DECLARE @BASELINE_TOCS_BELOW		INT = 0x1000 --    		4096
DECLARE @BASELINE_TOCS_ABOVE		INT = 0x2000 --    		8192
DECLARE @UAClientID		INT = 2	-- Always compute the base line w.r.t to CS
--DECLARE @sideInfo		TABLE (t_tranID int, t_major int, t_minor int, t_spVersionInCache INT, t_spVersionInstalled INT) -- this table is used to save on calculations
-- GET ALL CLIENTS WHOSE BASELINE NEEDS TO BE COMPUTED
IF @inClientID < 0
INSERT INTO #AU_ClientsInfo
SELECT	Id,ReleaseId,SPVersionID,0,@UAClientID,status,0
FROM	APP_Client WITH (NOLOCK) JOIN (select clientID, SPVersionID=MAX(SPVersionID) from SimInstalledPackages NOLOCK where baseline < 0 group by clientId) T ON id = clientID
ELSE
INSERT INTO #AU_ClientsInfo
SELECT	Id,ReleaseId,0,0,@UAClientID,status,0
FROM	APP_Client WITH (NOLOCK)
WHERE	@inClientID = 0 and id > 1 or Id = @inClientID
IF NOT EXISTS (SELECT 1 FROM #AU_ClientsInfo)
GOTO END_HERE
CREATE NONCLUSTERED INDEX AU_ClientsInfo_ClientID_SkipFlag_OperatingSystemID ON #AU_ClientsInfo (ClientID, SkipFlag, UpdateOSID)
CREATE NONCLUSTERED INDEX AU_ClientsInfo_ReleaseID_UpdateOsID ON #AU_ClientsInfo (ReleaseID, UpdateOsID)
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Get UA info', getdate())
  DECLARE  @tmpVar	INTEGER
  DECLARE  @tmpUPDOSID	INTEGER
  DECLARE  @tmpText	VARCHAR(MAX)
  DECLARE  @tmpRelId	INTEGER
  -- 1) TO SET SkipFlag for virtual,pre-conf,NAS or RAC clientS
  UPDATE	#AU_ClientsInfo
  SET		SkipFlag = 1
  WHERE		clientId NOT in (select clientId from simInstalledPackages WITH (NOLOCK))
  -- 2) Update OS ID
  UPDATE	#AU_ClientsInfo
  SET		UpdateOSID = (CASE WHEN releaseId < 15 THEN O.UpdateOSID ELSE O.NewUpdateOSID END)
  FROM		APP_ClientProp P WITH (NOLOCK), PatchUpdateOS O WITH (NOLOCK)
  WHERE		SkipFlag = 0 AND P.componentNameId = ClientID AND P.attrName = 'Binary Set ID' AND P.attrVal = CONVERT(VARCHAR(64),O.BinarySetID)
  UPDATE	#AU_ClientsInfo
  SET		SkipFlag = 2
  WHERE		SkipFlag = 0 AND UpdateOSID = 0
  -- 3) Update SP ID
  UPDATE	#AU_ClientsInfo
  SET		SPVersionID = ISNULL((select MAX(SPVersionID) from SimInstalledPackages P WITH (NOLOCK) where #AU_ClientsInfo.clientId=P.clientID), 0)
  WHERE		SkipFlag = 0 AND SPVersionID = 0
-- IF inClientID IS 2, WE WANT TO UPDATE BASELINE OF CS AND ITS ASSOCIATED CLIENTS.
IF @inClientID = @UAClientID
	DELETE #AU_ClientsInfo WHERE UAClientID <> @UAClientID
-- OKAY WE NOW HAVE ALL THE CLIENTS AND THEIR RESPECTIVE VALID UPDATE-CACHE-AGENT CLIENT IDS
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Get Current Client Status', getdate())
-- FETCH THE CURRENT UPDATE INFO FOR VALID CLIENTS AND SET THEIR BASELINE TO NOTSET (-1)
-- IF APPTYPE SPECIFIED GO PICK ONLY THOSE ROWS
INSERT INTO #AU_ClientsUpdateInfo
SELECT	CI.ClientID, CI.ReleaseID,PI.simPackageID, PI.HighestSP, PI.SpMinorVersion, PSP.transactionId, PI.UPNumber, PI.AdditionalPatches, PI.MissingPatches, @BASELINE_NOT_SET,'','', 0, 0, 0, 0, 0, 0
FROM	#AU_ClientsInfo AS CI JOIN simInstalledPackages AS PI WITH (NOLOCK) ON PI.ClientID = CI.ClientID
JOIN	PatchSPVersion AS PSP  WITH (NOLOCK) ON PI.SPVersionId = PSP.id
WHERE	(@inClientID <= 0 OR @inAppTypeID <= 0) OR PI.simPackageID = @inAppTypeID
-- SPLIT CURRENT CACHE CONTENTS OF ALL VALID CACHES FOR EASIER USE
INSERT INTO #AU_UAMultiCache
SELECT DISTINCT UAClientID,ReleaseID, UpdateOSID,0,'','',0,-1, 0, 0, '',SPVersionID, 0, 0
FROM	#AU_ClientsInfo
WHERE	ReleaseID > 0 AND UpdateOSID > 0
UNION
SELECT DISTINCT C.UAClientID,C.ReleaseID,C.UpdateOSID,PMC.isSPValid,PMC.highestSP,PMC.AddUpdates,0,-1, PMC.TransactionID, PMC.UpdatePackNumber, PMC.UpdatePackFriendlyName,ISNULL((select P.SPVersionID from PatchMultiCache P where P.Id = PMC.CacheID), 0), PMC.CacheID, 1
FROM	#AU_ClientsInfo C
CROSS APPLY dbo.patchGetCacheInfoByLevel(UAClientID, ReleaseID, 0, UpdateOSID, 1) AS PMC
WHERE	C.clientID=@UAClientID
CREATE NONCLUSTERED INDEX AU_UAMultiCache_UAClientID_ReleaseID_UpdateOsID ON #AU_UAMultiCache(UAClientID, ReleaseID, UpdateOsID)
CREATE NONCLUSTERED INDEX AU_UAMultiCache_SP ON #AU_UAMultiCache(SPVersionID)
UPDATE #AU_UAMultiCache
SET	IsValid = PMC.IsSPValid, SP = PMC.HighestSP, AdditionalUpdates = PMC.AddUpdates, SPTranId = PMC.TransactionId, UpdatePackNumber = PMC.UpdatePackNumber, UpdatePackFriendlyName = PMC.UpdatePackFriendlyName, cacheID = PMC.CacheID
FROM #AU_UAMultiCache UAMC
CROSS APPLY dbo.patchGetCacheInfoByLevel(UAMC.UAClientID, UAMC.ReleaseID, UAMC.SPVersionID, UAMC.UpdateOSID, 0) AS PMC
WHERE isCSSide = 0
-- IF UPDATES ARE NOT AVAILABLE IN CACHE FOR A GIVEN RELEASE & UPDATEOSID THEN
-- MARK THAT ROW IN #AU_UAMultiCache TABLE AS VALID BUT EMPTY (NO UPDATES).
UPDATE #AU_UAMultiCache
SET	IsValid = 1, SP = '0', AdditionalUpdates = ''
FROM #AU_UAMultiCache UAMC
WHERE NOT EXISTS ( SELECT 1 FROM dbo.patchGetCacheInfoByLevel(UAMC.UAClientID, UAMC.ReleaseID, UAMC.SPVersionID, UAMC.UpdateOSID, 0))
-- IF SP is 0 mark that row as valid
UPDATE #AU_UAMultiCache SET IsValid = 1 WHERE SP='0'
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Get Multi Cache Info', getdate())
-- For each AdditionalUpdate in patchmulticache, get appType list
  DECLARE GetAddUpdatesCur CURSOR FOR SELECT ID, ReleaseID, UpdateOSID, AdditionalUpdates FROM #AU_UAMultiCache WHERE IsValid = 1 AND LEN(AdditionalUpdates) > 0 AND AdditionalUpdates <> 'none'
  OPEN GetAddUpdatesCur
  FETCH NEXT FROM GetAddUpdatesCur INTO @tmpVar,@tmpRelId,@tmpUPDOSID,@tmpText
  WHILE @@FETCH_STATUS = 0
  BEGIN
	INSERT INTO #AU_PatchList
	SELECT @tmpVar,@tmpRelId,@tmpUPDOSID,0,*,'',0 FROM dbo.SplitIDString(@tmpText)
	FETCH NEXT FROM GetAddUpdatesCur INTO @tmpVar,@tmpRelId,@tmpUPDOSID,@tmpText
  END
  CLOSE GetAddUpdatesCur
  DEALLOCATE GetAddUpdatesCur
  UPDATE #AU_PatchList SET t_patchID = CASE ISNUMERIC(t_patchName) WHEN 1 THEN CONVERT(INT,t_patchName) ELSE 0 END
  -- Get applicable apptype list for each patchid
  UPDATE #AU_PatchList
  SET t_AppTypeList = AppTypeList, t_hasRebootPkg = CASE LEN(P.RebootPkgList) WHEN 0 THEN 0 ELSE 1 END
  FROM PatchINI P WITH (NOLOCK)
  WHERE  ReleaseID = t_RelId AND OSId = t_OSID AND t_patchID > 0 AND P.PatchId = t_patchID
  UPDATE #AU_PatchList
  SET t_AppTypeList = AppTypeList, t_hasRebootPkg = CASE LEN(P.RebootPkgList) WHEN 0 THEN 0 ELSE 1 END
  FROM PatchINI P WITH (NOLOCK)
  WHERE  ReleaseID = t_RelId AND OSId = t_OSID AND t_AppTypeList = '' AND t_patchID = 0 AND P.PatchName like '%' + t_patchName
  -- For each AdditionalUpdate in patchmulticache determine the apptypes that it appies to
  DECLARE GetPkgListForUpdatesCur CURSOR FOR SELECT DISTINCT t_AppTypeList FROM #AU_PatchList
  OPEN GetPkgListForUpdatesCur
  FETCH NEXT FROM GetPkgListForUpdatesCur INTO @tmpText
  WHILE @@FETCH_STATUS = 0
  BEGIN
	INSERT INTO #AU_listIDStrings SELECT @tmpText, *, NULL FROM dbo.SplitIDs(@tmpText)
	FETCH NEXT FROM GetPkgListForUpdatesCur INTO @tmpText
  END
  CLOSE GetPkgListForUpdatesCur
  DEALLOCATE GetPkgListForUpdatesCur
  CREATE NONCLUSTERED INDEX AU_listIDStrings_t_list_t_id ON #AU_listIDStrings(t_id) INCLUDE (t_list)
  INSERT INTO #AU_MCAddUpdates SELECT t_UAID, t_patchId, t_id, t_patchName, t_hasRebootPkg FROM #AU_listIDStrings, #AU_PatchList WHERE t_AppTypeList = t_list
  DROP TABLE #AU_PatchList
  -- UPDATE CACHED SIDE INFO
  UPDATE #AU_UAMultiCache SET SPMinor = P.SPMinor, SPMajor = P.SPMajor FROM PatchSPVersion P WITH (NOLOCK) WHERE P.id = SPVersionID
  UPDATE #AU_ClientsInfo SET SPVersionID = C.SPVersionID FROM #AU_UAMultiCache C WHERE ClientID = @UAClientID AND C.isCSSide = 1
		------ ALL SET. UPDATE THE BASELINE OF ALL CLIENTS	----------
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update Unknown Baseline Status', getdate())
-- SET BASELINE TO NOT_APLICABLE FOR THIRD PARTY PACKAGES
UPDATE #AU_ClientsUpdateInfo SET Baseline = @BASELINE_NOT_APLICABLE
WHERE AppTypeID BETWEEN 6000 AND 7000 AND Baseline = @BASELINE_NOT_SET
-- SET BASELINE TO NOT_APLICABLE FOR SKIPPED CLIENTS
-- SET BASELINE TO UNKNOWN IF CACHE IS NOT in  SYNC WITH CS
-- SET BASELINE TO UNKNOWN IF CACHE IS NOT in  A VALID STATE
UPDATE	#AU_ClientsUpdateInfo
SET	Baseline = (	CASE	WHEN SkipFlag = 1 THEN @BASELINE_NOT_APLICABLE
				WHEN EXISTS (SELECT id FROM #AU_UAMultiCache M WHERE C.UAClientID = M.UAClientID AND C.ReleaseID = M.ReleaseID AND C.UpdateOSID = M.UpdateOSID AND M.IsValid = 0) THEN @BASELINE_UNKNOWN
			ELSE Baseline END)
FROM	#AU_ClientsInfo C
WHERE	Baseline = @BASELINE_NOT_SET AND CID = C.ClientID
 CREATE NONCLUSTERED INDEX AU_ClientsUpdateInfo_Baseline_CID ON #AU_ClientsUpdateInfo(Baseline,CID)
 SET @tmpText	= '' -- will hold installed additional updates
 SET @tmpUPDOSID = 0
 SET @tmpRelId = 0
 -- OKAY, NOW ITERATE THROUGH EACH APPTYPE AND COMPUTE ITS BASELINE
--**************Compare with its own side
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update SP in Cache', getdate())
-- UPDATE SP IN CACHE INFO
UPDATE	#AU_ClientsUpdateInfo
SET	cacheSPMajor = CACHE.SPMajor, cacheSPMinor = CACHE.SPMinor, cacheSPTranId = CACHE.SPTranId, cacheUpdatePackNumber = CACHE.UpdatePackNumber, bAddUpdatesCached = (CASE WHEN LEN(AdditionalUpdates) > 0 AND AdditionalUpdates <> 'None' THEN 1 ELSE 0 END), UAMultiCacheId = CACHE.id
FROM	#AU_ClientsInfo CLIENT, #AU_UAMultiCache CACHE
WHERE	Baseline = @BASELINE_NOT_SET AND CID = CLIENT.ClientID AND CLIENT.SkipFlag = 0 AND
	CLIENT.UAClientID = CACHE.UAClientID AND CLIENT.ReleaseID = CACHE.ReleaseID AND CLIENT.SPVersionID = CACHE.SPVersionID AND CLIENT.UpdateOSID = CACHE.UpdateOSID AND CACHE.IsValid = 1
-- CURSOR TO COMPUTE AND UPDATE BASELINE OF ALL CLIENTS
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Compute Baseline', getdate())
TRUNCATE TABLE #AU_listIDStrings
DECLARE GetAdditionalUpdatesInstalledCur CURSOR FOR
  SELECT DISTINCT InstAddUpdates FROM #AU_ClientsUpdateInfo
  WHERE Baseline = @BASELINE_NOT_SET AND CID IN (select T.clientId from #AU_ClientsInfo T where T.SkipFlag = 0) AND LEN(InstAddUpdates) > 0 AND InstAddUpdates <> 'None'
OPEN GetAdditionalUpdatesInstalledCur
FETCH NEXT FROM GetAdditionalUpdatesInstalledCur INTO @tmpText
WHILE @@FETCH_STATUS = 0
  BEGIN
	INSERT INTO #AU_listIDStrings SELECT @tmpText, 0, * FROM dbo.SplitIDString(@tmpText)
	FETCH NEXT FROM GetAdditionalUpdatesInstalledCur INTO @tmpText
  END
CLOSE GetAdditionalUpdatesInstalledCur
DEALLOCATE GetAdditionalUpdatesInstalledCur
UPDATE #AU_listIDStrings SET t_Id = CAST(t_String AS INT) WHERE ISNUMERIC(t_String) > 0
INSERT INTO #tempServicePackStrings
SELECT DISTINCT InstSPMajor, InstSPMinor, dbo.GetServicePackStr(InstSPMajor, InstSPMinor)
FROM #AU_ClientsUpdateInfo
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update Diag Baseline Status', getdate())
-- IF Diag is installed, SET baseline = 16 , For the 9.0 and older release clients 'Has diag' will take the precedence as the user should manually uninstall diag and install the available patches
UPDATE #AU_ClientsUpdateInfo
SET	Baseline	= @BASELINE_HAS_DIAG,
	BaselineSP	= CASE WHEN InstSPMajor > 0 THEN spstr.spString ELSE '' END
FROM #AU_ClientsUpdateInfo cui
JOIN #AU_listIDStrings idstr ON cui.InstAddUpdates = idstr.t_list
JOIN #tempServicePackStrings spstr ON cui.InstSPMajor = spstr.major AND cui.InstSPMinor = spstr.minor
WHERE	Baseline = @BASELINE_NOT_SET AND ReleaseId < 15 AND t_id = 0 AND LEN(t_String) > 0
UPDATE #AU_ClientsUpdateInfo
SET BaselineUpdates = ISNULL(replace((SELECT DISTINCT t_String AS [data()] FROM #AU_listIDStrings WHERE InstAddUpdates = t_list AND t_id = 0 AND LEN(t_String) > 0 FOR xml path('')), ' ', ', '), '')
WHERE Baseline = @BASELINE_HAS_DIAG
INSERT INTO #tempServicePackStrings
SELECT CacheSPMajor, CacheSPMinor, dbo.GetServicePackStr(CacheSPMajor, CacheSPMinor)
FROM #AU_ClientsUpdateInfo
EXCEPT
SELECT major, minor, spstring
FROM #tempServicePackStrings
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update No update in Cache', getdate())
-- IF NO UPDATES IN CACHE
-- if installed major > 0, baselineSP = installed major + minor
-- -- if no diag, baseline = ABOVE_BASELINE (4)
-- if additional updates installed & no diag, baseline = ABOVE_BASELINE (4), baselineUpdate = additional updates
-- if baseline not set, baseline = MATCH_BASELINE (1)
UPDATE #AU_ClientsUpdateInfo
SET	Baseline	= @BASELINE_UNKNOWN,
	BaselineSP	= (CASE WHEN InstSPMajor > 0 THEN spstr.spString ELSE '' END),
	BaselineUpdates	= (CASE	WHEN LEN(InstAddUpdates) > 0 AND InstAddUpdates <> 'None' THEN InstAddUpdates ELSE '' END)
FROM #AU_ClientsUpdateInfo cui
JOIN #tempServicePackStrings spstr ON cui.InstSPMajor = spstr.major AND cui.InstSPMinor = spstr.minor
WHERE	Baseline = @BASELINE_NOT_SET AND cacheSPTranId = 0
INSERT INTO #tempCacheLevelComparison
SELECT 	cui.CID,
		MIN(dbo.CompareServicePackLevel(InstSPMajor, InstSPMinor, InstSPTranID, cacheSPMajor, cacheSPMinor, cacheSPTranID)) AS spCompareVal,
		MIN(CASE
			WHEN cui.InstUpdatePackNumber < cui.cacheUpdatePackNumber THEN -1
			WHEN cui.InstUpdatePackNumber > cui.cacheUpdatePackNumber THEN 1
			ELSE 0
		END) AS upCompareVal
FROM #AU_ClientsUpdateInfo cui
GROUP BY cui.CID
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update detailed Baseline Status', getdate())
-- if major installed > major in cache: baseline = ABOVE_BASELINE (4), baselineSP = installed major + minor
-- else if major installed < major in cache: baseline = BELOW_BASELINE (2), baselineSP = cached major + minor,
-- else (if major installed = major in cache):
-- -- if minor installed > minor incahe: baseline = ABOVE_BASELINE (4), baselineSP = installed major + minor
-- -- else if minor installed < minor incahe: baseline = BELOW_BASELINE (2), baselineSP = cached major + minor
-- -- else if major installed = major in cache:
-- -- -- if missing patches are installed: baseline = BELOW_BASELINE (2), baselineUpdate = missing updates
-- -- -- else if no addtional updates in cache)
-- -- -- -- if additional updates are installed on client: baseline = ABOVE_BASELINE (4), baselineUpdate = additional updates
-- -- -- -- else: baseline = MATCH_BASELINE (1)
UPDATE #AU_ClientsUpdateInfo
SET	Baseline	= (CASE	clc.spCompareVal
					WHEN  1 THEN @BASELINE_ABOVE
					WHEN -1 THEN @BASELINE_BELOW
					ELSE
						(CASE clc.upCompareVal
						WHEN  1 THEN @BASELINE_ABOVE
						WHEN -1 THEN @BASELINE_BELOW
						ELSE
							(CASE
								WHEN LEN(MissingUpdates) > 0 AND MissingUpdates <> 'None' THEN @BASELINE_BELOW
								WHEN bAddUpdatesCached > 0 THEN Baseline
								WHEN LEN(InstAddUpdates) > 0 AND InstAddUpdates <> 'None' THEN @BASELINE_ABOVE
								ELSE @BASELINE_MATCH
							END)
						END)
					END),
	BaselineSP	= (CASE
					WHEN clc.spCompareVal = 0 AND clc.upCompareVal = 0 THEN ''
					WHEN clc.spCompareVal = 1 OR clc.spCompareVal = 0 AND clc.upCompareVal = 1 THEN
(CASE WHEN ReleaseID <= 15 THEN spstr.spString
							 WHEN InstUpdatePackNumber = 0 THEN spstr.spString + ' (Build ' + CONVERT(VARCHAR(16), InstSPTranID) + ')'
							 ELSE spstr.spString + '.' + CONVERT(VARCHAR(16), InstUpdatePackNumber)
						END)
					WHEN clc.spCompareVal = -1 OR clc.spCompareVal = 0 AND clc.upCompareVal = -1 THEN
(CASE WHEN ReleaseID <= 15 THEN cachespstr.spString
							 WHEN cacheUpdatePackNumber = 0 THEN cachespstr.spString + ' (Build ' + CONVERT(VARCHAR(16), cacheSPTranID) + ')'
							 ELSE cachespstr.spString + '.' + CONVERT(VARCHAR(16), cacheUpdatePackNumber)
						END)
					END),
	BaselineUpdates	= (CASE
						WHEN clc.spCompareVal = 0 and clc.upCompareVal = 0 THEN
							 (CASE
								WHEN LEN(MissingUpdates) > 0 AND MissingUpdates <> 'None' THEN MissingUpdates
								WHEN (LEN(MissingUpdates) = 0 OR MissingUpdates = 'None') AND bAddUpdatesCached = 0 AND (LEN(InstAddUpdates) > 0 AND InstAddUpdates <> 'None') THEN InstAddUpdates
								ELSE ''
							  END)
						ELSE ''
					   END)
FROM #AU_ClientsUpdateInfo cui
JOIN #tempCacheLevelComparison clc ON cui.CID = clc.clientID
JOIN #tempServicePackStrings spstr ON cui.InstSPMajor = spstr.major AND cui.InstSPMinor = spstr.minor
JOIN #tempServicePackStrings cachespstr ON cui.cacheSPMajor = cachespstr.major AND cui.cacheSPMinor = cachespstr.minor
WHERE	Baseline = @BASELINE_NOT_SET
-- get SP list from PatchINI table
DECLARE GetPatchINISPs CURSOR FOR
	SELECT DISTINCT ServicePacks FROM PatchINI WITH(NOLOCK)	WHERE Servicepacks IS NOT null AND LEN(Servicepacks) > 0
OPEN GetPatchINISPs
FETCH NEXT FROM GetPatchINISPs INTO @tmpText
WHILE @@FETCH_STATUS = 0
BEGIN
	INSERT INTO #AU_spList SELECT @tmpText, *, 0, 0 FROM dbo.SplitIDString(@tmpText)
	FETCH NEXT FROM GetPatchINISPs INTO @tmpText
END
CLOSE GetPatchINISPs
DEALLOCATE GetPatchINISPs
--INSERT INTO @SPInfo SELECT DISTINCT t_name, spNum.major, spNum.minor FROM #AU_spList CROSS APPLY dbo.GetServicePackNumbers(t_name) as spNum WHERE t_name NOT IN (select t_sp from @SPInfo)
-- table variable used in later blocks
-- Add installed Updates for those who is below SP
IF @showExtraUpdates = 1
BEGIN
	IF EXISTS (select 1 from #AU_ClientsUpdateInfo where Baseline = @BASELINE_BELOW)
	BEGIN
		INSERT INTO #tempCachedAddUpdateInfo
		SELECT	UI.CID, UI.AppTypeID, CI.ReleaseID, CI.UpdateOSID, MC.PatchID, MC.PatchIDStr,
			spstr.spString,
			UI.InstSPMajor, UI.InstSPMinor, 0, UI.cacheSPMajor, UI.cacheSPMinor, 0, MC.hasRebootPkg
		FROM	#AU_ClientsUpdateInfo UI
							JOIN #AU_ClientsInfo CI		ON UI.CID = CI.ClientID
							JOIN #AU_MCAddUpdates MC	ON  UI.appTypeID = MC.appTypeId AND UI.UAMultiCacheId = MC.id
							JOIN #tempServicePackStrings spstr ON UI.cacheSPMajor = spstr.major AND UI.cacheSPMinor = spstr.minor
		WHERE	UI.Baseline = @BASELINE_BELOW
		CREATE NONCLUSTERED INDEX tCachedAddUpdateInfoIdx1 on #tempCachedAddUpdateInfo (t_clientID, t_appTypeId)
		CREATE NONCLUSTERED INDEX tCachedAddUpdateInfoIdx2 on #tempCachedAddUpdateInfo (t_relId, t_OSId, t_patchID)
		-- SKIP the updates already in SP cache
		DELETE	#tempCachedAddUpdateInfo
		FROM	PatchINI WITH(NOLOCK) JOIN #AU_spList ON ServicePacks = t_SPs AND t_SPs <> '0'
		WHERE   releaseId = t_relId AND OSId = t_OSId AND patchId = t_patchID AND t_SPInCache=t_name
		IF @bDebug > 0	INSERT INTO @tracking VALUES ('Obsoletes', getdate())
		INSERT INTO #tempAddUpdateTbl
		SELECT	CID, AppTypeID, @BASELINE_BELOW, t_patchIDString, t_hasRebootPkg
		FROM	#AU_ClientsUpdateInfo, #tempCachedAddUpdateInfo
		WHERE	Baseline = @BASELINE_BELOW AND CID = t_clientId AND AppTypeID = t_appTypeId AND
			NOT EXISTS( SELECT * FROM #AU_listIDStrings S WHERE InstAddUpdates = S.t_list AND S.t_string = t_patchIDString)
		UPDATE #AU_ClientsUpdateInfo
		SET	BaselineUpdates = ISNULL(replace((	SELECT DISTINCT A2.t_patch AS [data()] FROM #tempAddUpdateTbl A2
								WHERE CID = A2.t_clientId AND AppTypeID = A2.t_appTypeId AND A2.t_baseline = A1.t_baseline FOR xml path('')), ' ', ', '), '')
		FROM	#tempAddUpdateTbl A1
		WHERE	Baseline = @BASELINE_BELOW AND CID = t_clientId AND AppTypeID = t_appTypeId AND t_baseline = @BASELINE_BELOW
		DELETE #tempAddUpdateTbl
		DELETE #tempCachedAddUpdateInfo
	END
END
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update Baseline Status When Both Installed & Cached SP Match', getdate())
-- When both installed and cached SP match, also no missing updates on clients, skip the following obsolete updates which are additional in cache
-- -- 1) If higher update is also in the additional updates cache
-- -- 2) If higher update is installed on the client as loose patch
-- -- 3) If higher update is present in the servicePack and it is in the cache
-- -- 4) If higher update is present in the servicePack and it is installed on the client
-- IF there are addtional updates in cache not installed on clients: baseline = BELOW_BASELINE (2), baselineUpdate = additional updates in cache but not installed on client
-- ELSE IF there are addtional updates installed on clients but not in cache: baseline = ABOVE_BASELINE (4), baselineUpdate = additional updates installed on client but not in cache
-- ELSE: baseline = MATCH_BASELINE (1)
IF EXISTS (select 1 from #AU_ClientsUpdateInfo where Baseline = @BASELINE_NOT_SET)
BEGIN
	INSERT INTO #tempCachedAddUpdateInfo
	SELECT	UI.CID, UI.AppTypeID, CI.ReleaseID, CI.UpdateOSID, MC.PatchID, MC.PatchIDStr, spstr.spString,
		UI.InstSPMajor, UI.InstSPMinor, 0, UI.cacheSPMajor, UI.cacheSPMinor, 0, MC.hasRebootPkg
	FROM #AU_ClientsUpdateInfo UI
	JOIN #AU_ClientsInfo CI		ON UI.CID = CI.ClientID
	JOIN #AU_MCAddUpdates MC	ON  UI.appTypeID = MC.appTypeId AND UI.UAMultiCacheId = MC.id
	JOIN #tempServicePackStrings spstr ON UI.cacheSPMajor = spstr.major AND UI.cacheSPMinor = spstr.minor
	WHERE	UI.Baseline = @BASELINE_NOT_SET
	-- SKIP the updates already in SP cache
	DELETE	#tempCachedAddUpdateInfo
	FROM	PatchINI WITH(NOLOCK) JOIN #AU_spList ON ServicePacks = t_SPs AND t_SPs <> '0'
	WHERE   releaseId = t_relId AND OSId = t_OSId AND patchId = t_patchID AND t_SPInCache=t_name
	-- UPDATE BASELINE
	IF @bDebug > 0	INSERT INTO @tracking VALUES ('UPDATE BASELINE', getdate())
	INSERT INTO #tempAddUpdateTbl
	SELECT	CID, AppTypeID, @BASELINE_BELOW, t_patchIDString, t_hasRebootPkg
	FROM	#AU_ClientsUpdateInfo, #tempCachedAddUpdateInfo
	WHERE	Baseline = @BASELINE_NOT_SET AND CID = t_clientId AND AppTypeID = t_appTypeId AND
		NOT EXISTS( SELECT 1 FROM #AU_listIDStrings S WHERE InstAddUpdates = S.t_list AND S.t_string = t_patchIDString)
	UNION
	SELECT	CID, AppTypeID, @BASELINE_ABOVE, t_string, 0
	FROM	#AU_ClientsUpdateInfo, #AU_listIDStrings S
	WHERE	Baseline = @BASELINE_NOT_SET AND InstAddUpdates = S.t_list AND
		NOT EXISTS( SELECT 1 FROM #tempCachedAddUpdateInfo  C WHERE CID = C.t_clientId AND AppTypeID = C.t_appTypeId  AND S.t_string = C.t_patchIDString)
	CREATE NONCLUSTERED INDEX tAddUpdateTblIndex ON #tempAddUpdateTbl (t_clientId, t_appTypeId)
	IF @bDebug > 0	INSERT INTO @tracking VALUES ('Got additional updates', getdate())
	UPDATE #AU_ClientsUpdateInfo
	SET	Baseline = t_baseline,
		BaselineUpdates = ISNULL(replace((	SELECT DISTINCT A2.t_patch AS [data()] FROM #tempAddUpdateTbl A2
							WHERE CID = A2.t_clientId AND AppTypeID = A2.t_appTypeId AND A2.t_baseline = A1.t_baseline FOR xml path('')), ' ', ', '), '')
	FROM	#tempAddUpdateTbl A1
	WHERE	Baseline = @BASELINE_NOT_SET AND CID = t_clientId AND AppTypeID = t_appTypeId AND t_baseline IN (@BASELINE_BELOW, @BASELINE_ABOVE)
	UPDATE #AU_ClientsUpdateInfo
	SET	Baseline = @BASELINE_MATCH, BaselineUpdates = ''
	WHERE	Baseline = @BASELINE_NOT_SET AND NOT EXISTS (SELECT * FROM #tempAddUpdateTbl WHERE CID = t_clientId AND AppTypeID = t_appTypeId)
END
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update Remaining Baseline Status', getdate())
--In case we missed out a few clients.
UPDATE #AU_ClientsUpdateInfo SET Baseline = @BASELINE_UNKNOWN, BaselineSP = '', BaselineUpdates = ''
WHERE Baseline  = @BASELINE_NOT_SET
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Update Status for Clients above Baseline & Valid', getdate())
INSERT INTO #AU_aboveBaselineClients
SELECT ACU.CID,ACU.AppTypeID,ACU.InstSPMajor,ACU.InstSPMinor,ACU.BaselineUpdates,AC.UpdateOSID, AC.ReleaseID
FROM #AU_ClientsUpdateInfo ACU JOIN #AU_ClientsInfo AC ON ACU.CId = AC.ClientID WHERE AC.SkipFlag = 0 AND ACU.Baseline = @BASELINE_ABOVE AND ACU.InstSPMajor > 0
-- Fetch those clients that are above base line & valid.
IF EXISTS (select t_cid from #AU_aboveBaselineClients)
BEGIN
	DECLARE	@validBaselineUpdates TABLE (tt_relID INT, tt_OSId INT, tt_cid INT, tt_appTypeID INT, tt_instSPMaj INT, tt_instSPMin INT, tt_patchId INT, tt_patchName varchar(MAX))
	TRUNCATE TABLE #AU_listIDStrings
	DECLARE GetBaselineUpdates CURSOR FOR SELECT DISTINCT t_BaselineUpdates FROM #AU_aboveBaselineClients
	OPEN GetBaselineUpdates
	FETCH NEXT FROM GetBaselineUpdates INTO @tmpText
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #AU_listIDStrings SELECT @tmpText, 0, * FROM dbo.SplitIDString(@tmpText)
		FETCH NEXT FROM GetBaselineUpdates INTO @tmpText
	END
	CLOSE GetBaselineUpdates
	DEALLOCATE GetBaselineUpdates
	UPDATE #AU_listIDStrings SET t_ID = CAST(t_String AS INT) WHERE ISNUMERIC(t_String) > 0
	INSERT INTO @validBaselineUpdates
	SELECT	t_relID, t_OSId, t_cid, t_AppTypeID, t_instSPMaj, t_instSPMin, t_id, t_string
	FROM	#AU_aboveBaselineClients, #AU_listIDStrings
	WHERE	t_BaselineUpdates = t_list
	--UPDATE #AU_spList SET t_SPMinor = t_Minor, t_SPMajor = t_Major FROM @SPInfo WHERE t_SP = t_name
	DELETE	@validBaselineUpdates
	WHERE	EXISTS (SELECT 1 FROM PatchINI WITH(NOLOCK) JOIN #AU_spList ON ServicePacks = t_SPs
			WHERE ReleaseId = tt_relID AND OSId = tt_OSId AND PatchID = tt_patchId AND
			t_SPMajor > 0 AND (tt_instSPMaj > t_SPMajor OR (tt_instSPMaj = t_SPMajor AND tt_instSPMin > t_SPMinor)))
	UPDATE #AU_aboveBaselineClients
	SET t_BaselineUpdates = ISNULL(replace((SELECT DISTINCT tt_patchName AS [data()] FROM @validBaselineUpdates WHERE t_cid = tt_cid AND t_appTypeID = tt_appTypeID FOR xml path('')), ' ', ', '), '')
	UPDATE #AU_ClientsUpdateInfo
	SET	BaselineUpdates = t_BaselineUpdates, Baseline = (CASE WHEN LEN(t_BaselineUpdates) = 0 AND BaselineSP like '' THEN 1 ELSE Baseline END)
	FROM	#AU_aboveBaselineClients
	WHERE	CID = t_cid AND AppTypeID = t_appTypeID
END
--
--Update baseline with CS comparing
DECLARE @CSLevelTranIDInstalled INT = ISNULL((select TOP 1 InstSPTranId from #AU_ClientsUpdateInfo where cid=@UAClientID), 0)
IF @CSLevelTranIDInstalled = 0
	SELECT @CSLevelTranIDInstalled = MAX(TransactionID) FROM PatchSPVersion WITH (NOLOCK)
	WHERE TransactionID IN (select TransactionID from PatchSPVersion V1 WITH (NOLOCK) JOIN PatchMultiCache C WITH (NOLOCK) ON C.OSId=3 and C.releaseId = 16 and C.SPVersionID = V1.id)
		AND TransactionID IN (select TransactionID from PatchSPVersion V2 WITH (NOLOCK) JOIN SiminstalledPackages P WITH (NOLOCK) ON P.clientID = @UAClientID and P.SPVersionID = V2.id)
UPDATE #AU_ClientsUpdateInfo
SET Baseline = CASE	WHEN releaseID < 16 OR instSPTranID < @CSLevelTranIDInstalled THEN Baseline | @BASELINE_TOCS_BELOW
			WHEN instSPTranID > @CSLevelTranIDInstalled THEN Baseline | @BASELINE_TOCS_ABOVE
			ELSE Baseline END
DROP TABLE #AU_ClientsInfo
DROP TABLE #AU_MCAddUpdates
DROP TABLE #AU_UAMultiCache
DROP TABLE #AU_listIDStrings
DROP TABLE #AU_spList
DROP TABLE #AU_aboveBaselineClients
DROP TABLE #tempServicePackStrings
DROP TABLE #tempCacheLevelComparison
DROP TABLE #tempAddUpdateTbl
DROP TABLE #tempCachedAddUpdateInfo
END_HERE:
BUILD_XML:
IF @bDebug > 0	INSERT INTO @tracking VALUES ('Generate output XML', getdate())
SELECT	@inClientID AS '@clientId',
		-- installed updates
		(
			SELECT	A.AppTypeID AS '@simPackageId',
					S.Name AS '@simPackageName',
					A.Baseline AS '@baseline',
			(
				SELECT A.InstSPMajor AS '@Major',
					   A.InstSPMinor AS '@Minor',
					   A.InstSPTranId AS '@TransactionId'
				FOR XML PATH('servicePackInDB'), TYPE
			),
			(
				SELECT A.InstUpdatePackNumber AS '@Number'
				FOR XML PATH('updatePackInDB'), TYPE
			),
			(
				SELECT _ID AS '@patchName'
				FROM #AU_ClientsUpdateInfo B CROSS APPLY dbo.SplitStringByDelimiter(B.InstAddUpdates, ',')
				WHERE B.AppTypeID = A.AppTypeID
				FOR XML PATH('updateGroup'), TYPE
			)
			FROM #AU_ClientsUpdateInfo A JOIN simPackage S on A.AppTypeID = S.id
			FOR XML PATH('installedPatchesInfo'), TYPE
		),
		-- missing updates (for v10-)
		(
			SELECT A.AppTypeID AS '@simPackageId',
			(
				SELECT _ID AS '@patchName'
				FROM #AU_ClientsUpdateInfo B CROSS APPLY dbo.SplitStringByDelimiter(B.MissingUpdates, ',')
				WHERE B.AppTypeID = A.AppTypeID
				FOR XML PATH('updateGroup'), TYPE
			)
			FROM #AU_ClientsUpdateInfo A
			FOR XML PATH('missingPatchesInfo'), TYPE
		),
		-- needed updates
		(
			SELECT A.AppTypeID AS '@simPackageId',
			(
				SELECT _ID AS '@patchName'
				FROM #AU_ClientsUpdateInfo B CROSS APPLY dbo.SplitStringByDelimiter(B.BaselineUpdates, ',')
WHERE B.AppTypeID = A.AppTypeID AND (B.Baseline & 2) > 0
				FOR XML PATH('updateGroup'), TYPE
			)
			FROM #AU_ClientsUpdateInfo A
			FOR XML PATH('neededPatchesInfo'), TYPE
		)
FOR XML PATH('UpdatePatches_BaselineInfoResp')
DROP TABLE #AU_ClientsUpdateInfo
IF @bDebug > 0
BEGIN
	INSERT INTO @tracking VALUES ('END', getdate())
	SELECT * from @tracking
END
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchGetBaseline')
	delete from GxQscripts where name = 'PatchGetBaseline'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchGetBaseline')
	delete from GXDBVersions where aliasname = 'PatchGetBaseline'
GO

insert into GXDBVersions values(2, 'PatchGetBaseline',  '00010001000200090000', 'PatchGetBaseline', '00010001000200090000')
GO

