

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PatchCleanCacheEntries.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2017  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/PatchCleanCacheEntries.sp,v $ $Id: PatchCleanCacheEntries.sp,v 1.1.2.7 2020/05/01 18:11:08 kgao Exp $";
--  +========================================================================+
--  | Stored Proc: patchCleanCacheEntries()
--  |
--  | Description: Cleans cache entries for a given update agent, osid, and
--	|			   release ID. The mapping tables for cache entries are also
--	|			   cleared.
--	|
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='patchCleanCacheEntries')
BEGIN
	print '>>> Drop Stored Procedure: patchCleanCacheEntries <<<'
	drop procedure patchCleanCacheEntries
END
IF EXISTS (select * from GxQscripts where name='patchCleanCacheEntries')
	delete from GxQscripts where name = 'patchCleanCacheEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='patchCleanCacheEntries')
	delete from GXDBVersions where aliasname = 'patchCleanCacheEntries'
GO
print '... Creating Procedure: patchCleanCacheEntries'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure patchCleanCacheEntries
  @isListBased int,
  @updateAgentId int,
  @cacheIdList varchar(MAX) = '',
  @osId int=0,
  @spVersionId int=0
AS
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
DECLARE @cacheIDs TABLE(Id INT)
DECLARE @CUIDs TABLE(Num INT)
SET NOCOUNT ON
IF @isListBased = 0
	INSERT INTO @cacheIDs
	SELECT ID FROM PatchMultiCache WITH(NOLOCK)
	WHERE ((@updateAgentId = 0 AND ClientId IN (SELECT PUA.clientId
												FROM PatchUpdateAgentInfo PUA
												WHERE isEnabled = 1 AND isDeleted = 0 and ClientId <> 2 ))
	OR (@updateAgentId > 0 AND ClientId = @updateAgentId))
	AND((@osid = 0)
	OR (@osid >0 AND OSId = @osid))
	AND((@spVersionId = 0)
	OR (@spVersionId >0 AND SPVersionID = @spVersionId))
ELSE
	INSERT INTO @cacheIDs
	SELECT _ID FROM dbo.SplitIDs(@cacheIdList)
INSERT INTO @CUIDs
SELECT UpdatePackID FROM PatchCacheUpdatePackMap WITH(NOLOCK) WHERE CacheID IN (SELECT Id FROM @cacheIDs)
-- delete all updates if it is for CS cache
IF @updateAgentId = 2
	DELETE PatchUpdatePackPatchesMap
-- delete all CUs
DELETE PatchCacheUpdatePackMap
WHERE CacheID IN (SELECT Id FROM @cacheIDs)
-- delete all DVD level updates
DELETE PatchUpdatePackageMap
FROM PatchUpdatePackageMap pup
JOIN PatchCacheUpdateMap pcu WITH(NOLOCK) ON pup.UpdateID = pcu.UpdateID
JOIN PatchMultiCache pmc WITH(NOLOCK) ON pcu.CacheID = pmc.ID
AND pmc.id IN (SELECT id FROM @cacheIDs)
DELETE FROM PatchCachePackageMap WHERE CacheID IN (SELECT id FROM @cacheIDs)
DELETE FROM PatchCacheUpdateMap WHERE CacheID IN (SELECT id FROM @cacheIDs)
DELETE FROM PatchMultiCache WHERE id IN (SELECT id FROM @cacheIDs)
SET NOCOUNT OFF
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'PatchCleanCacheEntries')
	delete from GxQscripts where name = 'PatchCleanCacheEntries'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PatchCleanCacheEntries')
	delete from GXDBVersions where aliasname = 'PatchCleanCacheEntries'
GO

insert into GXDBVersions values(2, 'PatchCleanCacheEntries',  '00010001000200070000', 'PatchCleanCacheEntries', '00010001000200070000')
GO

