

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PSTArch_UserMachineAssoc.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  PSTArch_UserMachineAssoc()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Manas Mutha   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PSTArch_UserMachineAssoc <<<'

IF EXISTS (select * from sysobjects where name='PSTArch_UserMachineAssoc')
	drop procedure PSTArch_UserMachineAssoc
IF EXISTS (select * from GxQscripts where name='PSTArch_UserMachineAssoc')
	delete from GxQscripts where name = 'PSTArch_UserMachineAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PSTArch_UserMachineAssoc')
	delete from GXDBVersions where aliasname = 'PSTArch_UserMachineAssoc'
GO
print '... Creating Procedure: PSTArch_UserMachineAssoc'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PSTArch_UserMachineAssoc
  @inXml XML
AS
  DECLARE @outXml XML
SET NOCOUNT ON
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
declare @inClientID int
declare @inUserGUID varchar(128)
declare @inMode int
SET @inMode = ISNULL (( SELECT ref.value('@Mode', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_UserMachineAssocReq') R(ref)), 0)
if @inMode = 0
	begin
		set @outXml = ''
	end
else if @inMode = 1		--Set values
-- TODO: Return the USERAssociation id so that it can be used by the caller if needed.
	begin
		SET @inClientID = ISNULL (( SELECT ref.value('@ClientId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_UserMachineAssocReq/UserMachineAssocInInfo') R(ref)), 0)
		SET @inUserGUID = ISNULL (( SELECT ref.value('@UserGUID', 'varchar(128)')FROM @inXMl.nodes('App_PSTArch_UserMachineAssocReq/UserMachineAssocInInfo') R(ref)), 0)
		insert into APP_PSTArch_UserMachineAssoc (ClientId,UserGuid) values (@inClientID, @inUserGUID)
		set @outXml = (
			select 1 AS '@result'
			FOR XML PATH('App_PSTArch_UserMachineAssocResp'))
	end
else if @inMode = 2		--Get details given the ClientID
	begin
		SET @inClientID = ISNULL (( SELECT ref.value('@ClientId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_UserMachineAssocReq/UserMachineAssocInInfo') R(ref)), 0)
		set @outXml = (
			select Id As '@UserMachineAssocId',
				   UserGuid AS '@UserGUID',
				   ClientId AS '@ClientId'
			from APP_PSTArch_UserMachineAssoc
			where ClientId = @inClientID
			FOR XML PATH('UserMachineAssocOutInfo'), ROOT('App_PSTArch_UserMachineAssocResp')
			)
		if @outXml IS NULL
			set @outXml = '<App_PSTArch_UserMachineAssocResp />'
	end
else if @inMode = 3		--Get details given the UserGUID
	begin
		SET @inUserGUID = ISNULL (( SELECT ref.value('@UserGUID', 'varchar(128)')FROM @inXMl.nodes('App_PSTArch_UserMachineAssocReq/UserMachineAssocInInfo') R(ref)), 0)
		set @outXml = (
			select Id As '@UserMachineAssocId',
				   ClientId AS '@ClientId',
				   UserGuid AS '@UserGUID'
			from APP_PSTArch_UserMachineAssoc
			where UserGuid = @inUserGUID
			FOR XML PATH('UserMachineAssocOutInfo'), ROOT('App_PSTArch_UserMachineAssocResp')
			)
		if @outXml IS NULL
			set @outXml = '<App_PSTArch_UserMachineAssocResp />'
	end
COMMIT TRAN
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	set @outXml = ''
	ROLLBACK TRANSACTION
END CATCH;
select @outXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PSTArch_UserMachineAssoc')
	delete from GxQscripts where name = 'PSTArch_UserMachineAssoc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PSTArch_UserMachineAssoc')
	delete from GXDBVersions where aliasname = 'PSTArch_UserMachineAssoc'
GO

insert into GXDBVersions values(2, 'PSTArch_UserMachineAssoc',  '00000000000000000000', 'PSTArch_UserMachineAssoc', '00000000000000000000')
GO

