

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PSTArch_StagedFileList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  PSTArch_StagedFileList()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Manas Mutha   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PSTArch_StagedFileList <<<'

IF EXISTS (select * from sysobjects where name='PSTArch_StagedFileList')
	drop procedure PSTArch_StagedFileList
IF EXISTS (select * from GxQscripts where name='PSTArch_StagedFileList')
	delete from GxQscripts where name = 'PSTArch_StagedFileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PSTArch_StagedFileList')
	delete from GXDBVersions where aliasname = 'PSTArch_StagedFileList'
GO
print '... Creating Procedure: PSTArch_StagedFileList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PSTArch_StagedFileList
  @inXml XML
AS
  DECLARE @outXml XML
SET NOCOUNT ON
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
declare @inMode int
declare @StagedPSTId int
declare @inPSTId int
declare @inExtractedFilePath nvarchar(255)
declare @inStagedPSTFilePath nvarchar(255)
declare @inState int
declare @inErrorCode int
declare @inExtractedTime int
declare @inStagedTime int
declare @inDeletedTime int
declare @inStagedPstFileSize int
declare @inNumOfMessages int
declare @inEstArchivingTime int
declare @inLastJobId int
declare @inStagingTime int
SET @inMode = ISNULL (( SELECT ref.value('@Mode', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq') R(ref)), 0)
if @inMode = 0
	begin
		set @outXml = ''
	end
else if @inMode = 1		--Set values
	begin
		SET @inPSTId = ISNULL (( SELECT ref.value('@PSTFileId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inExtractedFilePath = ISNULL (( SELECT ref.value('@ExtractedFilePath', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inStagedPSTFilePath = ISNULL (( SELECT ref.value('@StagedPSTFilePath', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inState = ISNULL (( SELECT ref.value('@State', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inErrorCode = ISNULL (( SELECT ref.value('@ErrorCode', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inExtractedTime = ISNULL (( SELECT ref.value('@ExtractedTime', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inStagedTime = ISNULL (( SELECT ref.value('@StagedTime', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inDeletedTime = ISNULL (( SELECT ref.value('@DeletedTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inStagedPstFileSize = ISNULL (( SELECT ref.value('@StagedPstFileSize', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inNumOfMessages = ISNULL (( SELECT ref.value('@NumOfMessages', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inEstArchivingTime = ISNULL (( SELECT ref.value('@EstArchivingTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inLastJobId = ISNULL (( SELECT ref.value('@LastJobId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inStagingTime = ISNULL (( SELECT ref.value('@StagingTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		set @StagedPSTId = (SELECT StagedPSTId as '@StagedPSTId'
						FROM APP_PSTArch_StagedFileList
						WHERE PSTId = @inPSTId AND StagedPSTFilePath LIKE @inStagedPSTFilePath)
		if (@StagedPSTId <> 0)
			begin
				update APP_PSTArch_StagedFileList SET State=@inState, StagedTime=@inStagedTime, DeletedTime = @inDeletedTime,
					StagingTime=@inStagingTime, LastJobId=@inLastJobId
					 Where StagedPSTId = @StagedPSTId
			end
		else
			begin
				insert into APP_PSTArch_StagedFileList (PSTId,ExtractedFilePath,StagedPSTFilePath,State,ErrorCode,StagedTime,DeletedTime,StagedPstFileSize,
								NumOfMessages,EstArchivingTime,ExtractedTime, StagingTime,LastJobId,ReserverdField1,ReserverdField2,ReserverdField3,
								ReserverdField4,ReserverdField5,ReserverdField6)
						 values (@inPSTId, @inExtractedFilePath,@inStagedPSTFilePath, @inState, @inErrorCode, @inStagedTime, @inDeletedTime, @inStagedPstFileSize,
								@inNumOfMessages,@inEstArchivingTime,@inExtractedTime, @inStagingTime,@inLastJobId,'','','',0,0,0)
		end
		SET @outXml =	(SELECT distinct StagedPSTId as '@StagedPSTId'
			FROM APP_PSTArch_StagedFileList
			WHERE PSTId = @inPSTId AND
				StagedPSTFilePath LIKE @inStagedPSTFilePath
			FOR XML PATH('StagedFileList'), ROOT('App_PSTArch_StagedFileListResp') )
		if @outXml IS null
		begin
				set @outXml = '<App_PSTArch_FileListResp />'
		end
	end
else if @inMode = 2		--get values input = PSTID or/and lastjobid
	begin
		SET @inLastJobId = ISNULL (( SELECT ref.value('@inLastJobId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		SET @inPSTId = ISNULL (( SELECT ref.value('@PSTFileId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_StagedFileListReq/StagedFileInfo') R(ref)), 0)
		set @outXml = (
			select  StagedPSTId AS '@StagedPSTId',
					PSTId AS '@PSTFileId',
					ExtractedFilePath AS '@ExtractedFilePath',
					StagedPSTFilePath AS '@StagedPSTFilePath',
					State AS '@State',
					LastJobId AS '@LastJobId'
			from APP_PSTArch_StagedFileList
			where ( (@inPSTId = 0 and @inLastJobId > 0 and LastJobId = @inLastJobId) or
					(@inLastJobId = 0 and @inPSTId > 0 and PSTId = @inPSTId) or
					(@inLastJobId > 0 and LastJobId = @inLastJobId and @inPSTId > 0 and PSTId = @inPSTId) or
					(@inPSTId = 0 and @inLastJobId = 0))
			FOR XML PATH('StagedFileInfo'), ROOT('App_PSTArch_StagedFileListResp')
		)
		if @outXml IS NULL
			set @outXml = '<App_PSTArch_StagedFileListResp />'
	end
COMMIT TRAN
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	set @outXml = ''
	ROLLBACK TRANSACTION
END CATCH;
select @outXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PSTArch_StagedFileList')
	delete from GxQscripts where name = 'PSTArch_StagedFileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PSTArch_StagedFileList')
	delete from GXDBVersions where aliasname = 'PSTArch_StagedFileList'
GO

insert into GXDBVersions values(2, 'PSTArch_StagedFileList',  '00000000000000000000', 'PSTArch_StagedFileList', '00000000000000000000')
GO

