

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/PSTArch_FileList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  PSTArch_FileList()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:
-- 	|
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Manas Mutha   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: PSTArch_FileList <<<'

IF EXISTS (select * from sysobjects where name='PSTArch_FileList')
	drop procedure PSTArch_FileList
IF EXISTS (select * from GxQscripts where name='PSTArch_FileList')
	delete from GxQscripts where name = 'PSTArch_FileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PSTArch_FileList')
	delete from GXDBVersions where aliasname = 'PSTArch_FileList'
GO
print '... Creating Procedure: PSTArch_FileList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure PSTArch_FileList
  @inXml XML
AS
  DECLARE @outXml XML
SET NOCOUNT ON
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SET NOCOUNT ON
BEGIN TRY
BEGIN TRAN
declare @inMode int
declare @PSTFileId int
declare @inPSTFilePath nvarchar(255)
declare @inState int
declare @inErrorCode int
declare @inPSTFileSID nvarchar(255)
declare @inUserMachineAssocId int
declare @inUserName nvarchar(255)
declare @inPassword nvarchar(255)
declare @inDiscoveredTime int
declare @inDeletedTime int
declare @inFileModTime int
declare @inFileCreationTime int
declare @inmAlias nvarchar(255)
declare @inPstFileSize int
declare @inNumOfMessages int
declare @inEstStagingTime int
declare @inEstArchivingTime int
declare @inEstPSTSizeAfterArch int
declare @inLastJobId int
declare @inBackupsetId int
declare @inSubclientId int
SET @inMode = ISNULL (( SELECT ref.value('@Mode', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq') R(ref)), 0)
if @inMode = 0
	begin
		set @outXml = ''
	end
else if @inMode = 1		--Set values
	begin
		SET @inPSTFilePath = ISNULL (( SELECT ref.value('@PSTFilePath', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inState = ISNULL (( SELECT ref.value('@State', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inErrorCode = ISNULL (( SELECT ref.value('@ErrorCode', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inPSTFileSID = ISNULL (( SELECT ref.value('@PSTFileSID', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inUserMachineAssocId = ISNULL (( SELECT ref.value('@UserMachineAssocId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inUserName = ISNULL (( SELECT ref.value('@UserName', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inPassword = ISNULL (( SELECT ref.value('@Password', 'nvarchar(255)')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inDiscoveredTime = ISNULL (( SELECT ref.value('@DiscoveredTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inDeletedTime = ISNULL (( SELECT ref.value('@DeletedTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inFileModTime = ISNULL (( SELECT ref.value('@FileModTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inFileCreationTime = ISNULL (( SELECT ref.value('@FileCreationTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inmAlias = ISNULL (( SELECT ref.value('@mAlias', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inPstFileSize = ISNULL (( SELECT ref.value('@PstFileSize', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inNumOfMessages = ISNULL (( SELECT ref.value('@NumOfMessages', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inEstStagingTime = ISNULL (( SELECT ref.value('@EstStagingTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inEstArchivingTime = ISNULL (( SELECT ref.value('@EstArchivingTime', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inEstPSTSizeAfterArch = ISNULL (( SELECT ref.value('@EstPSTSizeAfterArch', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inLastJobId = ISNULL (( SELECT ref.value('@inLastJobId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inBackupsetId = ISNULL (( SELECT ref.value('@backupSetId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		SET @inSubclientId = ISNULL (( SELECT ref.value('@subclientId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
		-- For now check if the file is already entered in the table.
		set @PSTFileId = (SELECT PSTId as '@PSTFileId'
						FROM APP_PSTArch_FileList
						WHERE PSTFilePath LIKE @inPSTFilePath
							)
		if (@PSTFileId <> 0)
			begin
				update APP_PSTArch_FileList SET State=@inState,
							ErrorCode=@inErrorCode,PSTFileSID=@inPSTFileSID,UserMachineAssocId=@inUserMachineAssocId,
							UserName=@inUserName,Password=@inPassword,DiscoveredTime=@inDiscoveredTime,
							DeletedTime=@inDeletedTime,FileModTime=@inFileModTime,FileCreationTime=@inFileCreationTime,
							mAlias=@inmAlias,PstFileSize=@inPstFileSize,NumOfMessages=@inNumOfMessages,EstStagingTime=@inEstStagingTime,
							EstArchivingTime=@inEstArchivingTime,EstPSTSizeAfterArch=@inEstPSTSizeAfterArch,
							LastJobId=@inLastJobId,backupSetId=@inBackupsetId,subclientId=@inSubclientId
					 Where PSTId = @PSTFileId
			end
		else
			begin
				insert into APP_PSTArch_FileList (PSTFilePath,State,ErrorCode,PSTFileSID,UserMachineAssocId,UserName,Password,DiscoveredTime,
						DeletedTime,FileModTime,FileCreationTime,mAlias,PstFileSize,NumOfMessages,EstStagingTime,
						EstArchivingTime,EstPSTSizeAfterArch,LastJobId,ReserverdField1,ReserverdField2,ReserverdField3,ReserverdField4,
						ReserverdField5,ReserverdField6,BackupSetId,SubclientId)
					 values (@inPSTFilePath, @inState, @inErrorCode,@inPSTFileSID,@inUserMachineAssocId,@inUserName,@inPassword,@inDiscoveredTime,
						@inDeletedTime,@inFileModTime,@inFileCreationTime,@inmAlias,@inPstFileSize,@inNumOfMessages,@inEstStagingTime,
						@inEstArchivingTime,@inEstPSTSizeAfterArch,@inLastJobId,'','','',0,0,0,@inBackupsetId,@inSubclientId)
			end
		----------------------------
		--CONSTRUCT THE XML---------
		----------------------------
		SET @outXml =	(SELECT distinct PSTId as '@PstID'
					FROM APP_PSTArch_FileList
					WHERE PSTFilePath LIKE @inPSTFilePath AND
						DiscoveredTime = @inDiscoveredTime AND
						FileModTime = @inFileModTime AND
						FileCreationTime = @inFileCreationTime AND
						PstFileSize = @inPstFileSize
						--AND	PSTFileSID = '@inPSTFileSID'
					FOR XML PATH('FileListInfo'), ROOT('App_PSTArch_FileListResp') )
		if @outXml IS null
		begin
				set @outXml = '<App_PSTArch_FileListResp />'
		end
	end
else
	begin
		if @inMode = 2		--get values input = client id
			begin
				SET @inUserMachineAssocId = ISNULL (( SELECT ref.value('@UserMachineAssocId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
				set @outXml = (
					select  PSTId AS '@PstID',
							PSTFilePath AS '@PSTFilePath',
							LastJobId AS '@LastJobId',
							State	AS	'@State',
							PSTFileSID	AS	'@PSTFileSID',
							UserMachineAssocId	AS	'@UserMachineAssocId',
							UserName AS '@UserName',
							Password AS '@Password',
							DiscoveredTime AS '@DiscoveredTime',
							DeletedTime AS '@DeletedTime',
							FileModTime AS '@FileModTime',
							FileCreationTime AS '@FileCreationTime',
							--mAlias AS ,
							PstFileSize AS '@PstFileSize',
							NumOfMessages AS '@NumOfMessages',
							EstStagingTime AS '@EstStagingTime',
							EstArchivingTime AS '@EstArchivingTime',
							EstPSTSizeAfterArch AS '@EstPSTSizeAfterArch',
							LastJobId AS '@inLastJobId',
							SubclientId AS '@subclientId',
							BackupSetId AS '@backupSetId'
					from APP_PSTArch_FileList
					where UserMachineAssocId = @inUserMachineAssocId
					FOR XML PATH('FileListInfo'), ROOT('App_PSTArch_FileListResp')
				)
				if @outXml IS NULL
					set @outXml = '<App_PSTArch_FileListResp />'
			end
		else if @inMode = 3		--get values input = job id
			begin
				SET @inLastJobId = ISNULL (( SELECT ref.value('@inLastJobId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
				set @outXml = (
					select PSTId AS '@PstID',
							PSTFilePath AS '@PSTFilePath',
							PSTFileSID AS '@PSTFileSID',
							UserMachineAssocId AS '@UserMachineAssocId',
							LastJobId AS '@LastJobId'
					from APP_PSTArch_FileList
					where LastJobId = @inLastJobId
					FOR XML PATH('FileListInfo'), ROOT('App_PSTArch_FileListResp')
				)
				if @outXml IS NULL
					set @outXml = '<App_PSTArch_FileListResp />'
			end
		else if @inMode = 4		--get values input = backupset id
			begin
				SET @inBackupsetId = ISNULL (( SELECT ref.value('@backupSetId', 'INTEGER')FROM @inXMl.nodes('App_PSTArch_FileListReq/FileInfo') R(ref)), 0)
				set @outXml = (
					select  PSTId AS '@PstID',
							PSTFilePath AS '@PSTFilePath',
							LastJobId AS '@LastJobId',
							State	AS	'@State',
							PSTFileSID	AS	'@PSTFileSID',
							UserMachineAssocId	AS	'@UserMachineAssocId',
							UserName AS '@UserName',
							Password AS '@Password',
							DiscoveredTime AS '@DiscoveredTime',
							DeletedTime AS '@DeletedTime',
							FileModTime AS '@FileModTime',
							FileCreationTime AS '@FileCreationTime',
							--mAlias AS ,
							PstFileSize AS '@PstFileSize',
							NumOfMessages AS '@NumOfMessages',
							EstStagingTime AS '@EstStagingTime',
							EstArchivingTime AS '@EstArchivingTime',
							EstPSTSizeAfterArch AS '@EstPSTSizeAfterArch',
							LastJobId AS '@inLastJobId',
							PF.SubclientId AS '@subclientId',
							PF.BackupSetId AS '@backupSetId',
							CL.name AS '@userMachineAssociatedClientName'
					FROM APP_PSTArch_FileList AS PF
					INNER JOIN APP_PSTArch_UserMachineAssoc AS PU ON PU.Id = PF.UserMachineAssocId
					INNER JOIN APP_Client AS CL ON CL.id = PU.ClientId
					where PF.BackupSetId = @inBackupsetId
					FOR XML PATH('FileListInfo'), ROOT('App_PSTArch_FileListResp')
					)
					if @outXml IS NULL
						set @outXml = '<App_PSTArch_FileListResp />'
			end
	end
COMMIT TRAN
END TRY
BEGIN CATCH

	PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)

	set @outXml = ''
	ROLLBACK TRANSACTION
END CATCH;
select @outXml
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'PSTArch_FileList')
	delete from GxQscripts where name = 'PSTArch_FileList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='PSTArch_FileList')
	delete from GXDBVersions where aliasname = 'PSTArch_FileList'
GO

insert into GXDBVersions values(2, 'PSTArch_FileList',  '00000000000000000000', 'PSTArch_FileList', '00000000000000000000')
GO

