

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/OraclePluggableDbsInsertUpdate.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  OraclePluggableDbsInsertUpdate                             */
/*  Author	:  Prashanth Bangalore                                                                          */
/*  Description :  Stored proc used to insert/update OraclePluggableDbs Table */
/*             associated with given instance id                              */
/******************************************************************************/
--dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/OraclePluggableDbsInsertUpdate.sp,v $ $Id: OraclePluggableDbsInsertUpdate.sp,v 1.1.48.6 2020/10/04 01:03:25 abilbrey Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='OraclePluggableDbsInsertUpdate')
BEGIN
	print '>>> Drop Stored Procedure: OraclePluggableDbsInsertUpdate <<<'
	drop procedure OraclePluggableDbsInsertUpdate
END
IF EXISTS (select * from GxQscripts where name='OraclePluggableDbsInsertUpdate')
	delete from GxQscripts where name = 'OraclePluggableDbsInsertUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraclePluggableDbsInsertUpdate')
	delete from GXDBVersions where aliasname = 'OraclePluggableDbsInsertUpdate'
GO
print '... Creating Procedure: OraclePluggableDbsInsertUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure OraclePluggableDbsInsertUpdate
  @i_instance integer,
  @name varchar(64),
  @deleteFlag integer = 0,
  @createdModified integer =  0,
  @opType integer = 0,
  @i_xmlInput XML = NULL,
  @dbId bigint = 0
AS
  DECLARE @pdbId integer = 0
  DECLARE @errCode integer = 0
  DECLARE @errStr varchar(80) = ''
	DECLARE @ErrTbl table
	(
	 	errCode integer,
	 	errStr varchar(80)
	)
	DECLARE @IdTbl table
	(
		tblId integer
	)
	DECLARE @strIdList varchar(MAX)
SET NOCOUNT ON
BEGIN TRY
IF @i_instance = 0
BEGIN
set @errStr = 'Invalid Instance Id'
set @errCode = -1
goto EXIT_PROC
END
IF @name = '' and @deleteFlag = 0
BEGIN
SET @errStr = 'PDB Name cannot be null'
SET @errCode = -1
goto EXIT_PROC
END
IF @createdModified = 0 AND @deleteFlag <> 0
BEGIN
SET @errStr = 'Input Error: Updating DELETED OBJECTS requires modifiction time to be passed'
SET @errCode = -1
END
ELSE IF @createdModified = 0
BEGIN
	SET @createdModified = dbo.GetUnixTime(GETDATE())
END
BEGIN TRAN
-- This handles deletion here
-- where the PDBs that got deleted will be handled
IF @name = '' and @deleteFlag <> 0
BEGIN
	update OraclePluggableDbs set deleteFlag = @deleteFlag, deleted = @createdModified
	OUTPUT  INSERTED.pdbId into @IdTbl
	where instId = @i_instance  and modified != @createdModified and deleteFlag = 0;
	IF @@ROWCOUNT > 0
	BEGIN
		SELECT  @strIdList = stuff( (SELECT ',' + (convert(varchar(10), a.tblId) )  from
		   @IdTbl  a   for XML PATH('') ),1,1,'')
		insert @ErrTbl EXEC OracleObjectsUpdate  @i_instance, 20, 1, 1, 2, 0, @strIdList, 0, ''
		select @errCode = isnull(errCode, 0), @errStr = isnull(errStr, '') from @ErrTbl
		IF @errCode <> 0
		BEGIN
			GOTO EXIT_PROC
		END
		delete from  @IdTbl;
	END
	update oracleTableSpaces set deleteFlag = @deleteFlag, deleted = @createdModified
	OUTPUT  INSERTED.id into @IdTbl
	where instId = @i_instance  and modified != @createdModified and deleteFlag = 0;
	IF @@ROWCOUNT > 0
	BEGIN
		SELECT  @strIdList = stuff( (SELECT ',' + (convert(varchar(10), a.tblId) )  from
		   @IdTbl  a   for XML PATH('') ),1,1,'')
		insert @ErrTbl EXEC OracleObjectsUpdate  @i_instance, 5, 1, 1, 2, 0, @strIdList, 0, '';
		select @errCode = isnull(errCode, 0), @errStr = isnull(errStr, '') from @ErrTbl;
		IF @errCode <> 0
		BEGIN
			GOTO EXIT_PROC
		END
		delete from  @IdTbl;
	END
	update oracleDataFiles set deleteFlag = @deleteFlag, deleted = @createdModified
	OUTPUT  INSERTED.id into @IdTbl
	where instId = @i_instance  and modified != @createdModified and deleteFlag = 0;
	IF @@ROWCOUNT > 0
	BEGIN
		SELECT  @strIdList = stuff( (SELECT ',' + (convert(varchar(10), a.tblId) )  from
		   @IdTbl  a   for XML PATH('') ),1,1,'')
		insert @ErrTbl EXEC OracleObjectsUpdate  @i_instance, 1, 1, 1, 2, 0, @strIdList, 0, '';
		select @errCode = isnull(errCode, 0), @errStr = isnull(errStr, '') from @ErrTbl;
		IF @errCode <> 0
		BEGIN
			GOTO EXIT_PROC
		END
	END
END
ELSE
BEGIN
	select  @pdbId = isnull(pdbId, 0) from OraclePluggableDBs where name = @name and instId = @i_instance and deleteFlag = 0 and (@dbId = 0 or dbId = 0 or dbId = @dbId )
	IF @pdbId <> 0
	BEGIN
		update OraclePluggableDBS   set modified=@createdModified, deleteFlag=@deleteFlag,
				deleted = ( CASE WHEN @deleteFlag <> 0 THEN @createdModified
								ELSE deleted	END),
				dbAttributes = ( CASE	WHEN @i_xmlInput is not NULL  THEN @i_xmlInput
		 							ELSE dbAttributes END),
				dbId = (CASE WHEN @deleteFlag=0 THEN @dbId ELSE dbId END)
		where pdbId = @pdbId
		SET @errCode = @@ERROR
		IF @errCode <> 0
		BEGIN
			SET @errStr = ' Updating OraclePluggableDB table failed. Please check the errCode.'
		END
	END
	ELSE
	BEGIN
		IF  @deleteFlag = 0
		BEGIN
			INSERT INTO OraclePluggableDBs(name, instId, created, deleteFlag, deleted, modified, opType, dbAttributes, dbId) values
									(@name, @i_instance, @createdModified, 0, 0, @createdModified, 0, @i_xmlInput, @dbId)
			SET @pdbId = SCOPE_IDENTITY()
		END
		ELSE
		BEGIN
			SET @errStr = 'Row for Oracle PDB' + @name + 'does not exist'
			SET @errCode = -2
		END
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	select @errCode = @@ERROR, @errStr = ERROR_MESSAGE()
END CATCH
IF @errCode = 0
BEGIN
	COMMIT TRAN
END
ELSE
BEGIN
	ROLLBACK TRAN
END
EXIT_PROC:
SELECT @pdbId, @errCode, @errStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'OraclePluggableDbsInsertUpdate')
	delete from GxQscripts where name = 'OraclePluggableDbsInsertUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraclePluggableDbsInsertUpdate')
	delete from GXDBVersions where aliasname = 'OraclePluggableDbsInsertUpdate'
GO

insert into GXDBVersions values(2, 'OraclePluggableDbsInsertUpdate',  '00010001004800060000', 'OraclePluggableDbsInsertUpdate', '00010001004800060000')
GO

