

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/OracleObjectsUpdate.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  OracleObjectsUpdate                             */
/*  Author	:  Prashanth Bangalore                                                                          */
/*  Description :  Stored proc used to insert/update OraclePluggableDbs Table */
/*             associated with given instance id                              */
/******************************************************************************/
--dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/OracleObjectsUpdate.sp,v $ $Id: OracleObjectsUpdate.sp,v 1.1.48.2 2018/03/27 08:47:01 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: OracleObjectsUpdate <<<'

IF EXISTS (select * from sysobjects where name='OracleObjectsUpdate')
	drop procedure OracleObjectsUpdate
IF EXISTS (select * from GxQscripts where name='OracleObjectsUpdate')
	delete from GxQscripts where name = 'OracleObjectsUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OracleObjectsUpdate')
	delete from GXDBVersions where aliasname = 'OracleObjectsUpdate'
GO
print '... Creating Procedure: OracleObjectsUpdate'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure OracleObjectsUpdate
  @i_instance integer,
  @objType integer,
  @cdbInstance integer = 0,
  @deleteFlag integer = 0,
  @opType integer = 0,
  @appOrTaskId integer = 0,
  @objIdList varchar(max) = '',
  @actionType integer = 0,
  @name varchar(2048) = '',
  @underDBDir integer = 0,
  @contType integer = 0,
  @totalPages integer = 0,
  @isAccessible integer = 0
AS
  DECLARE @errCode integer = 0
  DECLARE @errStr varchar(80) = ''
DECLARE @childObjType  integer
	DECLARE @rowCnt	integer
	DECLARE @parentObjType integer
	DECLARE  @InputIdListTbl TABLE
	(
  		objId INTEGER
	)
	DECLARE  @ParentChildTbl TABLE
	(
		parentId INTEGER,
		child INTEGER
	)
	DECLARE @ObjIdTbl TABLE
	(
   		objType integer,
   		objId integer,
   		parentId integer
 	)
	set @childObjType = 0
	set @parentObjType = 0
	set @rowCnt = 0
SET NOCOUNT ON
IF @i_instance = 0
BEGIN
	set @errStr = 'Invalid Instance Id'
	set @errCode = -1
	goto EXIT_PROC
END
IF @objType <> 1 and @objType <> 5 and @objType <> 20
BEGIN
	set @errStr =  'Invalid Object Type it can be one of 20 (PDB), 5 (TableSpace), 1 (Datafile) '
	set @errCode = -1
goto EXIT_PROC
END
IF @opType <> 1 and @opType <> 2
BEGIN
	set @errStr =  'Invalid OpType can be one of 1 (restore) or 2 (Backup)'
	set @errCode = -1
	goto EXIT_PROC
END
IF @objIdList = ''
BEGIN
	set @errStr = 'Object ID list cannot  be empty and must be a comma separated list'
	set @errCode = -1
goto EXIT_PROC
END
ELSE
BEGIN
	insert into @InputIdListTbl select distinct _id from dbo.SplitIds(@objIdList)
END
IF (@deleteFlag = 0 or @opType = 1) and  @appOrTaskId = 0
BEGIN
	set @errStr =  'AppId or Restore Task Id not passed toStored Procedure'
	set @errCode = -1
END
SELECT @childObjType = CASE @objType
	WHEN  20 THEN   5
	WHEN  5 THEN  1
	ELSE 0
END
SELECT @parentObjType = CASE @objType
	WHEN  20 THEN   0
	WHEN  5 THEN  20
	ELSE 5
END
IF @parentObjType = 20 and @cdbInstance != 1
BEGIN
	SET @parentObjType = 0
END
BEGIN TRY
BEGIN TRAN
-- This handles deletion here
-- where the PDBs that got deleted will be handled
IF @deleteFlag = 1
BEGIN
	-- When we delete the PDB, we need to take care of deleting the Tablespace
        -- and its datafiles. Hence need to capture the deleted id in a table so that
        -- we can take care of deleting the datafiles correctly
	DELETE OracleObjects OUTPUT DELETED.Type, DELETED.objId, DELETED.parentId into @ObjIdTbl
	where instId = @i_instance and setType = @opType
	and (@appOrTaskId = 0 or (@opType = 1  and  taskId = @appOrTaskId) or
		(@opType = 2  and  subClientId = @appOrTaskId) )
	and ( (type = @childObjType and parentId in (select objId from @InputIdListTbl) )
		or (type = @objType and objId in (select objId from @InputIdListTbl) ) )
	-- To take care of cases where the PDB is deleted
	-- we need to remove datafiles asssocilated iwth it
	IF   @@ROWCOUNT > 0  and @objType = 20 and @appOrTaskId = 0
	BEGIN
		DELETE OracleObjects  where instId = @i_instance and setType = @opType and type = 2
		and parentId in (select objId from @ObjIdTbl where objType = 5)
	END
END
ELSE
BEGIN
	-- delete the Children that already exist
        -- Adding PDB, delete all the tablespaces it belongs to
	-- Adding TS, delete the datafiles it belongs to
	DELETE OracleObjects OUTPUT DELETED.Type, DELETED.objId, DELETED.parentId into @ObjIdTbl
	where instId = @i_instance and setType = @opType  and  @childObjType != 0
	and ((@opType = 1  and  taskId = @appOrTaskId) or  (@opType = 2  and  subClientId = @appOrTaskId))
	and  type = @childObjType and	parentId in  (select objId from @InputIdListTbl)
	-- PDB case
	IF   @objType = 20
	BEGIN
		--Delete the grand children
		DELETE OracleObjects  where instId = @i_instance and setType = @opType and type = 1
		 and 	((@opType = 1  and  taskId = @appOrTaskId) or  	(@opType = 2  and  subClientId = @appOrTaskId) )
		and parentId in (select  t.id from oracleTableSpaces t where t.pdbId in (select objId from @InputIdListTbl))
	END
	--delete the input that already exist
	DELETE @InputIdListTbl where EXISTS ( select objId from OracleObjects where instId = @i_instance and setType = @opType
	and type = @objType and ( (@opType = 1  and  taskId = @appOrTaskId)  or (@opType = 2 and subClientId = @appOrTaskId) )
	and objId in (select objId from @InputIdListTbl) )
	--Datafile case
	IF @parentObjType = 5
	BEGIN
		insert into @ParentChildTbl select   tblId, id from OracleDataFiles where
			instId = @i_instance and id in (select objId from @InputIdListTbl)
		-- delete the TS
		DELETE OracleObjects  where instId = @i_instance and setType = @opType
		and  ( (@opType = 1  and  taskId = @appOrTaskId)  or (@opType = 2 and subClientId = @appOrTaskId) )
		and  type = @parentObjType and objId in (select parentId from @ParentChildTbl )
		-- Delete pdbs to which datafile belongs
		DELETE OracleObjects where instId = @i_instance and setType = @opType and
		( (@opType = 1  and  taskId = @appOrTaskId)  or (@opType = 2 and subClientId = @appOrTaskId) )
		and  type = 20 and objId in (select isnull(t.pdbId, 0) from OracleTableSpaces t, @ParentChildTbl p
						where t.instId = @i_instance and t.id = p.parentId )
	END
	-- TS case
	ELSE IF @parentObjType = 20
	BEGIN
		insert into @ParentChildTbl select  isnull(pdbId, 0), id from OracleTableSpaces where instId = @i_instance and
			id in (select objId from @InputIdListTbl)
		-- Delete the PDBs in case they exist
		DELETE OracleObjects where instId = @i_instance and setType = @opType and
		type = 20 and  ( (@opType = 1  and  taskId = @appOrTaskId)  or (@opType = 2 and subClientId = @appOrTaskId) ) and
		objId in  (select parentId from @ParentChildTbl )
	END
	-- PDB case
	ELSE
	BEGIN
		insert into @ParentChildTbl select 0, objId from @InputIdListTbl
	END
	insert into OracleObjects select
		CASE WHEN @opType = 2 THEN @appOrTaskId  ELSE  0 END,
		CASE WHEN @opType = 1 THEN @appOrTaskId ELSE 0 END,
		@i_instance,
		@objType,
		parentId,
		child,
		@opType,
		@actionType,
		@name,
		@underDBDir,
		@contType,
		@totalPages,
		@isAccessible
		 from @ParentChildTbl
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	select @errCode = @@ERROR, @errStr = ERROR_MESSAGE()
END CATCH
IF @errCode = 0
BEGIN
	COMMIT TRAN
END
ELSE
BEGIN
	ROLLBACK TRAN
END
EXIT_PROC:
SELECT  @errCode, @errStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'OracleObjectsUpdate')
	delete from GxQscripts where name = 'OracleObjectsUpdate'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OracleObjectsUpdate')
	delete from GXDBVersions where aliasname = 'OracleObjectsUpdate'
GO

insert into GXDBVersions values(2, 'OracleObjectsUpdate',  '00010001004800020000', 'OracleObjectsUpdate', '00010001004800020000')
GO

